/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ICoreTrustStore;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BCertificateSelectFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateSelectFE.class);
    private static final Logger LOG = Logger.getLogger("platCrypto");
    private final BTextDropDown field = new BTextDropDown(false);
    private final ICoreCryptoManager cryptoManager;
    private final KeyStoreType type;
    private final KeyPurpose keyPurpose;
    private final BString fieldText;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCertificateSelectFE() {
        this.cryptoManager = null;
        this.type = null;
        this.keyPurpose = null;
        this.fieldText = null;
    }

    public BCertificateSelectFE(ICoreCryptoManager manager, KeyStoreType storeType, KeyPurpose purpose, BString text) {
        this.setContent((BWidget)this.field);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BDropDown.actionPerformed, (Slot)actionPerformed);
        this.cryptoManager = manager;
        this.type = storeType;
        this.keyPurpose = purpose;
        this.fieldText = text;
        if (this.fieldText != null) {
            try {
                this.field.addItem(this.fieldText.encodeToString());
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Unable to load CertificateSelectFE text", e);
            }
        }
    }

    public BCertificateSelectFE(ICoreCryptoManager manager, KeyStoreType storeType, KeyPurpose purpose) {
        this(manager, storeType, purpose, null);
    }

    public BCertificateSelectFE(ICoreCryptoManager manager, KeyStoreType storeType) {
        this(manager, storeType, null, null);
    }

    public void doLoadValue(BObject v, Context cx) {
        block3: {
            try {
                ICoreTrustStore keyStore = this.getKeyStore(this.cryptoManager, this.type);
                if (keyStore == null) {
                    throw new KeyStoreException("Unable to access keystore");
                }
                this.populateAliasList(keyStore);
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block3;
                LOG.log(Level.SEVERE, "Unable to load CertificateSelectFE aliases", e);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.field.setEnabled(enabled);
    }

    private void populateAliasList(ICoreTrustStore keyStore) throws Exception {
        Enumeration aliases = AccessController.doPrivileged(() -> ((ICoreTrustStore)keyStore).aliases());
        while (aliases.hasMoreElements()) {
            String alias = (String)aliases.nextElement();
            this.addAliasToArray(alias, keyStore);
        }
    }

    private void addAliasToArray(String alias, ICoreTrustStore keyStore) throws Exception {
        AccessController.doPrivileged(() -> {
            if (this.keyPurpose == KeyPurpose.CA_CERT) {
                if (CertUtils.isValidCACert((String)alias, (ICoreTrustStore)keyStore)) {
                    this.field.addItem(alias);
                }
            } else if (this.keyPurpose == KeyPurpose.CODE_SIGNING_CERT) {
                if (CertUtils.isValidSigningCert((String)alias, (KeyStore)keyStore.getKeyStore())) {
                    this.field.addItem(alias);
                }
            } else if (this.keyPurpose == KeyPurpose.SERVER_CERT) {
                if (CertUtils.isValidServerCert((String)alias, (ICoreKeyStore)this.cryptoManager.getKeyStore())) {
                    this.field.addItem(alias);
                }
            } else if (this.keyPurpose == KeyPurpose.CLIENT_CERT) {
                if (CertUtils.isClientCert((X509Certificate)keyStore.getCertificate(alias))) {
                    this.field.addItem(alias);
                }
            } else {
                this.field.addItem(alias);
            }
            return null;
        });
    }

    public ICoreTrustStore getKeyStore(ICoreCryptoManager manager, KeyStoreType storeType) throws Exception {
        switch (storeType) {
            case USER_KEYSTORE: {
                return manager.getKeyStore();
            }
            case SYSTEM_TRUST_STORE: {
                return manager.getSystemTrustStore();
            }
            case USER_TRUST_STORE: {
                return manager.getUserTrustStore();
            }
            case ALLOWED_HOSTS: {
                return manager.getUserUntrustedStore();
            }
        }
        return null;
    }

    public String getText() {
        return this.field.getText();
    }

    public int getItemCount() {
        return this.field.getList().getItemCount();
    }

    protected BObject doSaveValue(BObject v, Context cx) {
        return BString.make((String)this.getText());
    }

    public void setSelectedAlias(String alias) {
        int index = this.field.getList().indexOfItem((Object)alias);
        if (index != -1) {
            this.field.getList().setSelectedIndex(index);
            this.field.setText(alias);
        }
    }

    public static enum KeyStoreType {
        USER_KEYSTORE,
        SYSTEM_TRUST_STORE,
        USER_TRUST_STORE,
        ALLOWED_HOSTS;

    }
}

