/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb;

import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.systemDb.BSystemDb;
import java.io.IOException;
import java.security.Permission;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BFacets;
import javax.baja.tag.Entity;

public abstract class SystemDbConnection
implements AutoCloseable {
    public static final String CATEGORY_MASK_RESERVED_PROP_NAME = "CategoryMask";
    public static final String TAG_TYPES_RESERVED_PROP_NAME = "TagTypes";
    protected static final Logger LOGGER = BSystemDb.LOGGER;
    private static final Permission systemDbAddRemovePermission = new NiagaraBasicPermission("SYSTEM_DB_MODIFY");
    private static final BFacets REMOVE_LIMIT_FACETS = BFacets.make((String)"queryLimit", (int)-1);

    @Override
    public abstract void close() throws IOException;

    public final void addEntity(Entity entity) throws Exception {
        this.checkModifySystemDb();
        this.doAddEntity(entity);
    }

    protected abstract void doAddEntity(Entity var1) throws Exception;

    public final void addEntities(Stream<Entity> entities) throws Exception {
        this.checkModifySystemDb();
        this.doAddEntities(entities);
    }

    protected abstract void doAddEntities(Stream<Entity> var1) throws Exception;

    public final void removeEntity(Entity entity) throws Exception {
        this.checkModifySystemDb();
        this.doRemoveEntity(entity);
    }

    protected abstract void doRemoveEntity(Entity var1) throws Exception;

    public final long removeAllEntities() throws Exception {
        this.checkModifySystemDb();
        return this.doRemoveAllEntities();
    }

    protected abstract long doRemoveAllEntities() throws Exception;

    public final int removeEntities(OrdTarget scope, OrdQuery query) throws Exception {
        this.checkModifySystemDb();
        boolean hasLimit = scope != null && scope.getFacets() != null && scope.getFacets().geti("queryLimit", -1) >= 0;
        OrdTarget base = hasLimit ? OrdTarget.makeWithFacets((OrdTarget)scope, (BFacets)REMOVE_LIMIT_FACETS) : scope;
        return this.doRemoveEntities(base, query);
    }

    protected abstract int doRemoveEntities(OrdTarget var1, OrdQuery var2) throws Exception;

    public final int removeStationEntities(String ... stationNames) throws Exception {
        this.checkModifySystemDb();
        return this.doRemoveStationEntities(stationNames);
    }

    protected abstract int doRemoveStationEntities(String ... var1) throws Exception;

    private void checkModifySystemDb() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(systemDbAddRemovePermission);
        }
    }

    public static class AddEntityException
    extends Exception {
        public AddEntityException(String msg) {
            super(msg);
        }

        public AddEntityException(Exception e) {
            super(e);
        }
    }
}

