/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb;

import com.tridium.driver.util.DrUtil;
import com.tridium.fox.sys.broker.BFoxVirtualSpace;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nv.BNiagaraVirtualGateway;
import com.tridium.sys.tag.BEntityObjectWrapper;
import com.tridium.systemDb.BSystemDb;
import com.tridium.systemDb.BSystemDbScheme;
import com.tridium.virtual.BUnresolvedVirtualHandler;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQueryScheme;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Entity;
import javax.baja.tag.util.BasicEntity;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualPath;

@NiagaraType(agent={@AgentOn(types={"niagaraVirtual:NiagaraVirtualGateway"}, requiredPermissions="r")})
@NiagaraSingleton
public final class BSystemDbUnresolvedVirtualHandler
extends BUnresolvedVirtualHandler {
    @Generated
    public static final BSystemDbUnresolvedVirtualHandler INSTANCE = new BSystemDbUnresolvedVirtualHandler();
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemDbUnresolvedVirtualHandler.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BSystemDbUnresolvedVirtualHandler() {
    }

    public OrdTarget resolveFailedVirtualQuery(OrdTarget base, OrdQuery failedOrdQuery) {
        boolean canResolve = false;
        int size = base.depth();
        int failedQueryIdx = -1;
        int sysQueryIdx = -1;
        String firstQuerySchemeAfterSys = null;
        for (int i = 0; i < size; ++i) {
            OrdQuery queryToInspect = base.queryAt(i);
            if (queryToInspect == failedOrdQuery) {
                failedQueryIdx = i;
                continue;
            }
            if (failedQueryIdx == -1) continue;
            if (sysQueryIdx == -1) {
                if (queryToInspect instanceof BSystemDbScheme.SystemDbQuery) {
                    sysQueryIdx = i;
                    int nextIdx = i + 1;
                    if (nextIdx < size) {
                        String nextScheme = base.queryAt(nextIdx).getScheme();
                        try {
                            if (!BOrdScheme.lookup((String)nextScheme).getType().is(BQueryScheme.TYPE)) break;
                            firstQuerySchemeAfterSys = nextScheme;
                            canResolve = true;
                            continue;
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                    canResolve = true;
                    continue;
                }
                if (queryToInspect instanceof SlotPath) continue;
                break;
            }
            String scheme = queryToInspect.getScheme();
            boolean isQueryScheme = false;
            try {
                isQueryScheme = "bql".equals(scheme) || BOrdScheme.lookup((String)scheme).getType().is(BQueryScheme.TYPE);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!isQueryScheme || scheme.equals(firstQuerySchemeAfterSys)) continue;
            canResolve = false;
            break;
        }
        if (!canResolve) {
            return null;
        }
        BOrd nspaceOrd = null;
        int pathIdxStart = failedQueryIdx;
        if ("nspace".equals(failedOrdQuery.getScheme())) {
            nspaceOrd = BOrd.make((OrdQuery)failedOrdQuery);
            ++pathIdxStart;
        }
        BOrd pathOrd = null;
        for (int i = pathIdxStart; i < sysQueryIdx; ++i) {
            SlotPath sPath;
            OrdQuery query = base.queryAt(i);
            if (query instanceof VirtualPath) {
                int j;
                VirtualPath vPath = (VirtualPath)query;
                if (vPath.isAbsolute() || i == pathIdxStart) {
                    int len = vPath.depth();
                    String[] slotNames = new String[len];
                    for (j = 0; j < len; ++j) {
                        slotNames[j] = VirtualPath.toSlotPathName((String)vPath.nameAt(j));
                    }
                    query = new SlotPath("slot", slotNames);
                } else {
                    int backup = vPath.getBackupDepth();
                    StringBuilder sb = new StringBuilder();
                    for (j = 0; j < backup; ++j) {
                        sb.append("../");
                    }
                    String[] vPathNames = vPath.getNames();
                    int len = vPathNames.length;
                    for (int j2 = 0; j2 < len; ++j2) {
                        if (j2 != 0) {
                            sb.append('/');
                        }
                        sb.append(VirtualPath.toSlotPathName((String)vPathNames[j2]));
                    }
                    query = new SlotPath(sb.toString());
                }
            } else if (query instanceof SlotPath && (sPath = (SlotPath)query).isRelative() && i == pathIdxStart) {
                query = new SlotPath("slot", sPath.getNames());
            }
            pathOrd = pathOrd == null ? BOrd.make((OrdQuery)query) : BOrd.make((BOrd)pathOrd, (OrdQuery)query).normalize();
        }
        if (nspaceOrd == null) {
            BVirtualGateway gateway;
            BObject obj = base.get();
            BNiagaraVirtualGateway nGateway = null;
            if (obj instanceof BNiagaraVirtualGateway) {
                nGateway = (BNiagaraVirtualGateway)obj;
            } else if (obj instanceof BVirtualComponentSpace) {
                gateway = ((BVirtualComponentSpace)obj).getVirtualGateway();
                if (gateway instanceof BNiagaraVirtualGateway) {
                    nGateway = (BNiagaraVirtualGateway)gateway;
                }
            } else if (obj instanceof BFoxVirtualSpace && (gateway = ((BFoxVirtualSpace)obj).getVirtualGateway()) instanceof BNiagaraVirtualGateway) {
                nGateway = (BNiagaraVirtualGateway)gateway;
            }
            if (nGateway == null) {
                return null;
            }
            if (pathOrd == null) {
                String stationName = null;
                if (nGateway.getStationAdapter() != null) {
                    stationName = nGateway.getStationAdapter().getStationName();
                } else {
                    BNiagaraStation station = (BNiagaraStation)DrUtil.getParent((BComplex)nGateway, (Type)BNiagaraStation.TYPE);
                    if (station != null) {
                        stationName = station.getStationName();
                    }
                }
                if (stationName == null) {
                    return null;
                }
                nspaceOrd = BOrd.make((String)("nspace:" + stationName + "|slot:/"));
            } else {
                OrdQuery[] pathQueries = pathOrd.parse();
                SlotPath slotPath = pathQueries[0] instanceof SlotPath ? (SlotPath)pathQueries[0] : null;
                nspaceOrd = BSystemDb.convertToNspaceOrd(nGateway, slotPath);
                if (nspaceOrd == null) {
                    return null;
                }
                if (pathQueries.length > 1) {
                    nspaceOrd = BOrd.make((BOrd)nspaceOrd, (BOrd)BOrd.make((OrdQuery[])pathQueries, (int)1, (int)pathQueries.length));
                }
            }
        } else {
            nspaceOrd = pathOrd != null ? BOrd.make((BOrd)nspaceOrd, pathOrd).normalize() : BOrd.make((BOrd)nspaceOrd, (String)"slot:/");
        }
        BIEntity entity = BEntityObjectWrapper.makeEntityObject((Entity)new BasicEntity(nspaceOrd));
        BFacets facets = BFacets.make((String)"alternateQueryScope", (BIDataValue)BString.make((String)nspaceOrd.toString()), (String)"makeEntityForAlternateScope", (BIDataValue)BBoolean.TRUE, (String)"lightweightSystemDbQueryResults", (BIDataValue)BBoolean.TRUE);
        return OrdTarget.makeWithFacets((OrdTarget)base, (BObject)((BObject)entity), (BFacets)facets);
    }
}

