/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.excel;

import com.tridium.excel.CellRangeAddress;
import com.tridium.excel.DataFormatter;
import com.tridium.excel.EncryptionInfo;
import com.tridium.excel.ExcelFileObject;
import com.tridium.excel.ExcelFileSystem;
import com.tridium.excel.Factory;
import com.tridium.excel.IndexedColors;
import com.tridium.excel.Workbook;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.baja.sys.BModule;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;

public class ExcelUtils {
    private static boolean initialized = false;
    private static Factory factory = null;
    private static Throwable initializationError = null;
    private static final String EXCEL_SUPPORT_MODULE = "templateBulk";
    private static final String FACTORY_CLASS_NAME = "com.tridium.excel.impl.FactoryImpl";
    private static final String FACTORY_INSTANCE_METHOD_NAME = "instance";

    public static boolean isExcelSupportInstalled() {
        ExcelUtils.initialize();
        return factory != null;
    }

    public static void confirmExcelSupport() {
        if (!ExcelUtils.isExcelSupportInstalled()) {
            throw new UnsupportedOperationException("Install module templateBulk for Excel file support.", initializationError);
        }
    }

    public static Workbook createWorkbook(boolean xmlFormat) throws IOException {
        ExcelUtils.confirmExcelSupport();
        return factory.createWorkbook(xmlFormat);
    }

    public static Workbook createWorkbook(File file, String password) throws IOException {
        ExcelUtils.confirmExcelSupport();
        return factory.createWorkbook(file, password);
    }

    public static Workbook createWorkbook(InputStream inp, String password) throws IOException {
        ExcelUtils.confirmExcelSupport();
        return factory.createWorkbook(inp, password);
    }

    public static ExcelFileSystem makeFileSystem() {
        ExcelUtils.confirmExcelSupport();
        return factory.makeFileSystem();
    }

    public static void setCurrentUserPassword(String password) {
        ExcelUtils.confirmExcelSupport();
        factory.setCurrentUserPassword(password);
    }

    public static EncryptionInfo makeEncryptionInfo() {
        ExcelUtils.confirmExcelSupport();
        return factory.makeEncryptionInfo();
    }

    public static CellRangeAddress makeCellRangeAddress(int firstRow, int lastRow, int firstCol, int lastCol) {
        ExcelUtils.confirmExcelSupport();
        return factory.makeCellRangeAddress(firstRow, lastRow, firstCol, lastCol);
    }

    public static DataFormatter makeDataFormatter() {
        ExcelUtils.confirmExcelSupport();
        return factory.makeDataFormatter();
    }

    public static short getColorIndex(IndexedColors color) {
        ExcelUtils.confirmExcelSupport();
        return factory.getColorIndex(color);
    }

    public static short getBuiltinFormat(String pFmt) {
        ExcelUtils.confirmExcelSupport();
        return factory.getBuiltinFormat(pFmt);
    }

    public static boolean isXmlFormat(ExcelFileObject object) {
        return object != null && object.isXmlFormat();
    }

    private ExcelUtils() {
    }

    private static void initialize() {
        if (!initialized) {
            try {
                BModule excelSupportModule = Sys.loadModule((String)EXCEL_SUPPORT_MODULE);
                Class factoryClass = excelSupportModule.loadClass(FACTORY_CLASS_NAME);
                Method instanceMethod = factoryClass.getMethod(FACTORY_INSTANCE_METHOD_NAME, new Class[0]);
                factory = (Factory)instanceMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException | ModuleNotFoundException e) {
                initializationError = e;
            }
            finally {
                initialized = true;
            }
        }
    }
}

