/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinetDevice;
import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.BInfinityNetworkDevice;
import com.tridium.andoverInfinity.comm.InfinityUtil;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinityReadPointResponse;
import com.tridium.andoverInfinity.identify.BInfinityDeviceId;
import com.tridium.andoverInfinity.identify.BInfinityPointId;
import com.tridium.andoverInfinity.identify.BInfinityReadPointParams;
import com.tridium.andoverInfinity.point.BInfinityProxyExt;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfReadRequest;
import com.tridium.ddf.comm.req.BIDdfPingRequest;
import com.tridium.ddf.comm.req.IDdfPingable;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import java.util.StringTokenizer;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BInfinityReadPointRequest
extends BDdfReadRequest
implements RequiresNetworkAccess,
Vt100Const,
BIDdfPingRequest {
    @Generated
    public static final Type TYPE = Sys.loadType(BInfinityReadPointRequest.class);
    private static String RPROMPT = "R>";
    private IDdfPingable[] pingableSource;
    BInfinityNetwork network;
    int recoveryCount = 0;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDevDataFrame) throws DdfResponseException {
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinityReadPointRequest:processReceive(), mode=" + cursorModes[mode]);
        int line = this.network.getScreen().getCursorLine();
        switch (mode) {
            case 4: {
                if (this.network.getScreen().getTextLine(line).endsWith(RPROMPT)) {
                    String answer = this.network.getScreen().getTextLine(line - 1);
                    try {
                        answer = this.sanityCheck(answer);
                        BInfinityReadPointResponse rsp = new BInfinityReadPointResponse(answer);
                        return rsp;
                    }
                    catch (DdfResponseException dfe) {
                        IDdfReadable[] pointsToUpdate = this.getReadableSource();
                        for (int i = 0; i < pointsToUpdate.length; ++i) {
                            if (!(pointsToUpdate[0] instanceof BInfinityProxyExt)) continue;
                            BInfinityProxyExt ext = (BInfinityProxyExt)pointsToUpdate[i];
                            BInfinityPointId id = (BInfinityPointId)ext.getPointId();
                            id.setRawResponse(answer);
                        }
                        throw dfe;
                    }
                }
                throw new DdfResponseException("Invalid response:no R>," + this.network.getScreen().getTextLine(line));
            }
        }
        throw new DdfResponseException("Invalid response:" + this.network.getScreen().getTextLine(line));
    }

    private String getPointName() {
        BInfinityReadPointParams readParams = (BInfinityReadPointParams)this.getReadParameters();
        return readParams.getPointName();
    }

    private String sanityCheck(String rspLine) throws DdfResponseException {
        String pointName = this.getPointName();
        int split = rspLine.indexOf(" = ");
        if (split == -1) {
            if (rspLine.trim().length() > 0) {
                throw new DdfResponseException(rspLine.trim());
            }
            throw new DdfResponseException("missing =");
        }
        String leftSideString = rspLine.substring(0, split).trim();
        String rightSideString = rspLine.substring(split + 3).trim();
        if (leftSideString.length() == 0 || rightSideString.length() == 0) {
            throw new DdfResponseException("not enough tokens");
        }
        StringTokenizer leftSide = new StringTokenizer(leftSideString, " ");
        if (leftSide.countTokens() == 1) {
            if (leftSide.nextToken().trim().equalsIgnoreCase(pointName)) {
                return rspLine;
            }
            throw new DdfResponseException("response name does not equal requested name");
        }
        if (leftSide.countTokens() == 3) {
            leftSide.nextToken();
            leftSide.nextToken();
            String rspPnt = leftSide.nextToken().trim();
            if (rspPnt.equalsIgnoreCase(pointName)) {
                return rspLine;
            }
            throw new DdfResponseException("response name does not equal requested name");
        }
        throw new DdfResponseException("response not as expected:" + rspLine);
    }

    private BInfinityProxyExt getOriginator() {
        IDdfReadable[] pointsToUpdate = this.getReadableSource();
        for (int i = 0; i < pointsToUpdate.length; ++i) {
            if (!(pointsToUpdate[i] instanceof BInfinityProxyExt)) continue;
            return (BInfinityProxyExt)pointsToUpdate[i];
        }
        throw new RuntimeException("readableSource does not include an InfinityProxyExt");
    }

    public byte[] toByteArray() {
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinityReadPointRequest:toByteArray(), mode=" + cursorModes[mode]);
        StringBuffer sb = new StringBuffer();
        switch (mode) {
            case 0: 
            case 1: 
            case 138: {
                if (this.network.isConnected()) {
                    return "\u001a".getBytes();
                }
                return ("window" + this.network.getNetworkDevice().getUserName() + "\t").getBytes();
            }
            case 4: {
                if (this.network.getScreen().isInsertMode()) {
                    sb.append("\u001bi");
                    this.network.getScreen().resetInsertMode();
                }
                InfinityUtil.addMoveCursorCommands(this.network.getScreen(), sb);
                InfinityUtil.addChangeDeviceCommands(this.network.getScreen(), sb);
                break;
            }
            case 3: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 132: {
                ++this.recoveryCount;
                return this.network.getScreen().getRecovery(mode).getBytes();
            }
            default: {
                String recovery = this.network.getScreen().getRecovery(mode);
                sb.append(recovery);
            }
        }
        BInfinityReadPointParams readParams = (BInfinityReadPointParams)this.getReadParameters();
        String pointName = readParams.getPointName();
        BInfinityProxyExt updateProxy = this.getOriginator();
        BInfinetDevice device = (BInfinetDevice)updateProxy.getDevice();
        BInfinityDeviceId deviceId = (BInfinityDeviceId)this.getDeviceId();
        if (device instanceof BInfinityNetworkDevice) {
            sb.append("P ").append(pointName).append("\r");
        } else {
            sb.append("P ").append(deviceId.getControllerName()).append(" ").append(pointName).append("\r");
        }
        return sb.toString().getBytes();
    }

    public boolean getAutoPingFailOnError() {
        return false;
    }

    public boolean getAutoPingFailOnTimeout() {
        return true;
    }

    public boolean getAutoPingOk() {
        return true;
    }

    public boolean getAutoPingOkLate() {
        return false;
    }

    public IDdfPingable[] getPingableSource() {
        return this.pingableSource;
    }

    public void setPingableSource(IDdfPingable[] pingableSource) {
        this.pingableSource = pingableSource;
    }

    @Override
    public void setNetwork(BInfinityNetwork network) {
        this.network = network;
    }
}

