/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rtsp;

import java.io.IOException;
import java.io.InputStream;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.rtsp.RtpPacket;
import javax.baja.rtsp.RtspConnection;
import javax.baja.sys.Clock;
import javax.baja.util.Queue;

public class RtpStream
extends InputStream {
    public long time = 0L;
    protected static final long msb0baseTime = 2085978496000L;
    protected static final long msb1baseTime = -2208988800000L;
    RtspConnection rtspConnection;
    long dataReceived = 0L;
    long lastTick = 0L;
    double bandwidth = 0.0;
    long frameCount = 0L;
    long frameTime = 0L;
    long rtcpTime = 0L;
    Queue packetQueue;
    int packetCount = 0;
    int lastSequence = 0;
    int packetLost = 0;
    int port = 0;
    int udpbuffersize = 0;
    public byte[] rtpDataBuffer = new byte[0];
    public Object monitor = new Object();
    public boolean marker = false;
    public boolean useQueue = false;
    ByteBuffer frameRead = new ByteBuffer();
    public RtspConnection.SessionObject session;

    RtpStream() {
        this.packetQueue = new Queue();
    }

    void setRtspConnection(RtspConnection rtspConnection) {
        this.rtspConnection = rtspConnection;
    }

    RtspConnection getRtspConnection() {
        return this.rtspConnection;
    }

    @Override
    public void close() throws IOException {
        this.clearPacketQueue();
        super.close();
    }

    public void setPortandBuffer(int port, int buffer) {
        this.port = port;
        this.udpbuffersize = buffer;
    }

    @Override
    public int read() throws IOException {
        throw new IOException("Please use the readPacketMethod instead");
    }

    public void addPacket(RtpPacket pack, boolean RTP) throws Exception {
        if (pack == null) {
            return;
        }
        if (!RTP) {
            this.useRtcp(pack);
            return;
        }
        if (this.lastSequence == 0) {
            this.lastSequence = pack.seq_num;
        } else if (pack.seq_num - this.lastSequence > 1 && pack.seq_num - this.lastSequence < 100) {
            this.packetLost += pack.seq_num - this.lastSequence - 1;
        } else {
            this.lastSequence = pack.seq_num;
        }
        ++this.packetCount;
        this.packetQueue.enqueue((Object)pack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtpPacket readPacket() throws Exception {
        RtpPacket packet = (RtpPacket)this.packetQueue.dequeue(100);
        RtpStream rtpStream = this;
        synchronized (rtpStream) {
            this.notifyAll();
        }
        return packet;
    }

    public void useRtcp(RtpPacket pack) {
        long now = Clock.ticks();
        if (this.lastTick == 0L) {
            this.dataReceived = 0L;
        } else if (now - this.lastTick != 0L) {
            this.bandwidth = this.dataReceived / (now - this.lastTick) * 1000L / 1024L;
        }
        this.dataReceived = 0L;
        this.lastTick = now;
        this.time = this.getTime(pack.ntpTimeStamp1, pack.ntpTimeStamp2);
    }

    public long getTime() {
        return this.time;
    }

    public int size() {
        return this.packetQueue.size();
    }

    public void clearPacketQueue() {
        this.packetQueue.clear();
    }

    public byte[] readFrame() throws Exception {
        this.frameRead.reset();
        boolean finishFrame = false;
        while (!finishFrame) {
            RtpPacket pack = this.readPacket();
            if (pack != null) {
                finishFrame = pack.marker;
                this.frameRead.write(pack.payload, 0, pack.pay_length);
                continue;
            }
            finishFrame = true;
        }
        ++this.frameCount;
        return this.frameRead.toByteArray();
    }

    public long getFrameTime() {
        return this.frameTime;
    }

    public long getTime(long ntpTimeValue1, long ntpTimeValue2) {
        long seconds = ntpTimeValue1 & 0xFFFFFFFFL;
        long fraction = ntpTimeValue2 & 0xFFFFFFFFL;
        fraction = Math.round(1000.0 * (double)fraction / 4.294967296E9);
        long msb = seconds & 0x80000000L;
        if (msb == 0L) {
            return 2085978496000L + seconds * 1000L + fraction;
        }
        return -2208988800000L + seconds * 1000L + fraction;
    }

    public String getBandwidth() {
        if (this.bandwidth == 0.0) {
            return "Calculating...";
        }
        return this.bandwidth + " KBPS";
    }

    public double getPacketLoss() {
        double res = 0.0;
        if (this.packetLost <= 0) {
            return 0.0;
        }
        res = this.packetLost / this.packetCount;
        return res;
    }

    public int getPacketCount() {
        return this.packetCount;
    }

    public int numPacketLost() {
        return this.packetLost;
    }

    public long getFrameCount() {
        return this.frameCount;
    }

    public int getPort() {
        return this.port;
    }

    public int getUdpBufferSize() {
        return this.udpbuffersize;
    }
}

