/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.azure.msg;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.file.IFileUploadStatus;
import com.tridium.cloudLink.file.IUploadChannelConfig;
import com.tridium.cloudLink.msg.IEndFileUploadHandler;
import com.tridium.cloudLink.msg.ISensitiveMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.util.IValueWrapper;
import com.tridium.cloudLink.util.PasswordWrapper;
import com.tridium.cloudLink.util.StringWrapper;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AzureUpdateFileUploadStatusHandler
implements IEndFileUploadHandler,
ISensitiveMessageBuilder {
    private boolean _hasData;
    protected StringWriter stringWriter;
    protected JSONWriter jsonSerializer;
    private final BChannelConfig config;
    private Map<String, IValueWrapper<?>> connectionInfo;
    private static final String AZURE_FILE_UPLOAD_NOTIFICATION_URL_TEMPLATE = "https://%s/devices/%s/files/notifications?api-version=2020-03-13";
    protected static final Logger log = Logger.getLogger("cloudLink.file.upload");

    public AzureUpdateFileUploadStatusHandler(BChannelConfig config) {
        if (!(config instanceof IUploadChannelConfig)) {
            log.info("unable to get authentication info identifier for file upload");
            throw new IllegalArgumentException("unable to get authentication info identifier for file upload");
        }
        this.config = config;
        this.initializeMessage();
    }

    public int add(IFileUploadStatus value) {
        if (!this._hasData) {
            this.jsonSerializer.object();
            this.jsonSerializer.key("correlationId").value((Object)value.getInfo().getCorrelationId());
            Throwable error = value.getError();
            boolean isSuccess = error == null;
            this.jsonSerializer.key("isSuccess").value(isSuccess);
            this.jsonSerializer.key("statusCode").value(isSuccess ? 200L : 400L);
            this.jsonSerializer.key("statusDescription").value((Object)(isSuccess ? "File uploaded successfully" : error.getMessage()));
            this.jsonSerializer.endObject();
            this._hasData = true;
        }
        return this.stringWriter.getBuffer().length();
    }

    public void loadSensitives() {
        this.connectionInfo = this.config.getAuthenticator(IEndFileUploadHandler.getOperationId()).getConnectionInfo(((IUploadChannelConfig)this.config).getConnectionInfoName());
    }

    public IMessage toMessage(boolean isFinal) {
        HttpRequestMessage message;
        String uploadEndpoint = "";
        if (this.connectionInfo == null || this.connectionInfo.isEmpty()) {
            throw new RuntimeException("Connection information unavailable");
        }
        try {
            uploadEndpoint = String.format(AZURE_FILE_UPLOAD_NOTIFICATION_URL_TEMPLATE, StringWrapper.getString(this.connectionInfo.get("hostName")), StringWrapper.getString(this.connectionInfo.get("id")));
            String token = AccessController.doPrivileged(() -> PasswordWrapper.getPasswordValue(this.connectionInfo.get("token")));
            Map requestHeaders = CloudLinkUtils.makeSasTokenAuthHeaderMap((String)token);
            this.stringWriter.flush();
            String requestBody = this.stringWriter.toString();
            message = new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, new URL(uploadEndpoint), requestHeaders).mimeType("application/json").body(requestBody).build();
            log.finest(() -> String.format("Http message - headers: %s, payload [%s]", requestHeaders, requestBody));
        }
        catch (MalformedURLException urlExcept) {
            String logMsg = "An error occurred while creating the URL " + uploadEndpoint;
            log.log(Level.WARNING, logMsg, log.isLoggable(Level.FINE) ? urlExcept : null);
            throw new RuntimeException(logMsg, urlExcept);
        }
        finally {
            this.connectionInfo = null;
        }
        if (!isFinal) {
            this.initializeMessage();
        }
        return message;
    }

    public CompletableFuture<IMessageResponse> getFuture(CompletableFuture<Void> channelFuture, IMessage message) {
        CompletableFuture<IMessageResponse> future = new CompletableFuture<IMessageResponse>();
        future.whenComplete((resp, err) -> {
            if (err != null) {
                channelFuture.completeExceptionally((Throwable)err);
            } else {
                channelFuture.complete(null);
            }
        });
        return future;
    }

    protected final void finalize() throws Throwable {
    }

    protected void initializeMessage() {
        this.stringWriter = new StringWriter();
        this.jsonSerializer = QuickJSONWriter.make((Appendable)this.stringWriter);
        this._hasData = false;
    }
}

