/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.azure.auth;

import com.tridium.azureUtils.AzureIotSasTokenUtils;
import com.tridium.azureUtils.AzureSasException;
import com.tridium.azureUtils.AzureSasTokenParameters;
import com.tridium.azureUtils.BAzureIotSasToken;
import com.tridium.azureUtils.BAzureSasTokenParameters;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.util.IValueWrapper;
import com.tridium.cloudLink.util.PasswordWrapper;
import com.tridium.cloudLink.util.StringWrapper;
import com.tridium.nre.security.NiagaraBasicPermission;
import java.security.AccessController;
import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="authenticatorId", type="BString", defaultValue="BString.make(AUTH_PLATFORM_TYPE_AZURE_SAS)", flags=1, override=true), @NiagaraProperty(name="sslVersion", type="BSslTlsEnum", defaultValue="BSslTlsEnum.tlsv1_2", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="newTokenDelay", type="BRelTime", defaultValue="BRelTime.makeSeconds(5)", facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"second\")"), @Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(0)"), @Facet(name="BFacets.MAX", value="BRelTime.makeSeconds(60)")}), @NiagaraProperty(name="advanceRenewal", type="BRelTime", defaultValue="BRelTime.makeMinutes(15)", facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"minute\")"), @Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(0)"), @Facet(name="BFacets.MAX", value="BRelTime.makeHours(1)")}), @NiagaraProperty(name="lastError", type="String", defaultValue="BString.DEFAULT", flags=65), @NiagaraProperty(name="lastErrorTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65), @NiagaraProperty(name="tokenParameters", type="BAzureSasTokenParameters", defaultValue="new BAzureSasTokenParameters()"), @NiagaraProperty(name="currentToken", type="BAzureIotSasToken", defaultValue="new BAzureIotSasToken()")})
@NiagaraActions(value={@NiagaraAction(name="generateNewToken", flags=16), @NiagaraAction(name="setupFromConnectionString", parameterType="BString", defaultValue="BString.DEFAULT")})
public class BAzureSasAuthenticator
extends BAbstractClientAuthenticator {
    @Generated
    public static final Property authenticatorId = BAzureSasAuthenticator.newProperty((int)1, (BValue)BString.make((String)"Azure SAS Token"), null);
    @Generated
    public static final Property sslVersion = BAzureSasAuthenticator.newProperty((int)0, (BValue)BSslTlsEnum.tlsv1_2, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property newTokenDelay = BAzureSasAuthenticator.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)5), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"second")), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeSeconds((int)60))));
    @Generated
    public static final Property advanceRenewal = BAzureSasAuthenticator.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)15), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"minute")), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeHours((int)1))));
    @Generated
    public static final Property lastError = BAzureSasAuthenticator.newProperty((int)65, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property lastErrorTime = BAzureSasAuthenticator.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property tokenParameters = BAzureSasAuthenticator.newProperty((int)0, (BValue)new BAzureSasTokenParameters(), null);
    @Generated
    public static final Property currentToken = BAzureSasAuthenticator.newProperty((int)0, (BValue)new BAzureIotSasToken(), null);
    @Generated
    public static final Action generateNewToken = BAzureSasAuthenticator.newAction((int)16, null);
    @Generated
    public static final Action setupFromConnectionString = BAzureSasAuthenticator.newAction((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAzureSasAuthenticator.class);
    private static final Logger log = Logger.getLogger("cloudLinkAzure.auth");
    private Clock.Ticket regenTicket;
    private ScheduledExecutorService worker;

    @Generated
    public BSslTlsEnum getSslVersion() {
        return (BSslTlsEnum)this.get(sslVersion);
    }

    @Generated
    public void setSslVersion(BSslTlsEnum v) {
        this.set(sslVersion, (BValue)v, null);
    }

    @Generated
    public BRelTime getNewTokenDelay() {
        return (BRelTime)this.get(newTokenDelay);
    }

    @Generated
    public void setNewTokenDelay(BRelTime v) {
        this.set(newTokenDelay, (BValue)v, null);
    }

    @Generated
    public BRelTime getAdvanceRenewal() {
        return (BRelTime)this.get(advanceRenewal);
    }

    @Generated
    public void setAdvanceRenewal(BRelTime v) {
        this.set(advanceRenewal, (BValue)v, null);
    }

    @Generated
    public String getLastError() {
        return this.getString(lastError);
    }

    @Generated
    public void setLastError(String v) {
        this.setString(lastError, v, null);
    }

    @Generated
    public BAbsTime getLastErrorTime() {
        return (BAbsTime)this.get(lastErrorTime);
    }

    @Generated
    public void setLastErrorTime(BAbsTime v) {
        this.set(lastErrorTime, (BValue)v, null);
    }

    @Generated
    public BAzureSasTokenParameters getTokenParameters() {
        return (BAzureSasTokenParameters)this.get(tokenParameters);
    }

    @Generated
    public void setTokenParameters(BAzureSasTokenParameters v) {
        this.set(tokenParameters, (BValue)v, null);
    }

    @Generated
    public BAzureIotSasToken getCurrentToken() {
        return (BAzureIotSasToken)this.get(currentToken);
    }

    @Generated
    public void setCurrentToken(BAzureIotSasToken v) {
        this.set(currentToken, (BValue)v, null);
    }

    @Generated
    public void generateNewToken() {
        this.invoke(generateNewToken, null, null);
    }

    @Generated
    public void setupFromConnectionString(BString parameter) {
        this.invoke(setupFromConnectionString, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void started() {
        if (Sys.isStation() && this.getCurrentToken().getTokenStored()) {
            this.scheduleNewTokenGen();
        }
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 12: {
                this.fwStopped();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    protected void fwStarted() {
        BCloudConnectionService ccs = this.getConnectionService().orElse(null);
        if (ccs == null || ccs.isFatalFault()) {
            return;
        }
        this.worker = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("cloudLinkAzure.AzureSasAuthenticator");
                t.setPriority(1);
                return t;
            }
        });
    }

    protected void fwStopped() {
        if (this.worker != null) {
            this.worker.shutdownNow();
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (generateNewToken.equals(action)) {
            this.worker.execute(this::doGenerateNewToken);
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void doSetupFromConnectionString(BString connectionString) {
        if (this.isRunning()) {
            try {
                this.setupFromAzureConnectionString(connectionString.getString());
            }
            catch (Exception e) {
                this.error(String.format("Failed to setup new SAS token because: %s", e.getMessage()), e);
            }
        }
    }

    private void setupFromAzureConnectionString(String connectionString) throws AzureSasException {
        AzureSasTokenParameters parameters = AzureIotSasTokenUtils.getParametersForConnectionString((String)connectionString, (String)this.getTokenParameters().getApiVersion());
        this.getTokenParameters().setAzureHost(parameters.getAzureHost());
        this.getTokenParameters().setAzureDeviceId(parameters.getAzureDeviceId());
        this.getTokenParameters().setUserName(parameters.getUserName());
        this.getTokenParameters().setSharedAccessKey(parameters.getSharedAccessKey());
        this.getTokenParameters().store(this.getKeyRingStoreKey());
        if (!this.getSystemId().equals(this.getTokenParameters().getAzureDeviceId())) {
            log.info(() -> String.format("Updating Azure Sas Authenticator systemId from %s to %s due to new connection string", this.getSystemId(), this.getTokenParameters().getAzureDeviceId()));
        }
        this.setSystemId(this.getTokenParameters().getAzureDeviceId());
        this.generateNewToken();
    }

    public void doGenerateNewToken() {
        log.info("Generating new SAS token");
        try {
            AccessController.doPrivileged(() -> {
                this.getTokenParameters().validate(this.getKeyRingStoreKey());
                this.setCurrentToken(AzureIotSasTokenUtils.generateSasToken((BAzureSasTokenParameters)this.getTokenParameters(), (String)this.getKeyRingStoreKey()));
                this.scheduleNewTokenGen();
                log.info("Generated new SAS token");
                return null;
            });
        }
        catch (Exception e) {
            this.error(String.format("Failed to generate new SAS token because: %s", e.getMessage()), e);
        }
    }

    public void addMessageHandlerProperties(BAbstractTransport transport, String audience, Map<String, Object> encoderProps) {
    }

    public Map<String, Object> getPlatformProperties() {
        return Collections.emptyMap();
    }

    public boolean canAuthenticate() {
        try {
            AccessController.doPrivileged(() -> {
                this.getTokenParameters().validate(this.getHandle().toString());
                return null;
            });
            return true;
        }
        catch (Exception any) {
            log.log(Level.FINE, log.isLoggable(Level.FINEST) ? any : null, () -> String.format("Could not validate token parameters for authentication check: %s", any));
            return false;
        }
    }

    public boolean isRegistered() {
        return true;
    }

    public final Map<String, IValueWrapper<?>> getConnectionInfo(String id) {
        NiagaraBasicPermission getConnectionStringPermission = new NiagaraBasicPermission("CLOUD_GET_CONNECTION_INFORMATION");
        SecurityManager sm = System.getSecurityManager();
        if (sm == null || !this.isOperational()) {
            return Collections.emptyMap();
        }
        sm.checkPermission((Permission)getConnectionStringPermission);
        HashMap connectionMap = new HashMap();
        if (this.canAuthenticate()) {
            String storeValue = AccessController.doPrivileged(() -> this.getCurrentToken().getStoreValue());
            if (storeValue == null || storeValue.isEmpty()) {
                log.fine("Refreshing SAS Token for Azure Authenticator");
                this.doGenerateNewToken();
                storeValue = AccessController.doPrivileged(() -> this.getCurrentToken().getStoreValue());
            }
            if (storeValue == null) {
                log.warning("SAS Authenticator cannot populate connection info: SAS Token store value is null");
            } else {
                connectionMap.put("sslHostFormatString", (IValueWrapper<?>)new StringWrapper("ssl://%s"));
                connectionMap.put("wsHostFormatString", (IValueWrapper<?>)new StringWrapper("wss://%s/$iothub/websocket?iothub-no-client-cert=true"));
                connectionMap.put("hostName", (IValueWrapper<?>)new StringWrapper(this.getTokenParameters().getAzureHost()));
                connectionMap.put("clientId", (IValueWrapper<?>)new StringWrapper(this.getTokenParameters().getAzureDeviceId()));
                connectionMap.put("id", (IValueWrapper<?>)new StringWrapper(this.getTokenParameters().getUserName()));
                connectionMap.put("token", (IValueWrapper<?>)new PasswordWrapper(BPassword.make((String)storeValue)));
            }
        }
        return connectionMap;
    }

    public String getCertificate(String id) {
        throw new UnsupportedOperationException("Cannot get certificate");
    }

    private String getKeyRingStoreKey() {
        return this.getHandle().toString();
    }

    private void scheduleNewTokenGen() {
        BAbsTime nextRegenTime;
        if (this.regenTicket != null && !this.regenTicket.isExpired()) {
            this.regenTicket.cancel();
        }
        if ((nextRegenTime = this.getCurrentToken().getNextExpiryTime().subtract(this.getAdvanceRenewal())).isBefore(BAbsTime.now())) {
            nextRegenTime = BAbsTime.now().add(this.getNewTokenDelay());
        } else {
            String token = this.getCurrentToken().getStoreValue();
            if (token == null || token.isEmpty()) {
                nextRegenTime = BAbsTime.now().add(this.getNewTokenDelay());
            }
        }
        log.info(String.format("Scheduled next SAS token generation at %s", nextRegenTime.toString((Context)BFacets.make((String)"showMilliseconds", (boolean)true))));
        this.regenTicket = Clock.schedule((BComponent)this, (BAbsTime)nextRegenTime, (Action)generateNewToken, null);
    }

    private void error(String message, Exception e) {
        log.log(Level.SEVERE, message, e);
        this.setLastError(message);
        this.setLastErrorTime(BAbsTime.now());
    }
}

