/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.point;

import com.prosysopc.ua.AbstractOptionSetDataType;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.stack.builtintypes.BuiltinsMap;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.stack.core.EventNotifierType;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.core.ReferenceTypeIdentifiers;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.tridium.ndriver.discover.BINDiscoveryIcon;
import com.tridium.ndriver.discover.BINDiscoveryLeaf;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.alarm.BOpcUaClientAlarmDeviceExt;
import com.tridium.opcUaClient.point.BOpcUaLearnBase;
import com.tridium.opcUaClient.util.OpcUaClientUtil;
import com.tridium.opcUaCore.units.OpcUaUnitConverter;
import java.security.AccessController;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitException;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="UaNodeName", type="String", defaultValue="", flags=5), @NiagaraProperty(name="UaDisplayName", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="structurePath", type="String", defaultValue="", flags=5), @NiagaraProperty(name="isStructureComponent", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="isStructure", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="UaNodeId", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="NameSpaceUri", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="useServerTimestamp", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="ArrayDimension", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="ArrayIndex", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="NodeClass", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="Description", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="TypeSpec", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="UaDataType", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="UaDataTypeIdentifier", type="long", defaultValue="-1", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="UaValue", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="UaInstanceType", type="String", defaultValue="", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="WriteMask", type="long", defaultValue="0", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="UserWriteMask", type="long", defaultValue="0", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="AccessLevel", type="int", defaultValue="0", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="userAccessLevel", type="int", defaultValue="0", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="EventNotifier", type="int", defaultValue="0", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="HasCondition", type="boolean", defaultValue="false", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="Historizing", type="boolean", defaultValue="false", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="Facets", type="BFacets", defaultValue="BFacets.NULL", flags=5, facets={@Facet(value="SfUtil.incl()")}), @NiagaraProperty(name="IsProperty", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="IsEventType", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="HasAddableDescendant", type="boolean", defaultValue="false", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="test", flags=16), @NiagaraAction(name="showDetail", flags=16), @NiagaraAction(name="hideDetail", flags=16), @NiagaraAction(name="dumpHistory", flags=16), @NiagaraAction(name="subscribeForEvents", flags=16)})
public class BOpcUaNodeLearnEntry
extends BComponent
implements BINDiscoveryLeaf,
BINDiscoveryIcon,
BINDiscoveryObject {
    @Generated
    public static final Property UaNodeName = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", null);
    @Generated
    public static final Property UaDisplayName = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property structurePath = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", null);
    @Generated
    public static final Property isStructureComponent = BOpcUaNodeLearnEntry.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property isStructure = BOpcUaNodeLearnEntry.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property UaNodeId = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property NameSpaceUri = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property useServerTimestamp = BOpcUaNodeLearnEntry.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property ArrayDimension = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property ArrayIndex = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property NodeClass = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property Description = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property TypeSpec = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property UaDataType = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property UaDataTypeIdentifier = BOpcUaNodeLearnEntry.newProperty((int)5, (int)-1, (BFacets)SfUtil.incl());
    @Generated
    public static final Property UaValue = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property UaInstanceType = BOpcUaNodeLearnEntry.newProperty((int)5, (String)"", (BFacets)SfUtil.incl());
    @Generated
    public static final Property WriteMask = BOpcUaNodeLearnEntry.newProperty((int)5, (int)0, (BFacets)SfUtil.incl());
    @Generated
    public static final Property UserWriteMask = BOpcUaNodeLearnEntry.newProperty((int)5, (int)0, (BFacets)SfUtil.incl());
    @Generated
    public static final Property AccessLevel = BOpcUaNodeLearnEntry.newProperty((int)5, (int)0, (BFacets)SfUtil.incl());
    @Generated
    public static final Property userAccessLevel = BOpcUaNodeLearnEntry.newProperty((int)5, (int)0, (BFacets)SfUtil.incl());
    @Generated
    public static final Property EventNotifier = BOpcUaNodeLearnEntry.newProperty((int)5, (int)0, (BFacets)SfUtil.incl());
    @Generated
    public static final Property HasCondition = BOpcUaNodeLearnEntry.newProperty((int)5, (boolean)false, (BFacets)SfUtil.incl());
    @Generated
    public static final Property Historizing = BOpcUaNodeLearnEntry.newProperty((int)5, (boolean)false, (BFacets)SfUtil.incl());
    @Generated
    public static final Property Facets = BOpcUaNodeLearnEntry.newProperty((int)5, (BValue)BFacets.NULL, (BFacets)SfUtil.incl());
    @Generated
    public static final Property IsProperty = BOpcUaNodeLearnEntry.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property IsEventType = BOpcUaNodeLearnEntry.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property HasAddableDescendant = BOpcUaNodeLearnEntry.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Action test = BOpcUaNodeLearnEntry.newAction((int)16, null);
    @Generated
    public static final Action showDetail = BOpcUaNodeLearnEntry.newAction((int)16, null);
    @Generated
    public static final Action hideDetail = BOpcUaNodeLearnEntry.newAction((int)16, null);
    @Generated
    public static final Action dumpHistory = BOpcUaNodeLearnEntry.newAction((int)16, null);
    @Generated
    public static final Action subscribeForEvents = BOpcUaNodeLearnEntry.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaNodeLearnEntry.class);
    private static int level = 0;
    public static final Logger logger = Logger.getLogger("opcUaClient.point");
    private static final BIcon NC_OBJECT_ICON = BIcon.std((String)"folder.png");
    private static final BIcon NC_METHOD_ICON = BIcon.std((String)"gears.png");
    private static final BIcon NUMERIC_ICON = BIcon.std((String)"control/numericPoint.png");
    private static final BIcon BOOLEAN_ICON = BIcon.std((String)"control/booleanPoint.png");
    private static final BIcon ENUM_ICON = BIcon.std((String)"control/enumPoint.png");
    private static final BIcon STRING_ICON = BIcon.std((String)"control/stringPoint.png");
    private static final BIcon HISTORY_ICON = BIcon.std((String)"badges/history.png");
    private static final String lBracket = "\\[";
    private static final TypeInfo[] NO_TYPES = new TypeInfo[0];
    private static final TypeInfo[] RD_NUMERIC_TYPE = new TypeInfo[]{BNumericPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_BOOLEAN_TYPE = new TypeInfo[]{BBooleanPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_ENUM_TYPE = new TypeInfo[]{BEnumPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_STRING_TYPE = new TypeInfo[]{BStringPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_WR_NUMERIC_TYPE = new TypeInfo[]{BNumericWritable.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_WR_BOOLEAN_TYPE = new TypeInfo[]{BBooleanWritable.TYPE.getTypeInfo(), BBooleanPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_WR_ENUM_TYPE = new TypeInfo[]{BEnumWritable.TYPE.getTypeInfo(), BEnumPoint.TYPE.getTypeInfo()};
    private static final TypeInfo[] RD_WR_STRING_TYPE = new TypeInfo[]{BStringWritable.TYPE.getTypeInfo(), BStringPoint.TYPE.getTypeInfo()};
    private int structureDepth = 0;
    private static final int MAX_STRUCTURE_DEPTH_SUPPORTED = 100;
    private static final String EU_INFORMATION_PROPERTY_NAME = "EUInformation";
    private static final String UNIT_ID_PROPERTY_NAME = "UnitId";
    private static final int DEFAULT_UNIT_ID = -1;
    private static final int DEFAULT_PRECISION = 2;
    private static final int OPCUA_SERVER_BAD_UNIT_VALUE = 3;

    @Generated
    public String getUaNodeName() {
        return this.getString(UaNodeName);
    }

    @Generated
    public void setUaNodeName(String v) {
        this.setString(UaNodeName, v, null);
    }

    @Generated
    public String getUaDisplayName() {
        return this.getString(UaDisplayName);
    }

    @Generated
    public void setUaDisplayName(String v) {
        this.setString(UaDisplayName, v, null);
    }

    @Generated
    public String getStructurePath() {
        return this.getString(structurePath);
    }

    @Generated
    public void setStructurePath(String v) {
        this.setString(structurePath, v, null);
    }

    @Generated
    public boolean getIsStructureComponent() {
        return this.getBoolean(isStructureComponent);
    }

    @Generated
    public void setIsStructureComponent(boolean v) {
        this.setBoolean(isStructureComponent, v, null);
    }

    @Generated
    public boolean getIsStructure() {
        return this.getBoolean(isStructure);
    }

    @Generated
    public void setIsStructure(boolean v) {
        this.setBoolean(isStructure, v, null);
    }

    @Generated
    public String getUaNodeId() {
        return this.getString(UaNodeId);
    }

    @Generated
    public void setUaNodeId(String v) {
        this.setString(UaNodeId, v, null);
    }

    @Generated
    public String getNameSpaceUri() {
        return this.getString(NameSpaceUri);
    }

    @Generated
    public void setNameSpaceUri(String v) {
        this.setString(NameSpaceUri, v, null);
    }

    @Generated
    public boolean getUseServerTimestamp() {
        return this.getBoolean(useServerTimestamp);
    }

    @Generated
    public void setUseServerTimestamp(boolean v) {
        this.setBoolean(useServerTimestamp, v, null);
    }

    @Generated
    public String getArrayDimension() {
        return this.getString(ArrayDimension);
    }

    @Generated
    public void setArrayDimension(String v) {
        this.setString(ArrayDimension, v, null);
    }

    @Generated
    public String getArrayIndex() {
        return this.getString(ArrayIndex);
    }

    @Generated
    public void setArrayIndex(String v) {
        this.setString(ArrayIndex, v, null);
    }

    @Generated
    public String getNodeClass() {
        return this.getString(NodeClass);
    }

    @Generated
    public void setNodeClass(String v) {
        this.setString(NodeClass, v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(Description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(Description, v, null);
    }

    @Generated
    public String getTypeSpec() {
        return this.getString(TypeSpec);
    }

    @Generated
    public void setTypeSpec(String v) {
        this.setString(TypeSpec, v, null);
    }

    @Generated
    public String getUaDataType() {
        return this.getString(UaDataType);
    }

    @Generated
    public void setUaDataType(String v) {
        this.setString(UaDataType, v, null);
    }

    @Generated
    public long getUaDataTypeIdentifier() {
        return this.getLong(UaDataTypeIdentifier);
    }

    @Generated
    public void setUaDataTypeIdentifier(long v) {
        this.setLong(UaDataTypeIdentifier, v, null);
    }

    @Generated
    public String getUaValue() {
        return this.getString(UaValue);
    }

    @Generated
    public void setUaValue(String v) {
        this.setString(UaValue, v, null);
    }

    @Generated
    public String getUaInstanceType() {
        return this.getString(UaInstanceType);
    }

    @Generated
    public void setUaInstanceType(String v) {
        this.setString(UaInstanceType, v, null);
    }

    @Generated
    public long getWriteMask() {
        return this.getLong(WriteMask);
    }

    @Generated
    public void setWriteMask(long v) {
        this.setLong(WriteMask, v, null);
    }

    @Generated
    public long getUserWriteMask() {
        return this.getLong(UserWriteMask);
    }

    @Generated
    public void setUserWriteMask(long v) {
        this.setLong(UserWriteMask, v, null);
    }

    @Generated
    public int getAccessLevel() {
        return this.getInt(AccessLevel);
    }

    @Generated
    public void setAccessLevel(int v) {
        this.setInt(AccessLevel, v, null);
    }

    @Generated
    public int getUserAccessLevel() {
        return this.getInt(userAccessLevel);
    }

    @Generated
    public void setUserAccessLevel(int v) {
        this.setInt(userAccessLevel, v, null);
    }

    @Generated
    public int getEventNotifier() {
        return this.getInt(EventNotifier);
    }

    @Generated
    public void setEventNotifier(int v) {
        this.setInt(EventNotifier, v, null);
    }

    @Generated
    public boolean getHasCondition() {
        return this.getBoolean(HasCondition);
    }

    @Generated
    public void setHasCondition(boolean v) {
        this.setBoolean(HasCondition, v, null);
    }

    @Generated
    public boolean getHistorizing() {
        return this.getBoolean(Historizing);
    }

    @Generated
    public void setHistorizing(boolean v) {
        this.setBoolean(Historizing, v, null);
    }

    @Generated
    public BFacets getFacets() {
        return (BFacets)this.get(Facets);
    }

    @Generated
    public void setFacets(BFacets v) {
        this.set(Facets, (BValue)v, null);
    }

    @Generated
    public boolean getIsProperty() {
        return this.getBoolean(IsProperty);
    }

    @Generated
    public void setIsProperty(boolean v) {
        this.setBoolean(IsProperty, v, null);
    }

    @Generated
    public boolean getIsEventType() {
        return this.getBoolean(IsEventType);
    }

    @Generated
    public void setIsEventType(boolean v) {
        this.setBoolean(IsEventType, v, null);
    }

    @Generated
    public boolean getHasAddableDescendant() {
        return this.getBoolean(HasAddableDescendant);
    }

    @Generated
    public void setHasAddableDescendant(boolean v) {
        this.setBoolean(HasAddableDescendant, v, null);
    }

    @Generated
    public void test() {
        this.invoke(test, null, null);
    }

    @Generated
    public void showDetail() {
        this.invoke(showDetail, null, null);
    }

    @Generated
    public void hideDetail() {
        this.invoke(hideDetail, null, null);
    }

    @Generated
    public void dumpHistory() {
        this.invoke(dumpHistory, null, null);
    }

    @Generated
    public void subscribeForEvents() {
        this.invoke(subscribeForEvents, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOpcUaNodeLearnEntry() {
    }

    public BOpcUaNodeLearnEntry(String nodeName, String nodeId, String nodeClass, String uaDataType, BTypeSpec typeSpec) {
        this.setUaNodeName(nodeName);
        this.setUaDisplayName(nodeName);
        this.setUaNodeId(nodeId);
        this.setNodeClass(nodeClass);
        this.setUaDataType(uaDataType);
        if (!typeSpec.isNull()) {
            this.setTypeSpec(typeSpec.toString());
        }
    }

    public static BOpcUaNodeLearnEntry make(AddressSpace addressSpace, ReferenceDescription reference, NodeId thisNodeId, UaClient client) {
        try {
            BOpcUaNodeLearnEntry learnEntry = AccessController.doPrivileged(() -> {
                DataValue[] arrayOfNodes;
                BOpcUaNodeLearnEntry retEntry = new BOpcUaNodeLearnEntry();
                boolean isProperty = reference.getReferenceTypeId().equals((Object)ReferenceTypeIdentifiers.HasProperty);
                UnsignedInteger[] nodeAttributes = new UnsignedInteger[]{Attributes.NodeClass, Attributes.BrowseName, Attributes.DisplayName, Attributes.Value, Attributes.DataType, Attributes.Description, Attributes.WriteMask, Attributes.UserWriteMask, Attributes.AccessLevel, Attributes.UserAccessLevel, Attributes.EventNotifier, Attributes.Historizing};
                try {
                    arrayOfNodes = client.readAttributes(thisNodeId, nodeAttributes);
                }
                catch (ServiceException sEx) {
                    logger.info(sEx.getMessage());
                    return retEntry;
                }
                try {
                    Object oValue;
                    long dtIdentifier;
                    String dataType;
                    DataValue dataValue;
                    String displayName;
                    String nodeName;
                    block14: {
                        nodeName = OpcUaClientUtil.getNodeName(reference, arrayOfNodes);
                        displayName = OpcUaClientUtil.getDisplayName(reference, arrayOfNodes, nodeName);
                        dataValue = Objects.requireNonNull(arrayOfNodes[3], "DataValue should not be null. Skipping node entry for nodeId: " + thisNodeId);
                        dataType = "";
                        dtIdentifier = -1L;
                        try {
                            DataValue dtUaNode;
                            Optional<DataValue> nodeOptional = OpcUaClientUtil.getNodeDataTypeNode(arrayOfNodes[4]);
                            if (nodeOptional.isPresent() && (dtUaNode = nodeOptional.get()).getValue() != null && dtUaNode.getValue().getValue() != null) {
                                NodeId nodeId = (NodeId)dtUaNode.getValue().getValue();
                                dataType = addressSpace.getDataType(nodeId).getBrowseName().getName();
                                if (nodeId.getValue() != null) {
                                    dtIdentifier = Long.parseLong(nodeId.getValue().toString());
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Level.FINE)) break block14;
                            logger.log(Level.FINE, "Exception while fetching dataType and Identifier details for " + displayName, e);
                        }
                    }
                    Object dataValueValue = OpcUaClientUtil.getDataValueValue(dataValue);
                    String description = OpcUaClientUtil.getNodeLocalizedText(arrayOfNodes[5]);
                    BTypeSpec typeSpec = OpcUaClientUtil.getTypeSpec(dataValue.getValue(), dataType);
                    if (!dataValue.getValue().isEmpty()) {
                        retEntry.setIsStructure(OpcUaClientUtil.isStructure(dataValue.getValue().getValue()));
                        retEntry.setIsStructureComponent(retEntry.getIsStructure());
                    }
                    DataValue wmdv = arrayOfNodes[6];
                    DataValue uwmdv = arrayOfNodes[7];
                    DataValue al = arrayOfNodes[8];
                    DataValue ual = arrayOfNodes[9];
                    DataValue eventNotifier = arrayOfNodes[10];
                    DataValue historizing = arrayOfNodes[11];
                    retEntry.setUaNodeName(nodeName);
                    retEntry.setUaDisplayName(displayName);
                    retEntry.setUaNodeId(thisNodeId.toString());
                    retEntry.setNameSpaceUri(addressSpace.getNamespaceTable().toExpandedNodeId(thisNodeId).getNamespaceUri());
                    retEntry.setNodeClass(arrayOfNodes[0].getStatusCode().isNotBad() ? com.prosysopc.ua.stack.core.NodeClass.valueOf((int)arrayOfNodes[0].getValue().toNumber().intValue()).toString() : com.prosysopc.ua.stack.core.NodeClass.valueOf((int)reference.getNodeClass().getValue()).toString());
                    retEntry.setUaDataType(dataType);
                    retEntry.setUaDataTypeIdentifier(dtIdentifier);
                    retEntry.setTypeSpec(typeSpec.isNull() ? "" : typeSpec.toString());
                    retEntry.setDescription(description);
                    retEntry.setIsProperty(isProperty);
                    retEntry.setIsEventType(false);
                    if (!wmdv.isNull()) {
                        oValue = wmdv.getValue().getValue();
                        retEntry.setWriteMask(((UnsignedInteger)oValue).getValue());
                    }
                    if (!uwmdv.isNull()) {
                        oValue = uwmdv.getValue().getValue();
                        retEntry.setUserWriteMask(((UnsignedInteger)oValue).getValue());
                    }
                    oValue = al.isNull() ? UnsignedByte.valueOf((int)0) : al.getValue().getValue();
                    int accessLvl = ((UnsignedByte)oValue).getValue();
                    retEntry.setAccessLevel(accessLvl);
                    oValue = ual.isNull() ? UnsignedByte.valueOf((int)0) : ual.getValue().getValue();
                    retEntry.setUserAccessLevel(((UnsignedByte)oValue).getValue());
                    oValue = !historizing.isNull() && historizing.getValue().booleanValue();
                    String userBit = Integer.toBinaryString(accessLvl);
                    boolean hasHistory = userBit.length() > 2 && userBit.charAt(2) == '1' || userBit.length() > 3 && userBit.charAt(3) == '1' || (Boolean)oValue != false;
                    retEntry.setHistorizing(hasHistory);
                    oValue = eventNotifier.isNull() ? -1 : eventNotifier.getValue().intValue();
                    retEntry.setEventNotifier((Integer)oValue);
                    if (dataValueValue != null) {
                        retEntry.setUaValue(dataValueValue.toString());
                        retEntry.setUaInstanceType(dataValue.getValue().getCompositeClass().getSimpleName());
                    }
                    if (!dataValue.isNull() && dataValue.getValue().isArray()) {
                        retEntry.initArrayInfo(dataValue);
                    }
                    if (!dataValue.getValue().isEmpty() && retEntry.getIsStructure()) {
                        retEntry.initStructure(dataValue.getValue().getValue(), addressSpace);
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception while instantiating BOpcUaNodeLearnEntry: ", ex);
                }
                return retEntry;
            });
            return learnEntry;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Exception while instantiating BOpcUaNodeLearnEntry : " + e.getMessage());
            }
            return null;
        }
    }

    public boolean hasCondition() {
        UaReference hasCondition = null;
        try {
            UaNode node = OpcUaClientUtil.getAddressSpaceNode(this.getDevice().uaClient.getAddressSpace(), NodeId.parseNodeId((String)this.getUaNodeId()));
            if (node != null) {
                hasCondition = node.getReference(ReferenceTypeIdentifiers.HasCondition, false);
            }
        }
        catch (Exception stsEx) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.WARNING, "Unable to determine hasCondition", stsEx);
            }
            logger.log(Level.WARNING, "Unable to determine hasCondition: " + stsEx.getMessage());
        }
        this.setHasCondition(hasCondition != null);
        return hasCondition != null;
    }

    public BOpcUaLearnBase toDiscoveryTree(boolean showAddableOnly, int maxArraySize) {
        BOpcUaLearnBase root = BOpcUaLearnBase.make(this, maxArraySize);
        BOpcUaNodeLearnEntry.buildDiscoveryTree(this, root, showAddableOnly, maxArraySize);
        return root;
    }

    private static void buildDiscoveryTree(BOpcUaNodeLearnEntry entry, BOpcUaLearnBase root, boolean showAddableOnly, int maxArraySize) {
        for (BOpcUaNodeLearnEntry pointEntry : (BOpcUaNodeLearnEntry[])entry.getChildren(BOpcUaNodeLearnEntry.class)) {
            if (pointEntry.getIsProperty() || pointEntry.getIsEventType() || !"Method".equals(pointEntry.getNodeClass()) && pointEntry.getTypeSpec().isEmpty() && showAddableOnly && !pointEntry.getHasAddableDescendant()) continue;
            Property prop = root.add("le?", (BValue)BOpcUaLearnBase.make(pointEntry, maxArraySize));
            BOpcUaLearnBase addChild = (BOpcUaLearnBase)root.get(prop);
            ++level;
            BOpcUaNodeLearnEntry.buildDiscoveryTree(pointEntry, addChild, showAddableOnly, maxArraySize);
            --level;
        }
    }

    public String getDefaultName() {
        return this.getUaNodeId();
    }

    public void doDumpHistory() {
        block5: {
            if (!this.getHistorizing()) {
                logger.info(this.getUaNodeName() + " is not Historizing");
            } else {
                BOpcUaDevice device = this.getDevice();
                UaClient client = device.uaClient;
                NodeId nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
                try {
                    DataValue[] result;
                    for (DataValue dataValue : result = client.historyReadRaw(nodeId, DateTime.MIN_VALUE, DateTime.currentTime(), UnsignedInteger.MAX_VALUE, Boolean.valueOf(true), null, TimestampsToReturn.Source)) {
                        System.out.println(dataValue);
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) break block5;
                    logger.fine("Exception while dumping History: " + e);
                }
            }
        }
    }

    public void doShowDetail() {
        for (Property property : this.getFrozenPropertiesArray()) {
            this.setFlags((Slot)property, this.getFlags((Slot)property) & 0xFFFFFFFB);
        }
    }

    public void doHideDetail() {
        for (Property property : this.getFrozenPropertiesArray()) {
            this.setFlags((Slot)property, this.getFlags((Slot)property) | 4);
        }
    }

    public void added(Property property, Context context) {
        BValue bValue = this.get(property);
        if (bValue instanceof BOpcUaNodeLearnEntry) {
            if ("EnumStrings".equals(property.getName())) {
                this.setTypeSpec(BTypeSpec.make((Type)BEnum.TYPE).toString(null));
            } else if ("EnumValues".equals(property.getName())) {
                this.setTypeSpec(BTypeSpec.make((Type)BEnum.TYPE).toString(null));
            }
        }
        super.added(property, context);
    }

    public void initStructure(Object value, AddressSpace addressSpace) {
        try {
            AccessController.doPrivileged(() -> {
                String branchOrRoot;
                if (this.getStructureDepth() >= 100) {
                    logger.log(Level.WARNING, "Aborting traversal - Structure depth is greater than 100 levels for: " + this.getUaDisplayName());
                    return null;
                }
                String string = branchOrRoot = this.getStructureDepth() > 0 ? " branch " : " root ";
                if (value == null) {
                    throw new IllegalArgumentException("Parameter 'value' for initializing Structure" + branchOrRoot + "should not be null");
                }
                if (!OpcUaClientUtil.isStructure(value)) {
                    return null;
                }
                Structure structure = Objects.requireNonNull((Structure)value, "Structure" + branchOrRoot + "should not be null after cast from non-null parameter 'value'");
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Adding structure: " + structure);
                }
                for (FieldSpecification fieldSpecification : structure.specification().getFields()) {
                    Object fieldValue = structure.get(fieldSpecification);
                    String fieldName = fieldSpecification.getName();
                    UaNodeId fieldDataTypeId = fieldSpecification.getDataTypeId();
                    EnumerationSpecification fieldEnumerationSpecification = addressSpace.getEncoderContext().getEnumerationSpecification(fieldSpecification.getDataTypeId());
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "Field: " + fieldName + " = " + fieldValue);
                    }
                    try {
                        Variant fieldVariant = new Variant(fieldValue);
                        NodeId dataTypeNodeId = this.getDataTypeNodeId(fieldEnumerationSpecification, fieldDataTypeId, addressSpace.getNamespaceTable());
                        if (dataTypeNodeId == null) {
                            logger.log(Level.SEVERE, "Failed to determine data type for structure field: " + fieldName);
                            return null;
                        }
                        String dataType = addressSpace.getDataType(dataTypeNodeId).getBrowseName().getName();
                        Class builtInType = (Class)BuiltinsMap.MAP.get("http://opcfoundation.org/UA/" + dataType);
                        BTypeSpec typeSpec = builtInType != null ? OpcUaClientUtil.getTypeSpec(fieldValue, builtInType.getSimpleName()) : OpcUaClientUtil.getTypeSpec(fieldValue, dataType);
                        BOpcUaNodeLearnEntry nodeEntry = new BOpcUaNodeLearnEntry(fieldName, this.getUaNodeId(), this.getNodeClass(), dataType, typeSpec);
                        StringBuilder structurePathBuilder = new StringBuilder(this.getStructurePath());
                        structurePathBuilder.append(fieldName).append('>');
                        if (fieldValue != null) {
                            nodeEntry.setUaValue(fieldValue.toString());
                        }
                        nodeEntry.setStructureDepth(this.getStructureDepth() + 1);
                        nodeEntry.setStructurePath(structurePathBuilder.toString());
                        nodeEntry.setIsStructureComponent(this.getIsStructureComponent());
                        nodeEntry.setUaDisplayName(fieldName);
                        nodeEntry.setNameSpaceUri(this.getNameSpaceUri());
                        nodeEntry.setWriteMask(this.getWriteMask());
                        nodeEntry.setUserWriteMask(this.getUserWriteMask());
                        nodeEntry.setAccessLevel(this.getAccessLevel());
                        nodeEntry.setUserAccessLevel(this.getUserAccessLevel());
                        nodeEntry.setUaInstanceType(fieldValue != null ? fieldVariant.getCompositeClass().getSimpleName() : fieldSpecification.getJavaClass().getSimpleName());
                        nodeEntry.setUaDataTypeIdentifier(OpcUaClientUtil.getDataTypeIdentifier(dataTypeNodeId));
                        this.add(SlotPath.escape((String)fieldName) + '?', (BValue)nodeEntry, 2);
                        if (OpcUaClientUtil.isStructure(fieldValue)) {
                            nodeEntry.setIsStructure(true);
                            nodeEntry.initStructure(fieldValue, addressSpace);
                        }
                        if (fieldVariant.isArray()) {
                            nodeEntry.initArrayInfo(new DataValue(fieldVariant));
                        }
                        if (typeSpec.isNull() || !typeSpec.getTypeInfo().is(BEnum.TYPE) || fieldEnumerationSpecification == null) continue;
                        nodeEntry.setFacets(OpcUaClientUtil.makeEnumFacets(fieldEnumerationSpecification));
                    }
                    catch (Exception e) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.SEVERE, "Failed to add structure field: " + fieldName, e);
                            continue;
                        }
                        logger.log(Level.SEVERE, "Failed to add structure field: " + fieldName + ", error message: " + e.getMessage());
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Failed to initialize structure for: " + value, e);
            }
            logger.log(Level.SEVERE, "Failed to initialize structure for: " + value + ", error message: " + e.getMessage());
        }
    }

    public void initArrayInfo(DataValue dataValue) {
        block2: {
            try {
                AccessController.doPrivileged(() -> {
                    if (dataValue.isNull()) {
                        return null;
                    }
                    if (!dataValue.getValue().isArray()) {
                        return null;
                    }
                    int[] arrayDimensions = dataValue.getValue().getArrayDimensions();
                    if (arrayDimensions != null) {
                        StringBuilder sb = new StringBuilder();
                        sb.append('[');
                        for (int i = 0; i < arrayDimensions.length; ++i) {
                            sb.append(arrayDimensions[i]);
                            if (i + 1 >= arrayDimensions.length) continue;
                            sb.append(',');
                        }
                        sb.append(']');
                        this.setArrayDimension(sb.toString());
                    }
                    return null;
                });
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.fine("Exception while initiating ArrayInfo: " + e);
            }
        }
    }

    public boolean isEventNotifier(EventNotifierType value) {
        int enValue = this.getEventNotifier();
        if (enValue <= 0) {
            return false;
        }
        byte byteValue = (byte)enValue;
        EventNotifierType type = EventNotifierType.of((UnsignedByte)UnsignedByte.getFromBits((byte)byteValue));
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Event Notifier Types: " + type.toSet());
        }
        if (type == null) {
            return false;
        }
        return type.containsAll((AbstractOptionSetDataType)value);
    }

    public boolean isEventSubscribable() {
        return this.isEventNotifier(EventNotifierType.of((EventNotifierType.Options[])new EventNotifierType.Options[]{EventNotifierType.Options.SubscribeToEvents}));
    }

    public boolean isArray() {
        return !this.getArrayDimension().isEmpty();
    }

    public long[] getArrayDimensions() {
        String s = this.getArrayDimension();
        int il = s.indexOf(91);
        int ir = s.indexOf(93);
        if (il >= 0 && ir > il) {
            s = s.substring(il + 1, ir);
        }
        String[] split = s.split(",");
        long[] dimensions = new long[split.length];
        for (int i = 0; i < split.length; ++i) {
            try {
                dimensions[i] = Long.parseLong(split[i].trim());
                continue;
            }
            catch (Exception e) {
                throw new NumberFormatException(e.getMessage());
            }
        }
        return dimensions;
    }

    public void initHasAddableDescendant() {
        BOpcUaNodeLearnEntry parentEntry;
        boolean addable = this.isAddable();
        BComplex parent = this.getParent();
        while (parent instanceof BOpcUaNodeLearnEntry && !(parentEntry = (BOpcUaNodeLearnEntry)parent).getHasAddableDescendant()) {
            if (addable) {
                parentEntry.setHasAddableDescendant(true);
            } else {
                addable = parentEntry.isAddable();
            }
            parent = parent.getParent();
        }
    }

    public boolean isAddable() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "OPC UA Client discovered point: " + this.getUaNodeName() + " - NodeClass:" + this.getNodeClass() + ", IsProperty:" + this.getIsProperty() + ", TypeSpec:" + this.getTypeSpec() + ", EventType:" + this.getIsEventType() + ".");
        }
        return "Variable".equals(this.getNodeClass()) && !this.getIsProperty() && !this.getTypeSpec().isEmpty() && !this.getIsEventType();
    }

    public void doSubscribeForEvents() {
        try {
            NodeId nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
            BOpcUaDevice device = this.getDevice();
            if (device == null) {
                return;
            }
            BOpcUaClientAlarmDeviceExt eventListener = device.getAlarmExt();
            eventListener.addMonitorEvent(nodeId);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.INFO, "Error for the action SubscribeForEvent", e);
            }
            logger.log(Level.INFO, "Error for the action SubscribeForEvent: " + e);
        }
    }

    public void doTest() {
        block20: {
            try {
                NodeId nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
                Object value1 = nodeId.getValue();
                BOpcUaDevice device = this.getDevice();
                if (device == null) {
                    logger.finest("BOpcUaDevice not found");
                    break block20;
                }
                logger.finest("nodeId.getValue().class = " + value1.getClass().getName());
                logger.finest("NodeId = " + nodeId);
                logger.finest("NodeId.getValue() = " + value1);
                UaClient uaClient = device.uaClient;
                AddressSpace addressSpace = uaClient.getAddressSpace();
                UaNode node = addressSpace.getNode(nodeId);
                NodeClass nodeClass = node.getNodeClass();
                logger.finest("NodeClass = " + nodeClass);
                logger.finest("node = " + node);
                NodeAttributes attributes = node.getAttributes();
                logger.finest("attributes = " + attributes);
                try {
                    DataValue dataValue = node.readAttribute(Attributes.Value);
                    if (dataValue != null) {
                        UaProperty[] variantValue = dataValue.getValue();
                        Object value = variantValue.getValue();
                        if (value instanceof EUInformation) {
                            EUInformation eui = (EUInformation)value;
                            logger.finest(eui.getDisplayName().toString() + ", UnitId = " + eui.getUnitId());
                        }
                        logger.finest("dataValue = " + variantValue.toString(true));
                        if (variantValue.getCompositeClass() != null) {
                            logger.finest("dataValue.type = " + variantValue.getCompositeClass().getSimpleName());
                        }
                    } else {
                        logger.info("No data value");
                    }
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                }
                UaProperty[] properties = node.getProperties();
                if (properties != null) {
                    for (UaProperty uaProperty : properties) {
                        String propName = uaProperty.getDisplayName().getText();
                        Variant value = uaProperty.getValue().getValue();
                        logger.info("(" + propName + "=" + value + ")");
                    }
                } else {
                    logger.info("No properties defined");
                }
                BFacets pointFacet = this.makePointFacets();
                this.setFacets(pointFacet);
                logger.info("pointFacets = " + pointFacet);
                logger.info("isArray = " + this.isArray());
                StringBuilder sb = new StringBuilder();
                for (long l : this.getArrayDimensions()) {
                    sb.append('[');
                    if (l >= 0L) {
                        sb.append(l);
                    }
                    sb.append(']');
                }
                logger.info("ArrayDimensions = " + sb);
                int accessLevel = this.getAccessLevel();
                AccessLevelType accessLevelType = null;
                for (AccessLevelType.Options field : AccessLevelType.Options.values()) {
                    if (field.getBitPosition() != accessLevel) continue;
                    accessLevelType = AccessLevelType.of((AccessLevelType.Options[])new AccessLevelType.Options[]{field});
                    break;
                }
                if (accessLevelType != null) {
                    logger.info("AccessLevel = " + accessLevelType);
                } else {
                    logger.info("AccessLevel = null");
                }
                AttributeWriteMask writeMasks = null;
                for (AttributeWriteMask.Options field : AttributeWriteMask.Options.values()) {
                    if (field.getBitPosition() != (int)this.getWriteMask()) continue;
                    writeMasks = AttributeWriteMask.of((AttributeWriteMask.Options[])new AttributeWriteMask.Options[]{field});
                    break;
                }
                if (writeMasks != null) {
                    logger.info("WriteMask = " + writeMasks);
                } else {
                    logger.info("WriteMask = null");
                }
                logger.info("EventNotifier = " + this.getEventNotifier());
                logger.info("isEventNotifierSubscribeToEvents = " + this.isEventNotifier(EventNotifierType.of((EventNotifierType.Options[])new EventNotifierType.Options[]{EventNotifierType.Options.SubscribeToEvents})));
                logger.info("isEventNotifierHistoryRead  = " + this.isEventNotifier(EventNotifierType.of((EventNotifierType.Options[])new EventNotifierType.Options[]{EventNotifierType.Options.HistoryRead})));
                logger.info("isEventNotifierHistoryWrite = " + this.isEventNotifier(EventNotifierType.of((EventNotifierType.Options[])new EventNotifierType.Options[]{EventNotifierType.Options.HistoryWrite})));
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block20;
                logger.fine("Exception while testing: " + e);
            }
        }
    }

    BOpcUaDevice getDevice() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BOpcUaDevice)) continue;
            return (BOpcUaDevice)parent;
        }
        return null;
    }

    public TypeInfo[] getValidDatabaseTypes() {
        String spec;
        AccessLevelType levels = null;
        for (AccessLevelType.Options field : AccessLevelType.Options.values()) {
            if (field.getBitPosition() != this.getAccessLevel()) continue;
            levels = AccessLevelType.of((AccessLevelType.Options[])new AccessLevelType.Options[]{field});
            break;
        }
        boolean canWrite = false;
        if (levels != null) {
            canWrite = levels.contains(new OptionSpecification[]{AccessLevelType.Options.CurrentWrite});
        }
        if ((spec = this.getTypeSpec()).isEmpty()) {
            return NO_TYPES;
        }
        TypeInfo typeInfo = BTypeSpec.make((String)spec).getTypeInfo();
        if (typeInfo.is(BNumber.TYPE)) {
            return canWrite ? RD_WR_NUMERIC_TYPE : RD_NUMERIC_TYPE;
        }
        if (typeInfo.is(BBoolean.TYPE)) {
            return canWrite ? RD_WR_BOOLEAN_TYPE : RD_BOOLEAN_TYPE;
        }
        if (typeInfo.is(BEnum.TYPE)) {
            return canWrite ? RD_WR_ENUM_TYPE : RD_ENUM_TYPE;
        }
        if (typeInfo.is(BString.TYPE)) {
            return canWrite ? RD_WR_STRING_TYPE : RD_STRING_TYPE;
        }
        return NO_TYPES;
    }

    public void updateTarget(BComponent target) {
    }

    public boolean isExisting(BComponent component) {
        return false;
    }

    public String getDiscoveryName() {
        return SlotPath.escape((String)this.getUaNodeName());
    }

    public boolean isNumeric() {
        String specType = this.getTypeSpec();
        if ("".equals(specType)) {
            return false;
        }
        BTypeSpec ts = BTypeSpec.make((String)specType);
        if (ts.isNull()) {
            return false;
        }
        TypeInfo typeInfo = ts.getTypeInfo();
        return typeInfo.is(BNumber.TYPE);
    }

    public boolean isBoolean() {
        String specType = this.getTypeSpec();
        if ("".equals(specType)) {
            return false;
        }
        BTypeSpec ts = BTypeSpec.make((String)specType);
        if (ts.isNull()) {
            return false;
        }
        TypeInfo typeInfo = ts.getTypeInfo();
        return typeInfo.is(BBoolean.TYPE);
    }

    public BIcon getDiscoveryIcon() {
        String specType = this.getTypeSpec();
        if ("".equals(specType)) {
            if ("Method".equals(this.getNodeClass())) {
                return NC_METHOD_ICON;
            }
            return null;
        }
        BTypeSpec ts = BTypeSpec.make((String)specType);
        if (ts.isNull()) {
            return null;
        }
        TypeInfo typeInfo = ts.getTypeInfo();
        if (typeInfo.is(BNumber.TYPE)) {
            if (this.getHistorizing()) {
                return BIcon.make((BIcon)NUMERIC_ICON, (BIcon)HISTORY_ICON);
            }
            return NUMERIC_ICON;
        }
        if (typeInfo.is(BBoolean.TYPE)) {
            if (this.getHistorizing()) {
                return BIcon.make((BIcon)BOOLEAN_ICON, (BIcon)HISTORY_ICON);
            }
            return BOOLEAN_ICON;
        }
        if (typeInfo.is(BEnum.TYPE)) {
            if (this.getHistorizing()) {
                return BIcon.make((BIcon)ENUM_ICON, (BIcon)HISTORY_ICON);
            }
            return ENUM_ICON;
        }
        if (typeInfo.is(BString.TYPE)) {
            if (this.getHistorizing()) {
                return BIcon.make((BIcon)STRING_ICON, (BIcon)HISTORY_ICON);
            }
            return STRING_ICON;
        }
        return null;
    }

    public void defaultTargetUpdate(BComponent target) {
    }

    public void updateFacets() {
        this.setFacets(this.makePointFacets());
    }

    public BFacets makePointFacets() {
        BTypeSpec ts;
        BFacets rtnFacets = BFacets.DEFAULT;
        String typeSpec = this.getTypeSpec();
        if (!"".equals(typeSpec) && !(ts = BTypeSpec.make((String)typeSpec)).isNull()) {
            TypeInfo typeInfo = ts.getTypeInfo();
            if (this.hasEnumStringProperty()) {
                rtnFacets = this.makeEnumStringsFacets();
            } else if (this.hasEnumValuesProperty()) {
                rtnFacets = this.makeEnumValuesFacets();
            } else if (this.hasTrueStateProperty()) {
                rtnFacets = this.makeBooleanFacets();
            } else if (typeInfo.is(BNumber.TYPE)) {
                rtnFacets = this.makeNumericFacets();
            } else if (typeInfo.is(BEnum.TYPE) && !this.getFacets().isNull()) {
                return this.getFacets();
            }
        }
        return rtnFacets;
    }

    public boolean hasEnumStringProperty() {
        BValue enumStrings = this.get("EnumStrings");
        return enumStrings != null;
    }

    public boolean hasEnumValuesProperty() {
        BValue enumValues = this.get("EnumValues");
        return enumValues != null;
    }

    public boolean hasTrueStateProperty() {
        return this.get("TrueState") != null && this.get("FalseState") != null;
    }

    public BFacets makeEnumStringsFacets() {
        try {
            BOpcUaNodeLearnEntry enumStrings = (BOpcUaNodeLearnEntry)this.get("EnumStrings");
            String values = enumStrings.getUaValue();
            String[] split = values.split(",");
            BEnumRange enumRange = BEnumRange.make((String[])split);
            return BFacets.makeEnum((BEnumRange)enumRange);
        }
        catch (Exception e) {
            return BFacets.makeEnum();
        }
    }

    public BFacets makeEnumValuesFacets() {
        try {
            BOpcUaNodeLearnEntry enumValues = (BOpcUaNodeLearnEntry)this.get("EnumValues");
            String values = enumValues.getUaValue();
            values = values.substring(values.indexOf(123) + 1, values.indexOf(125));
            String[] keyValues = values.split(",");
            int[] ordinals = new int[keyValues.length];
            String[] tags = new String[keyValues.length];
            for (int i = 0; i < keyValues.length; ++i) {
                String tag;
                String[] pair = keyValues[i].trim().split("=");
                ordinals[i] = Integer.parseInt(pair[0].trim());
                String[] localeAndTag = pair[1].split(" ");
                tags[i] = tag = localeAndTag[localeAndTag.length - 1].trim();
            }
            BEnumRange enumRange = BEnumRange.make((int[])ordinals, (String[])tags);
            return BFacets.makeEnum((BEnumRange)enumRange);
        }
        catch (Exception e) {
            return BFacets.makeEnum();
        }
    }

    public BFacets makeBooleanFacets() {
        try {
            BOpcUaNodeLearnEntry trueState = (BOpcUaNodeLearnEntry)this.get("TrueState");
            String trueText = trueState.getUaValue();
            BOpcUaNodeLearnEntry falseState = (BOpcUaNodeLearnEntry)this.get("FalseState");
            String falseText = falseState.getUaValue();
            return BFacets.makeBoolean((String)trueText, (String)falseText);
        }
        catch (Exception e) {
            return BFacets.makeBoolean();
        }
    }

    public BFacets makeNumericFacets() {
        BFacets rtnFacets = this.makeNumericFacets(this.getUaInstanceType());
        BOpcUaNodeLearnEntry[] children = (BOpcUaNodeLearnEntry[])this.getChildren(BOpcUaNodeLearnEntry.class);
        if (children.length == 0) {
            return rtnFacets;
        }
        BDouble maxValue = (BDouble)rtnFacets.get("max", (BObject)BDouble.POSITIVE_INFINITY);
        BDouble minValue = (BDouble)rtnFacets.get("min", (BObject)BDouble.NEGATIVE_INFINITY);
        BUnit units = (BUnit)rtnFacets.get("units", (BObject)BUnit.DEFAULT);
        int precision = rtnFacets.geti("precision", 2);
        for (BOpcUaNodeLearnEntry child : children) {
            BOpcUaNodeLearnEntry[] grandChildren = (BOpcUaNodeLearnEntry[])child.getChildren(BOpcUaNodeLearnEntry.class);
            if ("Range".equals(child.getUaDataType())) {
                double min = Double.NEGATIVE_INFINITY;
                double max = Double.POSITIVE_INFINITY;
                for (BOpcUaNodeLearnEntry grandChild : grandChildren) {
                    if ("Low".equals(grandChild.getName())) {
                        String minStr = grandChild.getUaValue();
                        try {
                            min = Double.parseDouble(minStr);
                        }
                        catch (NumberFormatException e) {
                            logger.warning(e + " for: " + this.getUaNodeName());
                        }
                    }
                    if (!"High".equals(grandChild.getName())) continue;
                    String maxStr = grandChild.getUaValue();
                    try {
                        max = Double.parseDouble(maxStr);
                    }
                    catch (NumberFormatException e) {
                        logger.warning(e + " for: " + this.getUaNodeName());
                    }
                }
                minValue = BDouble.make((double)min);
                maxValue = BDouble.make((double)max);
                continue;
            }
            if (!EU_INFORMATION_PROPERTY_NAME.equals(child.getUaDataType())) continue;
            int unitId = -1;
            String unitName = null;
            for (BOpcUaNodeLearnEntry grandChild : grandChildren) {
                if (UNIT_ID_PROPERTY_NAME.equals(grandChild.getName())) {
                    String unitIdStr = grandChild.getUaValue();
                    try {
                        unitId = Integer.parseInt(unitIdStr);
                        try {
                            units = BUnit.getUnit((String)OpcUaUnitConverter.getDefault().getUnitNameFromOpcuaUnitId(unitId));
                        }
                        catch (UnitException ex) {
                            unitId = -1;
                        }
                    }
                    catch (NumberFormatException e) {
                        logger.warning(e + " for: " + this.getUaNodeName());
                        unitId = -1;
                    }
                    continue;
                }
                if (!"DisplayName".equals(grandChild.getName())) continue;
                unitName = grandChild.getUaValue();
            }
            if (unitId != 3 && unitId != -1 || unitName == null) continue;
            try {
                units = BUnit.getUnit(unitName);
            }
            catch (UnitException ex) {
                units = BUnit.DEFAULT;
            }
        }
        return BFacets.makeNumeric((BUnit)units, (int)precision, (double)minValue.getDouble(), (double)maxValue.getDouble());
    }

    private BFacets makeNumericFacets(String uaInstanceType) {
        switch (uaInstanceType) {
            case "SByte": 
            case "Byte": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)-128.0, (double)127.0);
            }
            case "UByte": 
            case "UnsignedByte": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)0.0, (double)255.0);
            }
            case "Int16": 
            case "Short": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)-32768.0, (double)32767.0);
            }
            case "UInt16": 
            case "UnsignedShort": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)UnsignedShort.L_MIN_VALUE, (double)UnsignedShort.L_MAX_VALUE);
            }
            case "Int32": 
            case "Integer": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)-2.147483648E9, (double)2.147483647E9);
            }
            case "UInt32": 
            case "UInteger": 
            case "UnsignedInteger": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)UnsignedInteger.MIN_VALUE.doubleValue(), (double)UnsignedInteger.MAX_VALUE.doubleValue());
            }
            case "Int64": 
            case "Long": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)-9.223372036854776E18, (double)9.223372036854776E18);
            }
            case "UInt64": 
            case "ULong": 
            case "UnsignedLong": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)UnsignedLong.MIN_VALUE.doubleValue(), (double)UnsignedLong.MAX_VALUE.doubleValue());
            }
            case "Float": {
                return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)2, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY);
            }
        }
        return BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)2, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY);
    }

    public NodeId getDataTypeNodeId(EnumerationSpecification specification, UaNodeId uaDataTypeId, NamespaceTable namespaceTable) {
        if (specification != null && specification.getTypeId() != null) {
            return specification.getTypeId().asNodeId(namespaceTable);
        }
        return uaDataTypeId != null ? uaDataTypeId.asNodeId(namespaceTable) : null;
    }

    public String toString(Context cx) {
        return this.getUaValue();
    }

    public BIcon getIcon() {
        if (this.getNodeClass().equals("Object")) {
            return NC_OBJECT_ICON;
        }
        if (this.getNodeClass().equals("Variable")) {
            return this.getDiscoveryIcon();
        }
        if (this.getNodeClass().equals("Method")) {
            return NC_METHOD_ICON;
        }
        return super.getIcon();
    }

    private void setStructureDepth(int structureDepth) {
        this.structureDepth = structureDepth;
    }

    public int getStructureDepth() {
        return this.structureDepth;
    }
}

