/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaClient.history;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.HistoryData;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.core.HistoryReadResult;
import com.prosysopc.ua.stack.core.HistoryReadValueId;
import com.prosysopc.ua.stack.core.ReadRawModifiedDetails;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.opcUaClient.BOpcUaDevice;
import com.tridium.opcUaClient.history.BOpcUaClientDiscoverHistoriesJob;
import com.tridium.opcUaClient.history.BOpcUaClientHistoryDiscoveryPreferences;
import com.tridium.opcUaClient.history.BOpcUaClientHistoryImport;
import com.tridium.opcUaClient.point.BOpcUaNodeLearnEntry;
import com.tridium.opcUaClient.util.OpcUaClientUtil;
import com.tridium.util.CompUtil;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BEnumTrendRecord;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="submitTrendLogDiscoveryJob", returnType="BOrd", flags=4)
public class BOpcUaClientHistoryDeviceExt
extends BHistoryDeviceExt
implements BINDiscoveryHost {
    @Generated
    public static final Action submitTrendLogDiscoveryJob = BOpcUaClientHistoryDeviceExt.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaClientHistoryDeviceExt.class);
    public static final Logger log = Logger.getLogger("opcUaClient.history");

    @Generated
    public BOrd submitTrendLogDiscoveryJob() {
        return (BOrd)this.invoke(submitTrendLogDiscoveryJob, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BOpcUaDevice;
    }

    public void added(Property p, Context c) {
        super.added(p, c);
        if (!this.isRunning()) {
            return;
        }
        BValue o = this.get(p);
        if (o instanceof BOpcUaClientHistoryImport) {
            ((BOpcUaClientHistoryImport)o).execute();
        }
    }

    public BOrd doSubmitTrendLogDiscoveryJob(Context cx) {
        BStatus status = this.device().getStatus();
        if (status.isDisabled() || status.isDown()) {
            return null;
        }
        return new BOpcUaClientDiscoverHistoriesJob(this).submit(cx);
    }

    public final BOpcUaDevice device() {
        return (BOpcUaDevice)this.getDevice();
    }

    public Type getImportDescriptorType() {
        return BOpcUaClientHistoryImport.TYPE;
    }

    public Type getExportDescriptorType() {
        return null;
    }

    public ArrayList<BOpcUaNodeLearnEntry> getHistorizingItems() {
        BOpcUaNodeLearnEntry[] descendants;
        ArrayList<BOpcUaNodeLearnEntry> list = new ArrayList<BOpcUaNodeLearnEntry>();
        BValue bValue = this.device().get("serverRoot");
        if (bValue == null) {
            return null;
        }
        BComponent learnRoot = bValue.asComponent();
        for (BOpcUaNodeLearnEntry descendant : descendants = (BOpcUaNodeLearnEntry[])CompUtil.getDescendants((BComponent)learnRoot, BOpcUaNodeLearnEntry.class)) {
            if (!descendant.getHistorizing()) continue;
            list.add((BOpcUaNodeLearnEntry)descendant.newCopy(true));
        }
        return list;
    }

    public BOrd submitDiscoveryJob(BNDiscoveryPreferences discoveryParams) {
        return null;
    }

    public BNDiscoveryPreferences getDiscoveryPreferences() {
        return new BOpcUaClientHistoryDiscoveryPreferences();
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) throws Exception {
        ArrayList<BOpcUaNodeLearnEntry> items = this.getHistorizingItems();
        if (items == null) {
            ((BOpcUaDevice)this.getDevice()).doLearn();
            items = this.getHistorizingItems();
        }
        return items.toArray(new BOpcUaNodeLearnEntry[0]);
    }

    void importHistory(NodeId nodeId, UaClient client, DateTime startTime, DateTime endTime, BIHistory pointHistory, HistoryDatabaseConnection dbConnection, boolean useServerTimestamp) throws ServiceException, AddressSpaceException, DecodingException {
        UaVariable variable = (UaVariable)client.getAddressSpace().getNode(nodeId);
        if (!variable.getHistorizing().booleanValue()) {
            log.severe("History not available for node: " + nodeId);
            return;
        }
        if (!variable.getUserAccessLevel().contains(new OptionSpecification[]{AccessLevelType.Options.HistoryRead})) {
            log.severe("User does not have access to read history for node: " + nodeId);
            return;
        }
        ReadRawModifiedDetails details = new ReadRawModifiedDetails(Boolean.valueOf(false), startTime, endTime, UnsignedInteger.valueOf((long)1000L), Boolean.valueOf(true));
        HistoryReadValueId valueId = new HistoryReadValueId(nodeId, null, null, null);
        boolean moreData = true;
        while (moreData) {
            HistoryReadResult[] results = client.historyRead((HistoryReadDetails)details, TimestampsToReturn.Source, Boolean.valueOf(false), new HistoryReadValueId[]{valueId});
            if (results != null && results.length > 0) {
                EncoderContext encoderContext;
                HistoryData historyData;
                DataValue[] historyDataValues;
                HistoryReadResult result = results[0];
                ExtensionObject historyDataObject = result.getHistoryData();
                ByteString continuationPoint = result.getContinuationPoint();
                if (historyDataObject != null && (historyDataValues = (historyData = (HistoryData)historyDataObject.decode(encoderContext = client.getEncoderContext())).getDataValues()) != null) {
                    for (DataValue historyDataValue : historyDataValues) {
                        try {
                            this.appendHistoryDataValue(historyDataValue, pointHistory, dbConnection, useServerTimestamp);
                        }
                        catch (Exception ex) {
                            log.warning("Exception while adding history data:" + ex.getMessage());
                        }
                    }
                }
                if (continuationPoint == null) {
                    moreData = false;
                    continue;
                }
                valueId.setContinuationPoint(continuationPoint);
                continue;
            }
            moreData = false;
        }
        client.historyRead((HistoryReadDetails)details, TimestampsToReturn.Source, Boolean.valueOf(true), new HistoryReadValueId[]{valueId});
    }

    private void appendHistoryDataValue(DataValue dataValue, BIHistory pointHistory, HistoryDatabaseConnection dbConnection, boolean userServerTimestamp) {
        DateTime timestamp = dataValue.getSourceTimestamp();
        if (userServerTimestamp) {
            timestamp = dataValue.getServerTimestamp();
        }
        BAbsTime sampleTime = OpcUaClientUtil.dateTimeToAbsTime(timestamp);
        BTrendRecord histRecord = (BTrendRecord)pointHistory.getRecordType().getInstance();
        BStatusValue histValue = OpcUaClientUtil.makeStatusValue(dataValue, histRecord);
        BAbsTime lastTimestamp = dbConnection.getLastTimestamp(pointHistory);
        if (histValue == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Unable to read history record (value null) for node: " + pointHistory.getId());
            }
            return;
        }
        if (dbConnection.getRecordCount(pointHistory) == 0 || sampleTime.isAfter(lastTimestamp)) {
            if (histRecord instanceof BNumericTrendRecord) {
                double value = ((BStatusNumeric)histValue).getValue();
                ((BNumericTrendRecord)histRecord).set(sampleTime, value, histValue.getStatus());
            } else if (histRecord instanceof BBooleanTrendRecord) {
                boolean value = ((BStatusBoolean)histValue).getValue();
                ((BBooleanTrendRecord)histRecord).set(sampleTime, value, histValue.getStatus());
            } else if (histRecord instanceof BEnumTrendRecord) {
                BDynamicEnum value = ((BStatusEnum)histValue).getValue();
                ((BEnumTrendRecord)histRecord).set(sampleTime, value, histValue.getStatus());
            } else if (histRecord instanceof BStringTrendRecord) {
                String value = ((BStatusString)histValue).getValue();
                ((BStringTrendRecord)histRecord).set(sampleTime, value, histValue.getStatus());
            } else {
                return;
            }
            dbConnection.append(pointHistory, (BIHistoryRecordSet)histRecord);
        }
    }
}

