/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui.security;

import com.tridium.platwifi.security.BWifiEncryptionMethod;
import com.tridium.platwifi.security.BWifiKeyManagementEnum;
import com.tridium.platwifi.security.BWifiWPAPSKSettings;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BLimitedFrozenEnumFE;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.security.AccessController;
import java.util.Objects;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.text.PasswordRenderer;
import javax.baja.ui.text.PasswordTextController;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextRenderer;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"platWifi:WifiWPAPSKSettings", "platWifi:WifiWPA2PSKSettings"})})
@NiagaraActions(value={@NiagaraAction(name="setEnabledStates", flags=4), @NiagaraAction(name="handlePassphraseChanged", flags=4), @NiagaraAction(name="handleShowPassphraseChecked", flags=4)})
public class BWifiWPAPSKEditor
extends BWbView {
    @Generated
    public static final Action setEnabledStates = BWifiWPAPSKEditor.newAction((int)4, null);
    @Generated
    public static final Action handlePassphraseChanged = BWifiWPAPSKEditor.newAction((int)4, null);
    @Generated
    public static final Action handleShowPassphraseChecked = BWifiWPAPSKEditor.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiWPAPSKEditor.class);
    private BPasswordFE wpaPskNetworkKeyFE;
    private BLimitedFrozenEnumFE pairwiseCipherFE;
    private BLimitedFrozenEnumFE groupwiseCipherFE;
    private BCheckBox wpaPskShowPassphraseFE;
    private boolean pskDirty;
    private boolean pskMustBeSet;
    private static final Lexicon LEX = Lexicon.make((String)"platWifi");

    @Generated
    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    @Generated
    public void handlePassphraseChanged() {
        this.invoke(handlePassphraseChanged, null, null);
    }

    @Generated
    public void handleShowPassphraseChecked() {
        this.invoke(handleShowPassphraseChecked, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context contextIn) {
        BFacets contextInFacets;
        int configurationMode;
        if (contextIn == null) {
            contextIn = new BasicContext((Context)BFacets.make((String)"configureMode", (int)0));
        }
        if ((configurationMode = (contextInFacets = contextIn.getFacets()).geti("configureMode", 0)) > 2 || configurationMode < 0) {
            configurationMode = 0;
        }
        this.pskMustBeSet = configurationMode != 0;
        BGridPane editorPane = new BGridPane();
        editorPane.setValign(BValign.top);
        editorPane.setHalign(BHalign.left);
        editorPane.setRowAlign(BValign.center);
        editorPane.setColumnAlign(BHalign.left);
        editorPane.setColumnGap(10.0);
        editorPane.setRowGap(6.0);
        this.pairwiseCipherFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)editorPane, (String)LEX.getText("WifiNetworksManager.pairwise_cipher.label"), (BWidget)this.pairwiseCipherFE);
        this.linkTo(null, (BComponent)this.pairwiseCipherFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setModified);
        this.groupwiseCipherFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)editorPane, (String)LEX.getText("WifiNetworksManager.group_cipher.label"), (BWidget)this.groupwiseCipherFE);
        this.linkTo(null, (BComponent)this.groupwiseCipherFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setModified);
        this.wpaPskNetworkKeyFE = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BPane)editorPane, (String)LEX.getText("WifiNetworksManager.WPA_PSKPassphrase.label"), (BWidget)this.wpaPskNetworkKeyFE);
        this.linkTo(null, (BComponent)this.wpaPskNetworkKeyFE, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.wpaPskNetworkKeyFE, (Slot)BPasswordFE.pluginModified, (Slot)handlePassphraseChanged);
        this.wpaPskShowPassphraseFE = new BCheckBox();
        LabelUtil.addLabelWidgetPair((BPane)editorPane, (String)LEX.getText("WifiNetworksManager.WPA_PSKShowPassphrase.label"), (BWidget)this.wpaPskShowPassphraseFE);
        this.linkTo(null, (BComponent)this.wpaPskShowPassphraseFE, (Slot)BCheckBox.actionPerformed, (Slot)handleShowPassphraseChecked);
        BWifiWPAPSKSettings settings = (BWifiWPAPSKSettings)value;
        this.pairwiseCipherFE.loadValue((BObject)settings.getPairwiseCipher(), (Context)new BasicContext(contextIn, this.getPairwiseCipherFacets()));
        this.groupwiseCipherFE.loadValue((BObject)settings.getGroupCipher(), (Context)new BasicContext(contextIn, this.getGroupCipherFacets()));
        this.wpaPskNetworkKeyFE.loadValue((BObject)settings.getNetworkKey(), (Context)new BasicContext(contextIn, BWifiWPAPSKSettings.networkKey.getFacets()));
        this.pskDirty = false;
        this.setContent((BWidget)editorPane);
        this.doSetEnabledStates();
        this.wpaPskShowPassphraseFE.setSelected(false);
        this.wpaPskShowPassphraseFE.setEnabled(false);
    }

    protected BObject doSaveValue(BObject value, Context context) throws Exception {
        BWifiWPAPSKSettings wifiWPAPSKSettings = (BWifiWPAPSKSettings)value;
        if (this.pskDirty) {
            BPassword preSharedKey = (BPassword)this.wpaPskNetworkKeyFE.saveValue(context);
            String tempPsk = AccessController.doPrivileged(() -> ((BPassword)preSharedKey).getValue());
            if (tempPsk.length() < 8) {
                this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidPreSharedKeyTooShort");
            } else if (tempPsk.length() > 64) {
                this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidPreSharedKeyTooLong");
            } else if (tempPsk.length() == 64) {
                if (!TextUtil.isHex((String)tempPsk)) {
                    this.saveError("WifiNetworkConfigurationEditor.cannotSave.invalidPreSharedKeyHexCharacter");
                }
            } else {
                char[] passphraseChars;
                for (char passphraseChar : passphraseChars = tempPsk.toCharArray()) {
                    if (passphraseChar >= ' ' && passphraseChar <= '~') continue;
                    this.saveError(LEX.getText("WifiNetworkConfigurationEditor.cannotSave.invalidPreSharedKeyAsciiCharacter", new Object[]{String.valueOf(passphraseChar)}));
                }
            }
            wifiWPAPSKSettings.setNetworkKey(preSharedKey);
            this.pskDirty = false;
        } else if (this.pskMustBeSet) {
            this.saveError("WifiNetworkConfigurationEditor.cannotSave.pskMustBeSet");
        }
        wifiWPAPSKSettings.setPairwiseCipher((BWifiEncryptionMethod)this.pairwiseCipherFE.saveValue(context));
        wifiWPAPSKSettings.setGroupCipher((BWifiEncryptionMethod)this.groupwiseCipherFE.saveValue(context));
        wifiWPAPSKSettings.setKeyManagement(this.getWifiKeyManagementEnum());
        return wifiWPAPSKSettings;
    }

    protected void doSetReadonly(boolean readOnly) {
        this.doSetEnabledStates();
    }

    protected BFacets getPairwiseCipherFacets() {
        return BWifiWPAPSKSettings.pairwiseCipher.getFacets();
    }

    protected BFacets getGroupCipherFacets() {
        return BWifiWPAPSKSettings.groupCipher.getFacets();
    }

    protected BWifiKeyManagementEnum getWifiKeyManagementEnum() {
        return BWifiKeyManagementEnum.wpaPsk;
    }

    private void saveError(String messageTag) throws CannotSaveException {
        Objects.requireNonNull(messageTag, "messageTag argument cannot be null");
        throw new CannotSaveException(LEX.getText(messageTag));
    }

    public void doSetEnabledStates() {
        boolean editorEnabled;
        boolean readOnly = this.isReadonly();
        boolean bl = editorEnabled = !readOnly;
        if (this.pairwiseCipherFE != null) {
            this.pairwiseCipherFE.setEnabled(editorEnabled);
            this.pairwiseCipherFE.setReadonly(readOnly);
        }
        if (this.groupwiseCipherFE != null) {
            this.groupwiseCipherFE.setEnabled(editorEnabled);
            this.groupwiseCipherFE.setReadonly(readOnly);
        }
        if (this.wpaPskNetworkKeyFE != null) {
            this.wpaPskNetworkKeyFE.setEnabled(editorEnabled);
            this.wpaPskNetworkKeyFE.setReadonly(readOnly);
        }
        if (this.wpaPskShowPassphraseFE != null && !editorEnabled) {
            this.wpaPskShowPassphraseFE.setSelected(false);
            this.wpaPskShowPassphraseFE.setEnabled(false);
            this.doHandleShowPassphraseChecked();
        }
    }

    public void doHandlePassphraseChanged() {
        this.pskDirty = true;
        this.wpaPskShowPassphraseFE.setEnabled(true);
    }

    public void doHandleShowPassphraseChecked() {
        boolean showPassphrase = this.wpaPskShowPassphraseFE.getSelected();
        BTextField passphraseTextField = (BTextField)this.wpaPskNetworkKeyFE.getContent();
        if (showPassphrase) {
            passphraseTextField.setController(new TextController());
            passphraseTextField.setRenderer(new TextRenderer());
            passphraseTextField.setAllowCopying(true);
        } else {
            passphraseTextField.setController((TextController)new PasswordTextController());
            passphraseTextField.setRenderer((TextRenderer)new PasswordRenderer());
            passphraseTextField.setAllowCopying(false);
        }
        this.wpaPskNetworkKeyFE.relayout();
    }
}

