/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui.daemon;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platwifi.BWifiMonitorData;
import com.tridium.platwifi.BWifiSettings;
import com.tridium.platwifi.BWifiSwitchTypeEnum;
import com.tridium.platwifi.WifiUtil;
import com.tridium.platwifi.status.BWifiSwitchEnum;
import com.tridium.platwifi.ui.BWifiAccessPointManager;
import com.tridium.platwifi.ui.BWifiNetworksManager;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"platform:DaemonSession"})})
@NiagaraActions(value={@NiagaraAction(name="wifiEnabledModified", flags=4), @NiagaraAction(name="wifiSwitchPositionModified", flags=4), @NiagaraAction(name="countryCodeModified", flags=4)})
public class BWifiConfiguration
extends BDaemonSessionView {
    @Generated
    public static final Action wifiEnabledModified = BWifiConfiguration.newAction((int)4, null);
    @Generated
    public static final Action wifiSwitchPositionModified = BWifiConfiguration.newAction((int)4, null);
    @Generated
    public static final Action countryCodeModified = BWifiConfiguration.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiConfiguration.class);
    private static final Object SETTINGS_MONITOR = new Object();
    private static final BasicContext POLL_CONTEXT = new BasicContext((Context)BFacets.make((String)"poll", (BIDataValue)BBoolean.TRUE));
    private static final Lexicon LEX = Lexicon.make((String)"platWifi");
    private static final Logger LOG = Logger.getLogger("plat.wifi");
    private static final BImage CLIENT_ICON = BImage.make((BIcon)BIcon.std((String)"wireless.png"));
    private static final BImage ACCESS_POINT_ICON = BImage.make((BIcon)BIcon.std((String)"remoteMgmt.png"));
    private static final BFont BOLD_TEXT_FONT = Theme.widget().getBoldText();
    private static final String COUNTRY_CODE_DELIMITER = "-";
    private static final String COUNTRY_CODE_NONE = "NONE";
    private static final String COUNTRY_CODE_US = "US-United States";
    private static final String COUNTRY_CODE_EU = "EU-European Union";
    private static final String COUNTRY_CODE_DE = "DE-Germany";
    private static final String SKU_US = "US";
    private static final String SKU_EU = "EU";
    private static final String SKU_NONE = "XX";
    private BDaemonSession daemonSession;
    private BWifiSettings wifiSettings;
    private String previousMonitorState;
    private boolean refreshDisabled;
    private BBooleanFE wifiEnabledFE;
    private BFrozenEnumFE wifiSwitchPositionFE;
    private BLabel wifiMonitorStateLabel;
    private BListDropDown countryCodeFE;
    private BWifiNetworksManager wifiNetworksManager;
    private BWifiAccessPointManager wifiAccessPointManager;

    @Generated
    public void wifiEnabledModified() {
        this.invoke(wifiEnabledModified, null, null);
    }

    @Generated
    public void wifiSwitchPositionModified() {
        this.invoke(wifiSwitchPositionModified, null, null);
    }

    @Generated
    public void countryCodeModified() {
        this.invoke(countryCodeModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadSession(BDaemonSession value, Context context) throws AuthenticationException {
        int rc;
        this.daemonSession = value;
        if (!WifiUtil.supportsWiFi((BDaemonSession)this.daemonSession)) {
            throw new UnsupportedOperationException("Wi-Fi is not supported on platform");
        }
        if (!this.daemonSession.isSecure() && (rc = BDialog.open((BWidget)this, (String)LEX.getText("WifiConfiguration.warning.dialog.title"), (Object)LEX.getText("WifiConfiguration.warning.dialog.msg"), (int)12, (BImage)BDialog.WARNING_ICON, (String)null)) == 8) {
            log.log(Level.SEVERE, LEX.getText("WifiConfiguration.warning.terminated.msg"));
            throw new LocalizableRuntimeException("platWifi", "WifiConfiguration.warning.terminated.msg");
        }
        this.wifiSettings = new BWifiSettings();
        this.wifiNetworksManager = new BWifiNetworksManager(this.daemonSession);
        this.wifiAccessPointManager = new BWifiAccessPointManager(this.daemonSession);
        try {
            BGridPane monitorStateGridPane = new BGridPane(2);
            monitorStateGridPane.setValign(BValign.top);
            monitorStateGridPane.setRowAlign(BValign.center);
            monitorStateGridPane.setColumnAlign(BHalign.left);
            monitorStateGridPane.setRowGap(0.0);
            monitorStateGridPane.setColumnGap(10.0);
            monitorStateGridPane.setStretchColumn(1);
            monitorStateGridPane.setUniformRowHeight(true);
            this.wifiEnabledFE = new BBooleanFE();
            LabelUtil.addLabelWidgetPair((BPane)monitorStateGridPane, (String)LEX.getText("WifiConfiguration.state.wifiEnabled.label"), (BWidget)this.wifiEnabledFE);
            this.wifiSwitchPositionFE = new BFrozenEnumFE();
            LabelUtil.addLabelWidgetPair((BPane)monitorStateGridPane, (String)LEX.getText("WifiConfiguration.state.wifiSwitch.label"), (BWidget)this.wifiSwitchPositionFE);
            this.wifiSwitchPositionFE.setReadonly(true);
            this.wifiMonitorStateLabel = new BLabel("");
            LabelUtil.addLabelWidgetPair((BPane)monitorStateGridPane, (String)LEX.getText("WifiConfiguration.state.monitorState.label"), (BWidget)this.wifiMonitorStateLabel);
            this.countryCodeFE = new BListDropDown();
            LabelUtil.addLabelWidgetPair((BPane)monitorStateGridPane, (String)LEX.getText("WifiConfiguration.state.countryCode.label"), (BWidget)this.countryCodeFE);
            BBorderPane monitorStateBorderPane = new BBorderPane((BWidget)monitorStateGridPane);
            monitorStateBorderPane.setBorder(BBorder.solid);
            monitorStateBorderPane.setLabel((BWidget)LabelUtil.makeLabel((String)LEX.getText("WifiConfiguration.state.label"), (boolean)true));
            monitorStateBorderPane.setMargin(BInsets.make((double)6.0, (double)0.0, (double)6.0, (double)0.0));
            BTabbedPane editorTabbedPane = new BTabbedPane();
            editorTabbedPane.addPane(new BLabel(CLIENT_ICON, LEX.getText("WifiNetworksManager.label"), BOLD_TEXT_FONT), (BWidget)this.wifiNetworksManager);
            editorTabbedPane.addPane(new BLabel(ACCESS_POINT_ICON, LEX.getText("WifiAccessPointManager.label"), BOLD_TEXT_FONT), (BWidget)this.wifiAccessPointManager);
            BEdgePane edge = new BEdgePane();
            edge.setTop((BWidget)monitorStateBorderPane);
            edge.setCenter((BWidget)editorTabbedPane);
            BWbShell shell = this.getWbShell();
            if (shell != null) {
                BButtonPane buttons = new BButtonPane();
                buttons.addWorkbenchButtons((BWidget)this);
                edge.setBottom((BWidget)new BBorderPane((BWidget)buttons, 5.0, 10.0, 0.0, 10.0));
                this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(context), (BWidget)edge));
            } else {
                this.setContent((BWidget)new BBorderPane((BWidget)edge, BBorder.none, BInsets.DEFAULT));
            }
            Object object = SETTINGS_MONITOR;
            synchronized (object) {
                String wifiSku = WifiUtil.wifiSkuFromSession((BDaemonSession)this.daemonSession);
                if (SKU_NONE.equals(wifiSku)) {
                    this.stopRefreshTimer();
                    this.wifiEnabledFE.loadValue((BObject)BBoolean.FALSE);
                    this.wifiEnabledFE.setEnabled(false);
                    this.wifiEnabledFE.setReadonly(true);
                    this.wifiSwitchPositionFE.loadValue((BObject)BWifiSwitchEnum.off);
                    this.wifiSwitchPositionFE.setEnabled(false);
                    this.wifiSwitchPositionFE.setReadonly(true);
                    this.wifiMonitorStateLabel.setText(LEX.getText("unknown"));
                    BString bNone = BString.make((String)COUNTRY_CODE_NONE);
                    this.countryCodeFE.getList().addItem((Object)bNone);
                    this.countryCodeFE.setSelectedItem((Object)bNone);
                    this.countryCodeFE.setEnabled(false);
                    this.setReadonly(true);
                    this.refreshDisabled = true;
                    return;
                }
                BWifiMonitorData monitorData = this.wifiSettings.getMonitorData();
                WifiUtil.monitorDataFromSession((BWifiMonitorData)monitorData, (BDaemonSession)this.daemonSession);
                this.wifiEnabledFE.loadValue((BObject)BBoolean.make((boolean)monitorData.getWifiEnabled()), context);
                this.wifiSwitchPositionFE.loadValue((BObject)monitorData.getWifiSwitchPosition());
                this.wifiMonitorStateLabel.setText(LEX.get("WifiConfiguration.state.monitorState." + monitorData.getWifimonState(), LEX.getText("unknown")));
                this.previousMonitorState = monitorData.getWifimonState();
                String countryCode = WifiUtil.countryCodeFromSession((BDaemonSession)this.daemonSession);
                if (SKU_EU.equals(wifiSku) || SKU_US.equals(wifiSku)) {
                    countryCode = SKU_EU.equals(wifiSku) ? COUNTRY_CODE_EU : COUNTRY_CODE_US;
                    BString countryCodeSelection = BString.make((String)countryCode);
                    this.countryCodeFE.getList().addItem((Object)countryCodeSelection);
                    this.countryCodeFE.setSelectedItem((Object)countryCodeSelection);
                    this.countryCodeFE.setEnabled(false);
                } else {
                    ArrayList countries = new ArrayList();
                    WifiUtil.countryListFromSession(countries, (BDaemonSession)this.daemonSession);
                    for (String country : countries) {
                        BString countryCodeSelection = BString.make((String)country);
                        this.countryCodeFE.getList().addItem((Object)countryCodeSelection);
                        if (this.countryCodeFE.getSelectedIndex() != -1 || !country.startsWith(countryCode)) continue;
                        this.countryCodeFE.setSelectedItem((Object)countryCodeSelection);
                    }
                    this.countryCodeFE.setEnabled(true);
                }
                this.linkTo(null, (BComponent)this.wifiEnabledFE, (Slot)BBooleanFE.pluginModified, (Slot)wifiEnabledModified);
                this.linkTo(null, (BComponent)this.wifiSwitchPositionFE, (Slot)BFrozenEnumFE.pluginModified, (Slot)wifiSwitchPositionModified);
                this.linkTo(null, (BComponent)this.countryCodeFE, (Slot)BListDropDown.valueModified, (Slot)countryCodeModified);
                WifiUtil.loadFromSession((BWifiSettings)this.wifiSettings, (BDaemonSession)this.daemonSession);
                this.wifiSwitchPositionFE.setReadonly(BWifiSwitchTypeEnum.hardware.equals((Object)this.wifiSettings.getWifiSwitchType()));
                this.wifiNetworksManager.loadValue((BObject)this.wifiSettings, context);
                this.wifiAccessPointManager.loadValue((BObject)this.wifiSettings, context);
                this.linkTo(null, (BComponent)this.wifiNetworksManager, (Slot)BWifiNetworksManager.pluginModified, (Slot)setModified);
                this.linkTo(null, (BComponent)this.wifiAccessPointManager, (Slot)BWifiAccessPointManager.pluginModified, (Slot)setModified);
                this.setReadonly(this.wifiSettings.getWifiReadonly());
                this.doWifiEnabledModified(false);
                this.startRefreshTimer();
            }
        }
        catch (RuntimeException runtimeException) {
            LOG.log(Level.SEVERE, LEX.getText("WifiConfiguration.parseError"), runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, LEX.getText("WifiConfiguration.parseError"), exception);
            throw new LocalizableRuntimeException("platWifi", "WifiConfiguration.parseError", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRefresh() {
        if (this.daemonSession == null || this.wifiEnabledFE == null || this.wifiSwitchPositionFE == null || this.wifiMonitorStateLabel == null || this.wifiNetworksManager == null || this.wifiAccessPointManager == null) {
            return;
        }
        if (this.refreshDisabled) {
            return;
        }
        try {
            Object object = SETTINGS_MONITOR;
            synchronized (object) {
                if (this.wifiSettings == null) {
                    return;
                }
                BWifiMonitorData monitorData = this.wifiSettings.getMonitorData();
                WifiUtil.monitorDataFromSession((BWifiMonitorData)monitorData, (BDaemonSession)this.daemonSession);
                this.wifiEnabledFE.loadValue((BObject)BBoolean.make((boolean)monitorData.getWifiEnabled()));
                this.wifiSwitchPositionFE.loadValue((BObject)monitorData.getWifiSwitchPosition());
                this.wifiMonitorStateLabel.setText(LEX.get("WifiConfiguration.state.monitorState." + monitorData.getWifimonState(), LEX.getText("unknown")));
                String newMonitorState = monitorData.getWifimonState();
                if (newMonitorState.equals(this.previousMonitorState)) {
                    return;
                }
                this.previousMonitorState = newMonitorState;
                WifiUtil.loadFromSession((BWifiSettings)this.wifiSettings, (BDaemonSession)this.daemonSession);
                BWifiSwitchEnum switchEnum = monitorData.getWifiSwitchPosition();
                if (switchEnum == BWifiSwitchEnum.station) {
                    if (newMonitorState.startsWith("sta_")) {
                        this.wifiNetworksManager.refreshSettings(this.wifiSettings, (Context)POLL_CONTEXT);
                    }
                } else if ((switchEnum == BWifiSwitchEnum.accessPoint || switchEnum == BWifiSwitchEnum.accessPointControlled) && newMonitorState.startsWith("sap_")) {
                    this.wifiAccessPointManager.refreshSettings(this.wifiSettings, (Context)POLL_CONTEXT);
                }
                this.doWifiEnabledModified(false);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, LEX.getText("WifiConfiguration.parseError"), exception);
        }
    }

    public BDaemonSession getDaemonSession() {
        return this.daemonSession;
    }

    public void deactivated() {
        super.deactivated();
        this.stopRefreshTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BObject doSaveValue(BObject value, Context context) throws Exception {
        if (this.isReadonly()) {
            return value;
        }
        if (!this.isModified()) {
            return value;
        }
        if (this.daemonSession == null || this.wifiEnabledFE == null || this.countryCodeFE == null || this.wifiNetworksManager == null || this.wifiAccessPointManager == null) {
            return value;
        }
        Object object = SETTINGS_MONITOR;
        synchronized (object) {
            if (this.wifiSettings == null) {
                return value;
            }
            boolean wifiEnabled = ((BBoolean)this.wifiEnabledFE.saveValue(context)).getBoolean();
            this.wifiSettings.setWifiEnabled(wifiEnabled);
            this.wifiSettings.getMonitorData().setWifiEnabled(wifiEnabled);
            BWifiSwitchEnum wifiSwitchEnum = (BWifiSwitchEnum)this.wifiSwitchPositionFE.saveValue(context);
            this.wifiSettings.getMonitorData().setWifiSwitchPosition(wifiSwitchEnum);
            String countryCode = ((BString)this.countryCodeFE.getSelectedItem()).getString();
            countryCode = COUNTRY_CODE_EU.equals(countryCode) ? COUNTRY_CODE_DE : countryCode;
            StringTokenizer stringTokenizer = new StringTokenizer(countryCode, COUNTRY_CODE_DELIMITER);
            countryCode = stringTokenizer.nextToken();
            this.wifiSettings.setCountryCode(countryCode);
            this.wifiSettings = (BWifiSettings)this.wifiNetworksManager.saveValue((BObject)this.wifiSettings, context);
            this.wifiSettings = (BWifiSettings)this.wifiAccessPointManager.saveValue((BObject)this.wifiSettings, context);
            WifiUtil.saveToSession((BWifiSettings)this.wifiSettings, (BDaemonSession)this.daemonSession, (Context)context);
            if (wifiSwitchEnum == BWifiSwitchEnum.accessPoint && this.wifiSettings.getWifiRequiresReboot()) {
                if (this.daemonSession.getHostProperties().getAccessLevel().atLeast(BDaemonAccessLevel.full)) {
                    this.promptForReboot(true);
                    this.refreshDisabled = true;
                } else {
                    BDialog.message((BWidget)this, (String)LEX.getText("WifiConfiguration.rebootRequired.title"), (Object)LEX.getText("WifiConfiguration.rebootRequired.message"));
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetReadonly(boolean readOnly) {
        if (this.wifiEnabledFE != null) {
            this.wifiEnabledFE.setReadonly(readOnly);
            this.wifiEnabledFE.setEnabled(!readOnly);
        }
        if (this.wifiSwitchPositionFE != null) {
            boolean hardwareSwitchType;
            Object object = SETTINGS_MONITOR;
            synchronized (object) {
                hardwareSwitchType = this.wifiSettings == null || BWifiSwitchTypeEnum.hardware.equals((Object)this.wifiSettings.getWifiSwitchType());
            }
            this.wifiSwitchPositionFE.setReadonly(hardwareSwitchType || readOnly);
            this.wifiSwitchPositionFE.setEnabled(!hardwareSwitchType && !readOnly);
        }
        if (this.countryCodeFE != null) {
            this.countryCodeFE.setEnabled(!readOnly);
        }
        if (this.wifiNetworksManager != null) {
            this.wifiNetworksManager.setReadonly(readOnly);
        }
        if (this.wifiAccessPointManager != null) {
            this.wifiAccessPointManager.setReadonly(readOnly);
        }
    }

    public void activated() {
        super.activated();
        if (this.daemonSession != null && !this.isRefreshTimerRunning()) {
            this.startRefreshTimer();
        }
    }

    public void doWifiEnabledModified() {
        this.doWifiEnabledModified(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWifiEnabledModified(boolean sendDaemonMessage) {
        if (this.wifiEnabledFE == null || this.wifiNetworksManager == null || this.wifiAccessPointManager == null) {
            return;
        }
        boolean wifiEnabled = false;
        try {
            wifiEnabled = ((BBoolean)this.wifiEnabledFE.saveValue()).getBoolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.wifiNetworksManager.setReadonly(!wifiEnabled);
        this.wifiAccessPointManager.setReadonly(!wifiEnabled);
        if (!sendDaemonMessage) {
            return;
        }
        if (this.isReadonly()) {
            return;
        }
        if (this.daemonSession == null) {
            return;
        }
        try {
            if (!WifiUtil.wifiEnabledToSession((boolean)wifiEnabled, (BDaemonSession)this.daemonSession)) {
                throw new Exception("Failed to set Wi-Fi enabled state");
            }
            boolean wifiRequiresReboot = false;
            Object object = SETTINGS_MONITOR;
            synchronized (object) {
                if (this.wifiSettings != null) {
                    wifiRequiresReboot = this.wifiSettings.getWifiRequiresReboot();
                }
            }
            this.doRefresh();
            if (wifiRequiresReboot) {
                if (this.daemonSession.getHostProperties().getAccessLevel().atLeast(BDaemonAccessLevel.full)) {
                    this.promptForReboot(true);
                    this.refreshDisabled = true;
                } else {
                    BDialog.message((BWidget)this, (String)LEX.getText("WifiConfiguration.rebootRequired.title"), (Object)LEX.getText("WifiConfiguration.rebootRequired.message"));
                }
            }
        }
        catch (Exception exception) {
            String message = LEX.getText("WifiConfiguration.state.wifiEnabled.error", new Object[]{wifiEnabled});
            LOG.log(Level.SEVERE, message, exception);
            BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)message, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWifiSwitchPositionModified() {
        if (this.isReadonly()) {
            return;
        }
        if (this.daemonSession == null || this.wifiSwitchPositionFE == null) {
            return;
        }
        Object object = SETTINGS_MONITOR;
        synchronized (object) {
            if (this.wifiSettings == null || BWifiSwitchTypeEnum.hardware.equals((Object)this.wifiSettings.getWifiSwitchType())) {
                return;
            }
        }
        BWifiSwitchEnum wifiSwitchEnum = BWifiSwitchEnum.off;
        try {
            wifiSwitchEnum = (BWifiSwitchEnum)this.wifiSwitchPositionFE.saveValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!WifiUtil.wifiSwitchPositionToSession((BWifiSwitchEnum)wifiSwitchEnum, (BDaemonSession)this.daemonSession)) {
                throw new Exception("Failed to set Wi-Fi switch position");
            }
            this.doRefresh();
            boolean wifiRequiresReboot = false;
            Object object2 = SETTINGS_MONITOR;
            synchronized (object2) {
                if (this.wifiSettings != null) {
                    wifiRequiresReboot = this.wifiSettings.getWifiRequiresReboot();
                }
            }
            if (wifiRequiresReboot) {
                if (this.daemonSession.getHostProperties().getAccessLevel().atLeast(BDaemonAccessLevel.full)) {
                    this.promptForReboot(true);
                    this.refreshDisabled = true;
                } else {
                    BDialog.message((BWidget)this, (String)LEX.getText("WifiConfiguration.rebootRequired.title"), (Object)LEX.getText("WifiConfiguration.rebootRequired.message"));
                }
            }
        }
        catch (Exception exception) {
            String message = LEX.getText("WifiConfiguration.state.wifiSwitchPosition.error", new Object[]{wifiSwitchEnum});
            LOG.log(Level.SEVERE, message, exception);
            BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)message, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCountryCodeModified() {
        if (this.isReadonly()) {
            return;
        }
        if (this.daemonSession == null || this.countryCodeFE == null) {
            return;
        }
        String countryCode = ((BString)this.countryCodeFE.getSelectedItem()).getString();
        countryCode = COUNTRY_CODE_EU.equals(countryCode) ? COUNTRY_CODE_DE : countryCode;
        StringTokenizer stringTokenizer = new StringTokenizer(countryCode, COUNTRY_CODE_DELIMITER);
        countryCode = stringTokenizer.nextToken();
        try {
            if (!WifiUtil.countryCodeToSession((String)countryCode, (BDaemonSession)this.daemonSession)) {
                throw new Exception("Failed to set Wi-Fi country code");
            }
            boolean wifiRequiresReboot = false;
            Object object = SETTINGS_MONITOR;
            synchronized (object) {
                if (this.wifiSettings != null) {
                    wifiRequiresReboot = this.wifiSettings.getWifiRequiresReboot();
                }
            }
            if (wifiRequiresReboot) {
                if (this.daemonSession.getHostProperties().getAccessLevel().atLeast(BDaemonAccessLevel.full)) {
                    this.promptForReboot(true);
                    this.refreshDisabled = true;
                } else {
                    BDialog.message((BWidget)this, (String)LEX.getText("WifiConfiguration.rebootRequired.title"), (Object)LEX.getText("WifiConfiguration.rebootRequired.message"));
                }
            }
        }
        catch (Exception exception) {
            String message = LEX.getText("WifiConfiguration.state.countryCode.error", new Object[]{countryCode});
            LOG.log(Level.SEVERE, message, exception);
            BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)message, (Throwable)exception);
        }
    }
}

