/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.WiFiServletType;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platwifi.BSupplicantNetBlock;
import com.tridium.platwifi.BSupplicantNetBlockVector;
import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.BWifiNetworkMode;
import com.tridium.platwifi.BWifiNetworkVector;
import com.tridium.platwifi.BWifiSettings;
import com.tridium.platwifi.WifiUtil;
import com.tridium.platwifi.daemon.message.SetGatewaySwitchingMessage;
import com.tridium.platwifi.security.BWifiAuthenticationMethod;
import com.tridium.platwifi.security.BWifiEncryptionMethod;
import com.tridium.platwifi.security.BWifiKeyManagementEnum;
import com.tridium.platwifi.security.BWifiProtocol;
import com.tridium.platwifi.security.BWifiSecurityPolicy;
import com.tridium.platwifi.security.BWifiSecuritySettings;
import com.tridium.platwifi.security.BWifiWPA2PSKSettings;
import com.tridium.platwifi.security.BWifiWPA3SAESettings;
import com.tridium.platwifi.security.BWifiWPAPSKSettings;
import com.tridium.platwifi.status.BWifiNetworkStateEnum;
import com.tridium.platwifi.status.BWifiSupplicantStateEnum;
import com.tridium.platwifi.ui.BDiscoverPreferences;
import com.tridium.platwifi.ui.BWifiDiscoverDialog;
import com.tridium.platwifi.ui.BWifiNetworkEditorDialog;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import java.util.Comparator;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="setEnabledStates", flags=4), @NiagaraAction(name="handleDiscoveredSelectionModified", flags=4), @NiagaraAction(name="handleDatabaseSelectionModified", flags=4), @NiagaraAction(name="handleDiscoveredFocusModified", parameterType="BFocusEvent", defaultValue="new BFocusEvent()", flags=4), @NiagaraAction(name="handleDatabaseFocusModified", parameterType="BFocusEvent", defaultValue="new BFocusEvent()", flags=4), @NiagaraAction(name="gatewaySwitchingModified", flags=4)})
public class BWifiNetworksManager
extends BWbComponentView {
    @Generated
    public static final Action setEnabledStates = BWifiNetworksManager.newAction((int)4, null);
    @Generated
    public static final Action handleDiscoveredSelectionModified = BWifiNetworksManager.newAction((int)4, null);
    @Generated
    public static final Action handleDatabaseSelectionModified = BWifiNetworksManager.newAction((int)4, null);
    @Generated
    public static final Action handleDiscoveredFocusModified = BWifiNetworksManager.newAction((int)4, (BValue)new BFocusEvent(), null);
    @Generated
    public static final Action handleDatabaseFocusModified = BWifiNetworksManager.newAction((int)4, (BValue)new BFocusEvent(), null);
    @Generated
    public static final Action gatewaySwitchingModified = BWifiNetworksManager.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiNetworksManager.class);
    private BDaemonSession daemonSession;
    private BWifiSettings wifiSettings;
    private BWifiNetwork currentNetwork;
    private boolean clientModeEnabled;
    private BWifiSupplicantStateEnum clientState;
    private BWifiSupplicantStateEnum previousClientState = BWifiSupplicantStateEnum.idle;
    private BGridPane clientConfigPane;
    private BLabel clientAdapterLabel;
    private BLabel connectedSsidLabel;
    private BLabel clientMACAddressLabel;
    private BLabel clientIpAddressLabel;
    private BLabel supplicantStateLabel;
    private BCheckBox updateGatewayCheckbox;
    private BTitlePane titledDiscoveryTable;
    private BTable discoveredNetworkTable;
    private WifiNetworkTableModel discoveredNetworkTableModel;
    private BButtonPane discoverButtons;
    private DiscoverCommand discoverNetworksCommand;
    private AddCommand addNetworkCommand;
    private BTitlePane titledDatabaseTable;
    private BTable databaseNetworkTable;
    private WifiNetworkTableModel databaseNetworkTableModel;
    private BButtonPane databaseButtons;
    private ConnectCommand connectNetworkCommand;
    private DisconnectCommand disconnectNetworkCommand;
    private EditCommand editNetworkCommand;
    private NewCommand newNetworkCommand;
    private RemoveCommand removeNetworkCommand;
    private static final BFacets SAVE_FACETS = BFacets.make((String)"wifiSaveSupplicant", (boolean)true);
    private static final Logger LOG = Logger.getLogger("plat.wifi");
    private static final Lexicon LEX = Lexicon.make((String)"platWifi");
    private static final BImage UNSECURED_NETWORK_ICON = BImage.make((BIcon)BIcon.std((String)"cloud.png"));
    private static final BImage SECURED_NETWORK_ICON = BImage.make((BIcon)BIcon.std((String)"securityDomain.png"));
    private static final BImage UNAVAILABLE_NETWORK_ICON = BImage.make((BIcon)BIcon.std((String)"cloudDisconnected.png"));
    private static final BImage DISCOVER_ICON = BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/find.png")}));
    private static final BImage ADD_ICON = BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/import.png")}));
    private static final BImage CONNECT_ICON = BImage.make((BIcon)BIcon.std((String)"connection.png"));
    private static final BImage DISCONNECT_ICON = BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/connection.png"), BOrd.make((String)"module://icons/x16/badges/remove.png")}));
    private static final BImage REMOVE_ICON = BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/remove.png")}));
    private static final BImage EDIT_ICON = BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/edit.png")}));
    private static final BImage NEW_ICON = BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/new.png")}));

    @Generated
    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    @Generated
    public void handleDiscoveredSelectionModified() {
        this.invoke(handleDiscoveredSelectionModified, null, null);
    }

    @Generated
    public void handleDatabaseSelectionModified() {
        this.invoke(handleDatabaseSelectionModified, null, null);
    }

    @Generated
    public void handleDiscoveredFocusModified(BFocusEvent parameter) {
        this.invoke(handleDiscoveredFocusModified, (BValue)parameter, null);
    }

    @Generated
    public void handleDatabaseFocusModified(BFocusEvent parameter) {
        this.invoke(handleDatabaseFocusModified, (BValue)parameter, null);
    }

    @Generated
    public void gatewaySwitchingModified() {
        this.invoke(gatewaySwitchingModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiNetworksManager() {
    }

    public BWifiNetworksManager(BDaemonSession daemonSession) {
        this.daemonSession = daemonSession;
    }

    protected void doLoadValue(BObject value, Context contextIn) {
        this.autoRegisterForComponentEvents = false;
        this.wifiSettings = (BWifiSettings)value;
        this.clientConfigPane = new BGridPane(2);
        this.clientConfigPane.setValign(BValign.top);
        this.clientConfigPane.setRowAlign(BValign.center);
        this.clientConfigPane.setColumnAlign(BHalign.left);
        this.clientConfigPane.setRowGap(5.0);
        this.clientConfigPane.setColumnGap(10.0);
        this.clientConfigPane.setStretchColumn(1);
        this.clientConfigPane.setUniformRowHeight(true);
        this.supplicantStateLabel = new BLabel("");
        LabelUtil.addLabelWidgetPair((BPane)this.clientConfigPane, (String)LEX.getText("WifiNetworksManager.settings.wpaState.label"), (BWidget)this.supplicantStateLabel);
        this.clientAdapterLabel = new BLabel("");
        LabelUtil.addLabelWidgetPair((BPane)this.clientConfigPane, (String)LEX.getText("WifiNetworksManager.settings.clientModeAdapter.label"), (BWidget)this.clientAdapterLabel);
        this.connectedSsidLabel = new BLabel("");
        LabelUtil.addLabelWidgetPair((BPane)this.clientConfigPane, (String)LEX.getText("WifiNetworksManager.settings.connectedSsid.label"), (BWidget)this.connectedSsidLabel);
        this.clientMACAddressLabel = new BLabel("");
        LabelUtil.addLabelWidgetPair((BPane)this.clientConfigPane, (String)LEX.getText("WifiNetworksManager.settings.clientMacAddress.label"), (BWidget)this.clientMACAddressLabel);
        this.clientIpAddressLabel = new BLabel("");
        LabelUtil.addLabelWidgetPair((BPane)this.clientConfigPane, (String)LEX.getText("WifiNetworksManager.settings.clientIpAddress.label"), (BWidget)this.clientIpAddressLabel);
        this.updateGatewayCheckbox = new BCheckBox(LEX.getText("WifiNetworksManager.settings.updateGateway.checkbox.label"), false);
        LabelUtil.addLabelWidgetPair((BPane)this.clientConfigPane, (String)LEX.getText("WifiNetworksManager.settings.updateGateway.label"), (BWidget)this.updateGatewayCheckbox);
        this.linkTo(null, (BComponent)this.updateGatewayCheckbox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.updateGatewayCheckbox, (Slot)BCheckBox.actionPerformed, (Slot)gatewaySwitchingModified);
        BBorderPane settingsBorder = new BBorderPane((BWidget)this.clientConfigPane);
        settingsBorder.setBorder(BBorder.solid);
        settingsBorder.setLabel((BWidget)LabelUtil.makeLabel((String)LEX.getText("WifiNetworksManager.settings.label"), (boolean)true));
        settingsBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)6.0, (double)0.0));
        this.discoveredNetworkTableModel = new WifiNetworkTableModel(true, true, false, true, false, true, true, true);
        this.discoveredNetworkTable = new BTable((TableModel)this.discoveredNetworkTableModel);
        this.discoveredNetworkTable.setCellRenderer((TableCellRenderer)new WifiNetworkCellRenderer());
        this.discoveredNetworkTable.setController((TableController)new DiscoveryTableController());
        this.discoveredNetworkTable.setHeaderVisible(true);
        this.discoveredNetworkTable.setMultipleSelection(false);
        this.discoveredNetworkTable.setVscrollBarVisible(true);
        this.linkTo(null, (BComponent)this.discoveredNetworkTable, (Slot)BTable.focusEvent, (Slot)handleDiscoveredFocusModified);
        this.linkTo(null, (BComponent)this.discoveredNetworkTable, (Slot)BTable.selectionModified, (Slot)handleDiscoveredSelectionModified);
        this.discoverButtons = new BButtonPane();
        this.discoverButtons.setColumnCount(2);
        this.discoverButtons.setUniformColumnWidth(false);
        this.discoverButtons.setBandBrush(Theme.scrollPane().getControlBackground());
        this.discoverNetworksCommand = new DiscoverCommand();
        this.discoverButtons.add("discover", (BValue)new BButton((Command)this.discoverNetworksCommand, true, true));
        this.addNetworkCommand = new AddCommand();
        this.discoverButtons.add("add", (BValue)new BButton((Command)this.addNetworkCommand, true, true));
        BBorderPane discoverButtonBorder = new BBorderPane((BWidget)this.discoverButtons, 5.0, 0.0, 0.0, 0.0);
        this.titledDiscoveryTable = BTitlePane.makePane((String)LEX.getText("WifiNetworksManager.header.discovered"), (BTable)this.discoveredNetworkTable);
        this.titledDiscoveryTable.setBottom((BWidget)discoverButtonBorder);
        BBorderPane titledDiscoveryTableBorder = new BBorderPane((BWidget)this.titledDiscoveryTable);
        titledDiscoveryTableBorder.setBorder(BBorder.solid);
        titledDiscoveryTableBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)6.0, (double)0.0));
        this.databaseNetworkTableModel = new WifiNetworkTableModel(false, true, true, false, true, true, false, false);
        this.databaseNetworkTable = new BTable((TableModel)this.databaseNetworkTableModel);
        this.databaseNetworkTable.setCellRenderer((TableCellRenderer)new WifiNetworkCellRenderer());
        this.databaseNetworkTable.setController((TableController)new DatabaseTableController());
        this.databaseNetworkTable.setHeaderVisible(true);
        this.databaseNetworkTable.setMultipleSelection(false);
        this.databaseNetworkTable.setVscrollBarVisible(true);
        this.linkTo(null, (BComponent)this.databaseNetworkTable, (Slot)BTable.tableModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.databaseNetworkTable, (Slot)BTable.focusEvent, (Slot)handleDatabaseFocusModified);
        this.linkTo(null, (BComponent)this.databaseNetworkTable, (Slot)BTable.actionPerformed, (Slot)handleDatabaseSelectionModified);
        this.databaseButtons = new BButtonPane();
        this.databaseButtons.setColumnCount(5);
        this.databaseButtons.setUniformColumnWidth(false);
        this.databaseButtons.setBandBrush(Theme.scrollPane().getControlBackground());
        this.connectNetworkCommand = new ConnectCommand();
        this.databaseButtons.add("connect", (BValue)new BButton((Command)this.connectNetworkCommand, true, true));
        this.disconnectNetworkCommand = new DisconnectCommand();
        this.databaseButtons.add("disconnect", (BValue)new BButton((Command)this.disconnectNetworkCommand, true, true));
        this.editNetworkCommand = new EditCommand();
        this.databaseButtons.add("edit", (BValue)new BButton((Command)this.editNetworkCommand, true, true));
        this.newNetworkCommand = new NewCommand();
        this.databaseButtons.add("new", (BValue)new BButton((Command)this.newNetworkCommand, true, true));
        this.removeNetworkCommand = new RemoveCommand();
        this.databaseButtons.add("remove", (BValue)new BButton((Command)this.removeNetworkCommand, true, true));
        BBorderPane databaseButtonBorder = new BBorderPane((BWidget)this.databaseButtons, 5.0, 0.0, 0.0, 0.0);
        this.titledDatabaseTable = BTitlePane.makePane((String)LEX.getText("WifiNetworksManager.header.database"), (BTable)this.databaseNetworkTable);
        this.titledDatabaseTable.setBottom((BWidget)databaseButtonBorder);
        BBorderPane titledDatabaseTableBorder = new BBorderPane((BWidget)this.titledDatabaseTable);
        titledDatabaseTableBorder.setBorder(BBorder.solid);
        titledDatabaseTableBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)6.0, (double)0.0));
        BGridPane assembledPanes = new BGridPane(1);
        assembledPanes.setValign(BValign.top);
        assembledPanes.setRowAlign(BValign.center);
        assembledPanes.setColumnAlign(BHalign.fill);
        assembledPanes.setStretchColumn(0);
        assembledPanes.setUniformColumnWidth(true);
        assembledPanes.add("settingsBorder", (BValue)settingsBorder);
        assembledPanes.add("titledDiscoveryTableBorder", (BValue)titledDiscoveryTableBorder);
        assembledPanes.add("titledDatabaseTableBorder", (BValue)titledDatabaseTableBorder);
        this.setContent((BWidget)new BScrollPane((BWidget)new BBorderPane((BWidget)assembledPanes)));
        this.refreshSettings(this.wifiSettings, contextIn);
        this.doSetEnabledStates();
    }

    protected BObject doSaveValue(BObject value, Context context) {
        if (!this.isModified()) {
            return value;
        }
        if (value == null) {
            return null;
        }
        BWifiSettings wifiSettings = (BWifiSettings)value;
        wifiSettings.getSupplicantNetworkBlocks().removeAll();
        for (int idx = 0; idx < this.databaseNetworkTableModel.getRowCount(); ++idx) {
            BSupplicantNetBlock networkBlock = this.databaseNetworkTableModel.getNetBlockAt(idx);
            String propName = SlotPath.escape((String)networkBlock.getSsid());
            wifiSettings.getSupplicantNetworkBlocks().add(propName, (BValue)networkBlock, 3);
        }
        this.refreshSettings(wifiSettings, null);
        return wifiSettings;
    }

    protected void doSetReadonly(boolean readOnly) {
        this.doSetEnabledStates();
    }

    public void refreshSettings(BWifiSettings wifiSettings, Context contextIn) {
        BSupplicantNetBlock[] supplicantNetworkBlocks;
        Context context;
        if (wifiSettings == null || this.supplicantStateLabel == null || this.clientAdapterLabel == null || this.connectedSsidLabel == null || this.clientMACAddressLabel == null || this.clientIpAddressLabel == null || this.updateGatewayCheckbox == null || this.discoveredNetworkTableModel == null || this.databaseNetworkTableModel == null) {
            return;
        }
        this.clientModeEnabled = wifiSettings.getMonitorData().getWifiSwitchPosition().getOrdinal() == 1;
        this.clientState = wifiSettings.getStaWpaSupplicantState();
        if (wifiSettings.getMonitorData().getWifimonState().startsWith("sap_")) {
            this.clientState = BWifiSupplicantStateEnum.notrunning;
        }
        this.supplicantStateLabel.setText(this.clientState.getDisplayTag(null));
        this.connectedSsidLabel.setText(wifiSettings.getStaCurrentNetworkSsid());
        this.clientMACAddressLabel.setText(wifiSettings.getStaCurrentNetworkAddress());
        this.clientAdapterLabel.setText(wifiSettings.getStaAdapterName());
        this.clientIpAddressLabel.setText(wifiSettings.getStaCurrentNetworkIpAddress());
        if (this.clientState.getOrdinal() == 9 && this.currentNetwork != null && this.currentNetwork.getNetworkState() == BWifiNetworkStateEnum.connecting) {
            this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.connected);
        }
        Object object = context = contextIn == null ? new BasicContext() : contextIn;
        if (context.getFacets().get("poll", (BObject)BBoolean.FALSE).equals((Object)BBoolean.TRUE)) {
            return;
        }
        this.lockModifiedState();
        boolean alreadyModified = this.isModified();
        this.updateGatewayCheckbox.setSelected(wifiSettings.getStaSwitchDefaultGateway());
        this.databaseNetworkTableModel.clear();
        String currentNetworkSsid = wifiSettings.getStaCurrentNetworkSsid();
        BSupplicantNetBlockVector supplicantNetworkBlockVector = wifiSettings.getSupplicantNetworkBlocks();
        for (BSupplicantNetBlock supplicantNetBlock : supplicantNetworkBlocks = (BSupplicantNetBlock[])supplicantNetworkBlockVector.getChildren(BSupplicantNetBlock.class)) {
            BWifiNetwork databaseNet = BWifiNetworksManager.supplicantNetBlockToWifiNetwork(supplicantNetBlock);
            if (currentNetworkSsid.equals(supplicantNetBlock.getSsid())) {
                this.currentNetwork = databaseNet;
            }
            this.databaseNetworkTableModel.addNetwork(databaseNet, BWifiNetworksManager.SECURED_NETWORK_ICON);
        }
        if (!this.clientState.equals((Object)this.previousClientState)) {
            switch (this.clientState.getOrdinal()) {
                case 0: {
                    int i;
                    this.discoveredNetworkTableModel.clear();
                    for (i = 0; i < this.databaseNetworkTableModel.getRowCount(); ++i) {
                        this.databaseNetworkTableModel.setStatusAt(i, BWifiNetworkStateEnum.unknown);
                    }
                    if (this.currentNetwork != null) {
                        this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.unknown);
                    }
                    this.currentNetwork = null;
                    break;
                }
                case 1: 
                case 10: 
                case 11: {
                    int i;
                    this.discoveredNetworkTableModel.clear();
                    for (i = 0; i < this.databaseNetworkTableModel.getRowCount(); ++i) {
                        this.databaseNetworkTableModel.setStatusAt(i, BWifiNetworkStateEnum.unavailable);
                    }
                    if (this.currentNetwork != null) {
                        this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.unavailable);
                    }
                    this.currentNetwork = null;
                    break;
                }
                case 2: 
                case 3: {
                    int i;
                    this.discoveredNetworkTableModel.clear();
                    for (i = 0; i < this.databaseNetworkTableModel.getRowCount(); ++i) {
                        this.databaseNetworkTableModel.setStatusAt(i, BWifiNetworkStateEnum.disconnected);
                    }
                    if (this.currentNetwork != null) {
                        this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.disconnected);
                    }
                    this.currentNetwork = null;
                    break;
                }
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: {
                    String ssid = wifiSettings.getStaCurrentNetworkSsid();
                    int row = this.databaseNetworkTableModel.getRowForSsid(ssid);
                    if (row != -1) {
                        this.databaseNetworkTableModel.setStatusAt(row, BWifiNetworkStateEnum.connecting);
                    }
                    if (this.currentNetwork == null) break;
                    this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.connecting);
                    break;
                }
                case 9: {
                    String ssid = wifiSettings.getStaCurrentNetworkSsid();
                    int row = this.databaseNetworkTableModel.getRowForSsid(ssid);
                    if (row != -1) {
                        this.databaseNetworkTableModel.setStatusAt(row, BWifiNetworkStateEnum.connected);
                    }
                    if (this.currentNetwork == null) break;
                    this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.connected);
                    break;
                }
            }
            this.databaseNetworkTableModel.updateValues(true);
            this.previousClientState = BWifiSupplicantStateEnum.make((int)this.clientState.getOrdinal());
        }
        this.databaseNetworkTableModel.sortColumn = 3;
        this.databaseNetworkTableModel.updateValues(true);
        this.unlockModifiedState();
        if (!alreadyModified) {
            this.clearModified();
        }
    }

    private static BWifiNetwork supplicantNetBlockToWifiNetwork(BSupplicantNetBlock supplicantNetBlock) {
        BWifiWPAPSKSettings wpaPskSettings;
        Objects.requireNonNull(supplicantNetBlock, "supplicantNetBlock argument cannot be null");
        BWifiNetwork wifiNetwork = new BWifiNetwork();
        wifiNetwork.setSsid(supplicantNetBlock.getSsid());
        wifiNetwork.setProtocols(BWifiProtocol.toWifiProtocol((String)supplicantNetBlock.getProto()));
        wifiNetwork.setPriority(supplicantNetBlock.getPriority());
        wifiNetwork.setSsidBroadcasted(supplicantNetBlock.getScan_ssid() == 0);
        wifiNetwork.setNetworkState(supplicantNetBlock.getDisabled() ? BWifiNetworkStateEnum.disabled : BWifiNetworkStateEnum.unknown);
        wifiNetwork.setMode(BWifiNetworkMode.managed);
        String wifiProtocol = supplicantNetBlock.getProto();
        BWifiAuthenticationMethod wifiAuthenticationMethod = BWifiAuthenticationMethod.open;
        BWifiKeyManagementEnum wifiKeyManagementEnum = BWifiKeyManagementEnum.toWifiKeyManagementEnum((String)supplicantNetBlock.getKey_mgmt());
        BWifiSecurityPolicy wifiSecurityPolicy = BWifiSecurityPolicy.toSecurityPolicy((String)wifiProtocol, (BWifiAuthenticationMethod)wifiAuthenticationMethod, (BWifiKeyManagementEnum)wifiKeyManagementEnum);
        switch (wifiSecurityPolicy.getOrdinal()) {
            default: {
                wpaPskSettings = new BWifiWPAPSKSettings();
                break;
            }
            case 5: 
            case 6: {
                wpaPskSettings = new BWifiWPA2PSKSettings();
                break;
            }
            case 8: {
                wpaPskSettings = new BWifiWPA3SAESettings();
            }
        }
        wpaPskSettings.setAuthentication(wifiAuthenticationMethod);
        wpaPskSettings.setKeyManagement(wifiKeyManagementEnum);
        wpaPskSettings.setGroupCipher(BWifiEncryptionMethod.toWifiEncryptionMethod((String)supplicantNetBlock.getGroup()));
        wpaPskSettings.setPairwiseCipher(BWifiEncryptionMethod.toWifiEncryptionMethod((String)supplicantNetBlock.getPairwise()));
        wpaPskSettings.setNetworkKey(supplicantNetBlock.getPsk());
        wifiNetwork.setSecurityPolicies(wifiSecurityPolicy);
        wifiNetwork.setSecuritySettings((BWifiSecuritySettings)wpaPskSettings);
        return wifiNetwork;
    }

    public void doSetEnabledStates() {
        boolean editorEnabled;
        boolean readOnly = this.isReadonly();
        boolean actionsEnabled = this.clientModeEnabled && !readOnly;
        boolean bl = editorEnabled = !readOnly;
        if (this.clientConfigPane != null) {
            this.clientConfigPane.setEnabled(editorEnabled);
        }
        if (this.updateGatewayCheckbox != null) {
            this.updateGatewayCheckbox.setEnabled(editorEnabled);
        }
        if (this.titledDiscoveryTable != null) {
            this.titledDiscoveryTable.setEnabled(actionsEnabled);
        }
        if (this.discoveredNetworkTable != null) {
            this.discoveredNetworkTable.setEnabled(actionsEnabled);
        }
        if (this.discoverButtons != null) {
            this.discoverButtons.setEnabled(actionsEnabled);
        }
        if (this.discoverNetworksCommand != null) {
            this.discoverNetworksCommand.setEnabled(actionsEnabled);
        }
        this.doHandleDiscoveredSelectionModified();
        if (this.titledDatabaseTable != null) {
            this.titledDatabaseTable.setEnabled(editorEnabled);
        }
        if (this.databaseNetworkTable != null) {
            this.databaseNetworkTable.setEnabled(editorEnabled);
        }
        if (this.databaseButtons != null) {
            this.databaseButtons.setEnabled(editorEnabled);
        }
        if (this.newNetworkCommand != null) {
            this.newNetworkCommand.setEnabled(editorEnabled);
        }
        this.doHandleDatabaseSelectionModified();
    }

    public void doHandleDiscoveredSelectionModified() {
        if (this.discoveredNetworkTable == null || this.discoveredNetworkTableModel == null || this.addNetworkCommand == null) {
            return;
        }
        boolean editorReadOnly = this.isReadonly();
        int[] rows = this.discoveredNetworkTable.getSelection().getRows();
        if (rows.length != 1) {
            this.addNetworkCommand.setEnabled(false);
            return;
        }
        BImage targetIcon = this.discoveredNetworkTableModel.getNetworkIconImageAt(this.discoveredNetworkTableModel.getSelection().getAnchor());
        this.addNetworkCommand.setEnabled(!editorReadOnly && !targetIcon.equals((Object)UNAVAILABLE_NETWORK_ICON));
    }

    public void doHandleDatabaseSelectionModified() {
        boolean actionsEnabled;
        if (this.databaseNetworkTable == null || this.databaseNetworkTableModel == null || this.editNetworkCommand == null || this.removeNetworkCommand == null || this.connectNetworkCommand == null || this.disconnectNetworkCommand == null || this.supplicantStateLabel == null) {
            return;
        }
        int[] rows = this.databaseNetworkTable.getSelection().getRows();
        if (rows.length != 1) {
            this.editNetworkCommand.setEnabled(false);
            this.removeNetworkCommand.setEnabled(false);
            this.connectNetworkCommand.setEnabled(false);
            this.disconnectNetworkCommand.setEnabled(false);
            return;
        }
        boolean editorReadOnly = this.isReadonly();
        this.editNetworkCommand.setEnabled(!editorReadOnly);
        this.removeNetworkCommand.setEnabled(!editorReadOnly);
        boolean bl = actionsEnabled = this.clientModeEnabled && !editorReadOnly;
        if (!actionsEnabled) {
            this.connectNetworkCommand.setEnabled(false);
            this.disconnectNetworkCommand.setEnabled(false);
            return;
        }
        BWifiNetwork selectedNetwork = this.databaseNetworkTableModel.getNetworkAt(this.databaseNetworkTableModel.getSelection().getAnchor());
        BWifiNetworkStateEnum selectedState = selectedNetwork.getNetworkState();
        if (selectedState == BWifiNetworkStateEnum.disconnected || selectedState == BWifiNetworkStateEnum.disconnecting) {
            this.connectNetworkCommand.setEnabled(true);
            this.disconnectNetworkCommand.setEnabled(false);
        } else if (selectedState == BWifiNetworkStateEnum.connected || selectedState == BWifiNetworkStateEnum.connecting) {
            this.connectNetworkCommand.setEnabled(false);
            this.disconnectNetworkCommand.setEnabled(true);
        } else {
            this.connectNetworkCommand.setEnabled(this.supplicantStateLabel.getText().equals(BWifiSupplicantStateEnum.disconnected.getDisplayTag(null)));
            this.disconnectNetworkCommand.setEnabled(this.supplicantStateLabel.getText().equals(BWifiSupplicantStateEnum.completed.getDisplayTag(null)));
        }
    }

    public void doHandleDiscoveredFocusModified(BFocusEvent event) {
        if (this.discoveredNetworkTable == null) {
            return;
        }
        if (event.getId() == 1005) {
            this.discoveredNetworkTable.getSelection().deselectAll();
            this.doSetEnabledStates();
        }
    }

    public void doHandleDatabaseFocusModified(BFocusEvent event) {
        if (this.databaseNetworkTable == null) {
            return;
        }
        if (event.getId() == 1005) {
            this.databaseNetworkTable.getSelection().deselectAll();
            this.doSetEnabledStates();
        }
    }

    public void doGatewaySwitchingModified() {
        if (this.updateGatewayCheckbox == null || this.daemonSession == null) {
            return;
        }
        if (this.isReadonly()) {
            return;
        }
        boolean switchingModified = this.updateGatewayCheckbox.getSelected();
        if (this.wifiSettings != null) {
            this.wifiSettings.setStaSwitchDefaultGateway(switchingModified);
        }
        try {
            this.daemonSession.sendMessage((DaemonMessage)new SetGatewaySwitchingMessage(WifiUtil.getWiFiServletType((BDaemonSession)this.daemonSession), switchingModified));
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this, (String)LEX.getText("WifiNetworksManager.settings.updateGateway.error.title"), (Object)LEX.getText("WifiNetworksManager.settings.updateGateway.error.message"), (Throwable)exception);
        }
    }

    private void saveParent() throws Exception {
        BWifiNetworksManager ancestor = this;
        BasicContext saveContext = new BasicContext((Context)null, SAVE_FACETS);
        while ((ancestor = ancestor.getParent()) != null) {
            if (!(ancestor instanceof BWbComponentView)) continue;
            BWbComponentView plugin = ancestor;
            plugin.saveValue((Context)saveContext);
            return;
        }
        throw new CannotSaveException(LEX.getText("WifiNetworksManager.saveError.noParent"));
    }

    private static class WifiNetworkCellRenderer
    extends TableCellRenderer {
        private WifiNetworkCellRenderer() {
        }

        private WifiNetworkTableModel getWifiNetworkTableModel() {
            return (WifiNetworkTableModel)this.getTable().getModel();
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            String s = this.getCellText(cell);
            BImage cellIcon = this.getWifiNetworkTableModel().getCellIcon(cell.row, cell.column);
            double textWidth = 5.0;
            double iconWidth = 0.0;
            if (s != null && !s.isEmpty()) {
                textWidth = Theme.table().getCellFont().width(s) + 12.0;
            }
            if (cellIcon != null) {
                iconWidth = cellIcon.getWidth() + 4.0;
            }
            return iconWidth + textWidth;
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            String s;
            WifiNetworkTableModel model = this.getWifiNetworkTableModel();
            this.paintCellBackground(g, cell);
            double x = 2.0;
            double y = (cell.height - 16.0) / 2.0;
            BImage icon = model.getCellIcon(cell.row, cell.column);
            if (icon != null) {
                g.drawImage(icon, x, y);
                x += 20.0;
            }
            if ((s = this.getCellText(cell)) != null && !s.isEmpty()) {
                BFont font = Theme.table().getCellFont();
                switch (model.getColumnAlignment(cell.column).getOrdinal()) {
                    case 2: {
                        x = cell.width - 2.0 - font.width(s);
                        break;
                    }
                    case 1: {
                        x = (cell.width - font.width(s)) / 2.0;
                    }
                }
                g.setFont(font);
                g.drawString(s, x, font.getAscent() + 5.0);
            }
        }
    }

    protected static class WifiNetworkTableRow {
        private BWifiNetwork network;
        private BImage rowNetworkIcon;
        private int databaseIndex;

        private WifiNetworkTableRow() {
        }

        private void setNetwork(BWifiNetwork value) {
            this.network = value;
        }

        private BWifiNetwork getCurrentWifiNetwork() {
            return this.network;
        }

        private String getSSID() {
            return this.network.getSsid();
        }

        private String getBSSID() {
            return this.network.getBssid();
        }

        private BWifiNetworkMode getMode() {
            return this.network.getMode();
        }

        private BInteger getChannel() {
            return BInteger.make((int)this.network.getChannel());
        }

        private BWifiSecurityPolicy getSecurityPolicy() {
            return this.network.getSecurityPolicies();
        }

        private BWifiNetworkStateEnum getNetworkState() {
            return this.network.getNetworkState();
        }

        private BInteger getSignalStrengthPercentage() {
            return BInteger.make((int)this.network.getSignalStrength());
        }

        private String getFlags() {
            return this.network.getScanResultFlags();
        }

        private BInteger getPriority() {
            return BInteger.make((int)this.network.getPriority());
        }

        private void setStatus(BWifiNetworkStateEnum temp) {
            this.network.setNetworkState(temp);
        }

        private BImage getSignalStrengthImage() {
            int strength = this.getSignalStrengthPercentage().getInt();
            if (strength >= 80) {
                return BImage.make((BIcon)BIcon.std((String)"fiveBars.png"));
            }
            if (strength >= 60) {
                return BImage.make((BIcon)BIcon.std((String)"fourBars.png"));
            }
            if (strength >= 40) {
                return BImage.make((BIcon)BIcon.std((String)"threeBars.png"));
            }
            if (strength >= 20) {
                return BImage.make((BIcon)BIcon.std((String)"twoBars.png"));
            }
            if (strength > 0) {
                return BImage.make((BIcon)BIcon.std((String)"oneBar.png"));
            }
            return BImage.make((BIcon)BIcon.std((String)"zeroBars.png"));
        }

        private void setNetworkIcon(BImage newIcon) {
            this.rowNetworkIcon = newIcon;
        }

        private BImage getNetworkIcon() {
            return this.rowNetworkIcon;
        }

        private void setDatabaseIndex(int newIndex) {
            this.databaseIndex = newIndex;
        }

        private int getDatabaseIndex() {
            return this.databaseIndex;
        }

        private int compareStatus(WifiNetworkTableRow row) {
            BWifiNetworkStateEnum LHSRowStatus = this.getNetworkState();
            BWifiNetworkStateEnum RHSRowStatus = row.getNetworkState();
            return Integer.compare(RHSRowStatus.getOrdinal(), LHSRowStatus.getOrdinal());
        }

        private int compareSecurity(WifiNetworkTableRow row) {
            BWifiSecurityPolicy LHSRowSecurity = this.getSecurityPolicy();
            BWifiSecurityPolicy RHSRowSecurity = row.getSecurityPolicy();
            if (LHSRowSecurity.getOrdinal() == RHSRowSecurity.getOrdinal()) {
                return 0;
            }
            if (LHSRowSecurity.equals((Object)BWifiSecurityPolicy.wpa_2_psk)) {
                if (RHSRowSecurity.equals((Object)BWifiSecurityPolicy.wpa_psk)) {
                    return -1;
                }
                if (RHSRowSecurity.equals((Object)BWifiSecurityPolicy.wpapsk_wpa2psk)) {
                    return -1;
                }
            }
            if (LHSRowSecurity.equals((Object)BWifiSecurityPolicy.wpapsk_wpa2psk)) {
                if (RHSRowSecurity.equals((Object)BWifiSecurityPolicy.wpa_2_psk)) {
                    return 1;
                }
                if (RHSRowSecurity.equals((Object)BWifiSecurityPolicy.wpa_psk)) {
                    return -1;
                }
            }
            return 1;
        }
    }

    private class DatabaseTableController
    extends TableController {
        private DatabaseTableController() {
        }

        protected void cellPressed(BMouseEvent event, int row, int column) {
            if (event.isPopupTrigger()) {
                super.cellPressed(event, row, column);
                return;
            }
            if (column != 0 || event.getX() > 14.0) {
                if (event.getClickCount() > 1) {
                    if (BWifiNetworksManager.this.editNetworkCommand.isEnabled()) {
                        BWifiNetworksManager.this.editNetworkCommand.invoke();
                    }
                } else {
                    super.cellPressed(event, row, column);
                }
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            BMenu menu = new BMenu();
            menu.add(null, (BValue)new BActionMenuItem((Command)BWifiNetworksManager.this.editNetworkCommand), null);
            menu.add(null, (BValue)new BActionMenuItem((Command)BWifiNetworksManager.this.removeNetworkCommand), null);
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (BValue)new BActionMenuItem((Command)BWifiNetworksManager.this.disconnectNetworkCommand), null);
            menu.open((BWidget)BWifiNetworksManager.this.databaseNetworkTable, event.getX(), event.getY());
        }
    }

    private class DiscoveryTableController
    extends TableController {
        private DiscoveryTableController() {
        }

        protected void cellPressed(BMouseEvent event, int row, int column) {
            if (event.isPopupTrigger()) {
                super.cellPressed(event, row, column);
                return;
            }
            if (column != 0 || event.getX() > 14.0) {
                if (event.getClickCount() > 1) {
                    if (BWifiNetworksManager.this.addNetworkCommand.isEnabled()) {
                        BWifiNetworksManager.this.addNetworkCommand.invoke();
                    }
                } else {
                    super.cellPressed(event, row, column);
                }
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            BMenu menu = new BMenu();
            menu.add(null, (BValue)new BActionMenuItem((Command)BWifiNetworksManager.this.addNetworkCommand), null);
            menu.open((BWidget)BWifiNetworksManager.this.discoveredNetworkTable, event.getX(), event.getY());
        }
    }

    private static class WifiNetworkTableModel
    extends TableModel {
        private static final int SSID_COL = 0;
        private static final int BSSID_COL = 1;
        private static final int MODE_COL = 2;
        private static final int STATUS_COL = 3;
        private static final int SIGNAL_STRENGTH_PER_COL = 4;
        private static final int PRIORITY_COL = 5;
        private static final int CHANNEL_COL = 6;
        private static final int SECURITY_POLICY_COL = 7;
        private static final int FLAGS_COL = 8;
        private boolean sortAscending = true;
        private boolean needsSort = true;
        private int sortColumn;
        protected Array<BInteger> viewableColumns;
        protected Array<WifiNetworkTableRow> rows = new Array(WifiNetworkTableRow.class);

        protected WifiNetworkTableModel(boolean showBSSID, boolean showMode, boolean showPriority, boolean showChannel, boolean showStatus, boolean showPolicy, boolean showSignal, boolean showFlags) {
            this.viewableColumns = new Array(BInteger.class);
            this.viewableColumns.add((Object)BInteger.make((int)0));
            if (showBSSID) {
                this.viewableColumns.add((Object)BInteger.make((int)1));
            }
            if (showMode) {
                this.viewableColumns.add((Object)BInteger.make((int)2));
            }
            if (showPriority) {
                this.viewableColumns.add((Object)BInteger.make((int)5));
            }
            if (showChannel) {
                this.viewableColumns.add((Object)BInteger.make((int)6));
            }
            if (showPolicy) {
                this.viewableColumns.add((Object)BInteger.make((int)7));
            }
            if (showStatus) {
                this.viewableColumns.add((Object)BInteger.make((int)3));
            }
            if (showSignal) {
                this.viewableColumns.add((Object)BInteger.make((int)4));
            }
            if (showFlags) {
                this.viewableColumns.add((Object)BInteger.make((int)8));
            }
        }

        public int getColumnCount() {
            return this.viewableColumns.size();
        }

        public String getColumnName(int col) {
            int targetColumn = ((BInteger)this.viewableColumns.get(col)).getInt();
            switch (targetColumn) {
                case 0: {
                    return LEX.getText("WifiNetworksManager.column.SSID.label");
                }
                case 1: {
                    return LEX.getText("WifiNetworksManager.column.BSSID.label");
                }
                case 2: {
                    return LEX.getText("WifiNetworksManager.column.mode.label");
                }
                case 5: {
                    return LEX.getText("WifiNetworksManager.column.priority.label");
                }
                case 6: {
                    return LEX.getText("WifiNetworksManager.column.channel.label");
                }
                case 7: {
                    return LEX.getText("WifiNetworksManager.column.security.label");
                }
                case 3: {
                    return LEX.getText("WifiNetworksManager.column.status.label");
                }
                case 4: {
                    return LEX.getText("WifiNetworksManager.column.signalPercent.label");
                }
                case 8: {
                    return LEX.getText("WifiNetworksManager.column.flags.label");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getValueAt(int row, int col) {
            int targetColumn = ((BInteger)this.viewableColumns.get(col)).getInt();
            switch (targetColumn) {
                case 0: {
                    return this.getRow(row).getSSID();
                }
                case 1: {
                    return this.getRow(row).getBSSID();
                }
                case 2: {
                    return this.getRow(row).getMode().getDisplayTag(null);
                }
                case 5: {
                    return this.getRow(row).getPriority();
                }
                case 6: {
                    return this.getRow(row).getChannel();
                }
                case 7: {
                    BWifiSecurityPolicy policy = this.getRow(row).getSecurityPolicy();
                    return policy.getDisplayTag(null);
                }
                case 3: {
                    return this.getRow(row).getNetworkState();
                }
                case 4: {
                    return this.getRow(row).getSignalStrengthPercentage();
                }
                case 8: {
                    return this.getRow(row).getFlags();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void clear() {
            this.rows.clear();
            this.updateValues(false);
        }

        public void updateTable(boolean resizeColumns) {
            this.needsSort = true;
            super.updateTable(resizeColumns);
        }

        public void sortByColumn(int col, boolean ascending) {
            int targetColumn = ((BInteger)this.viewableColumns.get(col)).getInt();
            if (!this.needsSort && targetColumn == this.sortColumn && ascending == this.sortAscending) {
                return;
            }
            this.sortColumn = targetColumn;
            this.sortAscending = ascending;
            this.updateValues(true);
        }

        protected void updateValues(boolean resort) {
            this.needsSort = false;
            if (resort) {
                int defaultColumn = this.viewableColumns.contains((Object)BInteger.make((int)3)) ? 3 : 4;
                this.rows = this.rows.sort((Comparator)new WifiNetworkTableRowComparator(defaultColumn));
            }
            this.getTable().getSelection().deselectAll();
            this.updateTable(true);
        }

        private void setNetwork(BWifiNetwork network, int id) {
            WifiNetworkTableRow updatedRow = this.makeRow();
            WifiNetworkTableRow existingRow = this.getRow(id);
            updatedRow.setNetwork(network);
            updatedRow.setNetworkIcon(existingRow.getNetworkIcon());
            updatedRow.setDatabaseIndex(existingRow.getDatabaseIndex());
            this.rows.set(id, (Object)updatedRow);
        }

        private void addNetwork(BWifiNetwork network, BImage rowNetworkIcon) {
            if (network == null || network.isNull()) {
                return;
            }
            WifiNetworkTableRow row = this.makeRow();
            row.setNetwork(network);
            row.setNetworkIcon(rowNetworkIcon);
            row.setDatabaseIndex(this.rows.size());
            this.rows.add((Object)row);
        }

        private void removeNetwork(String ssid) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.getSSIDAt(i).equals(ssid)) continue;
                this.rows.remove(i);
            }
        }

        private WifiNetworkTableRow makeRow() {
            return new WifiNetworkTableRow();
        }

        private WifiNetworkTableRow getRow(int row) {
            return (WifiNetworkTableRow)this.rows.get(row);
        }

        private BWifiNetwork getNetworkAt(int row) {
            return this.getRow(row).getCurrentWifiNetwork();
        }

        private BSupplicantNetBlock getNetBlockAt(int row) {
            return BSupplicantNetBlock.make((BWifiNetwork)this.getRow(row).getCurrentWifiNetwork());
        }

        private String getSSIDAt(int row) {
            return this.getRow(row).getSSID();
        }

        private int getRowForSsid(String ssid) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.getSSIDAt(i).equals(ssid)) continue;
                return i;
            }
            return -1;
        }

        private BImage getNetworkIconImageAt(int row) {
            return this.getRow(row).getNetworkIcon();
        }

        private void setNetworkIconImageAt(int row, BImage newIcon) {
            this.getRow(row).setNetworkIcon(newIcon);
        }

        private BWifiNetworkStateEnum getStatusAt(int row) {
            return this.getRow(row).getNetworkState();
        }

        private void setStatusAt(int row, BWifiNetworkStateEnum temp) {
            this.getRow(row).setStatus(temp);
        }

        private BImage getCellIcon(int row, int col) {
            int targetColumn = ((BInteger)this.viewableColumns.get(col)).getInt();
            WifiNetworkTableRow rowObject = this.getRow(row);
            if (targetColumn == 0) {
                return rowObject.getNetworkIcon();
            }
            if (targetColumn == 4) {
                return rowObject.getSignalStrengthImage();
            }
            return null;
        }

        private class WifiNetworkTableRowComparator
        implements Comparator<WifiNetworkTableRow> {
            private final WifiNetworkColumnComparator[] comparators;

            private WifiNetworkTableRowComparator(int defaultColumn) {
                int i;
                int next;
                int[] sortColumns = new int[9];
                sortColumns[0] = WifiNetworkTableModel.this.sortColumn;
                if (WifiNetworkTableModel.this.sortColumn != defaultColumn) {
                    sortColumns[1] = defaultColumn;
                    next = 2;
                    for (i = 0; i < sortColumns.length; ++i) {
                        if (i == WifiNetworkTableModel.this.sortColumn || i == defaultColumn) continue;
                        sortColumns[next++] = i;
                    }
                } else if (defaultColumn == 3) {
                    sortColumns[1] = 4;
                    next = 2;
                    for (i = 0; i < sortColumns.length; ++i) {
                        if (i == WifiNetworkTableModel.this.sortColumn || i == 4) continue;
                        sortColumns[next++] = i;
                    }
                } else {
                    next = 1;
                    for (i = 0; i < sortColumns.length; ++i) {
                        if (i == WifiNetworkTableModel.this.sortColumn) continue;
                        sortColumns[next++] = i;
                    }
                }
                this.comparators = new WifiNetworkColumnComparator[8];
                for (int i2 = 0; i2 < this.comparators.length; ++i2) {
                    this.comparators[i2] = new WifiNetworkColumnComparator(sortColumns[i2], WifiNetworkTableModel.this.sortAscending);
                }
            }

            @Override
            public int compare(WifiNetworkTableRow row1, WifiNetworkTableRow row2) {
                int result = 0;
                for (int i = 0; i < this.comparators.length && result == 0; ++i) {
                    result = this.comparators[i].compare(row1, row2);
                }
                return result;
            }
        }

        private static class WifiNetworkColumnComparator
        implements Comparator<WifiNetworkTableRow> {
            private final int comparatorSortColumn;
            private final boolean comparatorAscending;

            private WifiNetworkColumnComparator(int comparatorSortColumn, boolean comparatorAscending) {
                this.comparatorSortColumn = comparatorSortColumn;
                this.comparatorAscending = comparatorAscending;
            }

            @Override
            public int compare(WifiNetworkTableRow row1, WifiNetworkTableRow row2) {
                int sortDirection = this.comparatorAscending ? 1 : -1;
                switch (this.comparatorSortColumn) {
                    case 0: 
                    case 8: {
                        return sortDirection * TextUtil.toLowerCase((String)row1.getSSID()).compareTo(TextUtil.toLowerCase((String)row2.getSSID()));
                    }
                    case 1: {
                        return sortDirection * TextUtil.toLowerCase((String)row1.getBSSID()).compareTo(TextUtil.toLowerCase((String)row2.getBSSID()));
                    }
                    case 2: {
                        if (row1.getMode().getOrdinal() < row2.getMode().getOrdinal()) {
                            return sortDirection * -1;
                        }
                        if (row1.getMode().getOrdinal() > row2.getMode().getOrdinal()) {
                            return sortDirection;
                        }
                        return 0;
                    }
                    case 5: {
                        if (row1.getPriority() == null) {
                            if (row2.getPriority() == null) {
                                return 0;
                            }
                            return sortDirection;
                        }
                        if (row2.getPriority() == null) {
                            return sortDirection * -1;
                        }
                        return sortDirection * row1.getPriority().compareTo((Object)row2.getPriority());
                    }
                    case 6: {
                        if (row1.getChannel() == null) {
                            if (row2.getChannel() == null) {
                                return 0;
                            }
                            return sortDirection;
                        }
                        if (row2.getChannel() == null) {
                            return sortDirection * -1;
                        }
                        return sortDirection * row1.getChannel().compareTo((Object)row2.getChannel());
                    }
                    case 7: {
                        return sortDirection * row1.compareSecurity(row2);
                    }
                    case 3: {
                        return sortDirection * row1.compareStatus(row2);
                    }
                    case 4: {
                        sortDirection = -sortDirection;
                        if (row1.getSignalStrengthPercentage() == null) {
                            if (row2.getSignalStrengthPercentage() == null) {
                                return 0;
                            }
                            return sortDirection;
                        }
                        if (row2.getSignalStrengthPercentage() == null) {
                            return sortDirection * -1;
                        }
                        return sortDirection * row1.getSignalStrengthPercentage().compareTo((Object)row2.getSignalStrengthPercentage());
                    }
                }
                throw new IllegalArgumentException();
            }
        }
    }

    private class RemoveCommand
    extends Command {
        private RemoveCommand() {
            super((BWidget)BWifiNetworksManager.this, LEX.getText("WifiNetworksManager.remove.label"), REMOVE_ICON, null, LEX.getText("WifiNetworksManager.remove.description"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() {
            block14: {
                BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
                try {
                    BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                    this.setEnabled(false);
                    if (shell != null) {
                        shell.enterBusy();
                    }
                    if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount() == 0) {
                        CommandArtifact commandArtifact = null;
                        return commandArtifact;
                    }
                    if (BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getRowCount() > 1) {
                        CommandArtifact commandArtifact = null;
                        return commandArtifact;
                    }
                    BWifiNetwork networkToRemove = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
                    String message = LEX.getText("WifiNetworksManager.remove.confirmSingle", new Object[]{networkToRemove.getSsid()});
                    int result = BDialog.confirm((BWidget)this.getOwner(), (Object)message);
                    if (result == 4) {
                        BWifiNetworksManager.this.disconnectNetworkCommand.doInvoke();
                        BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                        BWifiNetworksManager.this.databaseNetworkTableModel.removeNetwork(networkToRemove.getSsid());
                        BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
                        BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                        BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                        if (BWifiNetworksManager.this.currentNetwork != null && networkToRemove.getSsid().equals(BWifiNetworksManager.this.currentNetwork.getSsid())) {
                            BWifiNetworksManager.this.currentNetwork = null;
                        }
                        for (int i = 0; i < BWifiNetworksManager.this.discoveredNetworkTableModel.getRowCount(); ++i) {
                            if (!BWifiNetworksManager.this.discoveredNetworkTableModel.getSSIDAt(i).equalsIgnoreCase(networkToRemove.getSsid())) continue;
                            BWifiNetwork target = BWifiNetworksManager.this.discoveredNetworkTableModel.getNetworkAt(i);
                            BWifiNetworksManager.this.discoveredNetworkTableModel.setNetworkIconImageAt(i, target.isNetworkSupported() ? SECURED_NETWORK_ICON : UNSECURED_NETWORK_ICON);
                            break;
                        }
                        BWifiNetworksManager.this.saveParent();
                        break block14;
                    }
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                catch (Throwable throwable) {
                    CommandUtil.error((Command)this, (BWidget)this.getOwner(), (Throwable)throwable);
                }
                finally {
                    BWifiNetworksManager.this.databaseButtons.setEnabled(true);
                    if (shell != null) {
                        shell.exitBusy();
                    }
                }
            }
            return null;
        }
    }

    private class NewCommand
    extends Command {
        private NewCommand() {
            super((BWidget)BWifiNetworksManager.this, LEX.getText("WifiNetworksManager.new.label"), NEW_ICON, null, LEX.getText("WifiNetworksManager.new.description"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                BWifiNetwork newNetwork;
                BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                this.setEnabled(false);
                if (shell != null) {
                    shell.enterBusy();
                }
                try {
                    newNetwork = this.promptNew();
                    if (newNetwork == null) {
                        CommandArtifact commandArtifact = null;
                        return commandArtifact;
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, LEX.getText("WifiNetworksManager.new.error"), exception);
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                for (int i = 0; i < BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount(); ++i) {
                    if (!BWifiNetworksManager.this.databaseNetworkTableModel.getSSIDAt(i).equals(newNetwork.getSsid())) continue;
                    BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)LEX.getText("WifiNetworkConfigurationEditor.cannotSave.duplicateSSID", new Object[]{newNetwork.getSsid()}));
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                boolean securityConfigured = false;
                SlotCursor c = newNetwork.getSecuritySettings().loadSlots().getProperties();
                if (c.next(BWifiSecuritySettings.class)) {
                    securityConfigured = true;
                }
                BWifiNetworksManager.this.databaseNetworkTableModel.addNetwork(newNetwork, securityConfigured ? SECURED_NETWORK_ICON : UNSECURED_NETWORK_ICON);
                BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
                BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                for (int i = 0; i < BWifiNetworksManager.this.discoveredNetworkTableModel.getRowCount(); ++i) {
                    if (!BWifiNetworksManager.this.discoveredNetworkTableModel.getSSIDAt(i).equalsIgnoreCase(newNetwork.getSsid())) continue;
                    BWifiNetworksManager.this.discoveredNetworkTableModel.setNetworkIconImageAt(i, UNAVAILABLE_NETWORK_ICON);
                    break;
                }
                BWifiNetworksManager.this.saveParent();
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (BWidget)this.getOwner(), (Throwable)throwable);
            }
            finally {
                BWifiNetworksManager.this.databaseButtons.setEnabled(true);
                this.setEnabled(true);
                if (shell != null) {
                    shell.exitBusy();
                }
            }
            return null;
        }

        public BWifiNetwork promptNew() {
            BWifiNetwork newNetwork = new BWifiNetwork();
            newNetwork.setSsid("");
            newNetwork.setBssid("00:00:00:00:00:00");
            newNetwork.setChannel(6);
            newNetwork.setPriority(0);
            newNetwork.setSsidBroadcasted(true);
            newNetwork.setMode(BWifiNetworkMode.managed);
            newNetwork.setProtocols(BWifiProtocol.rsn);
            newNetwork.setSecurityPolicies(BWifiSecurityPolicy.wpa_2_psk);
            BWifiWPAPSKSettings wifiWPAPSKSettings = new BWifiWPAPSKSettings();
            wifiWPAPSKSettings.setKeyManagement(BWifiKeyManagementEnum.wpaPsk);
            wifiWPAPSKSettings.setAuthentication(BWifiAuthenticationMethod.open);
            wifiWPAPSKSettings.setNetworkKey(BPassword.make((String)"passphrase"));
            wifiWPAPSKSettings.setGroupCipher(BWifiEncryptionMethod.ccmp);
            wifiWPAPSKSettings.setPairwiseCipher(BWifiEncryptionMethod.ccmp);
            newNetwork.setSecuritySettings((BWifiSecuritySettings)wifiWPAPSKSettings);
            String title = LEX.getText("WifiNetworkConfigurationEditor.new.title");
            BWifiNetworkEditorDialog dialog = new BWifiNetworkEditorDialog(this.getOwner(), title, 1, newNetwork);
            dialog.setBoundsCenteredOnOwner();
            dialog.requestFocus();
            dialog.open();
            if (dialog.getResult() != 1) {
                return null;
            }
            try {
                return dialog.getNetwork();
            }
            catch (Exception exception) {
                BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)LEX.getText("WifiNetworkConfigurationEditor.cannotSave.error"), (Throwable)exception);
                return null;
            }
        }
    }

    private class EditCommand
    extends Command {
        private EditCommand() {
            super((BWidget)BWifiNetworksManager.this, LEX.getText("WifiNetworksManager.edit.label"), EDIT_ICON, null, LEX.getText("WifiNetworksManager.edit.description"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BWifiNetwork editedNetwork;
            if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount() == 0) {
                return null;
            }
            try {
                editedNetwork = this.promptEdit();
                if (editedNetwork == null) {
                    return null;
                }
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, LEX.getText("WifiNetworksManager.edit.error"), exception);
                return null;
            }
            editedNetwork.setMode(BWifiNetworkMode.managed);
            BWifiNetworksManager.this.databaseNetworkTableModel.setNetwork(editedNetwork, BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
            BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
            BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
            BWifiNetworksManager.this.saveParent();
            return null;
        }

        private BWifiNetwork promptEdit() {
            BWifiNetwork networkToEdit = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
            String title = LEX.getText("WifiNetworkConfigurationEditor.edit.title");
            BWifiNetworkEditorDialog dialog = new BWifiNetworkEditorDialog(this.getOwner(), title, 0, networkToEdit);
            dialog.setBoundsCenteredOnOwner();
            dialog.requestFocus();
            dialog.open();
            if (dialog.getResult() != 1) {
                return null;
            }
            int lines = BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount();
            String ssid = dialog.getNetwork().getSsid();
            for (int i = 0; i < lines; ++i) {
                BWifiNetwork network = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(i);
                if (i == BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor() || !network.getSsid().equals(ssid)) continue;
                BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("WifiNetworkConfigurationEditor.duplicateError.title"), (Object)LEX.getText("WifiNetworkConfigurationEditor.duplicateError.message"));
                return networkToEdit;
            }
            try {
                return dialog.getNetwork();
            }
            catch (Exception exception) {
                BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)LEX.getText("WifiNetworkConfigurationEditor.cannotSave.error"), (Throwable)exception);
                return networkToEdit;
            }
        }
    }

    private class DisconnectCommand
    extends Command {
        private DisconnectCommand() {
            super((BWidget)BWifiNetworksManager.this, LEX.getText("WifiNetworksManager.disconnect.label"), DISCONNECT_ICON, null, LEX.getText("WifiNetworksManager.disconnect.description"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                BWifiNetworksManager.this.lockModifiedState();
                BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                BWifiNetworksManager.this.editNetworkCommand.setEnabled(false);
                BWifiNetworksManager.this.removeNetworkCommand.setEnabled(false);
                this.setEnabled(false);
                if (shell != null) {
                    shell.enterBusy();
                }
                if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount() == 0) {
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                if (!BWifiNetworksManager.this.clientModeEnabled) {
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                BWifiNetwork toDisconnect = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
                if (toDisconnect.getNetworkState() != BWifiNetworkStateEnum.connected && toDisconnect.getNetworkState() != BWifiNetworkStateEnum.connecting) {
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                if (BWifiNetworksManager.this.daemonSession == null) {
                    throw new IllegalArgumentException("Could not find Wi-Fi daemon session");
                }
                if (!WifiUtil.disconnectFromSession((String)BWifiNetworksManager.this.clientAdapterLabel.getText(), (BDaemonSession)BWifiNetworksManager.this.daemonSession)) {
                    throw new BajaRuntimeException("Failed to disconnect from selected Wi-Fi network (" + toDisconnect.getSsid() + ")");
                }
                toDisconnect.setNetworkState(BWifiNetworkStateEnum.disconnecting);
                if (BWifiNetworksManager.this.databaseNetworkTableModel.getStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor()) != BWifiNetworkStateEnum.disabled) {
                    BWifiNetworksManager.this.databaseNetworkTableModel.setStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor(), BWifiNetworkStateEnum.disconnecting);
                }
                if (BWifiNetworksManager.this.currentNetwork != null && BWifiNetworksManager.this.currentNetwork.getSsid().equalsIgnoreCase(toDisconnect.getSsid())) {
                    if (BWifiNetworksManager.this.currentNetwork.getNetworkState() != BWifiNetworkStateEnum.disabled) {
                        BWifiNetworksManager.this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.disconnected);
                    }
                    BWifiNetworksManager.this.currentNetwork = null;
                    BWifiNetworksManager.this.supplicantStateLabel.setText(BWifiSupplicantStateEnum.disconnected.getDisplayTag(null));
                }
                if (BWifiNetworksManager.this.databaseNetworkTableModel.getStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor()) != BWifiNetworkStateEnum.disabled) {
                    BWifiNetworksManager.this.databaseNetworkTableModel.setStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor(), BWifiNetworkStateEnum.disconnected);
                }
                BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
                BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (BWidget)this.getOwner(), (Throwable)throwable);
            }
            finally {
                BWifiNetworksManager.this.unlockModifiedState();
                BWifiNetworksManager.this.databaseButtons.setEnabled(true);
                if (shell != null) {
                    shell.exitBusy();
                }
            }
            return null;
        }
    }

    private class ConnectCommand
    extends Command {
        private ConnectCommand() {
            super((BWidget)BWifiNetworksManager.this, LEX.getText("WifiNetworksManager.connect.label"), CONNECT_ICON, null, LEX.getText("WifiNetworksManager.connect.description"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                BWifiNetworksManager.this.lockModifiedState();
                BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                BWifiNetworksManager.this.editNetworkCommand.setEnabled(false);
                BWifiNetworksManager.this.removeNetworkCommand.setEnabled(false);
                this.setEnabled(false);
                if (shell != null) {
                    shell.enterBusy();
                }
                if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount() == 0) {
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                if (!BWifiNetworksManager.this.clientModeEnabled) {
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                WifiNetworkTableRow selectedRow = BWifiNetworksManager.this.databaseNetworkTableModel.getRow(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
                BWifiNetwork toConnect = selectedRow.getCurrentWifiNetwork();
                if (toConnect.getNetworkState() == BWifiNetworkStateEnum.connected || toConnect.getNetworkState() == BWifiNetworkStateEnum.connecting) {
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                if (BWifiNetworksManager.this.daemonSession == null) {
                    throw new IllegalArgumentException("Could not find Wi-Fi daemon session");
                }
                String networkId = WiFiServletType.qnxwifi.equals((Object)WifiUtil.getWiFiServletType((BDaemonSession)BWifiNetworksManager.this.daemonSession)) ? String.valueOf(selectedRow.getDatabaseIndex()) : selectedRow.getSSID();
                if (!WifiUtil.connectFromSession((String)BWifiNetworksManager.this.clientAdapterLabel.getText(), (String)networkId, (BDaemonSession)BWifiNetworksManager.this.daemonSession)) {
                    throw new BajaRuntimeException("Failed to connect to selected Wi-Fi network (" + toConnect.getSsid() + ")");
                }
                if (BWifiNetworksManager.this.currentNetwork != null && !BWifiNetworksManager.this.currentNetwork.getSsid().equalsIgnoreCase(toConnect.getSsid())) {
                    BWifiNetworksManager.this.currentNetwork = null;
                }
                if (BWifiNetworksManager.this.currentNetwork == null) {
                    BWifiNetworksManager.this.currentNetwork = toConnect;
                }
                if (BWifiNetworksManager.this.currentNetwork.getNetworkState() != BWifiNetworkStateEnum.connected) {
                    BWifiNetworksManager.this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.connecting);
                }
                BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
                BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (BWidget)this.getOwner(), (Throwable)throwable);
            }
            finally {
                BWifiNetworksManager.this.unlockModifiedState();
                BWifiNetworksManager.this.databaseButtons.setEnabled(true);
                if (shell != null) {
                    shell.exitBusy();
                }
            }
            return null;
        }
    }

    private class AddCommand
    extends Command {
        private AddCommand() {
            super((BWidget)BWifiNetworksManager.this, LEX.getText("WifiNetworksManager.add.label"), ADD_ICON, null, LEX.getText("WifiNetworksManager.add.description"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                BWifiNetworksManager.this.discoverButtons.setEnabled(false);
                this.setEnabled(false);
                if (shell != null) {
                    shell.enterBusy();
                }
                if (BWifiNetworksManager.this.discoveredNetworkTableModel.getRowCount() == 0) {
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                BWifiNetwork addedNetwork = this.promptAdd();
                if (addedNetwork == null) {
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowForSsid(addedNetwork.getSsid()) >= 0) {
                    BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("WifiNetworkConfigurationEditor.duplicateError.title"), (Object)LEX.getText("WifiNetworkConfigurationEditor.duplicateError.message"));
                    CommandArtifact exception = null;
                    return exception;
                }
                for (int i = 0; i < BWifiNetworksManager.this.discoveredNetworkTableModel.getRowCount(); ++i) {
                    if (!BWifiNetworksManager.this.discoveredNetworkTableModel.getSSIDAt(i).equals(addedNetwork.getSsid())) continue;
                    BWifiNetworksManager.this.discoveredNetworkTableModel.setNetworkIconImageAt(i, UNAVAILABLE_NETWORK_ICON);
                }
                BWifiNetworksManager.this.discoveredNetworkTableModel.updateValues(false);
                BWifiNetworksManager.this.databaseNetworkTableModel.addNetwork(addedNetwork, addedNetwork.isNetworkSupported() ? SECURED_NETWORK_ICON : UNSECURED_NETWORK_ICON);
                BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
                BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                BWifiNetworksManager.this.saveParent();
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (BWidget)this.getOwner(), (Throwable)throwable);
            }
            finally {
                BWifiNetworksManager.this.discoverButtons.setEnabled(true);
                this.setEnabled(true);
                if (shell != null) {
                    shell.exitBusy();
                }
            }
            return null;
        }

        public BWifiNetwork promptAdd() {
            BWifiNetwork networkToAdd = (BWifiNetwork)BWifiNetworksManager.this.discoveredNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.discoveredNetworkTableModel.getSelection().getAnchor()).newCopy(true);
            if (!networkToAdd.isNetworkSupported()) {
                BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("WifiNetworkConfigurationEditor.errorAdd.title"), (Object)LEX.getText("WifiNetworkConfigurationEditor.errorAdd.message", new Object[]{networkToAdd.getSsid()}));
                return null;
            }
            String title = LEX.getText("WifiNetworkConfigurationEditor.add.title");
            BWifiNetworkEditorDialog dialog = new BWifiNetworkEditorDialog(this.getOwner(), title, 2, networkToAdd);
            dialog.setBoundsCenteredOnOwner();
            dialog.requestFocus();
            dialog.open();
            if (dialog.getResult() != 1) {
                return null;
            }
            try {
                return dialog.getNetwork();
            }
            catch (Exception exception) {
                BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)LEX.getText("WifiNetworkConfigurationEditor.cannotSave.error"), (Throwable)exception);
                return null;
            }
        }
    }

    private static class DiscoverThread
    extends Thread {
        private BWifiNetworkVector result;
        private final BDaemonSession sessionToPoll;
        private final String adapter;

        private DiscoverThread(String adapter, BDaemonSession sessionToPoll) {
            this.adapter = adapter;
            this.sessionToPoll = sessionToPoll;
        }

        private BWifiNetworkVector getResults() {
            return this.result;
        }

        @Override
        public void run() {
            try {
                this.result = WifiUtil.discoverFromSession((String)this.adapter, (BDaemonSession)this.sessionToPoll, (long)8000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class DiscoverCommand
    extends AsyncCommand {
        private DiscoverCommand() {
            super((BWidget)BWifiNetworksManager.this, LEX.getText("WifiNetworksManager.discover.label"), DISCOVER_ICON, null, LEX.getText("WifiNetworksManager.discover.description"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                BWifiNetworksManager.this.lockModifiedState();
                BWifiNetworksManager.this.discoverButtons.setEnabled(false);
                this.setEnabled(false);
                BDiscoverPreferences discoverPreferences = new BDiscoverPreferences();
                String title = LEX.getText("WifiNetworksManager.networkDiscover.title");
                BWifiDiscoverDialog dialog = new BWifiDiscoverDialog(this.getOwner(), title, discoverPreferences);
                dialog.setBoundsCenteredOnOwner();
                dialog.requestFocus();
                dialog.open();
                if (dialog.getResult() != 1) {
                    return;
                }
                if (shell != null) {
                    shell.enterBusy();
                }
                if (BWifiNetworksManager.this.daemonSession == null) {
                    throw new IllegalArgumentException("Could not find Wi-Fi daemon session");
                }
                BWifiNetworksManager.this.discoveredNetworkTableModel.clear();
                DiscoverThread myDiscoverTaskThread = new DiscoverThread(BWifiNetworksManager.this.clientAdapterLabel.getText(), BWifiNetworksManager.this.daemonSession);
                myDiscoverTaskThread.start();
                int stopCount = 0;
                int STOP_SEC = 15;
                while (myDiscoverTaskThread.isAlive() && ++stopCount < STOP_SEC) {
                    Thread.sleep(1000L);
                }
                BWifiNetworkVector result = null;
                if (stopCount == STOP_SEC) {
                    LOG.severe("Wi-Fi discovery task is taking excessive time, terminating task");
                    myDiscoverTaskThread.interrupt();
                    myDiscoverTaskThread.join(2000L);
                } else {
                    result = myDiscoverTaskThread.getResults();
                }
                if (result != null) {
                    for (int idx = 0; idx < BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount(); ++idx) {
                        BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(idx).setSignalStrength(0);
                    }
                    SlotCursor c = result.loadSlots().getProperties();
                    while (c.next(BWifiNetwork.class)) {
                        BWifiNetwork discoveredNetwork = (BWifiNetwork)c.get();
                        boolean foundInDatabase = false;
                        for (int idx = 0; idx < BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount(); ++idx) {
                            if (!BWifiNetworksManager.this.databaseNetworkTableModel.getSSIDAt(idx).equals(discoveredNetwork.getSsid())) continue;
                            foundInDatabase = true;
                            BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(idx).setSignalStrength(discoveredNetwork.getSignalStrength());
                            break;
                        }
                        this.icon = foundInDatabase || discoveredNetwork.getNetworkState() == BWifiNetworkStateEnum.disabled ? UNAVAILABLE_NETWORK_ICON : (discoveredNetwork.isNetworkSupported() ? SECURED_NETWORK_ICON : UNSECURED_NETWORK_ICON);
                        boolean dup = BWifiNetworksManager.this.discoveredNetworkTableModel.getRowForSsid(discoveredNetwork.getSsid()) != -1;
                        boolean show = discoveredNetwork.isNetworkSupported() && discoveredNetwork.getSsidBroadcasted() && !dup;
                        show = show || discoverPreferences.getShowUnsupported() && !discoveredNetwork.isNetworkSupported();
                        show = show || discoverPreferences.getShowHidden() && !discoveredNetwork.getSsidBroadcasted();
                        if (!(show = show || discoverPreferences.getShowDuplicate() && dup)) continue;
                        BWifiNetworksManager.this.discoveredNetworkTableModel.addNetwork(discoveredNetwork, this.icon);
                    }
                    for (int idx = 0; idx < BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount(); ++idx) {
                        BWifiNetwork databaseNetwork = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(idx);
                        if (databaseNetwork.getSignalStrength() == 0 && databaseNetwork.getSsidBroadcasted()) {
                            databaseNetwork.setNetworkState(BWifiNetworkStateEnum.notinrange);
                            continue;
                        }
                        BWifiNetworkStateEnum currentStatus = databaseNetwork.getNetworkState();
                        if (currentStatus == BWifiNetworkStateEnum.connected || currentStatus == BWifiNetworkStateEnum.connecting || currentStatus == BWifiNetworkStateEnum.disconnecting || currentStatus == BWifiNetworkStateEnum.disconnected || currentStatus == BWifiNetworkStateEnum.disabled) continue;
                        databaseNetwork.setNetworkState(BWifiNetworkStateEnum.disconnected);
                    }
                    BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
                    BWifiNetworksManager.this.discoveredNetworkTableModel.sortColumn = 4;
                    BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                    BWifiNetworksManager.this.discoveredNetworkTableModel.updateValues(true);
                    result.removeAll();
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (BWidget)this.getOwner(), (Throwable)throwable);
            }
            finally {
                BWifiNetworksManager.this.unlockModifiedState();
                BWifiNetworksManager.this.discoverButtons.setEnabled(true);
                this.setEnabled(true);
                if (shell != null) {
                    shell.exitBusy();
                }
            }
        }
    }
}

