/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.ui.BWifiNetworkEditor;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
@NiagaraAction(name="handleModified", flags=4)
public class BWifiNetworkEditorDialog
extends BDialog {
    @Generated
    public static final Action handleModified = BWifiNetworkEditorDialog.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiNetworkEditorDialog.class);
    private final BWifiNetworkEditor wifiNetworkEditor;
    private BWifiNetwork wifiNetwork;
    private final Command saveCommand;
    private final Command cancelCommand;
    private int dialogResult = 2;
    private static final Lexicon LEX = Lexicon.make((String)"platWifi");

    @Generated
    public void handleModified() {
        this.invoke(handleModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiNetworkEditorDialog(BWidget owner, String title, int configurationMode, BWifiNetwork wifiNetwork) {
        super(owner, title, true);
        this.setResizable(false);
        this.wifiNetwork = wifiNetwork;
        this.wifiNetworkEditor = new BWifiNetworkEditor();
        this.wifiNetworkEditor.loadValue((BObject)wifiNetwork, (Context)new BasicContext((Context)BFacets.make((String)"configureMode", (int)configurationMode)));
        this.linkTo(null, (BComponent)this.wifiNetworkEditor, (Slot)BWifiNetworkEditor.pluginModified, (Slot)handleModified);
        this.saveCommand = new Save((BWidget)this);
        this.cancelCommand = new Cancel((BWidget)this);
        this.saveCommand.setEnabled(false);
        this.cancelCommand.setEnabled(true);
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)new BButton(this.saveCommand));
        buttonPane.add(null, (BValue)new BButton(this.cancelCommand));
        BGridPane contentPane = new BGridPane(1);
        contentPane.setColumnAlign(BHalign.fill);
        contentPane.setUniformColumnWidth(true);
        contentPane.add(null, (BValue)new BBorderPane((BWidget)this.wifiNetworkEditor));
        contentPane.add(null, (BValue)new BBorderPane((BWidget)buttonPane));
        this.setContent((BWidget)new BScrollPane((BWidget)contentPane));
    }

    public int getResult() {
        return this.dialogResult;
    }

    public BWifiNetwork getNetwork() {
        return this.wifiNetwork;
    }

    public void doHandleModified() {
        this.saveCommand.setEnabled(true);
    }

    public void windowClosing(BWindowEvent event) {
        super.windowClosing(event);
        this.cancelCommand.invoke();
    }

    private class Cancel
    extends Command {
        private Cancel(BWidget owner) {
            super(owner, LEX.getText("WifiNetworkConfigurationEditor.cancel"));
        }

        public CommandArtifact doInvoke() {
            BWifiNetworkEditorDialog.this.dialogResult = 2;
            BWifiNetworkEditorDialog.this.close();
            return null;
        }
    }

    private class Save
    extends Command {
        private Save(BWidget owner) {
            super(owner, LEX.getText("WifiNetworkConfigurationEditor.save"));
        }

        public CommandArtifact doInvoke() {
            BWifiNetwork newWifiNetwork;
            try {
                newWifiNetwork = (BWifiNetwork)BWifiNetworkEditorDialog.this.wifiNetworkEditor.saveValue();
            }
            catch (Exception exception) {
                CannotSaveException cannotSaveException;
                boolean show = true;
                if (exception instanceof CannotSaveException && (cannotSaveException = (CannotSaveException)exception).isSilent()) {
                    show = false;
                }
                if (show) {
                    BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)LEX.getText("WifiNetworkConfigurationEditor.cannotSave.error"), (Throwable)exception);
                }
                return null;
            }
            BWifiNetworkEditorDialog.this.wifiNetwork = newWifiNetwork;
            BWifiNetworkEditorDialog.this.dialogResult = 1;
            BWifiNetworkEditorDialog.this.close();
            return null;
        }
    }
}

