/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.ui.util.BBox;
import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.security.BWifiProtocol;
import com.tridium.platwifi.security.BWifiSecurityPolicy;
import com.tridium.platwifi.security.BWifiSecuritySettings;
import com.tridium.platwifi.security.BWifiWPA3SAESettings;
import com.tridium.platwifi.security.BWifiWPAPSKSettings;
import com.tridium.platwifi.ui.security.BWifiWPA3SAEEditor;
import com.tridium.platwifi.ui.security.BWifiWPAPSKEditor;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import com.tridium.workbench.fieldeditors.BLimitedFrozenEnumFE;
import java.util.ArrayList;
import java.util.Objects;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"platWifi:WifiNetwork"})})
@NiagaraAction(name="setEnabledStates", flags=4)
public class BWifiNetworkEditor
extends BWbView {
    @Generated
    public static final Action setEnabledStates = BWifiNetworkEditor.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiNetworkEditor.class);
    private BTextField SSIDNameFE;
    private BCheckBox SSIDHiddenFE;
    private BIntegerFE priorityFE;
    private BLimitedFrozenEnumFE securityFE;
    private BEdgePane securityPane;
    private BGridPane nonePane;
    private BWifiWPAPSKEditor wpaPskEditor;
    private BWifiWPA3SAEEditor wpa3SaeEditor;
    private static final int MIN_PRIORITY = 0;
    private static final int MAX_PRIORITY = 9;
    private static final BFacets PRIORITY_FACETS = BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)9), (String)"fieldWidth", (BIDataValue)BInteger.make((int)2));
    public static final String CONFIGURE_MODE = "configureMode";
    public static final int EDIT_NETWORK = 0;
    public static final int NEW_NETWORK = 1;
    public static final int ADD_NETWORK = 2;
    private static final Lexicon LEX = Lexicon.make((String)"platWifi");

    @Generated
    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context contextIn) throws Exception {
        BFacets contextInFacets;
        int configurationMode;
        if (contextIn == null) {
            contextIn = new BasicContext((Context)BFacets.make((String)CONFIGURE_MODE, (int)0));
        }
        if ((configurationMode = (contextInFacets = contextIn.getFacets()).geti(CONFIGURE_MODE, 0)) > 2 || configurationMode < 0) {
            configurationMode = 0;
        }
        BGridPane editorPane = new BGridPane();
        editorPane.setValign(BValign.top);
        editorPane.setHalign(BHalign.left);
        editorPane.setRowAlign(BValign.center);
        editorPane.setColumnAlign(BHalign.left);
        editorPane.setColumnGap(10.0);
        editorPane.setRowGap(6.0);
        this.SSIDNameFE = new BTextField("", 34);
        LabelUtil.addLabelWidgetPair((BPane)editorPane, (String)LEX.getText("WifiNetworksManager.column.SSID.label"), (BWidget)this.SSIDNameFE);
        this.linkTo(null, (BComponent)this.SSIDNameFE, (Slot)BTextField.textModified, (Slot)setModified);
        this.SSIDHiddenFE = new BCheckBox();
        if (configurationMode != 2) {
            LabelUtil.addLabelWidgetPair((BPane)editorPane, (String)LEX.getText("WifiNetworksManager.column.ssidHidden.label"), (BWidget)this.SSIDHiddenFE);
            this.linkTo(null, (BComponent)this.SSIDHiddenFE, (Slot)BCheckBox.selected, (Slot)setModified);
        }
        this.priorityFE = new BIntegerFE();
        LabelUtil.addLabelWidgetPair((BPane)editorPane, (String)LEX.getText("WifiNetworksManager.column.priority.label"), (BWidget)this.priorityFE);
        this.linkTo(null, (BComponent)this.priorityFE, (Slot)BIntegerFE.pluginModified, (Slot)setModified);
        this.securityFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)editorPane, (String)LEX.getText("WifiNetworksManager.column.security.label"), (BWidget)this.securityFE);
        this.linkTo(null, (BComponent)this.securityFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setEnabledStates);
        this.linkTo(null, (BComponent)this.securityFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)pluginModified);
        BWifiNetwork wifiNetwork = (BWifiNetwork)value;
        this.SSIDNameFE.setText(wifiNetwork.getSsid());
        this.SSIDHiddenFE.setSelected(!wifiNetwork.getSsidBroadcasted());
        this.priorityFE.loadValue((BObject)BInteger.make((int)wifiNetwork.getPriority()), (Context)PRIORITY_FACETS);
        ArrayList<BWifiSecurityPolicy> securityPolicies = new ArrayList<BWifiSecurityPolicy>();
        securityPolicies.add(BWifiSecurityPolicy.wpa_psk);
        securityPolicies.add(BWifiSecurityPolicy.wpa_2_psk);
        securityPolicies.add(BWifiSecurityPolicy.wpapsk_wpa2psk);
        int policiesCount = securityPolicies.size();
        int[] ordinals = new int[policiesCount];
        String[] tags = new String[policiesCount];
        for (int i = 0; i < policiesCount; ++i) {
            ordinals[i] = ((BWifiSecurityPolicy)securityPolicies.get(i)).getOrdinal();
            tags[i] = SlotPath.escape((String)((BWifiSecurityPolicy)securityPolicies.get(i)).getDisplayTag(null));
        }
        BFacets securityDisplayFacets = BFacets.make((String)"range", (BIDataValue)BEnumRange.make((int[])ordinals, (String[])tags));
        BWifiProtocol wifiProtocols = wifiNetwork.getProtocols();
        BWifiSecurityPolicy wifiSecurityPolicy = wifiProtocols.equals((Object)BWifiProtocol.wpa) ? BWifiSecurityPolicy.wpa_psk : (wifiProtocols.equals((Object)BWifiProtocol.rsn) ? (wifiNetwork.getSecuritySettings() instanceof BWifiWPA3SAESettings ? BWifiSecurityPolicy.wpa_3_sae : BWifiSecurityPolicy.wpa_2_psk) : BWifiSecurityPolicy.wpapsk_wpa2psk);
        this.securityFE.loadValue((BObject)wifiSecurityPolicy, (Context)securityDisplayFacets);
        this.securityPane = new BEdgePane();
        this.nonePane = new BGridPane();
        this.wpaPskEditor = new BWifiWPAPSKEditor();
        this.linkTo(null, (BComponent)this.wpaPskEditor, (Slot)BWifiWPAPSKEditor.pluginModified, (Slot)setModified);
        if (wifiNetwork.getSecuritySettings() instanceof BWifiWPAPSKSettings) {
            this.wpaPskEditor.loadValue((BObject)wifiNetwork.getSecuritySettings(), contextIn);
        }
        this.wpa3SaeEditor = new BWifiWPA3SAEEditor();
        this.linkTo(null, (BComponent)this.wpa3SaeEditor, (Slot)BWifiWPAPSKEditor.pluginModified, (Slot)setModified);
        if (wifiNetwork.getSecuritySettings() instanceof BWifiWPAPSKSettings) {
            this.wpa3SaeEditor.loadValue((BObject)wifiNetwork.getSecuritySettings(), contextIn);
        }
        this.wpaPskEditor.computePreferredSize();
        this.wpa3SaeEditor.computePreferredSize();
        double maxWidth = Math.max(this.wpaPskEditor.getWidth(), this.wpa3SaeEditor.getWidth());
        double maxHeight = Math.max(this.wpa3SaeEditor.getHeight(), this.wpa3SaeEditor.getHeight());
        this.securityPane.setLeft((BWidget)new BBox(0.0, maxHeight));
        this.securityPane.setBottom((BWidget)new BBox(maxWidth, 0.0));
        BBorderPane securityBorderPane = new BBorderPane((BWidget)this.securityPane);
        securityBorderPane.setLabel((BWidget)LabelUtil.makeLabel((String)LEX.getText("WifiNetworksManager.securityOptions.label"), (boolean)true));
        securityBorderPane.setBorder(BBorder.solid);
        securityBorderPane.setMargin(BInsets.make((double)6.0, (double)0.0, (double)0.0, (double)0.0));
        BEdgePane contentEdgePane = new BEdgePane();
        contentEdgePane.setTop((BWidget)editorPane);
        contentEdgePane.setCenter((BWidget)securityBorderPane);
        this.setContent((BWidget)contentEdgePane);
        this.doSetReadonly(this.isReadonly());
        this.doSetEnabledStates();
        boolean readOnly = configurationMode == 2;
        boolean editing = configurationMode == 0;
        this.SSIDNameFE.setEditable(!readOnly && !editing);
        this.SSIDNameFE.setEnabled(!readOnly && !editing);
        this.SSIDHiddenFE.setEnabled(!readOnly);
    }

    protected BObject doSaveValue(BObject value, Context contextIn) throws Exception {
        BWifiNetwork wifiNetwork = (BWifiNetwork)value;
        String SSIDName = this.SSIDNameFE.getText().trim();
        if (SSIDName.isEmpty()) {
            this.saveError("WifiNetworkConfigurationEditor.cannotSave.nullSSID");
        } else if (SSIDName.length() > 32) {
            this.saveError("WifiNetworkConfigurationEditor.cannotSave.SSIDTooLong");
        }
        wifiNetwork.setSsid(SSIDName);
        boolean SSIDHidden = false;
        if (this.SSIDHiddenFE.getParent() != null) {
            SSIDHidden = this.SSIDHiddenFE.isSelected();
        }
        wifiNetwork.setSsidBroadcasted(!SSIDHidden);
        wifiNetwork.setPriority(((BInteger)this.priorityFE.saveValue()).getInt());
        BWifiSecurityPolicy wifiSecurityPolicy = (BWifiSecurityPolicy)this.securityFE.saveValue();
        wifiNetwork.setSecurityPolicies(wifiSecurityPolicy);
        if (wifiSecurityPolicy.getOrdinal() == 3) {
            wifiNetwork.setProtocols(BWifiProtocol.wpa);
        } else if (wifiSecurityPolicy.getOrdinal() == 5 || wifiSecurityPolicy.getOrdinal() == 8) {
            wifiNetwork.setProtocols(BWifiProtocol.rsn);
        } else {
            wifiNetwork.setProtocols(BWifiProtocol.wpa_rsn);
        }
        BWifiWPAPSKSettings securitySettings = wifiSecurityPolicy.getOrdinal() == 8 ? (BWifiWPAPSKSettings)this.wpa3SaeEditor.saveValue(contextIn) : (BWifiWPAPSKSettings)this.wpaPskEditor.saveValue(contextIn);
        wifiNetwork.setSecuritySettings((BWifiSecuritySettings)securitySettings);
        return wifiNetwork;
    }

    protected void doSetReadonly(boolean readOnly) {
        if (this.SSIDNameFE != null) {
            this.SSIDNameFE.setEditable(!readOnly);
            this.SSIDNameFE.setEnabled(!readOnly);
        }
        if (this.SSIDHiddenFE != null) {
            this.SSIDHiddenFE.setEnabled(!readOnly);
        }
        if (this.priorityFE != null) {
            this.priorityFE.setReadonly(readOnly);
            this.priorityFE.setEnabled(!readOnly);
        }
        if (this.securityFE != null) {
            this.securityFE.setReadonly(readOnly);
            this.securityFE.setEnabled(!readOnly);
        }
        if (this.wpaPskEditor != null) {
            this.wpaPskEditor.setReadonly(readOnly);
            this.wpaPskEditor.setEnabled(!readOnly);
        }
        if (this.wpa3SaeEditor != null) {
            this.wpa3SaeEditor.setReadonly(readOnly);
            this.wpa3SaeEditor.setEnabled(!readOnly);
        }
    }

    public void doSetEnabledStates() throws Exception {
        if (this.securityFE == null || this.securityPane == null) {
            return;
        }
        BWifiSecurityPolicy policy = (BWifiSecurityPolicy)this.securityFE.saveValue();
        if (BWifiSecurityPolicy.none.equals((Object)policy)) {
            this.securityPane.setCenter((BWidget)this.nonePane);
        } else if (BWifiSecurityPolicy.wpa_3_sae.equals((Object)policy)) {
            this.securityPane.setCenter((BWidget)this.wpa3SaeEditor);
        } else {
            this.securityPane.setCenter((BWidget)this.wpaPskEditor);
        }
    }

    private void saveError(String messageTag) throws CannotSaveException {
        Objects.requireNonNull(messageTag, "messageTag argument cannot be null");
        if (this.widgetSupport(null) != null) {
            BDialog.error((BWidget)this, (String)LEX.getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)LEX.getText(messageTag));
            CannotSaveException cannotSaveException = new CannotSaveException(LEX.getText(messageTag));
            cannotSaveException.setSilent(true);
            throw cannotSaveException;
        }
        throw new CannotSaveException(LEX.getText(messageTag));
    }
}

