/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platwifi.BWifiMacAddress;
import com.tridium.platwifi.BWifiMacAddressVector;
import com.tridium.platwifi.ui.BMacAddressFE;
import com.tridium.platwifi.ui.BWifiAllowListEditorDialog;
import com.tridium.ui.util.LabelUtil;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"platWifi:WifiMacAddressVector"})})
@NiagaraAction(name="handleFocusChange", parameterType="BFocusEvent", defaultValue="new BFocusEvent()", flags=4)
public class BWifiMacAddressVectorEditor
extends BWbView {
    @Generated
    public static final Action handleFocusChange = BWifiMacAddressVectorEditor.newAction((int)4, (BValue)new BFocusEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiMacAddressVectorEditor.class);
    private int maxWifiMACs = 20;
    private BMacAddressFE focusedEditor;
    private final BGridPane contentPane;
    private final Command addCommand;
    private final Command deleteCommand;
    private final BWifiAllowListEditorDialog dialog;
    private static final String MAC_ADDRESS_SLOT_NAME_PREFIX = "mac";
    private static final BImage ADD_ICON = BImage.make((BIcon)BIcon.std((String)"add.png"));
    private static final BImage DELETE_ICON = BImage.make((BIcon)BIcon.std((String)"delete.png"));
    private static final int MAX_WIFI_MACS_DEFAULT = 20;
    private static final String MAX_WIFI_MACS_FACET = "maxWifiMacs";
    private static final Logger LOG = Logger.getLogger("plat.wifi");
    private static final Lexicon LEX = Lexicon.make((String)"platWifi");

    @Generated
    public void handleFocusChange(BFocusEvent parameter) {
        this.invoke(handleFocusChange, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiMacAddressVectorEditor(BWifiAllowListEditorDialog wifiAllowListEditorDialog) {
        this.dialog = wifiAllowListEditorDialog;
        this.contentPane = new BGridPane(1);
        this.contentPane.setHalign(BHalign.center);
        BBorderPane contentBorder = new BBorderPane((BWidget)this.contentPane);
        contentBorder.setLabel((BWidget)LabelUtil.makeLabel((String)LEX.getText("AllowListDialog.content.title"), (boolean)true));
        contentBorder.setBorder(BBorder.solid);
        BFlowPane toolbarPane = new BFlowPane(BHalign.center);
        BToolBar toolbar = new BToolBar();
        toolbarPane.add(null, (BValue)toolbar, null);
        this.addCommand = new AddCommand();
        BButton button = new BButton(this.addCommand);
        toolbar.add("add", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.deleteCommand = new DeleteCommand();
        button = new BButton(this.deleteCommand);
        toolbar.add("delete", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        BEdgePane contentEdgePane = new BEdgePane();
        contentEdgePane.setCenter((BWidget)contentBorder);
        contentEdgePane.setBottom((BWidget)toolbarPane);
        this.setContent((BWidget)contentEdgePane);
        this.setEnabled(true);
    }

    protected void doLoadValue(BObject value, Context context) {
        this.maxWifiMACs = 20;
        if (context != null) {
            this.maxWifiMACs = context.getFacets().geti(MAX_WIFI_MACS_FACET, 20);
        }
        this.contentPane.removeAll();
        BWifiMacAddressVector wifiMacAddressVector = (BWifiMacAddressVector)value;
        SlotCursor c = wifiMacAddressVector.loadSlots().getProperties();
        while (c.next(BWifiMacAddress.class)) {
            this.addElement(c.get());
        }
        this.setEnabled(this.getEnabled());
    }

    protected BObject doSaveValue(BObject value, Context context) throws Exception {
        BWifiMacAddressVector wifiMacAddressVector = (BWifiMacAddressVector)value;
        wifiMacAddressVector.lease();
        wifiMacAddressVector.removeAll();
        if (wifiMacAddressVector.getSlotCount() > 0) {
            throw new LocalizableRuntimeException("platWifi", "MacAddressFE.removeError");
        }
        HashSet<String> duplicateMacs = new HashSet<String>();
        for (BWidget child : this.contentPane.getChildWidgets()) {
            BWifiMacAddress entry = (BWifiMacAddress)((BMacAddressFE)child).saveValue(context);
            String macValue = entry.getMac().trim();
            if (macValue.isEmpty()) {
                throw new LocalizableRuntimeException("platWifi", "MacAddressFE.emptyAddress");
            }
            if (!duplicateMacs.add(macValue)) {
                throw new LocalizableRuntimeException("platWifi", "MacAddressFE.duplicate", new Object[]{macValue});
            }
            wifiMacAddressVector.add("mac?", (BValue)entry, 3, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:MacAddressFE")), null);
        }
        if (wifiMacAddressVector.getSlotCount() != this.contentPane.getChildWidgets().length) {
            throw new LocalizableRuntimeException("platWifi", "MacAddressFE.addError");
        }
        return wifiMacAddressVector;
    }

    protected void doSetReadonly(boolean readOnly) {
        BWidget[] children;
        this.setEnabled(!readOnly);
        for (BWidget child : children = this.contentPane.getChildWidgets()) {
            ((BWbFieldEditor)child).setReadonly(readOnly);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        BWidget[] children = this.contentPane.getChildWidgets();
        this.addCommand.setEnabled(enabled && children.length < this.maxWifiMACs);
        this.deleteCommand.setEnabled(enabled && this.focusedEditor != null);
        for (BWidget child : children) {
            child.setEnabled(enabled);
        }
    }

    private void addElement(BValue value) {
        BMacAddressFE macAddressFE = new BMacAddressFE();
        macAddressFE.loadValue((BObject)value);
        this.contentPane.add("mac?", (BValue)macAddressFE);
        this.contentPane.requestFocus();
        this.focusedEditor = macAddressFE;
        this.focusedEditor.setEnabled(this.getEnabled());
        this.relayout();
        this.getContent().relayout();
        if (this.dialog != null) {
            this.dialog.relayout();
            this.dialog.setScreenSizeToPreferredSize();
        }
        this.linkTo(null, (BComponent)this.focusedEditor, (Slot)BWbFieldEditor.focusEvent, (Slot)handleFocusChange);
        this.linkTo(null, (BComponent)this.focusedEditor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
        this.setModified();
        this.setEnabled(this.getEnabled());
    }

    public void doHandleFocusChange(BFocusEvent focusEvent) {
        try {
            if (!this.getEnabled()) {
                return;
            }
            if (focusEvent.getId() == 1004) {
                this.focusedEditor = (BMacAddressFE)focusEvent.getWidget();
            } else if (focusEvent.getId() == 1005 && this.focusedEditor == focusEvent.getWidget()) {
                this.focusedEditor = null;
            }
            this.deleteCommand.setEnabled(this.focusedEditor != null);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, LEX.getText("MacAddressFE.focusError"), exception);
        }
    }

    private class DeleteCommand
    extends Command {
        private DeleteCommand() {
            super((BWidget)BWifiMacAddressVectorEditor.this, "", DELETE_ICON, null, "");
            super.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            if (BWifiMacAddressVectorEditor.this.focusedEditor == null) {
                return null;
            }
            SlotCursor c = BWifiMacAddressVectorEditor.this.contentPane.loadSlots().getProperties();
            while (c.next(BWbFieldEditor.class)) {
                if (c.get() != BWifiMacAddressVectorEditor.this.focusedEditor) continue;
                BWifiMacAddressVectorEditor.this.contentPane.remove(c.property());
                BWifiMacAddressVectorEditor.this.focusedEditor = null;
                break;
            }
            BWifiMacAddressVectorEditor.this.setModified();
            BWifiMacAddressVectorEditor.this.computePreferredSize();
            BWifiMacAddressVectorEditor.this.relayout();
            BWifiMacAddressVectorEditor.this.getContent().relayout();
            if (BWifiMacAddressVectorEditor.this.dialog != null) {
                BWifiMacAddressVectorEditor.this.dialog.relayout();
                BWifiMacAddressVectorEditor.this.dialog.setScreenSizeToPreferredSize();
            }
            BWifiMacAddressVectorEditor.this.addCommand.setEnabled(true);
            BWifiMacAddressVectorEditor.this.deleteCommand.setEnabled(false);
            return null;
        }
    }

    private class AddCommand
    extends Command {
        private AddCommand() {
            super((BWidget)BWifiMacAddressVectorEditor.this, "", ADD_ICON, null, "");
        }

        public CommandArtifact doInvoke() {
            BWifiMacAddressVectorEditor.this.addElement((BValue)new BWifiMacAddress());
            super.setEnabled(BWifiMacAddressVectorEditor.this.contentPane.getChildWidgets().length < BWifiMacAddressVectorEditor.this.maxWifiMACs);
            return null;
        }
    }
}

