/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platwifi.BWifiClientListEntry;
import com.tridium.platwifi.BWifiClientListVector;
import com.tridium.platwifi.WifiUtil;
import com.tridium.platwifi.ui.BWifiAccessPointManager;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;

@NiagaraType
public class BWifiClientListEditorDialog
extends BDialog {
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiClientListEditorDialog.class);
    private int dialogResult = 2;
    private final Command closeCommand;
    private final BGridPane displayPane;
    private static final Lexicon LEX = Lexicon.make((String)"platWifi");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiClientListEditorDialog(BWidget owner, String title) throws Exception {
        super(owner, title, true);
        this.setResizable(false);
        this.displayPane = new BGridPane(1);
        this.closeCommand = new Close((BWidget)this);
        this.closeCommand.setEnabled(true);
        BGridPane buttonPane = new BGridPane(1);
        buttonPane.setColumnAlign(BHalign.center);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)new BButton(this.closeCommand));
        BGridPane contentPane = new BGridPane(1);
        contentPane.setColumnAlign(BHalign.fill);
        contentPane.setUniformColumnWidth(true);
        contentPane.add(null, (BValue)new BBorderPane((BWidget)this.displayPane));
        contentPane.add(null, (BValue)new BBorderPane((BWidget)buttonPane));
        this.setContent((BWidget)new BScrollPane((BWidget)contentPane));
        this.refreshSettings();
    }

    private void refreshSettings() throws Exception {
        BWidget owner = this.getOwner();
        if (!(owner instanceof BWifiAccessPointManager)) {
            throw new IllegalArgumentException("BWifiClientListEditorDialog requires BWifiAccessPointManager owner, found " + owner);
        }
        BWifiAccessPointManager wifiAccessPointManager = (BWifiAccessPointManager)owner;
        BWifiClientListVector clients = new BWifiClientListVector();
        BDaemonSession daemonSession = wifiAccessPointManager.getWifiDaemonSession();
        if (daemonSession == null) {
            throw new IllegalArgumentException("Could not find Wi-Fi daemon session");
        }
        WifiUtil.clientListFromSession((BWifiClientListVector)clients, (BDaemonSession)daemonSession);
        this.displayPane.removeAll();
        BWifiClientListEntry[] entries = (BWifiClientListEntry[])clients.getChildren(BWifiClientListEntry.class);
        for (int i = 0; i < entries.length; ++i) {
            String text = LEX.getText("ClientListDialog.entry", new Object[]{entries[i].getMac(), entries[i].getTime()});
            BTextField textField = new BTextField(text, 50, false);
            this.displayPane.add("entry" + i, (BValue)textField);
        }
    }

    public int getResult() {
        return this.dialogResult;
    }

    public void windowClosing(BWindowEvent event) {
        super.windowClosing(event);
        this.closeCommand.invoke();
    }

    private class Close
    extends Command {
        private Close(BWidget owner) {
            super(owner, LEX.getText("ClientListDialog.close"));
        }

        public CommandArtifact doInvoke() {
            BWifiClientListEditorDialog.this.dialogResult = 1;
            BWifiClientListEditorDialog.this.close();
            return null;
        }
    }
}

