/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platwifi.BHapdHwModeEnum;
import com.tridium.platwifi.BHtCapabilityEnum;
import com.tridium.platwifi.BWifiChannelListEntry;
import com.tridium.platwifi.BWifiChannelListVector;
import com.tridium.platwifi.BWifiFreqBandEnum;
import com.tridium.platwifi.BWifiSettings;
import com.tridium.platwifi.WifiUtil;
import com.tridium.platwifi.ui.BWifiAccessPointManager;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import java.util.Objects;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="handleModeModified", flags=4), @NiagaraAction(name="handleChannelModified", flags=4)})
public class BWifiChannelListVectorEditorDialog
extends BDialog {
    @Generated
    public static final Action handleModeModified = BWifiChannelListVectorEditorDialog.newAction((int)4, null);
    @Generated
    public static final Action handleChannelModified = BWifiChannelListVectorEditorDialog.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiChannelListVectorEditorDialog.class);
    private final BFrozenEnumFE modeFE;
    private final BFrozenEnumFE capabilitiesFE;
    private final BListDropDown channelDropDown;
    private final Command saveCommand;
    private final Command cancelCommand;
    private int dialogResult = 2;
    private BWifiAccessPointManager wifiAccessPointManager;
    private BWifiChannelListVector channels;
    private final BWifiSettings wifiSettings;
    private static final Lexicon LEX = Lexicon.make((String)"platWifi");

    @Generated
    public void handleModeModified() {
        this.invoke(handleModeModified, null, null);
    }

    @Generated
    public void handleChannelModified() {
        this.invoke(handleChannelModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiChannelListVectorEditorDialog(BWidget owner, String title, BWifiSettings wifiSettings) throws Exception {
        super(owner, title, true);
        this.setResizable(false);
        this.wifiSettings = wifiSettings;
        BGridPane settingsPane = new BGridPane(2);
        settingsPane.setColumnAlign(BHalign.fill);
        this.modeFE = new BFrozenEnumFE();
        this.capabilitiesFE = new BFrozenEnumFE();
        this.channelDropDown = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BPane)settingsPane, (String)LEX.getText("RadioConfigDialog.mode.label"), (BWidget)this.modeFE);
        this.linkTo(null, (BComponent)this.modeFE, (Slot)BFrozenEnumFE.pluginModified, (Slot)handleModeModified);
        LabelUtil.addLabelWidgetPair((BPane)settingsPane, (String)LEX.getText("RadioConfigDialog.capability.label"), (BWidget)this.capabilitiesFE);
        this.linkTo(null, (BComponent)this.capabilitiesFE, (Slot)BFrozenEnumFE.pluginModified, (Slot)handleModeModified);
        LabelUtil.addLabelWidgetPair((BPane)settingsPane, (String)LEX.getText("RadioConfigDialog.channel.label"), (BWidget)this.channelDropDown);
        this.linkTo(null, (BComponent)this.channelDropDown, (Slot)BListDropDown.valueModified, (Slot)handleChannelModified);
        this.saveCommand = new Save((BWidget)this);
        this.cancelCommand = new Cancel((BWidget)this);
        this.saveCommand.setEnabled(false);
        this.cancelCommand.setEnabled(true);
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)new BButton(this.saveCommand));
        buttonPane.add(null, (BValue)new BButton(this.cancelCommand));
        BGridPane contentPane = new BGridPane(1);
        contentPane.setColumnAlign(BHalign.fill);
        contentPane.setUniformColumnWidth(true);
        contentPane.add(null, (BValue)new BBox(200.0, 0.0));
        contentPane.add(null, (BValue)new BBorderPane((BWidget)settingsPane));
        contentPane.add(null, (BValue)new BBorderPane((BWidget)buttonPane));
        this.setContent((BWidget)new BScrollPane((BWidget)contentPane));
        this.refreshSettings();
    }

    private void refreshSettings() throws Exception {
        BWidget owner = this.getOwner();
        if (!(owner instanceof BWifiAccessPointManager)) {
            throw new IllegalArgumentException("BWifiChannelListVectorEditorDialog requires BWifiAccessPointManager owner, found " + owner);
        }
        this.wifiAccessPointManager = (BWifiAccessPointManager)owner;
        this.channels = new BWifiChannelListVector();
        BDaemonSession daemonSession = this.wifiAccessPointManager.getWifiDaemonSession();
        if (daemonSession == null) {
            throw new IllegalArgumentException("Could not find Wi-Fi daemon session");
        }
        String countryCode = WifiUtil.countryCodeFromSession((BDaemonSession)daemonSession);
        WifiUtil.channelListFromSession((BWifiChannelListVector)this.channels, (BDaemonSession)daemonSession, (String)countryCode);
        BHapdHwModeEnum hapdHwModeEnum = this.wifiSettings.getSapHwMode();
        this.modeFE.loadValue((BObject)hapdHwModeEnum);
        BHtCapabilityEnum htCapabilityEnum = this.wifiSettings.getSapHtCapab();
        this.capabilitiesFE.loadValue((BObject)htCapabilityEnum);
        this.populateChannelList(hapdHwModeEnum, htCapabilityEnum, this.channelDropDown.getList(), this.wifiSettings.getSapChannel());
        boolean readOnly = this.wifiSettings.getWifiReadonly();
        boolean enabled = !readOnly;
        this.modeFE.setReadonly(readOnly);
        this.modeFE.setEnabled(enabled);
        boolean capabilitiesReadOnly = readOnly;
        if (!hapdHwModeEnum.equals((Object)BHapdHwModeEnum.ieee802_11n)) {
            this.capabilitiesFE.loadValue((BObject)BHtCapabilityEnum.ht20);
            capabilitiesReadOnly = true;
        }
        this.capabilitiesFE.setReadonly(capabilitiesReadOnly);
        this.capabilitiesFE.setEnabled(!capabilitiesReadOnly);
        this.channelDropDown.setEnabled(enabled);
    }

    private void populateChannelList(BHapdHwModeEnum hapdHwModeEnum, BHtCapabilityEnum htCapabilityEnum, BList channelList, int currentChannel) {
        Objects.requireNonNull(hapdHwModeEnum, "hapdHwModeEnum argument cannot be null");
        Objects.requireNonNull(htCapabilityEnum, "htCapabilityEnum argument cannot be null");
        Objects.requireNonNull(channelList, "channelList argument cannot be null");
        channelList.getSelection().deselectAll();
        channelList.removeAllItems();
        if (currentChannel == 0) {
            channelList.addItem((Object)BInteger.make((int)0));
        }
        SlotCursor c = this.channels.loadSlots().getProperties();
        block9: while (c.next(BWifiChannelListEntry.class)) {
            BWifiChannelListEntry wifiChannelListEntry = (BWifiChannelListEntry)c.get();
            BWifiFreqBandEnum entryFreqBand = wifiChannelListEntry.getBand();
            int entryChannel = wifiChannelListEntry.getChannel();
            switch (hapdHwModeEnum.getOrdinal()) {
                case 1: {
                    if (entryFreqBand == BWifiFreqBandEnum.band24) continue block9;
                    channelList.addItem((Object)BInteger.make((int)entryChannel));
                    continue block9;
                }
                case 2: 
                case 3: {
                    if (entryFreqBand != BWifiFreqBandEnum.band24) continue block9;
                    channelList.addItem((Object)BInteger.make((int)entryChannel));
                    continue block9;
                }
            }
            if (htCapabilityEnum.equals((Object)BHtCapabilityEnum.ht40) || htCapabilityEnum.equals((Object)BHtCapabilityEnum.ht20ht40)) {
                switch (entryChannel) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        continue block9;
                    }
                    case 36: 
                    case 44: 
                    case 52: 
                    case 60: 
                    case 100: 
                    case 108: 
                    case 116: 
                    case 124: 
                    case 132: 
                    case 140: 
                    case 149: 
                    case 157: 
                    case 165: {
                        continue block9;
                    }
                    case 40: 
                    case 48: 
                    case 56: 
                    case 64: 
                    case 104: 
                    case 112: 
                    case 120: 
                    case 128: 
                    case 136: 
                    case 153: 
                    case 161: {
                        channelList.addItem((Object)BInteger.make((int)entryChannel));
                        continue block9;
                    }
                }
                continue;
            }
            channelList.addItem((Object)BInteger.make((int)entryChannel));
        }
        if (channelList.getItemCount() == 0) {
            channelList.addItem((Object)BInteger.make((int)0));
        }
        for (int index = 0; index < channelList.getItemCount(); ++index) {
            if (((BInteger)channelList.getItem(index)).getInt() != currentChannel) continue;
            channelList.setSelectedIndex(index);
            break;
        }
        if (channelList.getSelectedItem() == null) {
            channelList.setSelectedIndex(0);
        }
    }

    public int getResult() {
        return this.dialogResult;
    }

    public void doHandleModeModified() throws Exception {
        boolean capabilitiesReadOnly = false;
        BHapdHwModeEnum hapdHwModeEnum = (BHapdHwModeEnum)this.modeFE.saveValue();
        if (!hapdHwModeEnum.equals((Object)BHapdHwModeEnum.ieee802_11n)) {
            this.capabilitiesFE.loadValue((BObject)BHtCapabilityEnum.ht20);
            capabilitiesReadOnly = true;
        }
        this.capabilitiesFE.setReadonly(capabilitiesReadOnly);
        this.capabilitiesFE.setEnabled(!capabilitiesReadOnly);
        BHtCapabilityEnum htCapabilityEnum = (BHtCapabilityEnum)this.capabilitiesFE.saveValue();
        BList channelList = this.channelDropDown.getList();
        int selectedChannel = 0;
        if (channelList.getItemCount() > 0) {
            selectedChannel = ((BInteger)channelList.getSelectedItem()).getInt();
        }
        this.populateChannelList(hapdHwModeEnum, htCapabilityEnum, channelList, selectedChannel);
        this.doHandleChannelModified();
    }

    public void doHandleChannelModified() {
        BList channelList = this.channelDropDown.getList();
        if (channelList.indexOfItem((Object)BInteger.make((int)0)) != -1 && channelList.getSelectedItem() != null && ((BInteger)channelList.getSelectedItem()).getInt() != 0) {
            int selectedChannel = ((BInteger)channelList.getSelectedItem()).getInt();
            channelList.removeItem((Object)BInteger.make((int)0));
            for (int index = 0; index < channelList.getItemCount(); ++index) {
                if (((BInteger)channelList.getItem(index)).getInt() != selectedChannel) continue;
                channelList.setSelectedIndex(index);
                break;
            }
            this.channelDropDown.doListActionPerformed();
        }
        this.saveCommand.setEnabled(true);
    }

    public void windowClosing(BWindowEvent event) {
        super.windowClosing(event);
        this.cancelCommand.invoke();
    }

    private class Cancel
    extends Command {
        private Cancel(BWidget owner) {
            super(owner, LEX.getText("RadioConfigDialog.cancel"));
        }

        public CommandArtifact doInvoke() {
            BWifiChannelListVectorEditorDialog.this.dialogResult = 2;
            BWifiChannelListVectorEditorDialog.this.close();
            return null;
        }
    }

    private class Save
    extends Command {
        private Save(BWidget owner) {
            super(owner, LEX.getText("RadioConfigDialog.save"));
        }

        public CommandArtifact doInvoke() {
            try {
                int channel = ((BInteger)BWifiChannelListVectorEditorDialog.this.channelDropDown.getSelectedItem()).getInt();
                if (channel <= 0) {
                    throw new CannotSaveException(LEX.getText("RadioConfigDialog.cannotSave.invalidChannel", new Object[]{channel}));
                }
                BHapdHwModeEnum hapdHwModeEnum = (BHapdHwModeEnum)BWifiChannelListVectorEditorDialog.this.modeFE.saveValue();
                BHtCapabilityEnum htCapabilityEnum = (BHtCapabilityEnum)BWifiChannelListVectorEditorDialog.this.capabilitiesFE.saveValue();
                BWifiChannelListVectorEditorDialog.this.wifiSettings.setSapChannel(channel);
                BWifiChannelListVectorEditorDialog.this.wifiSettings.setSapHwMode(hapdHwModeEnum);
                BWifiChannelListVectorEditorDialog.this.wifiSettings.setSapHtCapab(htCapabilityEnum);
                BWifiChannelListVectorEditorDialog.this.wifiAccessPointManager.setModified();
            }
            catch (Exception exception) {
                CannotSaveException cannotSaveException;
                boolean show = true;
                if (exception instanceof CannotSaveException && (cannotSaveException = (CannotSaveException)exception).isSilent()) {
                    show = false;
                }
                if (show) {
                    BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("RadioConfigDialog.cannotSave.title"), (Object)LEX.getText("RadioConfigDialog.cannotSave.error"), (Throwable)exception);
                }
                return null;
            }
            BWifiChannelListVectorEditorDialog.this.dialogResult = 1;
            BWifiChannelListVectorEditorDialog.this.close();
            return null;
        }
    }
}

