/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platwifi.BWifiMacAddressVector;
import com.tridium.platwifi.BWifiSettings;
import com.tridium.platwifi.WifiUtil;
import com.tridium.platwifi.ui.BWifiAccessPointManager;
import com.tridium.platwifi.ui.BWifiMacAddressVectorEditor;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
@NiagaraAction(name="handleModified", flags=4)
public class BWifiAllowListEditorDialog
extends BDialog {
    @Generated
    public static final Action handleModified = BWifiAllowListEditorDialog.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiAllowListEditorDialog.class);
    private final BWifiMacAddressVectorEditor allowListEditor;
    private final Command saveCommand;
    private final Command cancelCommand;
    private int dialogResult = 2;
    private BDaemonSession daemonSession;
    private BWifiMacAddressVector allowList;
    private final BWifiSettings wifiSettings;
    private static final Lexicon LEX = Lexicon.make((String)"platWifi");

    @Generated
    public void handleModified() {
        this.invoke(handleModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiAllowListEditorDialog(BWidget owner, String title, BWifiMacAddressVector allowList, BWifiSettings wifiSettings) throws Exception {
        super(owner, title, true);
        this.setResizable(false);
        this.allowList = allowList;
        this.wifiSettings = wifiSettings;
        this.allowListEditor = new BWifiMacAddressVectorEditor(this);
        this.linkTo(null, (BComponent)this.allowListEditor, (Slot)BWifiMacAddressVectorEditor.pluginModified, (Slot)handleModified);
        this.saveCommand = new Save((BWidget)this);
        this.cancelCommand = new Cancel((BWidget)this);
        this.saveCommand.setEnabled(false);
        this.cancelCommand.setEnabled(true);
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)new BButton(this.saveCommand));
        buttonPane.add(null, (BValue)new BButton(this.cancelCommand));
        BGridPane contentPane = new BGridPane(1);
        contentPane.setColumnAlign(BHalign.fill);
        contentPane.setUniformColumnWidth(true);
        contentPane.add(null, (BValue)new BBorderPane((BWidget)this.allowListEditor));
        contentPane.add(null, (BValue)new BBorderPane((BWidget)buttonPane));
        this.setContent((BWidget)new BScrollPane((BWidget)contentPane));
        this.refreshSettings();
    }

    private void refreshSettings() throws Exception {
        BWidget owner = this.getOwner();
        if (!(owner instanceof BWifiAccessPointManager)) {
            throw new IllegalArgumentException("BWifiAllowListEditorDialog requires BWifiAccessPointManager owner, found " + owner);
        }
        BWifiAccessPointManager wifiAccessPointManager = (BWifiAccessPointManager)owner;
        this.daemonSession = wifiAccessPointManager.getWifiDaemonSession();
        if (this.daemonSession == null) {
            throw new IllegalArgumentException("Could not find Wi-Fi daemon session");
        }
        WifiUtil.allowListFromSession((BWifiMacAddressVector)this.allowList, (BDaemonSession)this.daemonSession, (String)this.wifiSettings.getAllowListFilePath());
        this.allowListEditor.loadValue((BObject)this.allowList, null);
        boolean readOnly = this.wifiSettings.getWifiReadonly();
        boolean enabled = !readOnly;
        this.allowListEditor.setReadonly(readOnly);
        this.allowListEditor.setEnabled(enabled);
    }

    public int getResult() {
        return this.dialogResult;
    }

    public void doHandleModified() {
        this.saveCommand.setEnabled(true);
    }

    public void windowClosing(BWindowEvent event) {
        super.windowClosing(event);
        this.cancelCommand.invoke();
    }

    private class Cancel
    extends Command {
        private Cancel(BWidget owner) {
            super(owner, LEX.getText("AllowListDialog.cancel"));
        }

        public CommandArtifact doInvoke() {
            BWifiAllowListEditorDialog.this.dialogResult = 2;
            BWifiAllowListEditorDialog.this.close();
            return null;
        }
    }

    private class Save
    extends Command {
        private Save(BWidget owner) {
            super(owner, LEX.getText("AllowListDialog.save"));
        }

        public CommandArtifact doInvoke() {
            try {
                BWifiAllowListEditorDialog.this.allowList = (BWifiMacAddressVector)BWifiAllowListEditorDialog.this.allowListEditor.saveValue();
                if (BWifiAllowListEditorDialog.this.daemonSession == null) {
                    throw new IllegalArgumentException("Could not find Wi-Fi daemon session");
                }
                WifiUtil.allowListToSession((BWifiMacAddressVector)BWifiAllowListEditorDialog.this.allowList, (BDaemonSession)BWifiAllowListEditorDialog.this.daemonSession, (String)BWifiAllowListEditorDialog.this.wifiSettings.getAllowListFilePath());
            }
            catch (Exception exception) {
                CannotSaveException cannotSaveException;
                boolean show = true;
                if (exception instanceof CannotSaveException && (cannotSaveException = (CannotSaveException)exception).isSilent()) {
                    show = false;
                }
                if (show) {
                    BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("AllowListDialog.cannotSave.title"), (Object)LEX.getText("AllowListDialog.cannotSave.error"), (Throwable)exception);
                }
                return null;
            }
            BWifiAllowListEditorDialog.this.dialogResult = 1;
            BWifiAllowListEditorDialog.this.close();
            return null;
        }
    }
}

