/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.WiFiServletType;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.platform.ui.tcpip.BIpHostFE;
import com.tridium.platwifi.BHapdHwModeEnum;
import com.tridium.platwifi.BHtCapabilityEnum;
import com.tridium.platwifi.BWifiFreqBandEnum;
import com.tridium.platwifi.BWifiMacAddressVector;
import com.tridium.platwifi.BWifiSettings;
import com.tridium.platwifi.WifiUtil;
import com.tridium.platwifi.security.BHapdEncryptionMethod;
import com.tridium.platwifi.security.BHapdKeyManagementEnum;
import com.tridium.platwifi.security.BHapdWpaConfigEnum;
import com.tridium.platwifi.status.BWifiSwitchEnum;
import com.tridium.platwifi.ui.BWifiAllowListEditorDialog;
import com.tridium.platwifi.ui.BWifiChannelListVectorEditorDialog;
import com.tridium.platwifi.ui.BWifiClientListEditorDialog;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import com.tridium.workbench.fieldeditors.BLimitedFrozenEnumFE;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import com.tridium.workbench.fieldeditors.BRelTimeFE;
import java.security.AccessController;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BInsets;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.PasswordRenderer;
import javax.baja.ui.text.PasswordTextController;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextRenderer;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="setEnabledStates", flags=4), @NiagaraAction(name="handleAdapterAddressChanged", flags=4), @NiagaraAction(name="handlePassphraseChanged", flags=4), @NiagaraAction(name="handleShowPassphraseChecked", flags=4), @NiagaraAction(name="handleAllowListChecked", flags=4)})
public class BWifiAccessPointManager
extends BWbComponentView {
    @Generated
    public static final Action setEnabledStates = BWifiAccessPointManager.newAction((int)4, null);
    @Generated
    public static final Action handleAdapterAddressChanged = BWifiAccessPointManager.newAction((int)4, null);
    @Generated
    public static final Action handlePassphraseChanged = BWifiAccessPointManager.newAction((int)4, null);
    @Generated
    public static final Action handleShowPassphraseChecked = BWifiAccessPointManager.newAction((int)4, null);
    @Generated
    public static final Action handleAllowListChecked = BWifiAccessPointManager.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiAccessPointManager.class);
    private BDaemonSession daemonSession;
    private BWifiSettings wifiSettings;
    private boolean hostModeEnabled;
    private BGridPane sapAdapterPane;
    private BLabel sapAdapterLabel;
    private BIpHostFE sapAdapterIpAddressFE;
    private BIpHostFE sapAdapterSubnetMaskFE;
    private BGridPane sapDhcpdPane;
    private BRelTimeFE sapDhcpdLeaseTimeField;
    private BRelTimeFE sapDhcpdMaxLeaseTimeField;
    private BIpHostFE sapDhcpdSubnetField;
    private BIpHostFE sapDhcpdNetmaskField;
    private BIpHostFE sapDhcpdRangeStartField;
    private BIntegerFE sapDhcpdRangeSize;
    private BGridPane sapConfigPane;
    private BTextField sapSsidField;
    private BCheckBox sapBroadcastSsidCheckBox;
    private BPasswordFE sapPassphraseField;
    private BCheckBox sapShowPassphraseCheckBox;
    private BLimitedFrozenEnumFE sapWpaField;
    private BLimitedFrozenEnumFE sapWpaKeyMgmtField;
    private BLimitedFrozenEnumFE sapWpaPairwiseField;
    private BRelTimeFE sapTimeoutField;
    private BLabel sapRadioCfgTextInfo;
    private ConfigAllowListCommand configAllowListCommand;
    private BCheckBox sapUseAllowListCheckBox;
    private ShowClientsCommand showClientsCommand;
    private static final int MAX_BAND_24_CHANNEL = 15;
    private ConfigChannelsCommand configChannelsCommand;
    private int sapChannel;
    private BHapdHwModeEnum sapHwMode;
    private BHtCapabilityEnum sapHtCapability;
    private BFacets rangeFacets = DHCP_SERVER_RANGE_FACETS;
    private static final BFacets TRIDIUM_LEGACY_DHCP_SERVER_RANGE_FACETS = BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)16));
    private static final BFacets DHCP_SERVER_RANGE_FACETS = BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)8));
    private static final Logger LOG = Logger.getLogger("plat.wifi");
    private static final Lexicon LEX = Lexicon.make((String)"platWifi");

    @Generated
    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    @Generated
    public void handleAdapterAddressChanged() {
        this.invoke(handleAdapterAddressChanged, null, null);
    }

    @Generated
    public void handlePassphraseChanged() {
        this.invoke(handlePassphraseChanged, null, null);
    }

    @Generated
    public void handleShowPassphraseChecked() {
        this.invoke(handleShowPassphraseChecked, null, null);
    }

    @Generated
    public void handleAllowListChecked() {
        this.invoke(handleAllowListChecked, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiAccessPointManager() {
    }

    public BWifiAccessPointManager(BDaemonSession daemonSession) {
        this.daemonSession = daemonSession;
    }

    protected void doLoadValue(BObject value, Context contextIn) {
        this.autoRegisterForComponentEvents = false;
        this.wifiSettings = (BWifiSettings)value;
        this.sapAdapterPane = new BGridPane(2);
        this.sapAdapterPane.setValign(BValign.top);
        this.sapAdapterPane.setRowAlign(BValign.center);
        this.sapAdapterPane.setColumnAlign(BHalign.left);
        this.sapAdapterPane.setRowGap(5.0);
        this.sapAdapterPane.setColumnGap(10.0);
        this.sapAdapterPane.setStretchColumn(1);
        this.sapAdapterPane.setUniformRowHeight(true);
        this.sapAdapterLabel = new BLabel("");
        LabelUtil.addLabelWidgetPair((BPane)this.sapAdapterPane, (String)LEX.getText("WifiAccessPointManager.adapterSettings.sapAdapterName.label"), (BWidget)this.sapAdapterLabel);
        this.sapAdapterIpAddressFE = new BIpHostFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapAdapterPane, (String)LEX.getText("WifiAccessPointManager.adapterSettings.sapAdapterIp.label"), (BWidget)this.sapAdapterIpAddressFE);
        this.sapAdapterSubnetMaskFE = new BIpHostFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapAdapterPane, (String)LEX.getText("WifiAccessPointManager.adapterSettings.sapAdapterNetmask.label"), (BWidget)this.sapAdapterSubnetMaskFE);
        this.linkTo(null, (BComponent)this.sapAdapterIpAddressFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapAdapterIpAddressFE, (Slot)BIpHostFE.propagateKeyEvent, (Slot)handleAdapterAddressChanged);
        this.linkTo(null, (BComponent)this.sapAdapterSubnetMaskFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapAdapterSubnetMaskFE, (Slot)BIpHostFE.propagateKeyEvent, (Slot)handleAdapterAddressChanged);
        BBorderPane adapterBorder = new BBorderPane((BWidget)this.sapAdapterPane);
        adapterBorder.setBorder(BBorder.solid);
        adapterBorder.setLabel((BWidget)LabelUtil.makeLabel((String)LEX.getText("WifiAccessPointManager.adapterSettings.label"), (boolean)true));
        adapterBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)6.0, (double)0.0));
        this.sapDhcpdPane = new BGridPane(2);
        this.sapDhcpdPane.setValign(BValign.top);
        this.sapDhcpdPane.setRowAlign(BValign.center);
        this.sapDhcpdPane.setColumnAlign(BHalign.left);
        this.sapDhcpdPane.setRowGap(5.0);
        this.sapDhcpdPane.setColumnGap(10.0);
        this.sapDhcpdPane.setStretchColumn(1);
        this.sapDhcpdPane.setUniformRowHeight(true);
        this.sapDhcpdLeaseTimeField = new BRelTimeFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapDhcpdPane, (String)LEX.getText("WifiAccessPointManager.dhcpdSettings.defaultLeaseTime.label"), (BWidget)this.sapDhcpdLeaseTimeField);
        this.sapDhcpdMaxLeaseTimeField = new BRelTimeFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapDhcpdPane, (String)LEX.getText("WifiAccessPointManager.dhcpdSettings.maxLeaseTime.label"), (BWidget)this.sapDhcpdMaxLeaseTimeField);
        this.sapDhcpdSubnetField = new BIpHostFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapDhcpdPane, (String)LEX.getText("WifiAccessPointManager.dhcpdSettings.subnet.label"), (BWidget)this.sapDhcpdSubnetField);
        this.sapDhcpdNetmaskField = new BIpHostFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapDhcpdPane, (String)LEX.getText("WifiAccessPointManager.dhcpdSettings.netmask.label"), (BWidget)this.sapDhcpdNetmaskField);
        this.sapDhcpdRangeStartField = new BIpHostFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapDhcpdPane, (String)LEX.getText("WifiAccessPointManager.dhcpdSettings.rangestart.label"), (BWidget)this.sapDhcpdRangeStartField);
        this.sapDhcpdRangeSize = new BIntegerFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapDhcpdPane, (String)LEX.getText("WifiAccessPointManager.dhcpdSettings.rangesize.label"), (BWidget)this.sapDhcpdRangeSize);
        if (this.daemonSession != null && WiFiServletType.qnxwifi.equals((Object)WifiUtil.getWiFiServletType((BDaemonSession)this.daemonSession))) {
            this.rangeFacets = TRIDIUM_LEGACY_DHCP_SERVER_RANGE_FACETS;
        }
        this.linkTo(null, (BComponent)this.sapDhcpdLeaseTimeField, (Slot)BRelTimeFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapDhcpdMaxLeaseTimeField, (Slot)BRelTimeFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapDhcpdSubnetField, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapDhcpdNetmaskField, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapDhcpdRangeStartField, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapDhcpdRangeSize, (Slot)BIntegerFE.pluginModified, (Slot)setModified);
        BBorderPane dhcpdBorder = new BBorderPane((BWidget)this.sapDhcpdPane);
        dhcpdBorder.setBorder(BBorder.solid);
        dhcpdBorder.setLabel((BWidget)LabelUtil.makeLabel((String)LEX.getText("WifiAccessPointManager.dhcpdSettings.label"), (boolean)true));
        dhcpdBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)6.0, (double)0.0));
        this.sapConfigPane = new BGridPane(2);
        this.sapConfigPane.setValign(BValign.top);
        this.sapConfigPane.setRowAlign(BValign.center);
        this.sapConfigPane.setColumnAlign(BHalign.left);
        this.sapConfigPane.setRowGap(5.0);
        this.sapConfigPane.setColumnGap(10.0);
        this.sapConfigPane.setStretchColumn(1);
        this.sapConfigPane.setUniformRowHeight(false);
        this.sapSsidField = new BTextField("", 34);
        this.sapBroadcastSsidCheckBox = new BCheckBox(LEX.getText("WifiAccessPointManager.sapSettings.broadcastSsid.label"), false);
        BFlowPane ssidEditor = new BFlowPane();
        ssidEditor.add("ssid", (BValue)this.sapSsidField);
        ssidEditor.add("broadcast", (BValue)this.sapBroadcastSsidCheckBox);
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (String)LEX.getText("WifiAccessPointManager.sapSettings.ssid.label"), (BWidget)ssidEditor);
        this.sapPassphraseField = new BPasswordFE();
        this.sapShowPassphraseCheckBox = new BCheckBox(LEX.getText("WifiAccessPointManager.sapSettings.showPassphrase.label"), false);
        BFlowPane passphraseEditor = new BFlowPane();
        passphraseEditor.add("passphrase", (BValue)this.sapPassphraseField);
        passphraseEditor.add("show", (BValue)this.sapShowPassphraseCheckBox);
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (String)LEX.getText("WifiAccessPointManager.sapSettings.psk.label"), (BWidget)passphraseEditor);
        this.sapWpaField = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (String)LEX.getText("WifiAccessPointManager.sapSettings.wpa.label"), (BWidget)this.sapWpaField);
        this.sapWpaKeyMgmtField = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (String)LEX.getText("WifiAccessPointManager.sapSettings.keymgmt.label"), (BWidget)this.sapWpaKeyMgmtField);
        this.sapWpaPairwiseField = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (String)LEX.getText("WifiAccessPointManager.sapSettings.pairwise.label"), (BWidget)this.sapWpaPairwiseField);
        this.sapTimeoutField = new BRelTimeFE();
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (String)LEX.getText("WifiAccessPointManager.sapSettings.sapTo.label"), (BWidget)this.sapTimeoutField);
        BFlowPane configChannelFlowPane = new BFlowPane();
        this.sapRadioCfgTextInfo = new BLabel("");
        this.configChannelsCommand = new ConfigChannelsCommand((BWidget)this);
        configChannelFlowPane.add("button", (BValue)new BButton((Command)this.configChannelsCommand));
        configChannelFlowPane.add("summary", (BValue)this.sapRadioCfgTextInfo);
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (String)LEX.getText("WifiAccessPointManager.sapSettings.configChannels.label"), (BWidget)configChannelFlowPane);
        BFlowPane allowListFlowPane = new BFlowPane();
        this.sapUseAllowListCheckBox = new BCheckBox(LEX.getText("WifiAccessPointManager.sapSettings.allowListCheckBox.label"), false);
        this.configAllowListCommand = new ConfigAllowListCommand((BWidget)this);
        allowListFlowPane.add("button", (BValue)new BButton((Command)this.configAllowListCommand));
        allowListFlowPane.add("checkbox", (BValue)this.sapUseAllowListCheckBox);
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (String)LEX.getText("WifiAccessPointManager.sapSettings.allowList.label"), (BWidget)allowListFlowPane);
        BFlowPane clientsFlowPane = new BFlowPane();
        this.showClientsCommand = new ShowClientsCommand((BWidget)this);
        clientsFlowPane.add("button", (BValue)new BButton((Command)this.showClientsCommand));
        LabelUtil.addLabelWidgetPair((BPane)this.sapConfigPane, (String)LEX.getText("WifiAccessPointManager.sapSettings.showClients.label"), (BWidget)clientsFlowPane);
        this.linkTo(null, (BComponent)this.sapSsidField, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapBroadcastSsidCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapPassphraseField, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapPassphraseField, (Slot)BPasswordFE.pluginModified, (Slot)handlePassphraseChanged);
        this.linkTo(null, (BComponent)this.sapShowPassphraseCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)handleShowPassphraseChecked);
        this.linkTo(null, (BComponent)this.sapWpaField, (Slot)BFrozenEnumFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapWpaKeyMgmtField, (Slot)BFrozenEnumFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapWpaPairwiseField, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapTimeoutField, (Slot)BIntegerFE.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapUseAllowListCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.sapUseAllowListCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)handleAllowListChecked);
        BBorderPane sapConfigBorder = new BBorderPane((BWidget)this.sapConfigPane);
        sapConfigBorder.setBorder(BBorder.solid);
        sapConfigBorder.setLabel((BWidget)LabelUtil.makeLabel((String)LEX.getText("WifiAccessPointManager.sapSettings.label"), (boolean)true));
        sapConfigBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)6.0, (double)0.0));
        BGridPane assembledPanes = new BGridPane(1);
        assembledPanes.setValign(BValign.top);
        assembledPanes.setRowAlign(BValign.center);
        assembledPanes.setColumnAlign(BHalign.fill);
        assembledPanes.setStretchColumn(0);
        assembledPanes.setUniformColumnWidth(true);
        assembledPanes.add("adapterBorder", (BValue)adapterBorder);
        assembledPanes.add("dhcpdBorder", (BValue)dhcpdBorder);
        assembledPanes.add("sapConfigBorder", (BValue)sapConfigBorder);
        this.setContent((BWidget)new BScrollPane((BWidget)new BBorderPane((BWidget)assembledPanes)));
        this.refreshSettings(this.wifiSettings, contextIn);
        this.doSetEnabledStates();
    }

    protected BObject doSaveValue(BObject value, Context context) throws Exception {
        int lastOctet;
        int endLastOctet;
        byte[] endIpBytes;
        String endClientAddress;
        String dhcpEndAddressPrefix;
        byte[] subnetBytes;
        String dhcpStartAddressPrefix;
        int usableHosts;
        int range;
        if (!this.isModified()) {
            return value;
        }
        if (value == null) {
            return null;
        }
        BWifiSettings wifiSettings = (BWifiSettings)value;
        String sapIpAddress = ((BString)this.sapAdapterIpAddressFE.saveValue(context)).getString().trim();
        String sapSubnetMask = ((BString)this.sapAdapterSubnetMaskFE.saveValue(context)).getString().trim();
        if (sapIpAddress.isEmpty()) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapIpAdapterEditor.nullIpAddress");
        }
        if (sapSubnetMask.isEmpty()) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapIpAdapterEditor.nullSubnetMask");
        }
        if (!IPAddressUtil.isIpv4Address((String)sapIpAddress)) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapIpAdapterEditor.invalidIpAddressValue");
        }
        if (!IPAddressUtil.isIpv4SubnetMask((String)sapSubnetMask)) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapIpAdapterEditor.invalidSubnetMaskValue");
        }
        String sapSubnet = IPAddressUtil.getIPv4NetworkPrefix((String)sapIpAddress, (String)sapSubnetMask);
        BTcpIpHostSettings tcpIpHostSettings = wifiSettings.getTcpIpHostSettings();
        SlotCursor c = tcpIpHostSettings.getAdapters().getProperties();
        while (c.next(BTcpIpAdapterSettings.class)) {
            String adapterSubnet;
            BTcpIpAdapterSettings tcpIpAdapterSettings = (BTcpIpAdapterSettings)c.get();
            String ipAddress = tcpIpAdapterSettings.getIpAddress();
            String netmask = tcpIpAdapterSettings.getSubnetMask();
            if (!IPAddressUtil.isIpv4Address((String)ipAddress) || !IPAddressUtil.isIpv4SubnetMask((String)netmask) || IPAddressUtil.compare((Object)sapSubnet, (Object)(adapterSubnet = IPAddressUtil.getIPv4NetworkPrefix((String)ipAddress, (String)netmask))) != 0) continue;
            this.saveError(wifiSettings.getSapAdapterName(), "SapIpAdapterEditor.duplicateSubnet");
        }
        wifiSettings.setSapAdapterIp(sapIpAddress);
        wifiSettings.setSapAdapterNetmask(sapSubnetMask);
        BDhcpdHostSettings dhcpdHostSettings = wifiSettings.getDhcpdHostSettings();
        BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(wifiSettings.getSapAdapterName());
        dhcpdAdapterSettings.setIsDhcpdIpv4Supported(true);
        dhcpdAdapterSettings.setIsDhcpdIpv4Enabled(true);
        dhcpdAdapterSettings.setDefaultLeaseTime((BRelTime)this.sapDhcpdLeaseTimeField.saveValue(context));
        dhcpdAdapterSettings.setMaxLeaseTime((BRelTime)this.sapDhcpdMaxLeaseTimeField.saveValue(context));
        String sapDhcpdSubnet = ((BString)this.sapDhcpdSubnetField.saveValue(context)).getString().trim();
        String sapDhcpdMask = ((BString)this.sapDhcpdNetmaskField.saveValue(context)).getString().trim();
        if (sapDhcpdSubnet.isEmpty()) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdSubnet.nullSubnet");
        }
        if (sapDhcpdMask.isEmpty()) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdNetmask.nullSubnetMask");
        }
        if (!IPAddressUtil.isIpv4Address((String)sapDhcpdSubnet) || IPAddressUtil.compare((Object)sapDhcpdSubnet, (Object)sapSubnet) != 0) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdSubnet.invalidSubnet");
        }
        if (!IPAddressUtil.isIpv4SubnetMask((String)sapDhcpdMask) || IPAddressUtil.compare((Object)sapDhcpdMask, (Object)sapSubnetMask) != 0) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdNetmask.invalidSubnetMask");
        }
        if (!sapDhcpdSubnet.equals(IPAddressUtil.getIPv4NetworkPrefix((String)sapDhcpdSubnet, (String)sapDhcpdMask))) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdSubnet.invalidSubnet");
        }
        dhcpdAdapterSettings.setSubnet(sapDhcpdSubnet);
        dhcpdAdapterSettings.setSubnetMask(sapDhcpdMask);
        String startClientAddress = ((BString)this.sapDhcpdRangeStartField.saveValue(context)).getString().trim();
        if (startClientAddress.isEmpty()) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdStart.nullStart");
        }
        if (!IPAddressUtil.isIpv4Address((String)startClientAddress)) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdStart.invalidStart");
        }
        if ((range = ((BInteger)this.sapDhcpdRangeSize.saveValue(context)).getInt()) < this.rangeFacets.geti("min", -1)) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdRange.rangeLessThanOne");
            range = this.rangeFacets.geti("min", -1);
        }
        if (range > this.rangeFacets.geti("max", -1)) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdRange.rangeTooBig");
            range = this.rangeFacets.geti("max", -1);
        }
        if (range > (usableHosts = Math.max(DhcpdUtil.getUsableHosts((String)sapDhcpdMask) - 1, 0))) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdRange.rangeTooBigUsableHosts");
        }
        if (IPAddressUtil.compare((Object)(dhcpStartAddressPrefix = IPAddressUtil.getIPv4NetworkPrefix((String)startClientAddress, (String)sapDhcpdMask)), (Object)sapSubnet) != 0) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdRange.startAddrNotInSubnet");
        }
        if ((subnetBytes = IPAddressUtil.numericStringToByteArray((String)sapDhcpdSubnet)) == null) {
            throw new Exception("SapDhcpdSubnet.invalidSubnet");
        }
        byte[] subnetMaskBytes = IPAddressUtil.numericStringToByteArray((String)sapDhcpdMask);
        if (subnetMaskBytes == null) {
            throw new Exception("SapDhcpdNetmask.invalidSubnetMask");
        }
        byte[] startIpBytes = IPAddressUtil.numericStringToByteArray((String)startClientAddress);
        if (startIpBytes == null) {
            throw new Exception("SapDhcpdStart.invalidStart");
        }
        byte[] broadcastBytes = new byte[subnetBytes.length];
        for (int i = 0; i < subnetBytes.length; ++i) {
            broadcastBytes[i] = (byte)(subnetBytes[i] | ~subnetMaskBytes[i]);
        }
        boolean isNetworkAddress = startClientAddress.equals(sapDhcpdSubnet);
        boolean isFirstUsableAddress = startClientAddress.equals(DhcpdUtil.getNextIpAddress((String)sapDhcpdSubnet));
        boolean isBroadcastAddress = ByteArrayUtil.equals((byte[])startIpBytes, (byte[])broadcastBytes);
        if (isNetworkAddress || isFirstUsableAddress || isBroadcastAddress) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdStart.invalidStartAddressNotInUsableRange");
        }
        if (IPAddressUtil.compare((Object)(dhcpEndAddressPrefix = IPAddressUtil.getIPv4NetworkPrefix((String)(endClientAddress = DhcpdUtil.getEndIpAddress((String)startClientAddress, (int)range)), (String)sapDhcpdMask)), (Object)sapSubnet) != 0) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdRange.endAddrNotInSubnet");
        }
        if ((endIpBytes = IPAddressUtil.numericStringToByteArray((String)endClientAddress)) == null) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdStart.invalidStart");
        }
        if (isBroadcastAddress = ByteArrayUtil.equals((byte[])endIpBytes, (byte[])broadcastBytes)) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdStart.invalidStartAddressNotInUsableRange");
        }
        if ((endLastOctet = (lastOctet = startIpBytes[3] & 0xFF) + range - 1) > 255) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdRange.endAddrTooBig");
        }
        if (IPAddressUtil.compare((Object)startClientAddress, (Object)sapIpAddress) != 1 && IPAddressUtil.compare((Object)endClientAddress, (Object)sapIpAddress) != -1) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapDhcpdRange.adapterInClientRange");
        }
        dhcpdAdapterSettings.setRange(range);
        dhcpdAdapterSettings.setStartClientAddress(startClientAddress);
        String ssid = this.sapSsidField.getText();
        if (ssid.isEmpty()) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapSSIDField.nullSSID");
        } else if (ssid.length() > 32) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapSSIDField.SSIDTooLong");
        }
        wifiSettings.setSapSsid(ssid);
        wifiSettings.setIgnoreBroadcastSsid(this.sapBroadcastSsidCheckBox.getSelected() ? 0 : 1);
        BPassword sapPassphrase = (BPassword)this.sapPassphraseField.saveValue(context);
        String tempSapPassphrase = AccessController.doPrivileged(() -> ((BPassword)sapPassphrase).getValue());
        if (tempSapPassphrase.length() < 10) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapWpaPassphraseField.invalidPassphraseTooShort");
        } else if (tempSapPassphrase.length() > 64) {
            this.saveError(wifiSettings.getSapAdapterName(), "SapWpaPassphraseField.invalidPassphraseTooLong");
        } else if (tempSapPassphrase.length() == 64) {
            if (!TextUtil.isHex((String)tempSapPassphrase)) {
                this.saveError(wifiSettings.getSapAdapterName(), "SapWpaPassphraseField.invalidPassphraseHexCharacter");
            }
        } else {
            char[] passphraseChars;
            for (char passphraseChar : passphraseChars = tempSapPassphrase.toCharArray()) {
                if (passphraseChar >= ' ' && passphraseChar <= '~') continue;
                this.saveError(wifiSettings.getSapAdapterName(), LEX.getText("SapWpaPassphraseField.invalidPassphraseAsciiCharacter", new Object[]{String.valueOf(passphraseChar)}));
            }
        }
        if (!TextUtil.isHex((String)tempSapPassphrase)) {
            try {
                BPasswordStrength.STRONG.isPasswordValid(tempSapPassphrase);
            }
            catch (Exception strengthException) {
                this.saveError(wifiSettings.getSapAdapterName(), strengthException.getLocalizedMessage());
            }
        }
        wifiSettings.setSapWpaPassphrase(sapPassphrase);
        wifiSettings.setSapWpa((BHapdWpaConfigEnum)this.sapWpaField.saveValue(context));
        wifiSettings.setSapWpaKeyMgmt((BHapdKeyManagementEnum)this.sapWpaKeyMgmtField.saveValue(context));
        wifiSettings.setSapWpaPairwise((BHapdEncryptionMethod)this.sapWpaPairwiseField.saveValue(context));
        wifiSettings.setSapTimeout((BRelTime)this.sapTimeoutField.saveValue(context));
        wifiSettings.setSapHwMode(this.sapHwMode);
        wifiSettings.setSapHtCapab(this.sapHtCapability);
        wifiSettings.setSapChannel(this.sapChannel);
        if (this.sapChannel < 15) {
            wifiSettings.setSapFreqBand(BWifiFreqBandEnum.band24);
        } else {
            wifiSettings.setSapFreqBand(BWifiFreqBandEnum.band50);
        }
        wifiSettings.setUseAllowList(this.sapUseAllowListCheckBox.getSelected());
        this.refreshSettings(wifiSettings, null);
        return wifiSettings;
    }

    protected void doSetReadonly(boolean readOnly) {
        this.doSetEnabledStates();
    }

    public void refreshSettings(BWifiSettings wifiSettings, Context contextIn) {
        Context context;
        if (wifiSettings == null || this.sapAdapterLabel == null || this.sapAdapterIpAddressFE == null || this.sapAdapterSubnetMaskFE == null || this.sapDhcpdLeaseTimeField == null || this.sapDhcpdMaxLeaseTimeField == null || this.sapDhcpdSubnetField == null || this.sapDhcpdNetmaskField == null || this.sapDhcpdRangeStartField == null || this.sapDhcpdRangeSize == null || this.sapSsidField == null || this.sapBroadcastSsidCheckBox == null || this.sapPassphraseField == null || this.sapShowPassphraseCheckBox == null || this.sapWpaField == null || this.sapWpaKeyMgmtField == null || this.sapWpaPairwiseField == null || this.sapTimeoutField == null || this.sapRadioCfgTextInfo == null || this.sapUseAllowListCheckBox == null) {
            return;
        }
        BWifiSwitchEnum wifiSwitchEnum = wifiSettings.getMonitorData().getWifiSwitchPosition();
        this.hostModeEnabled = wifiSwitchEnum.getOrdinal() == 2 || wifiSwitchEnum.getOrdinal() == 3;
        Object object = context = contextIn == null ? new BasicContext() : contextIn;
        if (context.getFacets().get("poll", (BObject)BBoolean.FALSE).equals((Object)BBoolean.TRUE)) {
            return;
        }
        this.lockModifiedState();
        boolean alreadyModified = this.isModified();
        this.sapAdapterLabel.setText(wifiSettings.getSapAdapterName());
        this.sapAdapterIpAddressFE.loadValue((BObject)BString.make((String)wifiSettings.getSapAdapterIp()));
        this.sapAdapterSubnetMaskFE.loadValue((BObject)BString.make((String)wifiSettings.getSapAdapterNetmask()));
        BDhcpdHostSettings dhcpdHostSettings = wifiSettings.getDhcpdHostSettings();
        BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(wifiSettings.getSapAdapterName());
        if (dhcpdAdapterSettings == null) {
            String adapterName = wifiSettings.getSapAdapterName();
            String propName = SlotPath.escape((String)adapterName);
            dhcpdAdapterSettings = new BDhcpdAdapterSettings();
            dhcpdAdapterSettings.setAdapterId(adapterName);
            dhcpdAdapterSettings.setAdapterOsName(adapterName);
            dhcpdAdapterSettings.setIsReadOnly(false);
            dhcpdAdapterSettings.setIsDhcpdIpv4Supported(true);
            dhcpdAdapterSettings.setIsDhcpdIpv4Enabled(true);
            dhcpdHostSettings.getDhcpdSubnets().add(propName, (BValue)dhcpdAdapterSettings, 3);
        }
        this.sapDhcpdLeaseTimeField.loadValue((BObject)dhcpdAdapterSettings.getDefaultLeaseTime(), (Context)new BasicContext(context, BDhcpdAdapterSettings.defaultLeaseTime.getFacets()));
        this.sapDhcpdMaxLeaseTimeField.loadValue((BObject)dhcpdAdapterSettings.getMaxLeaseTime(), (Context)new BasicContext(context, BDhcpdAdapterSettings.maxLeaseTime.getFacets()));
        this.sapDhcpdSubnetField.loadValue((BObject)BString.make((String)dhcpdAdapterSettings.getSubnet()));
        this.sapDhcpdNetmaskField.loadValue((BObject)BString.make((String)dhcpdAdapterSettings.getSubnetMask()));
        this.sapDhcpdRangeStartField.loadValue((BObject)BString.make((String)dhcpdAdapterSettings.getStartClientAddress()));
        this.sapDhcpdRangeSize.loadValue((BObject)BInteger.make((int)dhcpdAdapterSettings.getRange()), (Context)new BasicContext(context, this.rangeFacets));
        this.sapSsidField.setText(wifiSettings.getSapSsid());
        this.sapBroadcastSsidCheckBox.setSelected(wifiSettings.getIgnoreBroadcastSsid() == 0);
        this.sapPassphraseField.loadValue((BObject)wifiSettings.getSapWpaPassphrase(), (Context)new BasicContext(context, BWifiSettings.sapWpaPassphrase.getFacets()));
        this.sapShowPassphraseCheckBox.setSelected(false);
        this.sapShowPassphraseCheckBox.setEnabled(false);
        this.sapWpaField.loadValue((BObject)wifiSettings.getSapWpa(), (Context)new BasicContext(context, BWifiSettings.sapWpa.getFacets()));
        this.sapWpaKeyMgmtField.loadValue((BObject)wifiSettings.getSapWpaKeyMgmt(), (Context)new BasicContext(context, BWifiSettings.sapWpaKeyMgmt.getFacets()));
        this.sapWpaPairwiseField.loadValue((BObject)wifiSettings.getSapWpaPairwise(), (Context)new BasicContext(context, BWifiSettings.sapWpaPairwise.getFacets()));
        this.sapTimeoutField.loadValue((BObject)wifiSettings.getSapTimeout(), (Context)new BasicContext(context, BWifiSettings.sapTimeout.getFacets()));
        this.sapChannel = wifiSettings.getSapChannel();
        this.sapHwMode = wifiSettings.getSapHwMode();
        this.sapHtCapability = wifiSettings.getSapHtCapab();
        this.sapRadioCfgTextInfo.setText(BWifiAccessPointManager.getRadioConfigString(this.sapHwMode, this.sapChannel));
        this.sapUseAllowListCheckBox.setSelected(wifiSettings.getUseAllowList());
        this.unlockModifiedState();
        if (!alreadyModified) {
            this.clearModified();
        }
    }

    private static String getRadioConfigString(BHapdHwModeEnum mode, int channel) {
        if (channel == 0) {
            return LEX.getText("RadioConfigDialog.channelNotSet.label");
        }
        return LEX.getText("RadioConfigDialog.mode.label") + " " + mode + " " + LEX.getText("RadioConfigDialog.channel.label") + " " + channel;
    }

    private void saveError(String interfaceId, String messageTag) throws CannotSaveException {
        Objects.requireNonNull(messageTag, "messageTag argument cannot be null");
        if (this.widgetSupport(null) != null) {
            BDialog.error((BWidget)this, (String)LEX.getText("SapIpAdapterEditor.invalidDataTitle"), (Object)(interfaceId + ": " + LEX.getText(messageTag)));
            CannotSaveException cannotSaveException = new CannotSaveException(interfaceId + ": " + LEX.getText(messageTag));
            cannotSaveException.setSilent(true);
            throw cannotSaveException;
        }
        throw new CannotSaveException(interfaceId + ": " + LEX.getText(messageTag));
    }

    public void doSetEnabledStates() {
        boolean editorEnabled;
        boolean readOnly = this.isReadonly();
        boolean actionsEnabled = this.hostModeEnabled && !readOnly;
        boolean bl = editorEnabled = !readOnly;
        if (this.sapAdapterPane != null) {
            this.sapAdapterPane.setEnabled(editorEnabled);
        }
        if (this.sapAdapterIpAddressFE != null) {
            this.sapAdapterIpAddressFE.setEnabled(editorEnabled);
            this.sapAdapterIpAddressFE.setReadonly(readOnly);
        }
        if (this.sapAdapterSubnetMaskFE != null) {
            this.sapAdapterSubnetMaskFE.setEnabled(editorEnabled);
            this.sapAdapterSubnetMaskFE.setReadonly(readOnly);
        }
        if (this.sapDhcpdPane != null) {
            this.sapDhcpdPane.setEnabled(editorEnabled);
        }
        if (this.sapDhcpdLeaseTimeField != null) {
            this.sapDhcpdLeaseTimeField.setEnabled(editorEnabled);
            this.sapDhcpdLeaseTimeField.setReadonly(readOnly);
        }
        if (this.sapDhcpdMaxLeaseTimeField != null) {
            this.sapDhcpdMaxLeaseTimeField.setEnabled(editorEnabled);
            this.sapDhcpdMaxLeaseTimeField.setReadonly(readOnly);
        }
        if (this.sapDhcpdSubnetField != null) {
            this.sapDhcpdSubnetField.setEnabled(editorEnabled);
            this.sapDhcpdSubnetField.setReadonly(true);
        }
        if (this.sapDhcpdNetmaskField != null) {
            this.sapDhcpdNetmaskField.setEnabled(editorEnabled);
            this.sapDhcpdNetmaskField.setReadonly(true);
        }
        if (this.sapDhcpdRangeStartField != null) {
            this.sapDhcpdRangeStartField.setEnabled(editorEnabled);
            this.sapDhcpdRangeStartField.setReadonly(readOnly);
        }
        if (this.sapDhcpdRangeSize != null) {
            this.sapDhcpdRangeSize.setEnabled(editorEnabled);
            this.sapDhcpdRangeSize.setReadonly(readOnly);
        }
        if (this.sapConfigPane != null) {
            this.sapConfigPane.setEnabled(editorEnabled);
        }
        if (this.sapSsidField != null) {
            this.sapSsidField.setEnabled(editorEnabled);
        }
        if (this.sapBroadcastSsidCheckBox != null) {
            this.sapBroadcastSsidCheckBox.setEnabled(editorEnabled);
        }
        if (this.sapPassphraseField != null) {
            this.sapPassphraseField.setEnabled(editorEnabled);
            this.sapPassphraseField.setReadonly(readOnly);
        }
        if (this.sapShowPassphraseCheckBox != null && !editorEnabled) {
            this.sapShowPassphraseCheckBox.setSelected(false);
            this.sapShowPassphraseCheckBox.setEnabled(false);
            this.doHandleShowPassphraseChecked();
        }
        if (this.sapWpaField != null) {
            this.sapWpaField.setEnabled(editorEnabled);
            this.sapWpaField.setReadonly(readOnly);
        }
        if (this.sapWpaKeyMgmtField != null) {
            this.sapWpaKeyMgmtField.setEnabled(editorEnabled);
            this.sapWpaKeyMgmtField.setReadonly(readOnly);
        }
        if (this.sapWpaPairwiseField != null) {
            this.sapWpaPairwiseField.setEnabled(editorEnabled);
            this.sapWpaPairwiseField.setReadonly(readOnly);
        }
        if (this.sapTimeoutField != null) {
            this.sapTimeoutField.setEnabled(editorEnabled);
            this.sapTimeoutField.setReadonly(readOnly);
        }
        if (this.configChannelsCommand != null) {
            this.configChannelsCommand.setEnabled(editorEnabled);
        }
        if (this.sapRadioCfgTextInfo != null) {
            this.sapRadioCfgTextInfo.setEnabled(editorEnabled);
        }
        if (this.configAllowListCommand != null) {
            this.configAllowListCommand.setEnabled(editorEnabled);
        }
        if (this.sapUseAllowListCheckBox != null) {
            this.sapUseAllowListCheckBox.setEnabled(editorEnabled);
        }
        if (this.showClientsCommand != null) {
            this.showClientsCommand.setEnabled(actionsEnabled);
        }
    }

    public void doHandleAdapterAddressChanged() {
        String sapAdapterNetmask;
        String sapAdapterIpAddress;
        try {
            sapAdapterIpAddress = ((BString)this.sapAdapterIpAddressFE.saveValue()).getString();
            sapAdapterNetmask = ((BString)this.sapAdapterSubnetMaskFE.saveValue()).getString();
        }
        catch (Exception ignored) {
            return;
        }
        if (!IPAddressUtil.isIpv4Address((String)sapAdapterIpAddress) || !IPAddressUtil.isIpv4SubnetMask((String)sapAdapterNetmask)) {
            return;
        }
        String sapAdapterSubnet = IPAddressUtil.getIPv4NetworkPrefix((String)sapAdapterIpAddress, (String)sapAdapterNetmask);
        this.sapDhcpdSubnetField.loadValue((BObject)BString.make((String)sapAdapterSubnet));
        this.sapDhcpdSubnetField.setModified();
        this.sapDhcpdNetmaskField.loadValue((BObject)BString.make((String)sapAdapterNetmask));
        this.sapDhcpdNetmaskField.setModified();
        String currentDhcpdStartClientAddress = "";
        try {
            currentDhcpdStartClientAddress = ((BString)this.sapDhcpdRangeStartField.saveValue()).getString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String suggestedDhcpdStartAddress = !currentDhcpdStartClientAddress.isEmpty() ? currentDhcpdStartClientAddress : DhcpdUtil.getNextIpAddress((String)sapAdapterIpAddress);
        String adjustedDhcpdStartClientAddress = DhcpdUtil.fixDhcpdAdapterSettingsStartAddress((String)suggestedDhcpdStartAddress, (String)sapAdapterSubnet, (String)sapAdapterNetmask);
        if (IPAddressUtil.compare((Object)adjustedDhcpdStartClientAddress, (Object)sapAdapterIpAddress) <= 0) {
            adjustedDhcpdStartClientAddress = DhcpdUtil.getNextIpAddress((String)sapAdapterIpAddress);
        }
        int currentDhcpdRange = 0;
        try {
            currentDhcpdRange = ((BInteger)this.sapDhcpdRangeSize.saveValue()).getInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int suggestedDhcpdRange = currentDhcpdRange != 0 ? currentDhcpdRange : ((BInteger)BDhcpdAdapterSettings.range.getDefaultValue()).getInt();
        int minClients = this.rangeFacets.geti("min", -1);
        int maxClient = this.rangeFacets.geti("max", -1);
        int adjustedDhcpdRange = DhcpdUtil.fixDhcpdAdapterSettingsRange((int)suggestedDhcpdRange, (int)minClients, (int)maxClient, (String)sapAdapterNetmask);
        String endClientAddress = DhcpdUtil.getEndIpAddress((String)adjustedDhcpdStartClientAddress, (int)adjustedDhcpdRange);
        String dhcpEndAddressPrefix = IPAddressUtil.getIPv4NetworkPrefix((String)endClientAddress, (String)sapAdapterNetmask);
        if (IPAddressUtil.compare((Object)dhcpEndAddressPrefix, (Object)sapAdapterSubnet) != 0) {
            while (adjustedDhcpdRange >= minClients && IPAddressUtil.compare((Object)dhcpEndAddressPrefix, (Object)sapAdapterSubnet) != 0) {
                endClientAddress = DhcpdUtil.getEndIpAddress((String)adjustedDhcpdStartClientAddress, (int)(--adjustedDhcpdRange));
                dhcpEndAddressPrefix = IPAddressUtil.getIPv4NetworkPrefix((String)endClientAddress, (String)sapAdapterNetmask);
            }
            if (adjustedDhcpdRange != currentDhcpdRange && adjustedDhcpdRange > minClients) {
                --adjustedDhcpdRange;
            }
        }
        if (IPAddressUtil.compare((Object)adjustedDhcpdStartClientAddress, (Object)currentDhcpdStartClientAddress) != 0) {
            this.sapDhcpdRangeStartField.loadValue((BObject)BString.make((String)adjustedDhcpdStartClientAddress));
            this.sapDhcpdRangeStartField.setModified();
        }
        if (adjustedDhcpdRange != currentDhcpdRange) {
            this.sapDhcpdRangeSize.loadValue((BObject)BInteger.make((int)adjustedDhcpdRange), (Context)this.rangeFacets);
            this.sapDhcpdRangeSize.setModified();
        }
    }

    public void doHandlePassphraseChanged() {
        this.sapShowPassphraseCheckBox.setEnabled(true);
    }

    public void doHandleShowPassphraseChecked() {
        boolean showPassphrase = this.sapShowPassphraseCheckBox.getSelected();
        BTextField passphraseTextField = (BTextField)this.sapPassphraseField.getContent();
        if (showPassphrase) {
            passphraseTextField.setController(new TextController());
            passphraseTextField.setRenderer(new TextRenderer());
            passphraseTextField.setAllowCopying(true);
        } else {
            passphraseTextField.setController((TextController)new PasswordTextController());
            passphraseTextField.setRenderer((TextRenderer)new PasswordRenderer());
            passphraseTextField.setAllowCopying(false);
        }
        this.sapPassphraseField.relayout();
    }

    public void doHandleAllowListChecked() {
        if (!this.sapUseAllowListCheckBox.isSelected()) {
            return;
        }
        if (!this.configAllowListCommand.isEnabled()) {
            return;
        }
        this.configAllowListCommand.doInvoke();
    }

    protected BDaemonSession getWifiDaemonSession() {
        return this.daemonSession;
    }

    private static class ShowClientsCommand
    extends Command {
        public ShowClientsCommand(BWidget owner) {
            super(owner, LEX.getText("ClientListDialog.description"));
        }

        public CommandArtifact doInvoke() {
            BWifiClientListEditorDialog dialog;
            try {
                String title = LEX.getText("ClientListDialog.title");
                dialog = new BWifiClientListEditorDialog(this.getOwner(), title);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, LEX.getText("ClientListDialog.cannotShow.error"), exception);
                BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("ClientListDialog.cannotShow.title", new Object[]{"Cannot Display"}), (Object)LEX.getText("ClientListDialog.cannotShow.error", new Object[]{"Failed to show clients"}), (Throwable)exception);
                return null;
            }
            dialog.setBoundsCenteredOnOwner();
            dialog.requestFocus();
            dialog.open();
            return null;
        }
    }

    private class ConfigAllowListCommand
    extends Command {
        public ConfigAllowListCommand(BWidget owner) {
            super(owner, LEX.getText("AllowListDialog.description"));
        }

        public CommandArtifact doInvoke() {
            BWifiAllowListEditorDialog dialog;
            BWifiMacAddressVector allowList = new BWifiMacAddressVector();
            try {
                String title = LEX.getText("AllowListDialog.title");
                dialog = new BWifiAllowListEditorDialog(this.getOwner(), title, allowList, BWifiAccessPointManager.this.wifiSettings);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, LEX.getText("AllowListDialog.cannotShow.error"), exception);
                BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("AllowListDialog.cannotShow.title"), (Object)LEX.getText("AllowListDialog.cannotShow.error"), (Throwable)exception);
                return null;
            }
            dialog.setBoundsCenteredOnOwner();
            dialog.requestFocus();
            dialog.open();
            if (allowList.getLength() == 0) {
                BWifiAccessPointManager.this.sapUseAllowListCheckBox.setSelected(false);
            }
            return null;
        }
    }

    private class ConfigChannelsCommand
    extends Command {
        public ConfigChannelsCommand(BWidget owner) {
            super(owner, LEX.getText("RadioConfigDialog.description"));
        }

        public CommandArtifact doInvoke() {
            BWifiChannelListVectorEditorDialog dialog;
            try {
                String title = LEX.getText("RadioConfigDialog.title");
                dialog = new BWifiChannelListVectorEditorDialog(this.getOwner(), title, BWifiAccessPointManager.this.wifiSettings);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, LEX.getText("RadioConfigDialog.cannotShow.error"), exception);
                BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("RadioConfigDialog.cannotShow.title"), (Object)LEX.getText("RadioConfigDialog.cannotShow.error"), (Throwable)exception);
                return null;
            }
            dialog.setBoundsCenteredOnOwner();
            dialog.requestFocus();
            dialog.open();
            if (dialog.getResult() != 1) {
                return null;
            }
            BWifiAccessPointManager.this.sapChannel = BWifiAccessPointManager.this.wifiSettings.getSapChannel();
            BWifiAccessPointManager.this.sapHwMode = BWifiAccessPointManager.this.wifiSettings.getSapHwMode();
            BWifiAccessPointManager.this.sapHtCapability = BWifiAccessPointManager.this.wifiSettings.getSapHtCapab();
            BWifiAccessPointManager.this.sapRadioCfgTextInfo.setText(BWifiAccessPointManager.getRadioConfigString(BWifiAccessPointManager.this.sapHwMode, BWifiAccessPointManager.this.sapChannel));
            return null;
        }
    }
}

