/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.virtual;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import java.util.logging.Level;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetPropertyReference;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.bacnet.virtual.BBacnetVirtualGateway;
import javax.baja.bacnet.virtual.BBacnetVirtualObject;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BLocalBacnetVirtualObject;
import javax.baja.bacnet.virtual.BLocalBacnetVirtualProperty;
import javax.baja.bacnet.virtual.LocalBacnetVirtualPoll;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.virtual.BVirtualComponent;

@NiagaraType
@NiagaraProperty(name="pollRate", type="BRelTime", defaultValue="BRelTime.makeSeconds(5)")
public class BLocalBacnetVirtualGateway
extends BBacnetVirtualGateway {
    @Generated
    public static final Property pollRate = BLocalBacnetVirtualGateway.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)5), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLocalBacnetVirtualGateway.class);
    private static final BBacnetPropertyReference[] ALL = new BBacnetPropertyReference[]{new BBacnetPropertyReference(8)};
    private LocalBacnetVirtualPoll localPoll;

    @Generated
    public BRelTime getPollRate() {
        return (BRelTime)this.get(pollRate);
    }

    @Generated
    public void setPollRate(BRelTime v) {
        this.set(pollRate, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.localPoll = new LocalBacnetVirtualPoll(this);
    }

    @Override
    protected BBacnetVirtualObject makeBacnetVirtualObject(String virtualPathName) {
        return new BLocalBacnetVirtualObject(this, virtualPathName);
    }

    protected BLocalBacnetVirtualObject makeLocalBacnetVirtualObject(BIBacnetExportObject export) {
        return new BLocalBacnetVirtualObject(export);
    }

    @Override
    protected BBacnetVirtualProperty makeBacnetVirtualProperty(int propertyId, BValue value, String readFault, boolean useFacets) {
        return new BLocalBacnetVirtualProperty(propertyId, value, readFault, useFacets);
    }

    @Override
    protected Property addVirtualSlot(BVirtualComponent parent, String virtualPathName) {
        block9: {
            try {
                if (parent instanceof BLocalBacnetVirtualProperty) break block9;
                if (parent instanceof BLocalBacnetVirtualObject) {
                    BString v;
                    BLocalBacnetVirtualObject object = (BLocalBacnetVirtualObject)parent;
                    int scndx = virtualPathName.indexOf(";");
                    String propertyName = scndx > 0 ? virtualPathName.substring(0, scndx) : virtualPathName;
                    String virtualPropertyName = SlotPath.escape((String)virtualPathName);
                    int propertyId = BBacnetPropertyIdentifier.ordinal(propertyName);
                    PropertyInfo pi = this.localDevice().getPropertyInfo(object.getExport().getObjectId().getObjectType(), propertyId);
                    boolean useFacets = false;
                    Object spec = null;
                    if (pi != null) {
                        try {
                            v = BBacnetObject.makeValue(pi);
                            if (!pi.getFacetControl().equals("no")) {
                                useFacets = true;
                            }
                        }
                        catch (Exception e) {
                            String s = "Unknown Type:" + spec + " for " + BBacnetObjectType.tag(object.getObjectId().getObjectType()) + ":" + propertyName;
                            log.severe("addVirtualSlot:" + s);
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "Exception occurred in addVirtualSlot", e);
                            }
                            v = BString.make((String)s);
                        }
                    } else {
                        v = BString.make((String)"???");
                    }
                    return parent.add(virtualPropertyName, (BValue)this.makeBacnetVirtualProperty(propertyId, (BValue)v, null, useFacets), 2);
                }
                return parent.add(SlotPath.escape((String)virtualPathName), (BValue)this.makeBacnetVirtualObject(virtualPathName), 2);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block9;
                log.log(Level.FINE, "Exception occurred in addVirtualSlot", e);
            }
        }
        return null;
    }

    @Override
    public void loadVirtualSlots(BVirtualComponent parent) {
        if (parent instanceof BBacnetVirtualProperty) {
            return;
        }
        if (parent instanceof BBacnetVirtualObject) {
            this.loadProperties((BBacnetVirtualObject)parent);
        } else {
            this.loadObjects(parent);
        }
    }

    @Override
    protected void loadObjects(BVirtualComponent parent) {
        BBacnetExportTable exports = (BBacnetExportTable)this.localDevice().getExportTable();
        BBacnetObjectIdentifier[] ids = exports.getObjectIds();
        for (int i = 0; i < ids.length; ++i) {
            BIBacnetExportObject o;
            BBacnetObjectIdentifier id = ids[i];
            String name = SlotPath.escape((String)id.toString(nameContext));
            Property p = parent.getProperty(name);
            if (p != null || (o = this.localDevice().lookupBacnetObject(id)) == null) continue;
            parent.add(SlotPath.escape((String)name), (BValue)this.makeLocalBacnetVirtualObject(o), 2);
        }
    }

    @Override
    protected void loadProperties(BBacnetVirtualObject object) {
        block14: {
            BLocalBacnetVirtualObject local = (BLocalBacnetVirtualObject)object;
            try {
                PropertyValue[] pvs = local.getExport().readPropertyMultiple(ALL);
                for (int i = 0; i < pvs.length; ++i) {
                    try {
                        BString v;
                        PropertyValue pv = pvs[i];
                        int propertyId = pv.getPropertyId();
                        String propertyName = BBacnetPropertyIdentifier.tag(propertyId);
                        String virtualPropertyName = SlotPath.escape((String)propertyName);
                        Property p = local.getProperty(virtualPropertyName);
                        if (p != null) continue;
                        PropertyInfo pi = this.localDevice().getPropertyInfo(local.getExport().getObjectId().getObjectType(), pv.getPropertyId());
                        String readFault = null;
                        boolean useFacets = false;
                        Object spec = null;
                        if (pi != null) {
                            try {
                                v = BBacnetObject.makeValue(pi);
                                if (!pi.getFacetControl().equals("no")) {
                                    useFacets = true;
                                }
                            }
                            catch (Exception e) {
                                String s = "Unknown Type:" + spec + " for " + BBacnetObjectType.tag(object.getObjectId().getObjectType()) + ":" + propertyName;
                                log.info("addVirtualSlot:" + s);
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "Exception occurred in loadProperties", e);
                                }
                                v = BString.make((String)s);
                            }
                        } else {
                            v = BString.make((String)"");
                        }
                        if (!pv.isError()) {
                            v = AsnUtil.asnToValue(pi, pv.getPropertyValue());
                        } else {
                            readFault = NErrorType.toString(pv.getErrorClass(), pv.getErrorCode());
                            v = BString.make((String)"???");
                        }
                        object.add(virtualPropertyName, (BValue)this.makeBacnetVirtualProperty(propertyId, (BValue)v, readFault, useFacets), 2, null);
                        continue;
                    }
                    catch (Exception e) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.FINE, "Exception occurred in loadProperties", e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block14;
                log.log(Level.FINE, "Exception occurred in loadProperties", e);
            }
        }
    }

    @Override
    protected int readArraySize(BBacnetVirtualProperty vp) {
        try {
            PropertyValue propVal = this.localDevice().readProperty(new NBacnetPropertyReference(vp.getPropertyId(), 0));
            return AsnUtil.fromAsnInteger(propVal.getPropertyValue());
        }
        catch (BacnetException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception reading array size in BacnetVirtualProperty " + (Object)((Object)vp.object().getObjectId()) + ":" + vp.getPropertyId() + "[" + vp.debugString(null) + "]", (Throwable)((Object)e));
            }
            return 0;
        }
    }

    public String toString(Context cx) {
        return "LocalBacnetVirtualGateway";
    }

    public LocalBacnetVirtualPoll getLocalPoll() {
        return this.localPoll;
    }

    BLocalBacnetDevice localDevice() {
        return (BLocalBacnetDevice)this.getParent();
    }

    @Override
    BBacnetNetwork network() {
        return (BBacnetNetwork)this.getParent().getParent();
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        this.localPoll.spy(out);
    }
}

