/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.virtual;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.config.BBacnetDeviceObject;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.bacnet.virtual.BBacnetVirtualComponent;
import javax.baja.bacnet.virtual.BBacnetVirtualObject;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.space.LoadCallbacks;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.virtual.BVirtualGateway;

@NiagaraType
public class BBacnetVirtualGateway
extends BVirtualGateway
implements BacnetConst {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetVirtualGateway.class);
    protected static final Logger log = Logger.getLogger("bacnet.virtual");
    private boolean auditWrites = false;
    private Object SLOT_LOCK = new Object();

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Deprecated
    protected BBacnetVirtualComponent makeBacnetVirtualComponent(String virtualPathName) {
        return new BBacnetVirtualComponent(virtualPathName);
    }

    protected BBacnetVirtualObject makeBacnetVirtualObject(String virtualPathName) {
        return new BBacnetVirtualObject(virtualPathName);
    }

    protected BBacnetVirtualProperty makeBacnetVirtualProperty(int propertyId, BValue value, String readFault, boolean useFacets) {
        return new BBacnetVirtualProperty(propertyId, value, readFault, useFacets);
    }

    protected boolean getAuditWrites() {
        return this.auditWrites;
    }

    protected void setAuditWrites(boolean aw) {
        this.auditWrites = aw;
    }

    protected BVirtualComponentSpace makeVirtualSpace() {
        BVirtualComponentSpace vspc = super.makeVirtualSpace();
        vspc.setLoadCallbacks((LoadCallbacks)new MyLoadCallbacks());
        return vspc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Slot loadVirtualSlot(BVirtualComponent parent, String virtualPathName) {
        if (parent == null) {
            return null;
        }
        Slot result = null;
        if (virtualPathName != null) {
            Object object = this.SLOT_LOCK;
            synchronized (object) {
                String virtualSlotName = SlotPath.escape((String)virtualPathName);
                result = parent.getSlot(virtualSlotName);
                if (result == null) {
                    String nameAssigned;
                    result = this.addVirtualSlot(parent, virtualPathName);
                    if (result != null && !(nameAssigned = result.getName()).equals(virtualSlotName)) {
                        log.warning("Name of virtual slot added is inconsistent: \"" + nameAssigned + "\" was expected to be \"" + virtualSlotName + "\"");
                    }
                } else if (parent instanceof BBacnetVirtualProperty) {
                    BBacnetArray a;
                    BValue v;
                    BBacnetVirtualProperty vp = (BBacnetVirtualProperty)parent;
                    if (result.isProperty() && (v = parent.get(result.asProperty())) instanceof BBacnetArray && !(a = (BBacnetArray)v).getFixedSize()) {
                        int size = this.readArraySize(vp);
                        a.setSize(size);
                    }
                }
            }
        }
        return result;
    }

    protected Property addVirtualSlot(BVirtualComponent parent, String virtualPathName) {
        block9: {
            try {
                if (parent instanceof BBacnetVirtualProperty) break block9;
                if (parent instanceof BBacnetVirtualObject) {
                    BString v;
                    BBacnetVirtualObject o = (BBacnetVirtualObject)parent;
                    int scndx = virtualPathName.indexOf(";");
                    String propertyName = scndx > 0 ? virtualPathName.substring(0, scndx) : virtualPathName;
                    String virtualPropertyName = SlotPath.escape((String)virtualPathName);
                    int propertyId = BBacnetPropertyIdentifier.ordinal(propertyName);
                    PropertyInfo pi = this.device().getPropertyInfo(o.getObjectId().getObjectType(), propertyId);
                    boolean useFacets = false;
                    Object spec = null;
                    if (pi != null) {
                        try {
                            v = BBacnetObject.makeValue(pi);
                            if (!pi.getFacetControl().equals("no")) {
                                useFacets = true;
                            }
                        }
                        catch (Exception e) {
                            String s = "Unknown Type:" + spec + " for " + BBacnetObjectType.tag(o.getObjectId().getObjectType()) + ":" + propertyName;
                            log.info("addVirtualSlot:" + s);
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "Exception occurred in addVirtualSlot: ", e);
                            }
                            v = BString.make((String)s);
                        }
                    } else {
                        v = BString.make((String)"???");
                    }
                    return parent.add(virtualPropertyName, (BValue)this.makeBacnetVirtualProperty(propertyId, (BValue)v, null, useFacets), 2);
                }
                return parent.add(SlotPath.escape((String)virtualPathName), (BValue)this.makeBacnetVirtualObject(virtualPathName), 2);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block9;
                log.log(Level.FINE, "Exception occurred in addVirtualSlot: ", e);
            }
        }
        return null;
    }

    public void loadVirtualSlots(BVirtualComponent parent) {
        if (this.device() == null || !this.device().isOperational()) {
            return;
        }
        if (parent instanceof BBacnetVirtualProperty) {
            return;
        }
        if (parent instanceof BBacnetVirtualObject) {
            this.loadProperties((BBacnetVirtualObject)parent);
        } else {
            this.loadObjects(parent);
        }
    }

    public void updateStatus() {
        BComponent root;
        BComponentSpace space = this.getVirtualSpace();
        if (space != null && (root = space.getRootComponent()) != null) {
            SlotCursor sc = root.getProperties();
            while (sc.next(BBacnetVirtualObject.class)) {
                ((BBacnetVirtualObject)sc.get()).updateStatus();
            }
        }
    }

    BBacnetDevice device() {
        return (BBacnetDevice)this.getParent();
    }

    BBacnetNetwork network() {
        return (BBacnetNetwork)this.device().getNetwork();
    }

    protected void loadObjects(BVirtualComponent parent) {
        block3: {
            try {
                BBacnetDeviceObject deviceObject = this.device().getConfig().getDeviceObject();
                deviceObject.readProperty(BBacnetDeviceObject.objectList);
                BBacnetObjectIdentifier[] objectList = (BBacnetObjectIdentifier[])deviceObject.getObjectList().getChildren(BBacnetObjectIdentifier.class);
                for (int i = 0; i < objectList.length; ++i) {
                    BBacnetObjectIdentifier objectId = objectList[i];
                    String virtualPathName = objectId.toString(nameContext);
                    String virtualObjectName = SlotPath.escape((String)virtualPathName);
                    Property p = parent.getProperty(virtualObjectName);
                    if (p != null) continue;
                    p = parent.add(virtualObjectName, (BValue)this.makeBacnetVirtualObject(virtualPathName), 2);
                }
            }
            catch (Exception e) {
                log.info("Unable to loadObjects in BacnetVirtualGateway!");
                if (!log.isLoggable(Level.FINE)) break block3;
                log.log(Level.FINE, "Exception occurred in loadObjects: ", e);
            }
        }
    }

    protected void loadProperties(BBacnetVirtualObject parent) {
        block26: {
            PropertyInfo pi;
            AsnInputStream asnIn;
            boolean propertiesLoaded;
            block23: {
                propertiesLoaded = false;
                asnIn = new AsnInputStream();
                try {
                    if (!this.device().isServiceSupported("readPropertyMultiple")) break block23;
                    Vector<NBacnetPropertyReference> refs = new Vector<NBacnetPropertyReference>();
                    refs.add(new NBacnetPropertyReference(8));
                    Vector vals = this.network().getBacnetComm().readPropertyMultiple(this.device().getAddress(), parent.getObjectId(), refs);
                    for (NReadPropertyResult rpr : vals) {
                        BString v;
                        int propertyId = rpr.getPropertyId();
                        String propertyName = BBacnetPropertyIdentifier.tag(propertyId);
                        String virtualPropertyName = SlotPath.escape((String)propertyName);
                        Property p = parent.getProperty(virtualPropertyName);
                        if (p != null) continue;
                        pi = this.device().getPropertyInfo(parent.getObjectId().getObjectType(), propertyId);
                        String readFault = null;
                        boolean useFacets = false;
                        if (pi != null) {
                            try {
                                v = BBacnetObject.makeValue(pi);
                                if (!pi.getFacetControl().equals("no")) {
                                    useFacets = true;
                                }
                            }
                            catch (Exception e) {
                                String s = "Unknown Type:" + pi.getType() + " for " + BBacnetObjectType.tag(parent.getObjectId().getObjectType()) + ":" + propertyName;
                                log.info("addVirtualSlot:" + s);
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "Exception occurred in loadProperties: ", e);
                                }
                                v = BString.make((String)s);
                            }
                        } else {
                            v = BString.make((String)"");
                        }
                        if (!rpr.isError()) {
                            asnIn.setBuffer(rpr.getPropertyValue());
                            v = BacnetVirtualUtil.readValue(asnIn, (BValue)v);
                        } else {
                            readFault = NErrorType.toString(rpr.getErrorClass(), rpr.getErrorCode());
                        }
                        parent.add(virtualPropertyName, (BValue)this.makeBacnetVirtualProperty(propertyId, (BValue)v, readFault, useFacets), 2, null);
                    }
                    propertiesLoaded = true;
                }
                catch (Exception e) {
                    log.info("Unable to loadProperties using RPM in BacnetVirtualGateway for " + parent + ":" + e);
                    if (!log.isLoggable(Level.FINE)) break block23;
                    log.log(Level.FINE, "Exception occurred in loadProperties: ", e);
                }
            }
            if (!propertiesLoaded) {
                try {
                    int[] propertyIds = this.device().getRequiredProperties(parent.getObjectId());
                    for (int i = 0; i < propertyIds.length; ++i) {
                        BString v;
                        int propertyId = propertyIds[i];
                        String propertyName = BBacnetPropertyIdentifier.tag(propertyId);
                        String virtualPropertyName = SlotPath.escape((String)propertyName);
                        Property p = parent.getProperty(virtualPropertyName);
                        if (p != null) continue;
                        String readFault = null;
                        pi = this.device().getPropertyInfo(parent.getObjectId().getObjectType(), propertyId);
                        boolean useFacets = false;
                        if (pi != null) {
                            try {
                                v = BBacnetObject.makeValue(pi);
                                if (!pi.getFacetControl().equals("no")) {
                                    useFacets = true;
                                }
                            }
                            catch (Exception e) {
                                String s = "Unknown Type:" + pi.getType() + " for " + BBacnetObjectType.tag(parent.getObjectId().getObjectType()) + ":" + propertyName;
                                log.info("addVirtualSlot:" + s);
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "Exception occurred in loadProperties: ", e);
                                }
                                v = BString.make((String)s);
                            }
                        } else {
                            v = BString.make((String)"");
                        }
                        try {
                            byte[] encodedValue = this.network().getBacnetComm().readProperty(this.device().getAddress(), parent.getObjectId(), propertyId);
                            asnIn.setBuffer(encodedValue);
                            v = BacnetVirtualUtil.readValue(asnIn, (BValue)v);
                        }
                        catch (BacnetException e) {
                            readFault = e.toString();
                        }
                        parent.add(virtualPropertyName, (BValue)this.makeBacnetVirtualProperty(propertyId, (BValue)v, readFault, useFacets), 2, null);
                    }
                }
                catch (Exception e) {
                    log.info("Unable to loadProperties using RP in BacnetVirtualGateway for " + parent + ":" + e);
                    if (!log.isLoggable(Level.FINE)) break block26;
                    log.log(Level.FINE, "Exception occurred in loadProperties: ", e);
                }
            }
        }
    }

    protected int readArraySize(BBacnetVirtualProperty vp) {
        try {
            byte[] encodedValue = this.network().getBacnetComm().readProperty(this.device().getAddress(), vp.object().getObjectId(), vp.getPropertyId(), 0);
            return AsnUtil.fromAsnInteger(encodedValue);
        }
        catch (BacnetException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception reading array size in BacnetVirtualProperty " + (Object)((Object)vp.object().getObjectId()) + ":" + vp.getPropertyId() + "[" + vp.debugString(null) + "]", (Throwable)((Object)e));
            }
            return 0;
        }
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.prop((Object)"auditWrites", this.auditWrites);
        out.endProps();
    }

    static class MyLoadCallbacks
    extends LoadCallbacks {
        MyLoadCallbacks() {
        }

        public void loadSlots(BComponent c) {
            BComponentSpace space = c.getComponentSpace();
            if (space instanceof BVirtualComponentSpace) {
                BBacnetArray a;
                Property e0;
                if (c instanceof BVirtualComponent) {
                    BVirtualGateway vGate = ((BVirtualComponentSpace)space).getVirtualGateway();
                    if (vGate != null) {
                        vGate.loadVirtualSlots((BVirtualComponent)c);
                    }
                } else if (c instanceof BBacnetArray && (e0 = (a = (BBacnetArray)c).getProperty("element0")) == null) {
                    a.add("element0", (BValue)BInteger.make((int)-1), 2);
                }
            }
        }
    }
}

