/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.util;

import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Type;

public abstract class LocalBacnetPoll
implements Runnable {
    private boolean alive = false;
    private Array<BObject> subs = new Array(BObject.class);
    private Thread thread = null;
    private static final Logger logger = Logger.getLogger("bacnet.util");

    protected LocalBacnetPoll() {
    }

    @Override
    public void run() {
        while (this.alive) {
            long now = Clock.ticks();
            long nextPollTime = now + this.getPollRate().getMillis();
            long sleepTime = nextPollTime - now;
            if (sleepTime > 0L) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            try {
                for (BObject o : this.subs) {
                    if (o == null || !o.getType().is(this.getPolledType()) || this.poll(o)) continue;
                    this.subs.remove((Object)o);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred in LocalBacnetPoll runnable", e);
            }
        }
    }

    protected abstract boolean poll(BObject var1) throws Exception;

    protected abstract BRelTime getPollRate();

    protected abstract String getThreadName();

    protected abstract Type getPolledType();

    public synchronized void subscribe(BObject o) {
        if (o == null) {
            return;
        }
        if (!o.getType().is(this.getPolledType())) {
            throw new IllegalArgumentException("wrong type " + o.getType() + " for local poll subscribe (" + this.getPolledType() + ")");
        }
        this.subs.add((Object)o);
        if (!this.alive) {
            this.startThread();
        }
    }

    public synchronized void unsubscribe(BObject o) {
        if (o == null) {
            return;
        }
        if (!o.getType().is(this.getPolledType())) {
            throw new IllegalArgumentException("wrong type " + o.getType() + " for local poll unsubscribe (" + this.getPolledType() + ")");
        }
        this.subs.remove((Object)o);
        if (this.subs.size() == 0) {
            this.stopThread();
        }
    }

    private void startThread() {
        this.alive = true;
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.start();
    }

    private void stopThread() {
        this.alive = false;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    public void spy(SpyWriter out) {
        out.prop((Object)"alive", this.alive);
        out.trTitle((Object)this.getThreadName(), 2);
        out.prop((Object)"subs", this.subs.size());
        ListIterator it = this.subs.iterator();
        int i = 0;
        while (it.hasNext()) {
            out.prop((Object)("  subs[" + i++ + "]"), it.next());
        }
    }
}

