/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.listeners;

import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.IAmListener;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.sys.BValue;

public class DynamicIAmListener
implements IAmListener {
    private static DynamicIAmListener dynamicIAmListener = new DynamicIAmListener();
    private static final int TRENDING = 1;
    private static final int ALARMING = 2;
    private static final int SCHEDULING = 4;
    private Map<BBacnetObjectIdentifier, Set<IAmHandler>> handlers;
    private boolean iAmRegistered;
    private static final Logger logger = Logger.getLogger("bacnet.listeners");

    private DynamicIAmListener() {
    }

    public static DynamicIAmListener getDynamicIAmListenerInstance() {
        return dynamicIAmListener;
    }

    @Override
    public void receiveIAm(IAmRequest request, BBacnetAddress sourceAddress) {
        block4: {
            try {
                BBacnetObjectIdentifier remoteOid = request.getObjectId();
                Set<IAmHandler> handlerList = this.getHandlerList(remoteOid);
                if (handlerList == null) {
                    return;
                }
                for (IAmHandler handler : handlerList) {
                    handler.handle(request, sourceAddress);
                }
                this.removeHandler(remoteOid);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block4;
                logger.log(Level.FINE, "Exception occurred during receiveIAm", e);
            }
        }
    }

    public void subscribeHandler(IAmHandler handler, BBacnetObjectIdentifier deviceId) {
        Set<IAmHandler> handlerList = this.addAndGetHandlerList(deviceId);
        handlerList.add(handler);
    }

    public boolean handlesTrending(BBacnetObjectIdentifier deviceId) {
        return this.handles(deviceId, 1);
    }

    public boolean handlesAlarms(BBacnetObjectIdentifier deviceId) {
        return this.handles(deviceId, 2);
    }

    public boolean handlesScheduling(BBacnetObjectIdentifier deviceId) {
        return this.handles(deviceId, 4);
    }

    private boolean handles(BBacnetObjectIdentifier deviceId, int service) {
        Set<IAmHandler> handlerList = this.getHandlerList(deviceId);
        if (handlerList == null) {
            return false;
        }
        for (IAmHandler handler : handlerList) {
            if (!handler.is(service)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHandler(BBacnetObjectIdentifier deviceId) {
        if (!this.iAmRegistered || !this.handlers.containsKey((Object)deviceId)) {
            return;
        }
        this.handlers.remove((Object)deviceId);
        DynamicIAmListener dynamicIAmListener = this;
        synchronized (dynamicIAmListener) {
            if (this.handlers.size() == 0) {
                this.unregister();
            }
        }
    }

    private Set<IAmHandler> getHandlerList(BBacnetObjectIdentifier deviceId) {
        if (!this.iAmRegistered && !this.handlers.containsKey((Object)deviceId)) {
            return null;
        }
        return this.handlers.get((Object)deviceId);
    }

    private synchronized Set<IAmHandler> addAndGetHandlerList(BBacnetObjectIdentifier deviceId) {
        Set<IAmHandler> handlerList;
        if (!this.iAmRegistered) {
            this.register();
        }
        if ((handlerList = this.getHandlerList(deviceId)) == null) {
            handlerList = new ConcurrentSkipListSet<IAmHandler>();
        }
        this.handlers.put(deviceId, handlerList);
        return handlerList;
    }

    private void register() {
        this.handlers = new ConcurrentHashMap<BBacnetObjectIdentifier, Set<IAmHandler>>();
        this.getServer().registerIAmListener(this);
        this.iAmRegistered = true;
    }

    private void unregister() {
        this.iAmRegistered = false;
        this.handlers = null;
        this.getServer().unregisterIAmListener(this);
    }

    private BBacnetServerLayer getServer() {
        BBacnetNetwork network = BBacnetNetwork.bacnet();
        BBacnetStack comm = (BBacnetStack)network.getBacnetComm();
        BBacnetServerLayer serverLayer = comm.getServer();
        return serverLayer;
    }

    public static abstract class IAmHandler
    implements Comparable<Object> {
        private int serviceHandled = 0;

        public abstract void handle(IAmRequest var1, BBacnetAddress var2);

        public void handles(int propertyId) {
            switch (propertyId) {
                case 20: {
                    this.serviceHandled |= 1;
                    break;
                }
                case 9: {
                    this.serviceHandled |= 2;
                    break;
                }
                case 17: {
                    this.serviceHandled |= 4;
                }
            }
        }

        public boolean isTrending() {
            return this.is(1);
        }

        public boolean isAlarming() {
            return this.is(2);
        }

        public boolean isScheduling() {
            return this.is(4);
        }

        private boolean is(int service) {
            switch (service) {
                case 1: 
                case 2: 
                case 4: {
                    return (this.serviceHandled & service) != 0;
                }
            }
            return false;
        }

        protected void bindDevice(BBacnetObjectIdentifier deviceOid) {
            if (BBacnetNetwork.bacnet().lookupDeviceById(deviceOid) == null) {
                BBacnetDevice device = new BBacnetDevice();
                device.setObjectId(deviceOid, null);
                BBacnetNetwork.bacnet().add(device.getName(), (BValue)device);
            }
        }

        @Override
        public int compareTo(Object o) {
            if (o == this) {
                return 0;
            }
            return 1;
        }
    }
}

