/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.CovNotificationParameters;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.DeviceRegistry;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BIBacnetCovSource;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RejectException;
import javax.baja.control.BControlPoint;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.util.ICoalesceable;

public class Cov
implements Runnable,
ICoalesceable {
    private static final PropertyReference STATUS_FLAGS_REF = new NBacnetPropertyReference(111);
    private static final PropertyReference SETPOINT_REF = new NBacnetPropertyReference(108);
    private static final PropertyReference CONTROLLED_VARIABLE_VALUE_REF = new NBacnetPropertyReference(21);
    private static final PropertyReference LAST_COMMAND_TIME_REF = new NBacnetPropertyReference(432);
    private static final Logger logger = Logger.getLogger("bacnet.server");
    private BBacnetCovSubscription sub;
    private PropertyValue[] propertyValues;
    private BIBacnetCovSource covSrc;
    private BControlPoint pt;
    private BBacnetAddress address;

    public Cov(BBacnetCovSubscription sub, BIBacnetCovSource object, BControlPoint pt) {
        this.sub = sub;
        this.covSrc = object;
        this.pt = pt;
    }

    public String toString() {
        return "Cov:" + this.sub + " on " + this.covSrc + " to " + this.pt.getName() + ":" + this.pt;
    }

    public Object getCoalesceKey() {
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof Cov) {
            Cov cov = (Cov)o;
            BIBacnetCovSource covObj = cov.covSrc;
            if (this.sub.equivalent(cov.sub) && this.covSrc.getExport().getObjectId().equals((Object)covObj.getExport().getObjectId()) && this.pt == cov.pt) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 1;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        this.sub = ((Cov)c).sub;
        this.covSrc = ((Cov)c).covSrc;
        this.pt = ((Cov)c).pt;
        return this;
    }

    @Override
    public void run() {
        try {
            int timeRemaining = this.sub.getTimeRemaining();
            if (timeRemaining < 0) {
                return;
            }
            BBacnetNetwork bacnet = BBacnetNetwork.bacnet();
            BBacnetRecipient recipient = this.sub.getRecipient().getRecipient();
            this.address = recipient.getChoice() == 0 ? DeviceRegistry.getDeviceAddress(recipient.getDevice()) : recipient.getAddress();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Sending Cov notification to address: " + this.address);
            }
            BBacnetObjectIdentifier initiatingDeviceId = BBacnetNetwork.localDevice().getObjectId();
            BIBacnetExportObject export = this.covSrc.getExport();
            this.buildPropertyValues(export);
            CovNotificationParameters cnp = new CovNotificationParameters(this.sub.getRecipient().getProcessIdentifier().getUnsigned(), initiatingDeviceId, this.sub.getMonitoredPropertyReference().getObjectId(), timeRemaining, this.propertyValues);
            if (this.sub.getIssueConfirmedNotifications()) {
                ((BBacnetStack)bacnet.getBacnetComm()).getClient().confirmedCovNotification(this.address, cnp);
            } else {
                ((BBacnetStack)bacnet.getBacnetComm()).getClient().unconfirmedCovNotification(this.address, cnp);
            }
        }
        catch (BacnetException e) {
            logger.log(Level.SEVERE, "BacnetException sending COV Notification", (Throwable)((Object)e));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to send COV notification to Bacnet", e);
        }
    }

    private void buildPropertyValues(BIBacnetExportObject export) throws RejectException {
        if (export.getObjectId().getObjectType() == 12) {
            PropertyValue cov = this.readPropertyValue(export);
            PropertyValue status = Cov.readProperty(export, STATUS_FLAGS_REF);
            PropertyValue setpt = Cov.readProperty(export, SETPOINT_REF);
            PropertyValue cvv = Cov.readProperty(export, CONTROLLED_VARIABLE_VALUE_REF);
            this.propertyValues = new PropertyValue[]{cov, status, setpt, cvv};
        } else if (!this.sub.isCovProperty()) {
            PropertyValue cov = this.readPropertyValue(export);
            PropertyValue status = Cov.readProperty(export, STATUS_FLAGS_REF);
            this.propertyValues = new PropertyValue[]{cov, status};
        } else {
            NBacnetPropertyValue presentValue;
            PropertyValue status;
            PropertyValue cov;
            PropertyValue last = this.sub.getLastPropertyValue();
            if (last != null) {
                cov = new NBacnetPropertyValue(last);
            } else {
                cov = this.readPropertyValue(export);
                this.sub.setLastPropertyValue(cov);
            }
            BStatus lastStatus = this.sub.getLastStatusFlags();
            if (lastStatus != null) {
                status = new NBacnetPropertyValue(111, AsnUtil.statusToAsnStatusFlags(lastStatus));
            } else {
                status = Cov.readProperty(export, STATUS_FLAGS_REF);
                this.sub.setLastStatusFlags(AsnUtil.asnStatusFlagsToBStatus(status.getPropertyValue()));
            }
            if (this.sub.getMonitoredPropertyReference().getPropertyId() != 433) {
                this.propertyValues = new PropertyValue[]{cov, status};
                return;
            }
            BBacnetPointDescriptor pointDescriptor = (BBacnetPointDescriptor)export;
            BStatusValue lastPresentValue = this.sub.getLastPresentValue();
            if (lastPresentValue != null) {
                presentValue = new NBacnetPropertyValue(85, pointDescriptor.convertToAsn(lastPresentValue.getValueValue()));
            } else {
                BStatusValue statusValue = pointDescriptor.getCurrentStatusValue();
                presentValue = new NBacnetPropertyValue(85, pointDescriptor.convertToAsn(statusValue.getValueValue()));
                this.sub.setLastPresentValue(statusValue);
            }
            if (pointDescriptor.isCommandable()) {
                NBacnetPropertyValue currentCommandPriority;
                int lastCommandPriority = this.sub.getLastCommandPriority();
                if (lastCommandPriority != 0) {
                    currentCommandPriority = new NBacnetPropertyValue(431, BBacnetPointDescriptor.activeLevelToAsn(lastCommandPriority));
                } else {
                    int activeLevel = ((BBacnetPointDescriptor)export).getActiveLevel();
                    currentCommandPriority = new NBacnetPropertyValue(431, BBacnetPointDescriptor.activeLevelToAsn(activeLevel));
                    this.sub.setLastCommandPriority(activeLevel);
                }
                PropertyValue lastCommandTime = Cov.readProperty(export, LAST_COMMAND_TIME_REF);
                this.propertyValues = new PropertyValue[]{presentValue, status, cov, lastCommandTime, currentCommandPriority};
            } else {
                this.propertyValues = new PropertyValue[]{presentValue, status, cov};
            }
        }
    }

    private PropertyValue readPropertyValue(BIBacnetExportObject export) throws RejectException {
        return Cov.readProperty(export, new NBacnetPropertyReference(this.sub.getMonitoredPropertyReference().getPropertyId(), this.sub.getMonitoredPropertyReference().getPropertyArrayIndex()));
    }

    private static PropertyValue readProperty(BIBacnetExportObject export, PropertyReference reference) throws RejectException {
        return new NBacnetPropertyValue(export.readProperty(reference));
    }

    public BBacnetCovSubscription getSub() {
        return this.sub;
    }
}

