/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.history.BBacnetBitStringTrendLogExt;
import com.tridium.bacnet.history.BBacnetBitStringTrendLogRemoteExt;
import com.tridium.bacnet.history.BBacnetBooleanTrendLogExt;
import com.tridium.bacnet.history.BBacnetBooleanTrendLogRemoteExt;
import com.tridium.bacnet.history.BBacnetEnumTrendLogExt;
import com.tridium.bacnet.history.BBacnetEnumTrendLogRemoteExt;
import com.tridium.bacnet.history.BBacnetNumericTrendLogExt;
import com.tridium.bacnet.history.BBacnetNumericTrendLogRemoteExt;
import com.tridium.bacnet.history.BBacnetStringTrendLogExt;
import com.tridium.bacnet.history.BBacnetStringTrendLogRemoteExt;
import com.tridium.bacnet.history.BBacnetTrendLogRemoteExt;
import com.tridium.bacnet.history.BIBacnetTrendLogExt;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.extensions.BBacnetRemoteUnsignedPropertyExt;
import javax.baja.bacnet.export.extensions.BBacnetUnsignedPropertyExt;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.point.BBacnetBooleanProxyExt;
import javax.baja.bacnet.point.BBacnetEnumProxyExt;
import javax.baja.bacnet.point.BBacnetNumericProxyExt;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.point.BBacnetStringProxyExt;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BDiscreteTotalizerExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Knob;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.util.BFolder;

public final class BacnetDescriptorUtil {
    private static final Pattern FORWARD_SLASH_PATTERN = Pattern.compile("/");
    private static final Logger logger = Logger.getLogger("bacnet.export.object.util");
    private static final BControlPoint[] EMPTY_POINT_ARRAY = new BControlPoint[0];
    private static final String DISCRETE_TOTALIZER_EXT = "DiscreteTotalizerExtension";

    private BacnetDescriptorUtil() {
    }

    static boolean isValid(BBacnetDeviceObjectPropertyReference reference) {
        if (reference == null) {
            return false;
        }
        if (!BBacnetPropertyIdentifier.isValid(reference.getPropertyId()) || !reference.getObjectId().isValid()) {
            return false;
        }
        BBacnetObjectIdentifier deviceId = reference.getDeviceId();
        if (deviceId.getObjectType() != 8) {
            return false;
        }
        int deviceNum = deviceId.getInstanceNumber();
        return deviceNum >= -1 && deviceNum < 0x3FFFFF;
    }

    public static boolean isLocalDevice(int deviceNum) {
        if (deviceNum == -1) {
            return true;
        }
        BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
        int localDeviceNum = localDevice.getObjectId().getInstanceNumber();
        return localDeviceNum == deviceNum;
    }

    static BControlPoint findOrAddPoint(BBacnetDeviceObjectPropertyReference objectPropRef) throws Exception {
        int deviceNum = objectPropRef.getDeviceId().getInstanceNumber();
        if (BacnetDescriptorUtil.isLocalDevice(deviceNum)) {
            return BacnetDescriptorUtil.findOrAddLocalPoint(objectPropRef.getObjectId(), objectPropRef.getPropertyId(), objectPropRef.getPropertyArrayIndex());
        }
        return BacnetDescriptorUtil.findOrAddRemotePoint(objectPropRef);
    }

    static BControlPoint findOrAddLocalPoint(BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex) throws Exception {
        BComponent point = BacnetDescriptorUtil.findLocalObject(objectId);
        if (!(point instanceof BControlPoint)) {
            return null;
        }
        if (propertyId == 33) {
            point = BacnetDescriptorUtil.getPointForElapsedActiveTime(objectId, propertyArrayIndex, (BControlPoint)point);
        }
        return (BControlPoint)point;
    }

    static BComponent findLocalObject(BBacnetObjectIdentifier objectId) throws Exception {
        BIBacnetExportObject exportObject = BBacnetNetwork.localDevice().lookupBacnetObject(objectId);
        if (exportObject == null) {
            throw new Exception("Could not find a local BACnet export object with ID " + (Object)((Object)objectId));
        }
        BOrd exportObjectOrd = exportObject.getObjectOrd();
        if (exportObjectOrd.isNull()) {
            throw new Exception("ObjectOrd is null for local BACnet object with ID " + (Object)((Object)objectId));
        }
        return (BComponent)exportObjectOrd.get((BObject)Sys.getStation());
    }

    private static BControlPoint getPointForElapsedActiveTime(BBacnetObjectIdentifier objectId, int propertyIndex, BControlPoint point) {
        BDiscreteTotalizerExt extension;
        BDiscreteTotalizerExt[] extensions = (BDiscreteTotalizerExt[])point.getChildren(BDiscreteTotalizerExt.class);
        BControlPoint linkedPoint = null;
        if (extensions.length > 0) {
            extension = extensions[0];
            extension.setEaTimeUpdateInterval(BRelTime.make((long)1000L));
            linkedPoint = BacnetDescriptorUtil.getNumericPointLinkedToDiscreteTotExt(objectId, extension);
        } else {
            extension = BacnetDescriptorUtil.addDiscreteTotalizerExtToPoint((BComponent)point);
        }
        if (linkedPoint == null) {
            linkedPoint = BacnetDescriptorUtil.addPropertyPoint(null, objectId, 33, propertyIndex);
            BacnetDescriptorUtil.linkToNumericPoint(extension, linkedPoint);
        }
        return linkedPoint;
    }

    private static void linkToNumericPoint(BDiscreteTotalizerExt extension, BControlPoint linkedPoint) {
        try {
            BControlPoint divide;
            BValue divideCheckVar = linkedPoint.get("divide");
            if (divideCheckVar == null) {
                Class divideClass = Sys.loadClass((String)"kitControl", (String)"com.tridium.kitControl.math.BDivide");
                divide = (BControlPoint)divideClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                divide.set("inB", (BValue)new BStatusNumeric(1000.0));
                linkedPoint.add("divide", (BValue)divide);
            } else {
                divide = (BControlPoint)divideCheckVar;
            }
            BLink linkToDivide = new BLink(extension.getHandleOrd(), BDiscreteTotalizerExt.elapsedActiveTimeNumeric.getName(), "inA", true);
            divide.add(null, (BValue)linkToDivide, BLocalBacnetDevice.getBacnetContext());
            BLink link = new BLink(divide.getHandleOrd(), "out", BNumericWritable.in16.getName(), true);
            linkedPoint.add(null, (BValue)link, BLocalBacnetDevice.getBacnetContext());
        }
        catch (ClassNotFoundException e) {
            BacnetDescriptorUtil.removePoint(linkedPoint);
            logger.severe("Class BDivide is not found or kitControl module is not found: " + e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            BacnetDescriptorUtil.removePoint(linkedPoint);
            logger.severe("Exception while creating instance of divide: " + e);
        }
    }

    private static BDiscreteTotalizerExt addDiscreteTotalizerExtToPoint(BComponent point) {
        BDiscreteTotalizerExt discreteTotalizerExt = new BDiscreteTotalizerExt();
        discreteTotalizerExt.setEaTimeUpdateInterval(BRelTime.make((long)1000L));
        point.add("DiscreteTotalizerExtension?", (BValue)discreteTotalizerExt);
        return discreteTotalizerExt;
    }

    private static BControlPoint getNumericPointLinkedToDiscreteTotExt(BBacnetObjectIdentifier objectId, BDiscreteTotalizerExt extension) {
        Knob[] knobs = extension.getKnobs((Slot)BDiscreteTotalizerExt.elapsedActiveTimeNumeric);
        ArrayList<BControlPoint> points = new ArrayList<BControlPoint>();
        for (Knob knob : knobs) {
            BComponent targetParent = knob.getTargetComponent().getParent().getParentComponent();
            if (!(targetParent instanceof BControlPoint)) continue;
            points.add((BControlPoint)targetParent);
        }
        if (!points.isEmpty()) {
            return BacnetDescriptorUtil.findElapsedActiveTimePoint(points.toArray(EMPTY_POINT_ARRAY), objectId);
        }
        return null;
    }

    static BControlPoint findOrAddRemotePoint(BBacnetDeviceObjectPropertyReference objPropRef) {
        int propertyIndex;
        int propertyId;
        BBacnetObjectIdentifier objectId;
        BBacnetDevice device = BacnetDescriptorUtil.findOrAddRemoteDevice(objPropRef.getDeviceId());
        BControlPoint point = BacnetDescriptorUtil.findRemotePoint(device, objectId = objPropRef.getObjectId(), propertyId = objPropRef.getPropertyId(), propertyIndex = objPropRef.getPropertyArrayIndex());
        if (point == null) {
            point = BacnetDescriptorUtil.addPropertyPoint(device, objectId, propertyId, propertyIndex);
        }
        return point;
    }

    private static BControlPoint findRemotePoint(BBacnetDevice device, BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex) {
        BControlPoint[] remotePoints;
        BControlPoint point;
        if (propertyId == 33 && (point = BacnetDescriptorUtil.findElapsedActiveTimePoint(remotePoints = device.getPoints().getPoints(), objectId)) != null) {
            return point;
        }
        return (BControlPoint)device.lookupBacnetObject(objectId, propertyId, propertyArrayIndex, "point");
    }

    private static BControlPoint findElapsedActiveTimePoint(BControlPoint[] points, BBacnetObjectIdentifier objectId) {
        if (points == null) {
            return null;
        }
        for (BControlPoint point : points) {
            BBacnetUnsignedPropertyExt[] extensions;
            for (BBacnetUnsignedPropertyExt ext : extensions = (BBacnetUnsignedPropertyExt[])point.getChildren(BBacnetUnsignedPropertyExt.class)) {
                if (ext.getPropertyId() != 33 || !ext.getObjectId().equivalent((Object)objectId)) continue;
                return point;
            }
        }
        return null;
    }

    private static BControlPoint addPropertyPoint(BBacnetDevice device, BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex) {
        try {
            BControlPoint point = BacnetDescriptorUtil.makePropertyPoint(device, objectId, propertyId, propertyArrayIndex);
            String name = BacnetDescriptorUtil.makePointName(objectId, propertyId, propertyArrayIndex);
            if (device == null) {
                BComponent dynamicPointsFolder = (BComponent)BBacnetNetwork.bacnet().get("dynamicPoints");
                if (dynamicPointsFolder == null) {
                    dynamicPointsFolder = new BFolder();
                    BBacnetNetwork.bacnet().add("dynamicPoints", (BValue)dynamicPointsFolder, 5);
                }
                dynamicPointsFolder.add(SlotPath.escape((String)name), (BValue)point);
            } else {
                device.getPoints().add(SlotPath.escape((String)name), (BValue)point);
            }
            return point;
        }
        catch (Exception e) {
            logger.severe("Could not add point for property " + propertyId + " on device " + device + "; " + e.getMessage());
            return null;
        }
    }

    private static String makePointName(BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex) {
        StringBuilder pointName = new StringBuilder(objectId.toString());
        if (propertyId != 85) {
            pointName.append('-').append(BBacnetPropertyIdentifier.tag(propertyId));
        }
        if (propertyArrayIndex > 0) {
            pointName.append('_').append(propertyArrayIndex);
        }
        return FORWARD_SLASH_PATTERN.matcher(pointName.toString()).replaceAll(".");
    }

    private static void removePoint(BControlPoint point) {
        if (null == BBacnetNetwork.bacnet().get("dynamicPoints")) {
            BBacnetNetwork.bacnet().get("dynamicPoints").asComponent().remove(point.getName());
        }
    }

    private static BBacnetDevice findOrAddRemoteDevice(BBacnetObjectIdentifier deviceId) {
        BBacnetNetwork network = BBacnetNetwork.bacnet();
        BBacnetDevice device = network.lookupDeviceById(deviceId);
        if (device == null) {
            device = BacnetDescriptorUtil.addRemoteDevice(deviceId.getInstanceNumber());
        }
        return device;
    }

    private static BBacnetDevice addRemoteDevice(int instanceNum) {
        BBacnetObjectIdentifier id = BBacnetObjectIdentifier.make(8, instanceNum);
        BBacnetDevice device = new BBacnetDevice();
        device.setObjectId(id, null);
        BBacnetNetwork.bacnet().add(null, (BValue)device);
        return device;
    }

    private static BControlPoint addPointForElapsedActiveTime(BBacnetObjectIdentifier bOid, boolean isLocal) {
        BNumericWritable point = new BNumericWritable();
        BBacnetUnsignedPropertyExt extension = isLocal ? new BBacnetUnsignedPropertyExt(bOid, 33) : new BBacnetRemoteUnsignedPropertyExt(bOid, 33);
        point.add("ElapsedActiveTimeExtension?", (BValue)extension);
        return point;
    }

    private static BControlPoint makePropertyPoint(BBacnetDevice device, BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex) throws BacnetException {
        if (propertyId == 33) {
            return BacnetDescriptorUtil.addPointForElapsedActiveTime(objectId, device == null);
        }
        int objectType = objectId.getObjectType();
        PropertyInfo propInfo = device.getPropertyInfo(objectType, propertyId);
        if (propInfo == null) {
            throw new BacnetException("BACnet property information not found when making a property point; object type: " + BBacnetObjectType.tag(objectType) + ", property ID: " + BBacnetPropertyIdentifier.tag(propertyId));
        }
        BControlPoint point = BacnetDescriptorUtil.makePointForPropertyInfo(objectType, propInfo);
        BBacnetProxyExt ext = (BBacnetProxyExt)point.getProxyExt();
        ext.setDeviceFacets((BFacets)point.getFacets().newCopy());
        ext.setDataType(propInfo.getDataType());
        ext.setObjectId(objectId);
        ext.setPropertyId(BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.make(propertyId)));
        ext.setPropertyArrayIndex(propertyArrayIndex);
        ext.setEnabled(true);
        return point;
    }

    private static BControlPoint makePointForPropertyInfo(int objectType, PropertyInfo propInfo) throws BacnetException {
        switch (propInfo.getAsnType()) {
            case 0: {
                return BacnetDescriptorUtil.makeBacnetStringWritable();
            }
            case 1: {
                return BacnetDescriptorUtil.makeBacnetBooleanWritable();
            }
            case 2: {
                return BacnetDescriptorUtil.isMultiStatePresentValue(propInfo.getId(), objectType) ? BacnetDescriptorUtil.makeBacnetEnumWritable() : BacnetDescriptorUtil.makeBacnetNumericWritable();
            }
            case 3: 
            case 4: 
            case 5: {
                return BacnetDescriptorUtil.makeBacnetNumericWritable();
            }
            case 6: 
            case 7: 
            case 8: {
                return BacnetDescriptorUtil.makeBacnetStringWritable();
            }
            case 9: {
                return propInfo.getType().equals("bacnet:BacnetBinaryPv") ? BacnetDescriptorUtil.makeBacnetBooleanWritable() : BacnetDescriptorUtil.makeBacnetEnumWritable();
            }
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 10: 
            case 11: 
            case 12: {
                return BacnetDescriptorUtil.makeBacnetStringWritable();
            }
        }
        throw new BacnetException("BACnet property type " + BBacnetPropertyIdentifier.tag(objectType) + " is not supported when making a property point");
    }

    private static BBooleanWritable makeBacnetBooleanWritable() {
        BBooleanWritable booleanWritable = new BBooleanWritable();
        booleanWritable.setProxyExt((BAbstractProxyExt)new BBacnetBooleanProxyExt());
        return booleanWritable;
    }

    private static BNumericWritable makeBacnetNumericWritable() {
        BNumericWritable numericWritable = new BNumericWritable();
        numericWritable.setProxyExt((BAbstractProxyExt)new BBacnetNumericProxyExt());
        return numericWritable;
    }

    private static BEnumWritable makeBacnetEnumWritable() {
        BEnumWritable enumWritable = new BEnumWritable();
        enumWritable.setProxyExt((BAbstractProxyExt)new BBacnetEnumProxyExt());
        return enumWritable;
    }

    private static BStringWritable makeBacnetStringWritable() {
        BStringWritable stringWritable = new BStringWritable();
        stringWritable.setProxyExt((BAbstractProxyExt)new BBacnetStringProxyExt());
        return stringWritable;
    }

    private static boolean isMultiStatePresentValue(int propertyId, int objectType) {
        return propertyId == 85 && (objectType == 13 || objectType == 14 || objectType == 19);
    }

    static boolean isEqual(BBacnetDeviceObjectPropertyReference dopr1, BBacnetDeviceObjectPropertyReference dopr2) {
        if (dopr1 == null && dopr2 == null) {
            return true;
        }
        if (dopr1 == null || dopr2 == null) {
            return false;
        }
        if (dopr1.isNull() && dopr2.isNull()) {
            return true;
        }
        return dopr1.getDeviceId().getInstanceNumber() == dopr2.getDeviceId().getInstanceNumber() && dopr1.getObjectId().getObjectType() == dopr2.getObjectId().getObjectType() && dopr1.getObjectId().getInstanceNumber() == dopr2.getObjectId().getInstanceNumber() && dopr1.getPropertyId() == dopr2.getPropertyId() && dopr1.getPropertyArrayIndex() == dopr2.getPropertyArrayIndex();
    }

    static BIBacnetTrendLogExt makeTrendLogExt(int objectType, PropertyInfo propInfo, boolean isRemote) throws BacnetException {
        switch (propInfo.getAsnType()) {
            case 1: {
                return isRemote ? new BBacnetBooleanTrendLogRemoteExt() : new BBacnetBooleanTrendLogExt();
            }
            case 2: {
                if (BacnetDescriptorUtil.isMultiStatePresentValue(propInfo.getId(), objectType)) {
                    return isRemote ? new BBacnetEnumTrendLogRemoteExt() : new BBacnetEnumTrendLogExt();
                }
                return isRemote ? new BBacnetNumericTrendLogRemoteExt() : new BBacnetNumericTrendLogExt();
            }
            case 3: 
            case 4: 
            case 5: {
                return isRemote ? new BBacnetNumericTrendLogRemoteExt() : new BBacnetNumericTrendLogExt();
            }
            case 8: {
                return isRemote ? new BBacnetBitStringTrendLogRemoteExt() : new BBacnetBitStringTrendLogExt();
            }
            case 9: {
                if (propInfo.getType().equals("bacnet:BacnetBinaryPv")) {
                    return isRemote ? new BBacnetBooleanTrendLogRemoteExt() : new BBacnetBooleanTrendLogExt();
                }
                return isRemote ? new BBacnetEnumTrendLogRemoteExt() : new BBacnetEnumTrendLogExt();
            }
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                return isRemote ? new BBacnetStringTrendLogRemoteExt() : new BBacnetStringTrendLogExt();
            }
        }
        throw new BacnetException("BACnet property type " + BBacnetPropertyIdentifier.tag(objectType) + " is not supported when making a trend log extension for " + (isRemote ? "remote" : "local") + " device");
    }

    public static boolean isGenericTrendLogExtension(BIBacnetTrendLogExt ext) {
        return ext instanceof BBacnetNumericTrendLogExt || ext instanceof BBacnetStringTrendLogExt || ext instanceof BBacnetEnumTrendLogExt || ext instanceof BBacnetBooleanTrendLogExt || ext instanceof BBacnetTrendLogRemoteExt;
    }

    public static BBacnetObjectIdentifier nextObjectIdentifier(int objectType) {
        BBacnetExportTable et = BacnetDescriptorUtil.exportTable();
        for (int i = 0; i < 0x3FFFFE; ++i) {
            BBacnetObjectIdentifier oid = BBacnetObjectIdentifier.make(objectType, i);
            if (et.byObjectId(oid) != null) continue;
            return oid;
        }
        return null;
    }

    public static BBacnetExportTable exportTable() {
        return (BBacnetExportTable)BBacnetNetwork.localDevice().getExportTable();
    }

    public static ChangeListError makeAddListElementError(BBacnetErrorClass errorClass, BBacnetErrorCode errorCode) {
        return new NChangeListError(8, new NErrorType(errorClass, errorCode), 0L);
    }

    public static ChangeListError makeRemoveListElementError(BBacnetErrorClass errorClass, BBacnetErrorCode errorCode) {
        return new NChangeListError(9, new NErrorType(errorClass, errorCode), 0L);
    }

    public static PropertyValue readArray(BBacnetPropertyIdentifier pId, int ndx, BBacnetArray array) {
        return BacnetDescriptorUtil.readArray(pId.getOrdinal(), ndx, array);
    }

    public static PropertyValue readArray(int pId, int ndx, BBacnetArray array) {
        if (ndx == 0) {
            return new NReadPropertyResult(pId, 0, AsnUtil.toAsnUnsigned(array.getSize()));
        }
        if (ndx == -1) {
            return new NReadPropertyResult(pId, AsnUtil.toAsn(-2, (BValue)array));
        }
        if (ndx >= 1 && ndx <= array.getSize()) {
            return new NReadPropertyResult(pId, ndx, AsnUtil.toAsn(array.getElement(ndx)));
        }
        return new NReadPropertyResult(pId, ndx, new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.invalidArrayIndex));
    }

    public static ErrorType writeArray(BBacnetArray array, int index, byte[] value) throws AsnException {
        if (index == 0) {
            int newSize = AsnUtil.fromAsnUnsignedInt(value);
            array.setInt(BBacnetArray.size, newSize, BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        if (index == -1) {
            BBacnetArray newArray = new BBacnetArray(array.getArrayTypeSpec().getResolvedType());
            newArray = (BBacnetArray)AsnUtil.fromAsn(-2, value, (BValue)newArray);
            array.getParent().set(array.getPropertyInParent(), (BValue)newArray, BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        if (index >= 1 && index <= array.getSize()) {
            array.set("element" + index, AsnUtil.fromAsn(value, (BValue)array.getArrayTypeSpec().getInstance()), BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.invalidArrayIndex);
    }

    public static PropertyValue makeNullReadResult(BBacnetPropertyIdentifier id) {
        return new NReadPropertyResult(id.getOrdinal(), AsnUtil.toAsnNull());
    }

    public static PropertyValue makeBooleanReadResult(BBacnetPropertyIdentifier id, boolean value) {
        return new NReadPropertyResult(id.getOrdinal(), AsnUtil.toAsnBoolean(value));
    }

    public static PropertyValue makeUnsignedReadResult(BBacnetPropertyIdentifier id, long value) {
        return new NReadPropertyResult(id.getOrdinal(), AsnUtil.toAsnUnsigned(value));
    }

    public static PropertyValue makeUnsignedReadResult(BBacnetPropertyIdentifier id, int index, long value) {
        return new NReadPropertyResult(id.getOrdinal(), index, AsnUtil.toAsnUnsigned(value));
    }

    public static PropertyValue makeUnsignedReadResult(BBacnetPropertyIdentifier id, BBacnetUnsigned value) {
        return new NReadPropertyResult(id.getOrdinal(), AsnUtil.toAsnUnsigned(value));
    }

    public static PropertyValue makeRealReadResult(BBacnetPropertyIdentifier id, float value) {
        return new NReadPropertyResult(id.getOrdinal(), AsnUtil.toAsnReal(value));
    }

    public static PropertyValue makeOctetStringReadResult(BBacnetPropertyIdentifier id, byte[] value) {
        return new NReadPropertyResult(id.getOrdinal(), AsnUtil.toAsnOctetString(value));
    }

    public static PropertyValue makeOctetStringReadResult(BBacnetPropertyIdentifier id, BBacnetOctetString value) {
        return new NReadPropertyResult(id.getOrdinal(), AsnUtil.toAsnOctetString(value));
    }

    public static PropertyValue makeOctetStringReadResult(BBacnetPropertyIdentifier id, int index, BBacnetOctetString value) {
        return new NReadPropertyResult(id.getOrdinal(), index, AsnUtil.toAsnOctetString(value));
    }

    public static PropertyValue makeCharStringReadResult(BBacnetPropertyIdentifier id, String value) {
        return new NReadPropertyResult(id.getOrdinal(), AsnUtil.toAsnCharacterString(value));
    }

    public static PropertyValue makeEnumReadResult(BBacnetPropertyIdentifier id, BEnum value) {
        return new NReadPropertyResult(id.getOrdinal(), AsnUtil.toAsnEnumerated(value));
    }

    public static PropertyValue makeObjectIdReadResult(BBacnetPropertyIdentifier id, BBacnetObjectIdentifier value) {
        return new NReadPropertyResult(id.getOrdinal(), AsnUtil.toAsnObjectId(value));
    }

    public static PropertyValue makeConstructedReadResult(BBacnetPropertyIdentifier id, BValue value) {
        return new NReadPropertyResult(id.getOrdinal(), AsnUtil.toAsn(-1, value));
    }

    public static PropertyValue makeConstructedReadResult(BBacnetPropertyIdentifier id, int index, BValue value) {
        return new NReadPropertyResult(id.getOrdinal(), index, AsnUtil.toAsn(-1, value));
    }

    public static PropertyValue makeListOfReadResult(BBacnetPropertyIdentifier id, BBacnetListOf value) {
        return new NReadPropertyResult(id.getOrdinal(), AsnUtil.toAsn(-3, (BValue)value));
    }

    public static PropertyValue makeAsnReadResult(BBacnetPropertyIdentifier id, byte[] value) {
        return new NReadPropertyResult(id.getOrdinal(), value);
    }

    public static PropertyValue makeAsnReadResult(BBacnetPropertyIdentifier id, int index, byte[] value) {
        return new NReadPropertyResult(id.getOrdinal(), index, value);
    }

    public static PropertyValue makeReadError(BBacnetPropertyIdentifier id, ErrorType error) {
        return new NReadPropertyResult(id.getOrdinal(), error);
    }

    public static PropertyValue makeReadError(BBacnetPropertyIdentifier id, BBacnetErrorClass errorClass, BBacnetErrorCode errorCode) {
        return new NReadPropertyResult(id.getOrdinal(), new NErrorType(errorClass, errorCode));
    }

    public static PropertyValue makeReadError(BBacnetPropertyIdentifier id, int index, BBacnetErrorClass errorClass, BBacnetErrorCode errorCode) {
        return new NReadPropertyResult(id.getOrdinal(), index, new NErrorType(errorClass, errorCode));
    }
}

