/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.stack.link.sc.BAbstractConnectionManager;
import com.tridium.bacnet.stack.link.sc.BHubConnector;
import com.tridium.bacnet.stack.link.sc.BHubFunction;
import com.tridium.bacnet.stack.link.sc.BNodeSwitch;
import com.tridium.bacnet.stack.link.sc.BScConfiguration;
import com.tridium.bacnet.stack.link.sc.BScLinkLayer;
import com.tridium.bacnet.stack.link.sc.connection.BAbstractConnection;
import com.tridium.bacnet.stack.link.sc.connection.BDirectAcceptingConnection;
import com.tridium.bacnet.stack.link.sc.connection.BDirectInitiatingConnection;
import com.tridium.bacnet.stack.link.sc.connection.BHubAcceptingConnection;
import com.tridium.bacnet.stack.link.sc.connection.BHubInitiatingConnection;
import com.tridium.bacnet.stack.link.sc.message.ScMessageUtil;
import com.tridium.nre.util.IPAddressUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetHostAddress;
import javax.baja.bacnet.datatypes.BBacnetHostNPort;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetScDirectConnection;
import javax.baja.bacnet.datatypes.BBacnetScFailedConnectionRequest;
import javax.baja.bacnet.datatypes.BBacnetScHubConnection;
import javax.baja.bacnet.datatypes.BBacnetScHubFunctionConnection;
import javax.baja.bacnet.datatypes.BErrorType;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetScConnectionState;
import javax.baja.bacnet.export.BBacnetNetworkPortDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.ValidateChangesException;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.net.BInternetAddress;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.web.BWebService;

@NiagaraType
public class BBacnetScPortDescriptor
extends BBacnetNetworkPortDescriptor {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetScPortDescriptor.class);
    private static final String SC_PRIMARY_HUB_URI = "ScPrimaryHubUri";
    private static final String SC_FAILOVER_HUB_URI = "ScFailoverHubUri";
    private static final String SC_HUB_FUNCTION_ENABLE = "ScHubFunctionEnable";
    private static final String SC_DIRECT_CONNECT_INITIATE_ENABLE = "ScDirectConnectInitiateEnable";
    private static final String SC_DIRECT_CONNECT_ACCEPT_ENABLE = "ScDirectConnectAcceptEnable";
    private static final int[] OPTIONAL_PROPS_WITHOUT_HUB_FUNCTION = new int[]{28, 417, 425, 426, 399, 423, 0x400000, 0x400001, 4194325, 0x40000D, 4194327, 4194326, 0x400004, 0x40000A, 4194323, 0x40000E, 428, 0x400014, 0x40000C, 0x400009, 0x400005, 0x400006, 0x400007, 0x400008, 0x40000B};
    private static final int[] OPTIONAL_PROPS_WITH_HUB_FUNCTION = new int[]{28, 417, 425, 426, 399, 423, 0x400000, 0x400001, 4194325, 0x40000D, 4194327, 4194326, 0x400004, 0x40000A, 4194323, 0x40000E, 428, 0x400014, 0x40000C, 4194322, 0x40000F, 0x400010, 0x400011, 0x400009, 0x400005, 0x400006, 0x400007, 0x400008, 0x40000B};

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected int getNetworkType() {
        return 64;
    }

    @Override
    protected int[] getOptionalProps() {
        return this.getHubFunction() == null ? OPTIONAL_PROPS_WITHOUT_HUB_FUNCTION : OPTIONAL_PROPS_WITH_HUB_FUNCTION;
    }

    @Override
    protected boolean isArrayProp(int propId) {
        switch (propId) {
            case 371: 
            case 0x400006: 
            case 0x40000F: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isListProp(int propId) {
        switch (propId) {
            case 428: 
            case 0x400008: 
            case 0x40000B: 
            case 0x400011: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected PropertyValue readOptionalProperty(int propertyId, int index) {
        switch (propertyId) {
            case 425: {
                return this.readNetworkNumber();
            }
            case 426: {
                return this.readNetworkNumberQuality();
            }
            case 399: {
                return this.readApduLength();
            }
            case 423: {
                return this.readMacAddress();
            }
            case 0x400000: {
                return this.readMaxBvlcLengthAccepted();
            }
            case 0x400001: {
                return this.readMaxNpduLengthAccepted();
            }
            case 4194325: {
                return this.readScPrimaryHubUri();
            }
            case 0x40000D: {
                return this.readScFailoverHubUri();
            }
            case 4194327: {
                return this.readScMinimumReconnectTime();
            }
            case 4194326: {
                return this.readScMaximumReconnectTime();
            }
            case 0x400004: {
                return this.readScConnectWaitTimeout();
            }
            case 0x40000A: {
                return this.readScDisconnectWaitTimeout();
            }
            case 4194323: {
                return this.readScHeartbeatTimeout();
            }
            case 0x40000E: {
                return this.readScHubConnectorState();
            }
            case 428: {
                return this.readRoutingTable();
            }
            case 0x400014: {
                return this.readScPrimaryHubConnectionStatus();
            }
            case 0x40000C: {
                return this.readScFailoverHubConnectionStatus();
            }
            case 4194322: {
                return this.readScHubFunctionEnable();
            }
            case 0x40000F: {
                return this.readScHubFunctionAcceptUris(index);
            }
            case 0x400010: {
                return this.readScHubFunctionBinding();
            }
            case 0x400011: {
                return this.readScHubFunctionConnectionStatus();
            }
            case 0x400009: {
                return this.readScDirectConnectInitiateEnable();
            }
            case 0x400005: {
                return this.readScDirectConnectAcceptEnable();
            }
            case 0x400006: {
                return this.readScDirectConnectAcceptUris(index);
            }
            case 0x400007: {
                return this.readScDirectConnectBinding();
            }
            case 0x400008: {
                return this.readScDirectConnectConnectionStatus();
            }
            case 0x40000B: {
                return this.readScFailedConnectionRequests();
            }
        }
        return new NReadPropertyResult(propertyId, new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty));
    }

    @Override
    protected List<? extends BIBacnetDataType> getListElements(int propertyId) throws ErrorException {
        switch (propertyId) {
            case 428: {
                return this.getRouterEntries();
            }
            case 0x400011: {
                return BBacnetScPortDescriptor.getScHubFunctionConnections(this.getHubFunction());
            }
            case 0x400008: {
                return this.getScDirectConnections();
            }
            case 0x40000B: {
                return this.getFailedConnections();
            }
        }
        throw new IllegalArgumentException("Invalid propertyId value " + propertyId);
    }

    @Override
    protected ErrorType writeOptionalProperty(int propertyId, int index, byte[] value, int priority) throws BacnetException {
        switch (propertyId) {
            case 399: 
            case 423: 
            case 426: 
            case 428: 
            case 0x400000: 
            case 0x400001: 
            case 0x400007: 
            case 0x400008: 
            case 0x40000B: 
            case 0x40000C: 
            case 0x40000E: 
            case 0x400014: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this + ": attempted to write read-only property " + BBacnetPropertyIdentifier.tag(propertyId));
                }
                return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
            }
            case 425: {
                return this.writeNetworkNumber(value);
            }
            case 4194325: {
                return this.writeScPrimaryHubUri(value);
            }
            case 0x40000D: {
                return this.writeScFailoverHubUri(value);
            }
            case 4194327: {
                return this.writeScMinimumReconnectTime(value);
            }
            case 4194326: {
                return this.writeScMaximumReconnectTime(value);
            }
            case 0x400004: {
                return this.writeScConnectWaitTimeout(value);
            }
            case 0x40000A: {
                return this.writeScDisconnectWaitTimeout(value);
            }
            case 4194323: {
                return this.writeScHeartbeatTimeout(value);
            }
            case 4194322: {
                return this.writeScHubFunctionEnable(value);
            }
            case 0x40000F: {
                return this.writeScHubFunctionAcceptUris(index, value);
            }
            case 0x400010: {
                return this.writeScHubFunctionBinding();
            }
            case 0x400011: {
                return this.writeScHubFunctionConnectionStatus();
            }
            case 0x400009: {
                return this.writeScDirectConnectInitiateEnable(value);
            }
            case 0x400005: {
                return this.writeScDirectConnectAcceptEnable(value);
            }
            case 0x400006: {
                return this.writeScDirectConnectAcceptUris(index, value);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": attempted to write unknown property " + BBacnetPropertyIdentifier.tag(propertyId));
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
    }

    @Override
    protected void validateSetPendingChange(String name, BValue value, Context context) {
        switch (name) {
            case "NetworkNumber": {
                this.validateSetNetworkNumber(value, context);
                break;
            }
            case "ScPrimaryHubUri": {
                this.validateSetPrimaryHubUri(value, context);
                break;
            }
            case "ScFailoverHubUri": {
                this.validateSetFailoverHubUri(value, context);
                break;
            }
            case "ScHubFunctionEnable": {
                this.validateSetHubFunctionEnable(value, context);
                break;
            }
            case "ScDirectConnectInitiateEnable": {
                this.validateSetDirectConnectInitiateEnable(value, context);
                break;
            }
            case "ScDirectConnectAcceptEnable": {
                this.validateSetDirectConnectAcceptEnable(value, context);
                break;
            }
            default: {
                throw new LocalizableRuntimeException("bacnet", "networkPortDescriptor.pendingChange.unknown", new Object[]{name});
            }
        }
    }

    @Override
    public void validateChanges(Context context) throws ValidateChangesException {
        if (!this.hasPendingChanges()) {
            return;
        }
        this.checkCanReadPendingChanges(context);
        this.validateNetworkNumber(context);
        this.validateScPrimaryHubUri(context);
        this.validateScFailoverHubUri(context);
        this.validateScHubFunctionEnable(context);
        this.validateScDirectConnectInitiateEnable(context);
        this.validateScDirectConnectAcceptEnable(context);
    }

    @Override
    public void activateChanges(Context context) throws Exception {
        if (!this.hasPendingChanges()) {
            return;
        }
        this.activateNetworkNumber(context);
        this.activateScPrimaryHubUri(context);
        this.activateScFailoverHubUri(context);
        this.activateScHubFunctionEnable(context);
        this.activateScDirectConnectInitiateEnable(context);
        this.activateScDirectConnectAcceptEnable(context);
    }

    private PropertyValue readMacAddress() {
        byte[] macBytes = this.getScLink().getMacAddress();
        if (macBytes == null || macBytes.length != 6) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.macAddress, BBacnetErrorClass.property, BBacnetErrorCode.valueNotInitialized);
        }
        return BacnetDescriptorUtil.makeOctetStringReadResult(BBacnetPropertyIdentifier.macAddress, macBytes);
    }

    private PropertyValue readMaxBvlcLengthAccepted() {
        return BacnetDescriptorUtil.makeUnsignedReadResult(BBacnetPropertyIdentifier.maxBvlcLengthAccepted, this.getScLink().getMaxBvlcLength());
    }

    private PropertyValue readMaxNpduLengthAccepted() {
        return BacnetDescriptorUtil.makeUnsignedReadResult(BBacnetPropertyIdentifier.maxNpduLengthAccepted, this.getScLink().getMaxNpduLength());
    }

    private PropertyValue readScPrimaryHubUri() {
        BString pending = this.getPendingChange(SC_PRIMARY_HUB_URI, BString.class);
        if (pending != null) {
            return BacnetDescriptorUtil.makeCharStringReadResult(BBacnetPropertyIdentifier.scPrimaryHubUri, pending.getString());
        }
        return this.readUri(BBacnetPropertyIdentifier.scPrimaryHubUri, this.getPrimaryConnection());
    }

    private ErrorType writeScPrimaryHubUri(byte[] value) throws AsnException {
        String uri = AsnUtil.fromAsnCharacterString(value);
        try {
            BBacnetScPortDescriptor.validateUri(uri, BBacnetPropertyIdentifier.scPrimaryHubUri);
        }
        catch (ValidateChangesException e) {
            return e.getError();
        }
        this.addPendingChange(SC_PRIMARY_HUB_URI, (BValue)BString.make((String)uri), BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    private void validateSetPrimaryHubUri(BValue value, Context context) {
        this.checkPendingChangeType(SC_PRIMARY_HUB_URI, value, BString.TYPE);
        this.checkCanWriteUri(this.getPrimaryConnection(), context);
    }

    private void validateScPrimaryHubUri(Context context) throws ValidateChangesException {
        BString change = this.getPendingChange(SC_PRIMARY_HUB_URI, BString.class);
        if (change != null) {
            BBacnetScPortDescriptor.validateUri(change.getString(), BBacnetPropertyIdentifier.scPrimaryHubUri);
            this.validateCanWriteUri(this.getPrimaryConnection(), BBacnetPropertyIdentifier.scPrimaryHubUri, context);
        }
    }

    private void activateScPrimaryHubUri(Context context) throws URISyntaxException {
        BString change = this.getPendingChange(SC_PRIMARY_HUB_URI, BString.class);
        if (change != null) {
            BBacnetScPortDescriptor.activateUri(change.getString(), this.getPrimaryConnection(), context);
        }
    }

    private PropertyValue readScFailoverHubUri() {
        BString pending = this.getPendingChange(SC_FAILOVER_HUB_URI, BString.class);
        if (pending != null) {
            return BacnetDescriptorUtil.makeCharStringReadResult(BBacnetPropertyIdentifier.scFailoverHubUri, pending.getString());
        }
        return this.readUri(BBacnetPropertyIdentifier.scFailoverHubUri, this.getFailoverConnection());
    }

    private ErrorType writeScFailoverHubUri(byte[] value) throws AsnException {
        String uri = AsnUtil.fromAsnCharacterString(value);
        try {
            BBacnetScPortDescriptor.validateUri(uri, BBacnetPropertyIdentifier.scFailoverHubUri);
        }
        catch (ValidateChangesException e) {
            return e.getError();
        }
        this.addPendingChange(SC_FAILOVER_HUB_URI, (BValue)BString.make((String)uri), BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    private void validateSetFailoverHubUri(BValue value, Context context) {
        this.checkPendingChangeType(SC_FAILOVER_HUB_URI, value, BString.TYPE);
        this.checkCanWriteUri(this.getFailoverConnection(), context);
    }

    private void validateScFailoverHubUri(Context context) throws ValidateChangesException {
        BString change = this.getPendingChange(SC_FAILOVER_HUB_URI, BString.class);
        if (change != null) {
            BBacnetScPortDescriptor.validateUri(change.getString(), BBacnetPropertyIdentifier.scFailoverHubUri);
            this.validateCanWriteUri(this.getFailoverConnection(), BBacnetPropertyIdentifier.scFailoverHubUri, context);
        }
    }

    private void activateScFailoverHubUri(Context context) throws URISyntaxException {
        BString change = this.getPendingChange(SC_FAILOVER_HUB_URI, BString.class);
        if (change != null) {
            BBacnetScPortDescriptor.activateUri(change.getString(), this.getFailoverConnection(), context);
        }
    }

    private PropertyValue readScMinimumReconnectTime() {
        return BBacnetScPortDescriptor.readConfigTime(BBacnetPropertyIdentifier.scMinimumReconnectTime, this.getScConfig().getMinimumReconnectTime().getSeconds());
    }

    private ErrorType writeScMinimumReconnectTime(byte[] value) throws AsnException {
        return this.writeConfigTime(BScConfiguration.minimumReconnectTime, value, 1, 600);
    }

    private PropertyValue readScMaximumReconnectTime() {
        return BBacnetScPortDescriptor.readConfigTime(BBacnetPropertyIdentifier.scMaximumReconnectTime, this.getScConfig().getMaximumReconnectTime().getSeconds());
    }

    private ErrorType writeScMaximumReconnectTime(byte[] value) throws AsnException {
        return this.writeConfigTime(BScConfiguration.maximumReconnectTime, value, 1, 600);
    }

    private PropertyValue readScConnectWaitTimeout() {
        return BBacnetScPortDescriptor.readConfigTime(BBacnetPropertyIdentifier.scConnectWaitTimeout, this.getScConfig().getConnectWaitTimeout().getSeconds());
    }

    private ErrorType writeScConnectWaitTimeout(byte[] value) throws AsnException {
        return this.writeConfigTime(BScConfiguration.connectWaitTimeout, value, 1, Integer.MAX_VALUE);
    }

    private PropertyValue readScDisconnectWaitTimeout() {
        return BBacnetScPortDescriptor.readConfigTime(BBacnetPropertyIdentifier.scDisconnectWaitTimeout, this.getScConfig().getDisconnectWaitTimeout().getSeconds());
    }

    private ErrorType writeScDisconnectWaitTimeout(byte[] value) throws AsnException {
        return this.writeConfigTime(BScConfiguration.disconnectWaitTimeout, value, 1, Integer.MAX_VALUE);
    }

    private PropertyValue readScHeartbeatTimeout() {
        return BBacnetScPortDescriptor.readConfigTime(BBacnetPropertyIdentifier.scHeartbeatTimeout, this.getScConfig().getInitiatingHeartbeatTimeout().getSeconds());
    }

    private ErrorType writeScHeartbeatTimeout(byte[] value) throws AsnException {
        return this.writeConfigTime(BScConfiguration.initiatingHeartbeatTimeout, value, 1, Integer.MAX_VALUE);
    }

    private PropertyValue readScHubConnectorState() {
        return BacnetDescriptorUtil.makeEnumReadResult(BBacnetPropertyIdentifier.scHubConnectorState, (BEnum)this.getHubConnector().getState());
    }

    private PropertyValue readScPrimaryHubConnectionStatus() {
        return BBacnetScPortDescriptor.readHubConnectionStatus(BBacnetPropertyIdentifier.scPrimaryHubConnectionStatus, this.getPrimaryConnection());
    }

    private static PropertyValue readHubConnectionStatus(BBacnetPropertyIdentifier propertyIdentifier, BHubInitiatingConnection connection) {
        BBacnetScHubConnection scHubConnection = new BBacnetScHubConnection();
        scHubConnection.setConnectionState(connection.getState());
        scHubConnection.setConnectTimestamp(BBacnetScPortDescriptor.makeDateTime(connection.getLastConnect()));
        scHubConnection.setDisconnectTimestamp(BBacnetScPortDescriptor.makeDateTime(connection.getLastDisconnect()));
        BErrorType error = connection.getError();
        if (error.getErrorClass() != -1) {
            scHubConnection.setError((BErrorType)connection.getError().newCopy());
            scHubConnection.setErrorDetails(connection.getErrorDetails());
        }
        return BacnetDescriptorUtil.makeConstructedReadResult(propertyIdentifier, (BValue)scHubConnection);
    }

    private PropertyValue readScFailoverHubConnectionStatus() {
        return BBacnetScPortDescriptor.readHubConnectionStatus(BBacnetPropertyIdentifier.scFailoverHubConnectionStatus, this.getFailoverConnection());
    }

    private PropertyValue readScHubFunctionEnable() {
        BHubFunction hubFunction = this.getHubFunction();
        if (hubFunction == null) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.scHubFunctionEnable, BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        BBoolean pending = this.getPendingChange(SC_HUB_FUNCTION_ENABLE, BBoolean.class);
        return BacnetDescriptorUtil.makeBooleanReadResult(BBacnetPropertyIdentifier.scHubFunctionEnable, pending != null ? pending.getBoolean() : hubFunction.getEnabled());
    }

    private ErrorType writeScHubFunctionEnable(byte[] value) throws AsnException {
        BHubFunction hubFunction = this.getHubFunction();
        if (hubFunction == null) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        this.addPendingChange(SC_HUB_FUNCTION_ENABLE, (BValue)BBoolean.make((boolean)AsnUtil.fromAsnBoolean(value)), BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    private void validateSetHubFunctionEnable(BValue value, Context context) {
        this.checkPendingChangeType(SC_HUB_FUNCTION_ENABLE, value, BBoolean.TYPE);
        this.checkCanWrite(this.getHubFunction(), (Slot)BHubFunction.enabled, context);
    }

    private void validateScHubFunctionEnable(Context context) throws ValidateChangesException {
        BHubFunction hubFunction = this.getHubFunction();
        if (hubFunction == null) {
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty, BBacnetPropertyIdentifier.scHubFunctionEnable, "Port does not support the BACnet/SC hub function.");
        }
        this.validateCanWrite(hubFunction, (Slot)BHubFunction.enabled, BBacnetPropertyIdentifier.scHubFunctionEnable, context);
    }

    private void activateScHubFunctionEnable(Context context) {
        BBoolean change = this.getPendingChange(SC_HUB_FUNCTION_ENABLE, BBoolean.class);
        if (change != null) {
            this.getHubFunction().setBoolean(BHubFunction.enabled, change.getBoolean(), context);
        }
    }

    private PropertyValue readScHubFunctionAcceptUris(int index) {
        BHubFunction hubFunction = this.getHubFunction();
        if (hubFunction == null) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.scHubFunctionAcceptUris, BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        return BacnetDescriptorUtil.readArray(BBacnetPropertyIdentifier.scHubFunctionAcceptUris, index, hubFunction.getAcceptUris());
    }

    private ErrorType writeScHubFunctionAcceptUris(int index, byte[] value) throws AsnException {
        BHubFunction hubFunction = this.getHubFunction();
        if (hubFunction == null) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        return BBacnetScPortDescriptor.writeAcceptUris(hubFunction.getAcceptUris(), index, value);
    }

    private PropertyValue readScHubFunctionBinding() {
        BHubFunction hubFunction = this.getHubFunction();
        if (hubFunction == null) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.scHubFunctionBinding, BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        return BBacnetScPortDescriptor.readHttpsPortBinding(BBacnetPropertyIdentifier.scHubFunctionBinding, hubFunction);
    }

    private ErrorType writeScHubFunctionBinding() {
        return this.writeHubFunctionReadOnlyProperty(BBacnetPropertyIdentifier.scHubFunctionBinding);
    }

    private PropertyValue readScHubFunctionConnectionStatus() {
        BHubFunction hubFunction = this.getHubFunction();
        if (hubFunction == null) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.scHubFunctionConnectionStatus, BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        BBacnetListOf list = new BBacnetListOf(BBacnetScHubFunctionConnection.TYPE);
        for (BBacnetScHubFunctionConnection connection : BBacnetScPortDescriptor.getScHubFunctionConnections(hubFunction)) {
            list.addListElement((BValue)connection, null);
        }
        return BacnetDescriptorUtil.makeListOfReadResult(BBacnetPropertyIdentifier.scHubFunctionConnectionStatus, list);
    }

    private static List<BBacnetScHubFunctionConnection> getScHubFunctionConnections(BHubFunction hubFunction) {
        BHubAcceptingConnection[] connections = (BHubAcceptingConnection[])hubFunction.getConnections().getChildren(BHubAcceptingConnection.class);
        ArrayList<BBacnetScHubFunctionConnection> scConnections = new ArrayList<BBacnetScHubFunctionConnection>(connections.length);
        for (BHubAcceptingConnection connection : connections) {
            BBacnetScConnectionState connectionState = connection.getState();
            if (connectionState.equals((Object)BBacnetScConnectionState.failedToConnect)) continue;
            BBacnetScHubFunctionConnection scConnection = new BBacnetScHubFunctionConnection();
            scConnection.setConnectionState(connectionState);
            scConnection.setConnectTimestamp(BBacnetScPortDescriptor.makeDateTime(connection.getLastConnect()));
            scConnection.setDisconnectTimestamp(BBacnetScPortDescriptor.makeDateTime(connection.getLastDisconnect()));
            scConnection.setPeerAddress(BBacnetScPortDescriptor.makeHostNPort(connection.getNodeAddress()));
            scConnection.setPeerVmac(connection.getNodeVmac());
            scConnection.setPeerUuid(BBacnetOctetString.make(connection.getNodeUuid().getBytes()));
            if (connectionState.equals((Object)BBacnetScConnectionState.disconnectedWithErrors)) {
                scConnection.setError((BErrorType)connection.getError().newCopy());
                scConnection.setErrorDetails(connection.getErrorDetails());
            }
            scConnections.add(scConnection);
        }
        return scConnections;
    }

    private ErrorType writeScHubFunctionConnectionStatus() {
        return this.writeHubFunctionReadOnlyProperty(BBacnetPropertyIdentifier.scHubFunctionConnectionStatus);
    }

    private PropertyValue readScDirectConnectInitiateEnable() {
        BBoolean pending = this.getPendingChange(SC_DIRECT_CONNECT_INITIATE_ENABLE, BBoolean.class);
        return BacnetDescriptorUtil.makeBooleanReadResult(BBacnetPropertyIdentifier.scDirectConnectInitiateEnable, pending != null ? pending.getBoolean() : this.getNodeSwitch().getInitiateEnabled());
    }

    private ErrorType writeScDirectConnectInitiateEnable(byte[] value) throws AsnException {
        this.addPendingChange(SC_DIRECT_CONNECT_INITIATE_ENABLE, (BValue)BBoolean.make((boolean)AsnUtil.fromAsnBoolean(value)), BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    private void validateSetDirectConnectInitiateEnable(BValue value, Context context) {
        this.checkPendingChangeType(SC_DIRECT_CONNECT_INITIATE_ENABLE, value, BBoolean.TYPE);
        this.checkCanWrite(this.getNodeSwitch(), (Slot)BNodeSwitch.initiateEnabled, context);
    }

    private void validateScDirectConnectInitiateEnable(Context context) throws ValidateChangesException {
        BBoolean pending = this.getPendingChange(SC_DIRECT_CONNECT_INITIATE_ENABLE, BBoolean.class);
        if (pending != null) {
            this.validateCanWrite(this.getNodeSwitch(), (Slot)BNodeSwitch.initiateEnabled, BBacnetPropertyIdentifier.scDirectConnectInitiateEnable, context);
        }
    }

    private void activateScDirectConnectInitiateEnable(Context context) {
        BBoolean change = this.getPendingChange(SC_DIRECT_CONNECT_INITIATE_ENABLE, BBoolean.class);
        if (change != null) {
            this.getNodeSwitch().setBoolean(BNodeSwitch.initiateEnabled, change.getBoolean(), context);
        }
    }

    private PropertyValue readScDirectConnectAcceptEnable() {
        BBoolean pending = this.getPendingChange(SC_DIRECT_CONNECT_ACCEPT_ENABLE, BBoolean.class);
        return BacnetDescriptorUtil.makeBooleanReadResult(BBacnetPropertyIdentifier.scDirectConnectAcceptEnable, pending != null ? pending.getBoolean() : this.getNodeSwitch().getAcceptEnabled());
    }

    private ErrorType writeScDirectConnectAcceptEnable(byte[] value) throws AsnException {
        this.addPendingChange(SC_DIRECT_CONNECT_ACCEPT_ENABLE, (BValue)BBoolean.make((boolean)AsnUtil.fromAsnBoolean(value)), BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    private void validateSetDirectConnectAcceptEnable(BValue value, Context context) {
        this.checkPendingChangeType(SC_DIRECT_CONNECT_ACCEPT_ENABLE, value, BBoolean.TYPE);
        this.checkCanWrite(this.getNodeSwitch(), (Slot)BNodeSwitch.acceptEnabled, context);
    }

    private void validateScDirectConnectAcceptEnable(Context context) throws ValidateChangesException {
        BBoolean pending = this.getPendingChange(SC_DIRECT_CONNECT_ACCEPT_ENABLE, BBoolean.class);
        if (pending != null) {
            this.validateCanWrite(this.getNodeSwitch(), (Slot)BNodeSwitch.acceptEnabled, BBacnetPropertyIdentifier.scDirectConnectAcceptEnable, context);
        }
    }

    private void activateScDirectConnectAcceptEnable(Context context) {
        BBoolean change = this.getPendingChange(SC_DIRECT_CONNECT_ACCEPT_ENABLE, BBoolean.class);
        if (change != null) {
            this.getNodeSwitch().setBoolean(BNodeSwitch.acceptEnabled, change.getBoolean(), context);
        }
    }

    private PropertyValue readScDirectConnectBinding() {
        return BBacnetScPortDescriptor.readHttpsPortBinding(BBacnetPropertyIdentifier.scDirectConnectBinding, this.getNodeSwitch());
    }

    private PropertyValue readScDirectConnectAcceptUris(int index) {
        return BacnetDescriptorUtil.readArray(BBacnetPropertyIdentifier.scDirectConnectAcceptUris, index, this.getNodeSwitch().getAcceptUris());
    }

    private ErrorType writeScDirectConnectAcceptUris(int index, byte[] value) throws AsnException {
        return BBacnetScPortDescriptor.writeAcceptUris(this.getNodeSwitch().getAcceptUris(), index, value);
    }

    private PropertyValue readScDirectConnectConnectionStatus() {
        BBacnetListOf list = new BBacnetListOf(BBacnetScDirectConnection.TYPE);
        for (BBacnetScDirectConnection connection : this.getScDirectConnections()) {
            list.addListElement((BValue)connection, null);
        }
        return BacnetDescriptorUtil.makeListOfReadResult(BBacnetPropertyIdentifier.scDirectConnectConnectionStatus, list);
    }

    private List<BBacnetScDirectConnection> getScDirectConnections() {
        BAbstractConnection[] connections = (BAbstractConnection[])this.getNodeSwitch().getConnections().getChildren(BAbstractConnection.class);
        ArrayList<BBacnetScDirectConnection> scConnections = new ArrayList<BBacnetScDirectConnection>(connections.length);
        for (BAbstractConnection connection : connections) {
            BUuid peerUuid;
            BBacnetOctetString peerVmac;
            BInternetAddress peerAddress;
            BBacnetScDirectConnection scConnection;
            BBacnetScConnectionState connectionState;
            block10: {
                connectionState = connection.getState();
                if (!(connection instanceof BDirectInitiatingConnection) && connectionState.equals((Object)BBacnetScConnectionState.failedToConnect)) continue;
                scConnection = new BBacnetScDirectConnection();
                if (connection instanceof BDirectInitiatingConnection) {
                    try {
                        scConnection.setUri(((BDirectInitiatingConnection)connection).getURI().toString());
                    }
                    catch (URISyntaxException e) {
                        if (!logger.isLoggable(Level.FINE)) break block10;
                        logger.log(Level.FINE, this + ": failed to write direct initiating connection URI", e);
                    }
                }
            }
            scConnection.setConnectionState(connectionState);
            if (connectionState.equals((Object)BBacnetScConnectionState.failedToConnect)) {
                scConnection.setConnectTimestamp(BBacnetScPortDescriptor.makeDateTime(connection.getLastFailureToConnect()));
            } else {
                scConnection.setConnectTimestamp(BBacnetScPortDescriptor.makeDateTime(connection.getLastConnect()));
            }
            scConnection.setDisconnectTimestamp(BBacnetScPortDescriptor.makeDateTime(connection.getLastDisconnect()));
            if (connection instanceof BDirectInitiatingConnection) {
                BDirectInitiatingConnection initiatingConnection = (BDirectInitiatingConnection)connection;
                peerAddress = initiatingConnection.getPeerAddress();
                peerVmac = initiatingConnection.getPeerVmac();
                peerUuid = initiatingConnection.getPeerUuid();
            } else {
                BDirectAcceptingConnection acceptingConnection = (BDirectAcceptingConnection)connection;
                peerAddress = acceptingConnection.getPeerAddress();
                peerVmac = acceptingConnection.getPeerVmac();
                peerUuid = acceptingConnection.getPeerUuid();
            }
            scConnection.setPeerAddress(BBacnetScPortDescriptor.makeHostNPort(peerAddress));
            scConnection.setPeerVmac(peerVmac);
            if (!peerUuid.equals((Object)BUuid.DEFAULT)) {
                scConnection.setPeerUuid(BBacnetOctetString.make(peerUuid.getBytes()));
            }
            if (connectionState.equals((Object)BBacnetScConnectionState.failedToConnect) || connectionState.equals((Object)BBacnetScConnectionState.disconnectedWithErrors)) {
                scConnection.setError((BErrorType)connection.getError().newCopy());
                scConnection.setErrorDetails(connection.getErrorDetails());
            }
            scConnections.add(scConnection);
        }
        return scConnections;
    }

    private PropertyValue readScFailedConnectionRequests() {
        BBacnetListOf list = new BBacnetListOf(BBacnetScFailedConnectionRequest.TYPE);
        for (BBacnetScFailedConnectionRequest connection : this.getFailedConnections()) {
            list.addListElement((BValue)connection, null);
        }
        return BacnetDescriptorUtil.makeListOfReadResult(BBacnetPropertyIdentifier.scFailedConnectionRequests, list);
    }

    private List<BBacnetScFailedConnectionRequest> getFailedConnections() {
        BDirectAcceptingConnection[] connections;
        ArrayList<BBacnetScFailedConnectionRequest> failedConnections = new ArrayList<BBacnetScFailedConnectionRequest>();
        BHubFunction hubFunction = this.getHubFunction();
        if (hubFunction != null) {
            for (BHubAcceptingConnection connection : (BHubAcceptingConnection[])hubFunction.getConnections().getChildren(BHubAcceptingConnection.class)) {
                if (!connection.getState().equals((Object)BBacnetScConnectionState.failedToConnect)) continue;
                BBacnetScFailedConnectionRequest failedConnection = new BBacnetScFailedConnectionRequest();
                failedConnection.setTimestamp(BBacnetScPortDescriptor.makeDateTime(connection.getLastFailureToConnect()));
                failedConnection.setPeerAddress(BBacnetScPortDescriptor.makeHostNPort(connection.getNodeAddress()));
                failedConnection.setPeerVmac(connection.getNodeVmac());
                BUuid nodeUuid = connection.getNodeUuid();
                if (!nodeUuid.equals((Object)BUuid.DEFAULT)) {
                    failedConnection.setPeerUuid(BBacnetOctetString.make(connection.getNodeUuid().getBytes()));
                }
                failedConnection.setError((BErrorType)connection.getError().newCopy());
                failedConnection.setErrorDetails(connection.getErrorDetails());
                failedConnections.add(failedConnection);
            }
        }
        for (BDirectAcceptingConnection connection : connections = (BDirectAcceptingConnection[])this.getNodeSwitch().getConnections().getChildren(BDirectAcceptingConnection.class)) {
            if (!connection.getState().equals((Object)BBacnetScConnectionState.failedToConnect)) continue;
            BBacnetScFailedConnectionRequest failedConnection = new BBacnetScFailedConnectionRequest();
            failedConnection.setTimestamp(BBacnetScPortDescriptor.makeDateTime(connection.getLastFailureToConnect()));
            failedConnection.setPeerAddress(BBacnetScPortDescriptor.makeHostNPort(connection.getPeerAddress()));
            failedConnection.setPeerVmac(connection.getPeerVmac());
            BUuid peerUuid = connection.getPeerUuid();
            if (!peerUuid.equals((Object)BUuid.DEFAULT)) {
                failedConnection.setPeerUuid(BBacnetOctetString.make(connection.getPeerUuid().getBytes()));
            }
            failedConnection.setError((BErrorType)connection.getError().newCopy());
            failedConnection.setErrorDetails(connection.getErrorDetails());
            failedConnections.add(failedConnection);
        }
        return failedConnections;
    }

    private BScLinkLayer getScLink() {
        return (BScLinkLayer)this.networkPort.getLink();
    }

    private BScConfiguration getScConfig() {
        return this.getScLink().getConfig();
    }

    private BNodeSwitch getNodeSwitch() {
        return this.getScLink().getNodeSwitch();
    }

    private BHubConnector getHubConnector() {
        return this.getScLink().getHubConnector();
    }

    private BHubFunction getHubFunction() {
        return this.getScLink().getHubFunction();
    }

    private BHubInitiatingConnection getPrimaryConnection() {
        return this.getHubConnector().getPrimaryConnection();
    }

    private BHubInitiatingConnection getFailoverConnection() {
        return this.getHubConnector().getFailoverConnection();
    }

    private PropertyValue readUri(BBacnetPropertyIdentifier propertyId, BHubInitiatingConnection connection) {
        try {
            return BacnetDescriptorUtil.makeCharStringReadResult(propertyId, connection.getURI().toString());
        }
        catch (URISyntaxException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, this + ": failed to retrieve connection URI for " + propertyId, e);
            }
            return BacnetDescriptorUtil.makeReadError(propertyId, BBacnetErrorClass.property, BBacnetErrorCode.other);
        }
    }

    private static void validateUri(String uri, BBacnetPropertyIdentifier propertyId) throws ValidateChangesException {
        String error = ScMessageUtil.checkWebSocketUri(uri);
        if (error != null) {
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange, propertyId, "Web Socket URI " + uri + " is not valid; error: " + error);
        }
    }

    private void checkCanWriteUri(BHubInitiatingConnection connection, Context context) {
        this.checkCanWrite(connection, (Slot)BHubInitiatingConnection.hubUriAddress, context);
        this.checkCanWrite(connection, (Slot)BHubInitiatingConnection.hubUriPath, context);
        this.checkCanWrite(connection, (Slot)BHubInitiatingConnection.hubUriQuery, context);
    }

    private void validateCanWriteUri(BHubInitiatingConnection connection, BBacnetPropertyIdentifier propertyId, Context context) throws ValidateChangesException {
        this.validateCanWrite(connection, (Slot)BHubInitiatingConnection.hubUriAddress, propertyId, context);
        this.validateCanWrite(connection, (Slot)BHubInitiatingConnection.hubUriPath, propertyId, context);
        this.validateCanWrite(connection, (Slot)BHubInitiatingConnection.hubUriQuery, propertyId, context);
    }

    private static void activateUri(String uriStr, BHubInitiatingConnection connection, Context context) throws URISyntaxException {
        URI uri = new URI(uriStr);
        connection.set(BHubInitiatingConnection.hubUriAddress, (BValue)new BInternetAddress(uri.getHost(), uri.getPort()), context);
        String path = uri.getPath();
        connection.setString(BHubInitiatingConnection.hubUriPath, path != null ? path : "", context);
        String query = uri.getQuery();
        connection.setString(BHubInitiatingConnection.hubUriQuery, query != null ? query : "", context);
    }

    private static PropertyValue readConfigTime(BBacnetPropertyIdentifier propertyId, int seconds) {
        if (seconds < 1) {
            return BacnetDescriptorUtil.makeReadError(propertyId, BBacnetErrorClass.property, BBacnetErrorCode.valueNotInitialized);
        }
        return BacnetDescriptorUtil.makeUnsignedReadResult(propertyId, seconds);
    }

    private ErrorType writeConfigTime(Property configProp, byte[] value, int min, int max) throws AsnException {
        int seconds = AsnUtil.fromAsnUnsignedInt(value);
        if (seconds < min || seconds > max) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
        }
        this.getScConfig().set(configProp, (BValue)BRelTime.makeSeconds((int)seconds), BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    private static BBacnetDateTime makeDateTime(BAbsTime absTime) {
        return absTime.equals((Object)BAbsTime.DEFAULT) ? new BBacnetDateTime() : new BBacnetDateTime(absTime);
    }

    private static PropertyValue readHttpsPortBinding(BBacnetPropertyIdentifier propertyId, BAbstractConnectionManager connectionManager) {
        BWebService webService = connectionManager.getWebSocketAcceptor().getWebService();
        if (webService == null) {
            return BacnetDescriptorUtil.makeReadError(propertyId, BBacnetErrorClass.property, BBacnetErrorCode.valueNotInitialized);
        }
        return BacnetDescriptorUtil.makeCharStringReadResult(propertyId, Integer.toString(webService.getHttpsPort().getPublicServerPort()));
    }

    private static BBacnetHostNPort makeHostNPort(BInternetAddress internetAddress) {
        String host = internetAddress.getHost();
        if (host == null) {
            return new BBacnetHostNPort();
        }
        byte[] hostBytes = IPAddressUtil.numericStringToByteArray((String)host);
        BBacnetHostAddress hostAddress = hostBytes != null && (hostBytes.length == 4 || hostBytes.length == 16) ? BBacnetHostAddress.makeWithIpAddress(hostBytes) : BBacnetHostAddress.makeWithHostName(host);
        return new BBacnetHostNPort(hostAddress, Math.max(0, internetAddress.getPort()));
    }

    private static ErrorType writeAcceptUris(BBacnetArray array, int index, byte[] value) throws AsnException {
        if (index == 0) {
            int newSize = AsnUtil.fromAsnUnsignedInt(value);
            array.setInt(BBacnetArray.size, newSize, BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        if (index == -1) {
            BBacnetArray newArray = new BBacnetArray(BString.TYPE);
            newArray = (BBacnetArray)AsnUtil.fromAsn(-2, value, (BValue)newArray);
            for (BString element : (BString[])newArray.getChildren(BString.class)) {
                if (ScMessageUtil.checkWebSocketUri(element.getString()) == null) continue;
                return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
            }
            array.getParent().set(array.getPropertyInParent(), (BValue)newArray, BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        if (index >= 1 && index <= array.getSize()) {
            String uri = AsnUtil.fromAsnCharacterString(value);
            if (ScMessageUtil.checkWebSocketUri(uri) != null) {
                return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
            }
            array.set("element" + index, (BValue)BString.make((String)uri), BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.invalidArrayIndex);
    }

    private ErrorType writeHubFunctionReadOnlyProperty(BBacnetPropertyIdentifier propertyId) {
        BHubFunction hubFunction = this.getHubFunction();
        if (hubFunction == null) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": attempted to write read-only property " + propertyId);
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
    }
}

