/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetAnalogValueDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"control:NumericPoint"})})
@NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.POSITIVE_INTEGER_VALUE)", flags=64, override=true)
public class BBacnetPositiveIntegerValueDescriptor
extends BBacnetAnalogValueDescriptor {
    @Generated
    public static final Property objectId = BBacnetPositiveIntegerValueDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(48), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetPositiveIntegerValueDescriptor.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BBacnetReliability validatePoint(BNumericPoint point, BStatusNumeric pointOut) {
        return this.validatePositiveIntegerPoint(point, pointOut);
    }

    @Override
    public byte[] convertToAsn(double value) {
        return AsnUtil.toAsnUnsigned((long)value);
    }

    @Override
    public byte[] convertToAsn(BValue value) {
        return AsnUtil.toAsnUnsigned(((BNumber)value).getLong());
    }

    @Override
    public double convertFromAsn(byte[] value) throws AsnException {
        return AsnUtil.fromAsnUnsignedInteger(value);
    }

    @Override
    protected void addRequiredProps(Vector v) {
        v.add(BBacnetPropertyIdentifier.presentValue);
        v.add(BBacnetPropertyIdentifier.statusFlags);
        v.add(BBacnetPropertyIdentifier.units);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        this.addValueObjectOptionalProps(v);
    }
}

