/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BBacnetTrendLogAlarmSourceExt;
import com.tridium.bacnet.history.BBacnetTrendRecord;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetLogRecord;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.BacnetPropertyList;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"history:IHistory"})})
@NiagaraProperties(value={@NiagaraProperty(name="id", type="BHistoryId", defaultValue="BHistoryId.NULL", flags=8), @NiagaraProperty(name="historyOrd", type="BOrd", defaultValue="BOrd.DEFAULT", flags=5), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.TREND_LOG)", flags=64), @NiagaraProperty(name="objectName", type="String", defaultValue="", flags=64), @NiagaraProperty(name="description", type="String", defaultValue=""), @NiagaraProperty(name="firstTimestamp", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=5), @NiagaraProperty(name="firstSeqNum", type="long", defaultValue="0", flags=5), @NiagaraProperty(name="lastTimestamp", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=5), @NiagaraProperty(name="lastSeqNum", type="long", defaultValue="0", flags=5)})
public class BBacnetNiagaraHistoryDescriptor
extends BBacnetEventSource {
    @Generated
    public static final Property id = BBacnetNiagaraHistoryDescriptor.newProperty((int)8, (BValue)BHistoryId.NULL, null);
    @Generated
    public static final Property historyOrd = BBacnetNiagaraHistoryDescriptor.newProperty((int)5, (BValue)BOrd.DEFAULT, null);
    @Generated
    public static final Property objectId = BBacnetNiagaraHistoryDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(20), null);
    @Generated
    public static final Property objectName = BBacnetNiagaraHistoryDescriptor.newProperty((int)64, (String)"", null);
    @Generated
    public static final Property description = BBacnetNiagaraHistoryDescriptor.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property firstTimestamp = BBacnetNiagaraHistoryDescriptor.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property firstSeqNum = BBacnetNiagaraHistoryDescriptor.newProperty((int)5, (int)0, null);
    @Generated
    public static final Property lastTimestamp = BBacnetNiagaraHistoryDescriptor.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastSeqNum = BBacnetNiagaraHistoryDescriptor.newProperty((int)5, (int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetNiagaraHistoryDescriptor.class);
    private static final int[] ARRAY_PROPS = new int[]{130, 351, 352, 371};
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"history.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    private int[] optionalProps;
    private BBacnetObjectIdentifier oldId = null;
    private String oldName = null;
    private boolean duplicate = false;
    private static AsnOutputStream asnOut = new AsnOutputStream();
    private static final int[] REQUIRED_PROPS = new int[]{75, 77, 79, 133, 144, 126, 131, 141, 145, 36};
    static Logger log = Logger.getLogger("bacnet.server");

    @Generated
    public BHistoryId getId() {
        return (BHistoryId)this.get(id);
    }

    @Generated
    public void setId(BHistoryId v) {
        this.set(id, (BValue)v, null);
    }

    @Generated
    public BOrd getHistoryOrd() {
        return (BOrd)this.get(historyOrd);
    }

    @Generated
    public void setHistoryOrd(BOrd v) {
        this.set(historyOrd, (BValue)v, null);
    }

    @Override
    @Generated
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Override
    @Generated
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Override
    @Generated
    public String getObjectName() {
        return this.getString(objectName);
    }

    @Override
    @Generated
    public void setObjectName(String v) {
        this.setString(objectName, v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public BAbsTime getFirstTimestamp() {
        return (BAbsTime)this.get(firstTimestamp);
    }

    @Generated
    public void setFirstTimestamp(BAbsTime v) {
        this.set(firstTimestamp, (BValue)v, null);
    }

    @Generated
    public long getFirstSeqNum() {
        return this.getLong(firstSeqNum);
    }

    @Generated
    public void setFirstSeqNum(long v) {
        this.setLong(firstSeqNum, v, null);
    }

    @Generated
    public BAbsTime getLastTimestamp() {
        return (BAbsTime)this.get(lastTimestamp);
    }

    @Generated
    public void setLastTimestamp(BAbsTime v) {
        this.set(lastTimestamp, (BValue)v, null);
    }

    @Generated
    public long getLastSeqNum() {
        return this.getLong(lastSeqNum);
    }

    @Generated
    public void setLastSeqNum(long v) {
        this.setLong(lastSeqNum, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public final void started() throws Exception {
        super.started();
        if (this.getFirstTimestamp().equals((Object)BAbsTime.NULL)) {
            this.initialize();
        }
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.checkConfiguration();
        if (Sys.isStationStarted()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        local.unexport(this.oldId, this.oldName, this);
        try (HistoryDatabaseConnection conn = BBacnetNiagaraHistoryDescriptor.getHistoryDbConnection(null);){
            local.unsubscribe(this, this.getHistory(conn));
        }
        this.optionalProps = null;
        this.oldId = null;
        this.oldName = null;
        if (local.isRunning()) {
            local.incrementDatabaseRevision();
        }
    }

    @Override
    public final void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p.equals(historyOrd)) {
            this.setId(BHistoryId.make((String)this.getHistoryOrd().parse()[0].getBody()));
            if (this.isRunning()) {
                this.checkConfiguration();
            }
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {
                // empty catch block
            }
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(id)) {
            this.setHistoryOrd(BOrd.make((String)("history:" + this.getId())));
            this.initialize();
            this.checkConfiguration();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        }
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(20);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public final BObject getObject() {
        return (BObject)this.getHistory();
    }

    @Override
    public final BOrd getObjectOrd() {
        return this.getHistoryOrd();
    }

    @Override
    public final void setObjectOrd(BOrd objectOrd, Context cx) {
        this.set(historyOrd, (BValue)objectOrd, cx);
    }

    @Override
    public void checkConfiguration() {
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        try (HistoryDatabaseConnection conn = BBacnetNiagaraHistoryDescriptor.getHistoryDbConnection(null);){
            local.unsubscribe(this, this.getHistory(conn));
            boolean configOk = true;
            if (this.getHistory(conn) == null) {
                this.setFaultCause("Cannot find exported history");
                configOk = false;
            } else {
                local.subscribe(this, this.getHistory(conn));
            }
            if (!this.getObjectId().isValid()) {
                this.setFaultCause("Invalid Object ID");
                configOk = false;
            }
            if (configOk) {
                String err = BBacnetNetwork.localDevice().export(this);
                if (err != null) {
                    this.duplicate = true;
                    this.setFaultCause(err);
                    configOk = false;
                } else {
                    this.duplicate = false;
                }
            }
            if (configOk) {
                this.setFaultCause("");
            }
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (!configOk ? 1 : 0) != 0));
        }
    }

    @Override
    public boolean isValidAlarmExt(BIAlarmSource ext) {
        return ext instanceof BBacnetTrendLogAlarmSourceExt;
    }

    @Override
    @Deprecated
    protected void updateAlarmInhibit() {
    }

    @Override
    public final boolean isEventInitiationEnabled() {
        return this.getNotificationClass() != null;
    }

    @Override
    public final BEnum getEventState() {
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        return BBacnetEventState.make(almExt.getAlarmState());
    }

    @Override
    public BControlPoint getPoint() {
        return null;
    }

    @Override
    public final BBacnetBitString getAckedTransitions() {
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(almExt.getAckedTransitions());
    }

    @Override
    public final BBacnetTimeStamp[] getEventTimeStamps() {
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        BAbsTime normalTime = almExt.getToOffnormalTimes().getNormalTime();
        if (normalTime.isBefore(almExt.getToFaultTimes().getNormalTime())) {
            normalTime = almExt.getToFaultTimes().getNormalTime();
        }
        return new BBacnetTimeStamp[]{new BBacnetTimeStamp(almExt.getToOffnormalTimes().getAlarmTime()), new BBacnetTimeStamp(almExt.getToFaultTimes().getAlarmTime()), new BBacnetTimeStamp(normalTime)};
    }

    @Override
    public final BBacnetNotifyType getNotifyType() {
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        return almExt.getNotifyType();
    }

    @Override
    public final BBacnetBitString getEventEnable() {
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(almExt.getAlarmEnable());
    }

    @Override
    public final int[] getEventPriorities() {
        BBacnetNotificationClassDescriptor nc = this.getNotificationClass();
        if (nc == null) {
            return null;
        }
        return nc.getEventPriorities();
    }

    @Override
    public final BBacnetNotificationClassDescriptor getNotificationClass() {
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return null;
        }
        try {
            BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmClass ac = as.lookupAlarmClass(almExt.getAlarmClass());
            SlotCursor c = ac.getProperties();
            if (c.next(BBacnetNotificationClassDescriptor.class)) {
                return (BBacnetNotificationClassDescriptor)c.get();
            }
        }
        catch (ServiceNotFoundException e) {
            log.log(Level.SEVERE, "getNotificationClass on " + this + ": Unable to find alarm service", e);
        }
        return null;
    }

    @Override
    public BEnum getEventType() {
        return BBacnetEventType.bufferReady;
    }

    public String toString(Context c) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + "]";
    }

    final BBacnetTrendLogAlarmSourceExt getAlarmExt() {
        SlotCursor c = this.getProperties();
        if (c.next(BBacnetTrendLogAlarmSourceExt.class)) {
            return (BBacnetTrendLogAlarmSourceExt)c.get();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": found no associated BacnetTrendLogAlarmSourceExt");
        }
        return null;
    }

    private void initialize() {
        try (HistoryDatabaseConnection conn = BBacnetNiagaraHistoryDescriptor.getHistoryDbConnection(null);){
            BIHistory history = this.getHistory(conn);
            if (history == null) {
                this.resetTimestamps();
                return;
            }
            int dataSize = conn.getRecordCount(history);
            if (dataSize < 1) {
                this.resetTimestamps();
                return;
            }
            this.setFirstTimestamp(conn.getFirstTimestamp(history));
            this.setFirstSeqNum(1L);
            this.setLastTimestamp(conn.getLastTimestamp(history));
            this.setLastSeqNum(dataSize);
        }
    }

    private void resetTimestamps() {
        this.setFirstTimestamp(BAbsTime.NULL);
        this.setFirstSeqNum(0L);
        this.setLastTimestamp(BAbsTime.NULL);
        this.setLastSeqNum(0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BIHistory getHistory() {
        if (!this.isRunning()) {
            return null;
        }
        try (HistoryDatabaseConnection conn = BBacnetNiagaraHistoryDescriptor.getHistoryDbConnection(null);){
            BIHistory bIHistory = conn.getHistory(this.getId());
            return bIHistory;
        }
        catch (Exception e) {
            BBacnetNiagaraHistoryDescriptor.logException(Level.SEVERE, (Object)((Object)this.getObjectId()) + ": Exception occurred in getHistory", e);
            return null;
        }
    }

    public final BIHistory getHistory(HistoryDatabaseConnection conn) {
        if (!this.isRunning()) {
            return null;
        }
        try {
            return conn.getHistory(this.getId());
        }
        catch (Exception e) {
            BBacnetNiagaraHistoryDescriptor.logException(Level.SEVERE, (Object)((Object)this.getObjectId()) + ": Exception occurred in getHistory for history ID " + this.getId(), e);
            return null;
        }
    }

    private static HistoryDatabaseConnection getHistoryDbConnection(Context cx) {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        return db.getDbConnection(true, cx);
    }

    private void reinitTimestamps(HistoryDatabaseConnection conn, BIHistory history) {
        long count2;
        Throwable throwable;
        TableCursor data;
        BAbsTime newFirstTimestamp = conn.getFirstTimestamp(history);
        if (newFirstTimestamp.isNull()) {
            this.setFirstTimestamp(BAbsTime.NULL);
            this.setFirstSeqNum(0L);
            this.setLastTimestamp(BAbsTime.NULL);
            return;
        }
        BAbsTime oldFirstTimestamp = this.getFirstTimestamp();
        BAbsTime newLastTimestamp = conn.getLastTimestamp(history);
        BAbsTime oldLastTimestamp = this.getLastTimestamp();
        if (!newFirstTimestamp.equals((Object)oldFirstTimestamp)) {
            if (newFirstTimestamp.isAfter(oldLastTimestamp)) {
                this.setFirstTimestamp(newFirstTimestamp);
                this.setFirstSeqNum(BBacnetNiagaraHistoryDescriptor.getSequenceNumber(this.getLastSeqNum() + 1L));
            } else {
                data = conn.timeQuery(history, newFirstTimestamp, oldLastTimestamp).cursor();
                throwable = null;
                try {
                    count2 = BBacnetNiagaraHistoryDescriptor.countRecords((Cursor<BHistoryRecord>)data, oldLastTimestamp);
                    this.setFirstTimestamp(newFirstTimestamp);
                    this.setFirstSeqNum(BBacnetNiagaraHistoryDescriptor.getSequenceNumber(this.getLastSeqNum() - count2));
                }
                catch (Throwable count2) {
                    throwable = count2;
                    throw count2;
                }
                finally {
                    if (data != null) {
                        if (throwable != null) {
                            try {
                                data.close();
                            }
                            catch (Throwable count2) {
                                throwable.addSuppressed(count2);
                            }
                        } else {
                            data.close();
                        }
                    }
                }
            }
            if (newFirstTimestamp.isBefore(oldFirstTimestamp)) {
                log.log(Level.WARNING, "History has been altered causing the timestamp of the oldest record to be earlier than the timestamp of the previous oldest record; BACnet Object ID: " + (Object)((Object)this.getObjectId()) + ", history ID: " + history.getId());
            }
        }
        if (!newLastTimestamp.equals((Object)oldLastTimestamp)) {
            if (newLastTimestamp.isAfter(oldLastTimestamp)) {
                data = conn.timeQuery(history, oldLastTimestamp, newLastTimestamp).cursor();
                throwable = null;
                try {
                    count2 = BBacnetNiagaraHistoryDescriptor.countRecords((Cursor<BHistoryRecord>)data, oldLastTimestamp);
                    this.setLastTimestamp(newLastTimestamp);
                    this.setLastSeqNum(BBacnetNiagaraHistoryDescriptor.getSequenceNumber(this.getLastSeqNum() + count2));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (data != null) {
                        if (throwable != null) {
                            try {
                                data.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            data.close();
                        }
                    }
                }
            } else if (newLastTimestamp.isBefore(oldLastTimestamp)) {
                log.log(Level.WARNING, "History has been altered causing the timestamp of the newest record to be earlier than the timestamp of the previous newest record; BACnet Object ID: " + (Object)((Object)this.getObjectId()) + ", history ID: " + history.getId());
            }
        }
    }

    private static long countRecords(Cursor<BHistoryRecord> data, BAbsTime excludeTimestamp) {
        long count = 0L;
        while (data.next()) {
            if (((BHistoryRecord)data.get()).getTimestamp().equals((Object)excludeTimestamp)) continue;
            ++count;
        }
        return count;
    }

    private static long getSequenceNumber(long newSeqNum) {
        if (newSeqNum > BacnetTrendLogUtil.MAX_SEQ_NUM) {
            newSeqNum -= BacnetTrendLogUtil.MAX_SEQ_NUM;
        }
        return newSeqNum;
    }

    /*
     * Exception decompiling
     */
    private ReadLogResult readRangeAll(int maxSize) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadLogResult readRangeByPosition(long refIndex, int count, int maxSize) {
        try (HistoryDatabaseConnection conn = BBacnetNiagaraHistoryDescriptor.getHistoryDbConnection(null);){
            Object object;
            boolean moreItems;
            boolean includesLastItem;
            boolean includesFirstItem;
            long itemCount;
            block61: {
                BIHistory dataHistory = this.getHistory(conn);
                this.reinitTimestamps(conn, dataHistory);
                BAbsTime firstTimestamp = conn.getFirstTimestamp(dataHistory);
                BAbsTime lastTimestamp = conn.getLastTimestamp(dataHistory);
                BAbsTime recTimestamp = null;
                itemCount = 0L;
                includesFirstItem = false;
                includesLastItem = false;
                moreItems = false;
                BTrendRecord r = null;
                object = asnOut;
                synchronized (object) {
                    ArrayList<BTrendRecord> records;
                    block57: {
                        Object record;
                        long position;
                        block58: {
                            if (count <= 0) break block58;
                            asnOut.reset();
                            try (Cursor data = conn.scan(dataHistory);){
                                while (data.next() && itemCount < (long)count) {
                                    block59: {
                                        block60: {
                                            if (position < refIndex) break block59;
                                            r = (BTrendRecord)data.get();
                                            recTimestamp = r.getTimestamp();
                                            int logDatumType = BBacnetNiagaraHistoryDescriptor.getLogDatumType(r);
                                            if (logDatumType < 0) break block59;
                                            AsnOutputStream temp = new AsnOutputStream();
                                            try {
                                                asnOut.writeTo(temp);
                                            }
                                            catch (Exception e) {
                                                log.log(Level.WARNING, "Error caching trend records during read by position, Bacnet Object ID " + (Object)((Object)this.getObjectId()), e);
                                                temp = asnOut;
                                            }
                                            BBacnetLogRecord.writeLogRecord(recTimestamp, (BSimple)r.get(r.getValueProperty()), logDatumType, r.getStatus(), BBacnetNiagaraHistoryDescriptor.getLogEvent(r).getLong(), (AsnOutput)asnOut);
                                            if (maxSize <= 0 || asnOut.size() <= maxSize) break block60;
                                            asnOut = temp;
                                            moreItems = true;
                                            break block61;
                                        }
                                        if (recTimestamp.equals((Object)firstTimestamp)) {
                                            includesFirstItem = true;
                                        }
                                        if (recTimestamp.equals((Object)lastTimestamp)) {
                                            includesLastItem = true;
                                        }
                                        ++itemCount;
                                    }
                                    ++position;
                                }
                                break block61;
                            }
                        }
                        count = -count;
                        records = new ArrayList<BTrendRecord>();
                        try (Cursor data = conn.scan(dataHistory);){
                            for (position = 1L; data.next() && position <= refIndex; ++position) {
                                record = (BTrendRecord)((BHistoryRecord)data.get()).newCopy(true);
                                if (BBacnetNiagaraHistoryDescriptor.getLogDatumType(record) < 0) continue;
                                records.add((BTrendRecord)record);
                            }
                        }
                        long maxRecordPosition = Math.max(0L, position - 1L);
                        if (refIndex == maxRecordPosition) break block57;
                        record = new ReadLogResult(itemCount, -1L, asnOut.toByteArray(), false, false, false);
                        return record;
                    }
                    int numRecords = records.size();
                    int startIndex = 0;
                    if (numRecords > count) {
                        startIndex = numRecords - count;
                    }
                    asnOut.reset();
                    for (int i = startIndex; i < numRecords; ++i) {
                        r = (BTrendRecord)records.get(i);
                        recTimestamp = r.getTimestamp();
                        AsnOutputStream temp = new AsnOutputStream();
                        try {
                            asnOut.writeTo(temp);
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, "Error caching trend records during read by position, Bacnet Object ID " + (Object)((Object)this.getObjectId()), e);
                            temp = asnOut;
                        }
                        BBacnetLogRecord.writeLogRecord(recTimestamp, (BSimple)r.get(r.getValueProperty()), BBacnetNiagaraHistoryDescriptor.getLogDatumType(r), r.getStatus(), BBacnetNiagaraHistoryDescriptor.getLogEvent(r).getLong(), (AsnOutput)asnOut);
                        if (maxSize > 0 && asnOut.size() > maxSize) {
                            asnOut = temp;
                            moreItems = true;
                            break;
                        }
                        if (recTimestamp.equals((Object)firstTimestamp)) {
                            includesFirstItem = true;
                        }
                        if (recTimestamp.equals((Object)lastTimestamp)) {
                            includesLastItem = true;
                        }
                        ++itemCount;
                    }
                }
            }
            object = new ReadLogResult(itemCount, -1L, asnOut.toByteArray(), includesFirstItem, includesLastItem, moreItems);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadLogResult readRangeByTime(BBacnetDateTime refTime, int count, int maxSize) {
        BAbsTime referenceTime = refTime.toBAbsTime();
        try (HistoryDatabaseConnection conn = BBacnetNiagaraHistoryDescriptor.getHistoryDbConnection(null);){
            BIHistory dataHistory = this.getHistory(conn);
            this.reinitTimestamps(conn, dataHistory);
            BAbsTime firstTimestamp = conn.getFirstTimestamp(dataHistory);
            BAbsTime lastTimestamp = conn.getLastTimestamp(dataHistory);
            long itemCount = 0L;
            long firstFoundSequenceNumber = 0L;
            boolean includesFirstItem = false;
            boolean includesLastItem = false;
            boolean moreItems = false;
            Object object = asnOut;
            synchronized (object) {
                if (count >= 0) {
                    asnOut.reset();
                    long loopCount = 0L;
                    try (TableCursor data = conn.timeQuery(dataHistory, referenceTime, null).cursor();){
                        BTrendRecord r = null;
                        while (data.next()) {
                            if ((long)count > itemCount) {
                                r = (BTrendRecord)data.get();
                                BBacnetDateTime recTime = new BBacnetDateTime(r.getTimestamp());
                                if (BBacnetNiagaraHistoryDescriptor.getLogDatumType(r) >= 0 && !recTime.toBAbsTime().equals((Object)referenceTime)) {
                                    AsnOutputStream temp = new AsnOutputStream();
                                    try {
                                        asnOut.writeTo(temp);
                                    }
                                    catch (Exception e) {
                                        log.log(Level.WARNING, "Error caching trend records during read by time, Bacnet Object ID " + (Object)((Object)this.getObjectId()), e);
                                        temp = asnOut;
                                    }
                                    BBacnetLogRecord.writeLogRecord(r.getTimestamp(), (BSimple)r.get(r.getValueProperty()), BBacnetNiagaraHistoryDescriptor.getLogDatumType(r), r.getStatus(), BBacnetNiagaraHistoryDescriptor.getLogEvent(r).getLong(), (AsnOutput)asnOut);
                                    if (maxSize > 0 && asnOut.size() > maxSize) {
                                        asnOut = temp;
                                        moreItems = true;
                                        break;
                                    }
                                    if (r.getTimestamp().equals((Object)firstTimestamp)) {
                                        includesFirstItem = true;
                                    }
                                    if (r.getTimestamp().equals((Object)lastTimestamp)) {
                                        includesLastItem = true;
                                    }
                                    if (itemCount == 0L) {
                                        firstFoundSequenceNumber = loopCount + 1L;
                                    }
                                    ++itemCount;
                                }
                            }
                            ++loopCount;
                        }
                    }
                    firstFoundSequenceNumber = this.getLastSeqNum() - loopCount + firstFoundSequenceNumber;
                } else {
                    ArrayList<Object> records = new ArrayList<Object>();
                    int adjustedCount = count * -1;
                    try (TableCursor data = conn.timeQuery(dataHistory, null, referenceTime).cursor();){
                        long loopCount = this.getFirstSeqNum();
                        while (data.next()) {
                            BBacnetDateTime recTime = new BBacnetDateTime(((BHistoryRecord)data.get()).getTimestamp());
                            if (BBacnetNiagaraHistoryDescriptor.getLogDatumType((BTrendRecord)data.get()) >= 0 && !recTime.toBAbsTime().equals((Object)referenceTime)) {
                                records.add(data.get());
                                records.add(BLong.make((long)loopCount));
                            }
                            ++loopCount;
                        }
                    }
                    int numRecords = records.size() / 2;
                    int startIndex = 0;
                    if (numRecords > adjustedCount) {
                        startIndex = numRecords - adjustedCount;
                        numRecords = adjustedCount;
                    }
                    asnOut.reset();
                    BTrendRecord r = null;
                    for (int i = startIndex; i < numRecords; ++i) {
                        r = (BTrendRecord)records.get(i * 2);
                        AsnOutputStream temp = new AsnOutputStream();
                        try {
                            asnOut.writeTo(temp);
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, "Error exporting trend records by time, Bacnet Object ID " + (Object)((Object)this.getObjectId()), e);
                            temp = asnOut;
                        }
                        BBacnetLogRecord.writeLogRecord(r.getTimestamp(), (BSimple)r.get(r.getValueProperty()), BBacnetNiagaraHistoryDescriptor.getLogDatumType(r), r.getStatus(), BBacnetNiagaraHistoryDescriptor.getLogEvent(r).getLong(), (AsnOutput)asnOut);
                        if (maxSize > 0 && asnOut.size() > maxSize) {
                            asnOut = temp;
                            moreItems = true;
                            break;
                        }
                        if (r.getTimestamp().equals((Object)firstTimestamp)) {
                            includesFirstItem = true;
                        }
                        if (r.getTimestamp().equals((Object)lastTimestamp)) {
                            includesLastItem = true;
                        }
                        if (itemCount == 0L) {
                            firstFoundSequenceNumber = ((BLong)records.get(i * 2 + 1)).getLong();
                        }
                        ++itemCount;
                    }
                    records.clear();
                }
            }
            object = new ReadLogResult(itemCount, firstFoundSequenceNumber, asnOut.toByteArray(), includesFirstItem, includesLastItem, moreItems);
            return object;
        }
    }

    private static int getLogDatumType(BTrendRecord record) {
        if (record instanceof BBacnetTrendRecord) {
            return ((BBacnetTrendRecord)record).getLogDatumType();
        }
        BValue recordType = record.get(record.getValueProperty());
        if (recordType instanceof BBoolean) {
            return 1;
        }
        if (recordType instanceof BDouble) {
            return 2;
        }
        if (recordType instanceof BEnum) {
            return 3;
        }
        if (recordType instanceof BBacnetUnsigned) {
            return 4;
        }
        if (recordType instanceof BFloat) {
            return 2;
        }
        if (recordType instanceof BInteger) {
            return 5;
        }
        if (recordType instanceof BBacnetBitString) {
            return 6;
        }
        if (recordType instanceof BBacnetNull) {
            return 7;
        }
        if (recordType instanceof BTrendEvent) {
            BTrendEvent evt = (BTrendEvent)recordType;
            if (evt.isLogStatus()) {
                return 0;
            }
            if (evt.isFailure()) {
                return 8;
            }
            if (evt.isTimeChange()) {
                return 9;
            }
        } else if (recordType instanceof BString) {
            return 10;
        }
        return -1;
    }

    private static BTrendEvent getLogEvent(BTrendRecord record) {
        if (record instanceof BBacnetTrendRecord) {
            return ((BBacnetTrendRecord)record).getLogEvent();
        }
        return BTrendEvent.DEFAULT;
    }

    @Override
    public final PropertyValue readProperty(PropertyReference ref) throws RejectException {
        return this.readProperty(ref.getPropertyId(), ref.getPropertyArrayIndex());
    }

    @Override
    public final PropertyValue[] readPropertyMultiple(PropertyReference[] refs) throws RejectException {
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>(refs.length);
        block5: for (int i = 0; i < refs.length; ++i) {
            switch (refs[i].getPropertyId()) {
                case 8: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    props = this.getOptionalProps();
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 80: {
                    int j;
                    int[] props = this.getOptionalProps();
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 105: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                default: {
                    results.add(this.readProperty(refs[i].getPropertyId(), refs[i].getPropertyArrayIndex()));
                }
            }
        }
        return results.toArray(new PropertyValue[0]);
    }

    @Override
    public final RangeData readRange(RangeReference rangeReference) throws RejectException {
        int propertyId = rangeReference.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (propertyId != 131) {
            return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (rangeReference.getPropertyArrayIndex() != -1) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        int maxDataSize = -1;
        if (rangeReference instanceof BacnetConfirmedRequest) {
            maxDataSize = ((BacnetConfirmedRequest)((Object)rangeReference)).getMaxDataLength();
        }
        int count = rangeReference.getCount();
        switch (rangeReference.getRangeType()) {
            case 6: {
                logger.warning("BY_SEQUENCE_NUMBER is not supported for NiagaraHistoryDescriptor, transaction rejected");
                throw new RejectException(6);
            }
            case 3: {
                long refIndex = rangeReference.getReferenceIndex();
                if (refIndex <= 0L || count == 0) {
                    return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.parameterOutOfRange);
                }
                try {
                    ReadLogResult rlr = this.readRangeByPosition(refIndex, count, maxDataSize);
                    return new ReadRangeAck(this.getObjectId(), propertyId, -1, rlr.getResultFlags(), rlr.itemCount, rlr.itemCount > 0L ? rlr.firstSequenceNumber : -1L, rlr.itemData);
                }
                catch (Exception e) {
                    BBacnetNiagaraHistoryDescriptor.logException(Level.SEVERE, (Object)((Object)this.getObjectId()) + ": could not readRange by position", e);
                    return new ReadRangeAck(2, 0);
                }
            }
            case 7: {
                BBacnetDateTime refTime = rangeReference.getReferenceTime();
                if (refTime.isAnyUnspecified() || count == 0) {
                    return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.parameterOutOfRange);
                }
                try {
                    ReadLogResult rlr = this.readRangeByTime(refTime, count, maxDataSize);
                    return new ReadRangeAck(this.getObjectId(), propertyId, -1, rlr.getResultFlags(), rlr.itemCount, rlr.itemCount > 0L ? rlr.firstSequenceNumber : -1L, rlr.itemData);
                }
                catch (Exception e) {
                    BBacnetNiagaraHistoryDescriptor.logException(Level.SEVERE, (Object)((Object)this.getObjectId()) + ": could not readRange by time", e);
                    return new ReadRangeAck(2, 0);
                }
            }
            case -1: {
                try {
                    ReadLogResult rlr = this.readRangeAll(maxDataSize);
                    return new ReadRangeAck(this.getObjectId(), propertyId, -1, rlr.getResultFlags(), rlr.itemCount, rlr.itemCount > 0L ? rlr.firstSequenceNumber : -1L, rlr.itemData);
                }
                catch (Exception e) {
                    BBacnetNiagaraHistoryDescriptor.logException(Level.SEVERE, (Object)((Object)this.getObjectId()) + ": could not readRange all records", e);
                    return new ReadRangeAck(2, 0);
                }
            }
        }
        log.info((Object)((Object)this.getObjectId()) + ": unsupported ReadRange Range Type: " + rangeReference.getRangeType());
        return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.parameterOutOfRange);
    }

    private boolean hasProperty(int propertyId) {
        for (int id : REQUIRED_PROPS) {
            if (id != propertyId) continue;
            return true;
        }
        for (int id : this.getOptionalProps()) {
            if (id != propertyId) continue;
            return true;
        }
        return propertyId == 371;
    }

    @Override
    public final ErrorType writeProperty(PropertyValue val) throws BacnetException {
        return this.writeProperty(val.getPropertyId(), val.getPropertyArrayIndex(), val.getPropertyValue(), val.getPriority());
    }

    @Override
    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        int propertyId = propertyValue.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (propertyId != 131) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (propertyValue.getPropertyArrayIndex() != -1) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
    }

    @Override
    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        int propertyId = propertyValue.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (propertyId != 131) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (propertyValue.getPropertyArrayIndex() != -1) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
    }

    boolean isArray(int propId) {
        for (int arrayPropId : ARRAY_PROPS) {
            if (propId != arrayPropId) continue;
            return true;
        }
        return false;
    }

    protected PropertyValue readProperty(int pId, int ndx) {
        if (ndx >= 0) {
            if (!this.isArray(pId)) {
                return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
            }
        } else if (ndx < -1) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 42));
        }
        switch (pId) {
            case 75: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 77: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 79: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 28: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
            case 133: {
                log.info("ReadProperty for enable is not accessible for NiagaraHistoryDescriptor");
                return new NReadPropertyResult(pId, ndx, new NErrorType(2, 27));
            }
            case 144: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBoolean(this.getHistory().getConfig().getFullPolicy().equals((Object)BFullPolicy.stop)));
            }
            case 126: {
                long maxRecords = 0xFFFFFFFFL;
                BIHistory hist = this.getHistory();
                if (hist.getConfig().getCapacity().isByRecordCount()) {
                    maxRecords = hist.getConfig().getCapacity().getMaxRecords();
                } else if (hist.getConfig().getCapacity().isByStorageSize()) {
                    maxRecords = hist.getConfig().getCapacity().getMaxStorage();
                }
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(maxRecords));
            }
            case 131: {
                log.info("ReadProperty for logBuffer is not accessible except via ReadRange for NiagaraHistoryDescriptor");
                return new NReadPropertyResult(pId, ndx, new NErrorType(2, 27));
            }
            case 141: {
                try (HistoryDatabaseConnection conn = BBacnetNiagaraHistoryDescriptor.getHistoryDbConnection(null);){
                    NReadPropertyResult nReadPropertyResult = new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(conn.getRecordCount(this.getHistory(conn))));
                    return nReadPropertyResult;
                }
            }
            case 145: {
                return this.readTotalRecordCount();
            }
            case 36: {
                return this.readEventState();
            }
        }
        return this.readOptionalProperty(pId, ndx);
    }

    private PropertyValue readTotalRecordCount() {
        try (HistoryDatabaseConnection conn = BBacnetNiagaraHistoryDescriptor.getHistoryDbConnection(null);){
            BIHistory history = this.getHistory(conn);
            this.reinitTimestamps(conn, history);
            NReadPropertyResult nReadPropertyResult = new NReadPropertyResult(145, -1, AsnUtil.toAsnUnsigned(this.getLastSeqNum()));
            return nReadPropertyResult;
        }
    }

    private PropertyValue readEventState() {
        if (!this.getEventDetectionEnable()) {
            return new NReadPropertyResult(36, -1, AsnUtil.toAsnEnumerated(0));
        }
        BBacnetTrendLogAlarmSourceExt alarmExt = this.getAlarmExt();
        if (alarmExt == null) {
            return new NReadPropertyResult(36, -1, AsnUtil.toAsnEnumerated(0));
        }
        return new NReadPropertyResult(36, -1, AsnUtil.toAsnEnumerated(BBacnetEventState.fromBAlarmState(alarmExt.getAlarmState())));
    }

    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        if (ndx >= 0) {
            if (!this.isArray(pId)) {
                return new NErrorType(2, 50);
            }
        } else if (ndx < -1) {
            return new NErrorType(2, 42);
        }
        try {
            switch (pId) {
                case 77: {
                    return BacUtil.setObjectName(this, objectName, val);
                }
                case 36: 
                case 75: 
                case 79: 
                case 126: 
                case 131: 
                case 133: 
                case 141: 
                case 144: 
                case 145: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine((Object)((Object)this.getObjectId()) + ": attempted to write read-only property " + BBacnetPropertyIdentifier.tag(pId));
                    }
                    return new NErrorType(2, 40);
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(val), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return this.writeOptionalProperty(pId, ndx, val, pri);
        }
        catch (AsnException e) {
            BBacnetNiagaraHistoryDescriptor.logException(Level.INFO, (Object)((Object)this.getObjectId()) + ": AsnException writing property " + BBacnetPropertyIdentifier.tag(pId), (Exception)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            BBacnetNiagaraHistoryDescriptor.logException(Level.INFO, (Object)((Object)this.getObjectId()) + ": PermissionException writing property " + BBacnetPropertyIdentifier.tag(pId), (Exception)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            switch (pId) {
                case 17: {
                    BBacnetNotificationClassDescriptor nc = this.getNotificationClass();
                    if (nc == null) {
                        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
                    }
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(nc.getNotificationClass()));
                }
                case 35: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(almExt.getAlarmEnable())));
                }
                case 353: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnBoolean(this.getEventDetectionEnable()));
                }
                case 0: {
                    return this.readAckedTransitions(almExt.getAckedTransitions());
                }
                case 72: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated((BEnum)almExt.getNotifyType()));
                }
                case 130: {
                    return this.readEventTimeStamps(almExt.getToOffnormalTimes().getAlarmTime(), almExt.getToFaultTimes().getAlarmTime(), almExt.getToNormalTimes().getAlarmTime(), ndx);
                }
                case 351: {
                    return this.readEventMessageTexts(ndx);
                }
                case 137: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(almExt.getNotificationThreshold()));
                }
                case 140: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(almExt.getRecordsSinceNotification()));
                }
                case 173: {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(almExt.getLastNotifyRecord()));
                }
            }
        }
        if (pId == 134) {
            BCollectionInterval collInt = this.getHistory().getConfig().getInterval();
            long logInt = collInt.isIrregular() ? 0L : collInt.getInterval().getMillis() / 10L;
            return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(logInt));
        }
        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
    }

    private NReadPropertyResult readAckedTransitions(BAlarmTransitionBits ackedTrans) {
        if (this.getEventDetectionEnable()) {
            BAlarmTransitionBits eventTrans = this.readEventTransition(ackedTrans);
            return new NReadPropertyResult(0, -1, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(eventTrans)));
        }
        return new NReadPropertyResult(0, -1, AsnUtil.toAsnBitString(ACKED_TRANS_DEFAULT));
    }

    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        try {
            BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
            if (almExt != null) {
                switch (pId) {
                    case 72: {
                        this.set(BBacnetTrendLogAlarmSourceExt.notifyType, (BValue)BBacnetNotifyType.make(AsnUtil.fromAsnEnumerated(val)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 17: {
                        int ncinst = AsnUtil.fromAsnUnsignedInt(val);
                        if (ncinst > 0x3FFFFE) {
                            return new NErrorType(2, 37);
                        }
                        BBacnetObjectIdentifier ncid = BBacnetObjectIdentifier.make(15, ncinst);
                        BBacnetNotificationClassDescriptor nc = (BBacnetNotificationClassDescriptor)BBacnetNetwork.localDevice().lookupBacnetObject(ncid);
                        if (nc == null) {
                            return new NErrorType(2, 37);
                        }
                        BAlarmClass ac = nc.getAlarmClass();
                        almExt.setString(BBacnetTrendLogAlarmSourceExt.alarmClass, ac.getName(), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 0: 
                    case 35: 
                    case 130: 
                    case 137: 
                    case 140: 
                    case 173: 
                    case 351: {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine((Object)((Object)this.getObjectId()) + ": attempted to write read-only property " + BBacnetPropertyIdentifier.tag(pId));
                        }
                        return new NErrorType(2, 40);
                    }
                    case 353: {
                        this.setBoolean(eventDetectionEnable, AsnUtil.fromAsnBoolean(val), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
            }
            if (pId == 134) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine((Object)((Object)this.getObjectId()) + ": attempted to write read-only property " + BBacnetPropertyIdentifier.tag(pId));
                }
                return new NErrorType(2, 40);
            }
        }
        catch (AsnException e) {
            BBacnetNiagaraHistoryDescriptor.logException(Level.INFO, (Object)((Object)this.getObjectId()) + ": AsnException writing property " + BBacnetPropertyIdentifier.tag(pId), (Exception)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            BBacnetNiagaraHistoryDescriptor.logException(Level.INFO, (Object)((Object)this.getObjectId()) + ": PermissionException writing property " + BBacnetPropertyIdentifier.tag(pId), (Exception)((Object)e));
            return new NErrorType(2, 40);
        }
        catch (IllegalArgumentException e) {
            BBacnetNiagaraHistoryDescriptor.logException(Level.INFO, (Object)((Object)this.getObjectId()) + ": IllegalArgumentException writing property " + BBacnetPropertyIdentifier.tag(pId), e);
            return new NErrorType(2, 37);
        }
        return new NErrorType(2, 32);
    }

    private int[] getOptionalProps() {
        ArrayList<BBacnetPropertyIdentifier> v = new ArrayList<BBacnetPropertyIdentifier>();
        v.add(BBacnetPropertyIdentifier.description);
        v.add(BBacnetPropertyIdentifier.logInterval);
        BBacnetTrendLogAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            v.add(BBacnetPropertyIdentifier.notificationThreshold);
            v.add(BBacnetPropertyIdentifier.recordsSinceNotification);
            v.add(BBacnetPropertyIdentifier.lastNotifyRecord);
            v.add(BBacnetPropertyIdentifier.notificationClass);
            v.add(BBacnetPropertyIdentifier.eventEnable);
            v.add(BBacnetPropertyIdentifier.ackedTransitions);
            v.add(BBacnetPropertyIdentifier.notifyType);
            v.add(BBacnetPropertyIdentifier.eventTimeStamps);
            v.add(BBacnetPropertyIdentifier.eventMessageTexts);
            v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
        }
        this.optionalProps = new int[v.size()];
        for (int i = 0; i < this.optionalProps.length; ++i) {
            this.optionalProps[i] = ((BEnum)v.get(i)).getOrdinal();
        }
        return this.optionalProps;
    }

    private static void logException(Level level, String message, Exception e) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(level, message + "; exception: " + e.getLocalizedMessage(), e);
        } else if (logger.isLoggable(level)) {
            logger.log(level, message + "; exception: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetNiagaraHistoryDescriptor", 2);
        out.prop((Object)"history", (Object)this.getHistory());
        out.prop((Object)"oldId", (Object)this.oldId);
        out.prop((Object)"oldName", (Object)this.oldName);
        out.prop((Object)"duplicate", this.duplicate);
        out.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }

    @Override
    public int[] getPropertyList() {
        return BacnetPropertyList.makePropertyList(REQUIRED_PROPS, this.getOptionalProps());
    }

    static class ReadLogResult
    implements RangeData {
        long itemCount;
        long firstSequenceNumber;
        byte[] itemData;
        boolean includeFirst;
        boolean includeLast;
        boolean moreItems;

        ReadLogResult(long ic, long fsn, byte[] id, boolean inclFirst, boolean inclLast, boolean more) {
            this.itemCount = ic;
            this.firstSequenceNumber = fsn;
            this.itemData = id;
            this.includeFirst = inclFirst;
            this.includeLast = inclLast;
            this.moreItems = more;
        }

        @Override
        public BBacnetBitString getResultFlags() {
            return BBacnetBitString.make(new boolean[]{this.includeFirst, this.includeLast, this.moreItems});
        }

        @Override
        public boolean includesFirstItem() {
            return this.includeFirst;
        }

        @Override
        public boolean includesLastItem() {
            return this.includeLast;
        }

        @Override
        public boolean isMoreItems() {
            return this.moreItems;
        }

        @Override
        public long getItemCount() {
            return this.itemCount;
        }

        @Override
        public long getFirstSequenceNumber() {
            return this.firstSequenceNumber;
        }

        @Override
        public byte[] getItemData() {
            return this.itemData;
        }

        @Override
        public ErrorType getError() {
            return null;
        }

        @Override
        public int getErrorClass() {
            return -1;
        }

        @Override
        public int getErrorCode() {
            return -1;
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        public int getPropertyId() {
            return 131;
        }

        @Override
        public int getPropertyArrayIndex() {
            return -1;
        }

        @Override
        public void writeAsn(AsnOutput out) {
        }

        @Override
        public void readAsn(AsnInput in) {
        }
    }
}

