/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BBacnetRouterEntry;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetRoutingTableEntry;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetNetworkPortCommand;
import javax.baja.bacnet.enums.BBacnetNetworkType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetProtocolLevel;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.enums.BBacnetRouterStatus;
import javax.baja.bacnet.export.BBacnetNetworkPortPendingChanges;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.BacnetPropertyList;
import javax.baja.bacnet.export.BacnetPropertyListProvider;
import javax.baja.bacnet.export.ValidateChangesException;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=67), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=67), @NiagaraProperty(name="networkPortOrd", type="BOrd", defaultValue="BOrd.DEFAULT", flags=65, facets={@Facet(name="BFacets.TARGET_TYPE", value="\"bacnet:NetworkPort\"")}), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.NETWORK_PORT)", flags=67, facets={@Facet(value="BBacnetObjectType.getObjectIdFacets(BBacnetObjectType.NETWORK_PORT)")}), @NiagaraProperty(name="objectName", type="String", defaultValue="", flags=64), @NiagaraProperty(name="description", type="String", defaultValue=""), @NiagaraProperty(name="reliability", type="BEnum", defaultValue="BBacnetReliability.noFaultDetected", flags=3), @NiagaraProperty(name="command", type="BEnum", defaultValue="BDynamicEnum.make(BBacnetNetworkPortCommand.IDLE, BEnumRange.make(BBacnetNetworkPortCommand.TYPE))", flags=3), @NiagaraProperty(name="pendingChanges", type="BBacnetNetworkPortPendingChanges", defaultValue="new BBacnetNetworkPortPendingChanges()")})
@NiagaraActions(value={@NiagaraAction(name="executeCommand", parameterType="BDynamicEnum", defaultValue="BDynamicEnum.make(BBacnetNetworkPortCommand.idle)"), @NiagaraAction(name="activatePendingChanges", parameterType="BBoolean", defaultValue="BBoolean.FALSE")})
public abstract class BBacnetNetworkPortDescriptor
extends BComponent
implements BIBacnetExportObject,
BacnetPropertyListProvider {
    @Generated
    public static final Property status = BBacnetNetworkPortDescriptor.newProperty((int)67, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BBacnetNetworkPortDescriptor.newProperty((int)67, (String)"", null);
    @Generated
    public static final Property networkPortOrd = BBacnetNetworkPortDescriptor.newProperty((int)65, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (String)"bacnet:NetworkPort"));
    @Generated
    public static final Property objectId = BBacnetNetworkPortDescriptor.newProperty((int)67, (BValue)BBacnetObjectIdentifier.make(56), (BFacets)BBacnetObjectType.getObjectIdFacets(56));
    @Generated
    public static final Property objectName = BBacnetNetworkPortDescriptor.newProperty((int)64, (String)"", null);
    @Generated
    public static final Property description = BBacnetNetworkPortDescriptor.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property reliability = BBacnetNetworkPortDescriptor.newProperty((int)3, (BValue)BBacnetReliability.noFaultDetected, null);
    @Generated
    public static final Property command = BBacnetNetworkPortDescriptor.newProperty((int)3, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetNetworkPortCommand.TYPE)), null);
    @Generated
    public static final Property pendingChanges = BBacnetNetworkPortDescriptor.newProperty((int)0, (BValue)new BBacnetNetworkPortPendingChanges(), null);
    @Generated
    public static final Action executeCommand = BBacnetNetworkPortDescriptor.newAction((int)0, (BValue)BDynamicEnum.make((BEnum)BBacnetNetworkPortCommand.idle), null);
    @Generated
    public static final Action activatePendingChanges = BBacnetNetworkPortDescriptor.newAction((int)0, (BValue)BBoolean.FALSE, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetNetworkPortDescriptor.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"usbPort.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    public static final Context atStarted = new BasicContext();
    protected static final String NETWORK_NUMBER = "NetworkNumber";
    protected static final Logger logger = Logger.getLogger("bacnet.server");
    private static final Context skipExport = new BasicContext();
    private static final int[] REQUIRED_PROPS = new int[]{75, 77, 79, 111, 103, 81, 427, 482, 416};
    protected BNetworkPort networkPort;
    protected boolean fatalFault;
    private BBacnetObjectIdentifier oldId = BBacnetObjectIdentifier.make(56);
    private String oldName = "";
    private boolean exportFault;

    @Override
    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BOrd getNetworkPortOrd() {
        return (BOrd)this.get(networkPortOrd);
    }

    @Generated
    public void setNetworkPortOrd(BOrd v) {
        this.set(networkPortOrd, (BValue)v, null);
    }

    @Override
    @Generated
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Override
    @Generated
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Override
    @Generated
    public String getObjectName() {
        return this.getString(objectName);
    }

    @Override
    @Generated
    public void setObjectName(String v) {
        this.setString(objectName, v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public BEnum getReliability() {
        return (BEnum)this.get(reliability);
    }

    @Generated
    public void setReliability(BEnum v) {
        this.set(reliability, (BValue)v, null);
    }

    @Generated
    public BEnum getCommand() {
        return (BEnum)this.get(command);
    }

    @Generated
    public void setCommand(BEnum v) {
        this.set(command, (BValue)v, null);
    }

    @Generated
    public BBacnetNetworkPortPendingChanges getPendingChanges() {
        return (BBacnetNetworkPortPendingChanges)this.get(pendingChanges);
    }

    @Generated
    public void setPendingChanges(BBacnetNetworkPortPendingChanges v) {
        this.set(pendingChanges, (BValue)v, null);
    }

    @Generated
    public void executeCommand(BDynamicEnum parameter) {
        this.invoke(executeCommand, (BValue)parameter, null);
    }

    @Generated
    public void activatePendingChanges(BBoolean parameter) {
        this.invoke(activatePendingChanges, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkFatalFault();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.resolveNetworkPort();
        if (Sys.isStationStarted()) {
            this.checkConfiguration();
            if (!this.exportFault) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        local.unexport(this.oldId, this.oldName, this);
        this.networkPort = null;
        this.oldId = null;
        this.oldName = null;
        if (local.isRunning()) {
            local.incrementDatabaseRevision();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(objectId) && cx != skipExport) {
            BBacnetObjectIdentifier newId = this.getObjectId();
            if (this.networkPort != null) {
                int portId = this.networkPort.getPortId();
                if (portId != newId.getInstanceNumber()) {
                    logger.info(this + ": resetting object ID " + (Object)((Object)newId) + " based on port ID " + portId);
                    newId = BBacnetNetworkPortDescriptor.makeObjectId(portId);
                    this.set(objectId, (BValue)newId, skipExport);
                }
                BLocalBacnetDevice local = BBacnetNetwork.localDevice();
                local.unexport(this.oldId, this.oldName, this);
                this.oldId = newId;
                this.checkConfiguration();
                if (cx != atStarted && !this.exportFault) {
                    local.incrementDatabaseRevision();
                }
            } else {
                logger.info(this + ": resetting object ID " + (Object)((Object)newId) + " instance number to -1 because network port cannot be resolved");
                newId = BBacnetNetworkPortDescriptor.makeObjectId(-1);
                this.set(objectId, (BValue)newId, skipExport);
            }
        } else if (p.equals(objectName) && cx != skipExport) {
            BLocalBacnetDevice local = BBacnetNetwork.localDevice();
            local.unexport(this.oldId, this.oldName, this);
            this.oldName = this.getObjectName();
            this.checkConfiguration();
            if (!this.exportFault) {
                local.incrementDatabaseRevision();
            }
        } else if (p.equals(networkPortOrd)) {
            BLocalBacnetDevice local = BBacnetNetwork.localDevice();
            local.unexport(this.oldId, this.oldName, this);
            this.resolveNetworkPort();
            this.oldId = this.networkPort != null ? BBacnetNetworkPortDescriptor.makeObjectId(this.networkPort.getPortId()) : BBacnetNetworkPortDescriptor.makeObjectId(-1);
            this.set(objectId, (BValue)this.oldId, skipExport);
            this.checkConfiguration();
            if (!this.exportFault) {
                local.incrementDatabaseRevision();
            }
        } else if (p.equals(reliability)) {
            boolean hasFault = !this.getReliability().equals((Object)BBacnetReliability.noFaultDetected);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)hasFault));
        }
    }

    public static String makeDescriptorName(String portName) {
        return "NetworkPort_" + portName;
    }

    public static BBacnetObjectIdentifier makeObjectId(int portId) {
        return BBacnetObjectIdentifier.make(56, portId);
    }

    public BIcon getIcon() {
        return icon;
    }

    public String toString(Context c) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + ']';
    }

    @Override
    public BObject getObject() {
        return this.networkPort;
    }

    @Override
    public BOrd getObjectOrd() {
        return this.getNetworkPortOrd();
    }

    @Override
    public void setObjectOrd(BOrd objectOrd, Context cx) {
        this.set(networkPortOrd, (BValue)objectOrd, cx);
    }

    @Override
    public boolean isFatalFault() {
        return this.fatalFault;
    }

    private void checkFatalFault() {
        if (this.fatalFault) {
            return;
        }
        BBacnetExportTable exportTable = null;
        BLocalBacnetDevice localDevice = null;
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof BBacnetExportTable) {
                exportTable = (BBacnetExportTable)parent;
                continue;
            }
            if (!(parent instanceof BLocalBacnetDevice)) continue;
            localDevice = (BLocalBacnetDevice)parent;
            break;
        }
        if (exportTable == null || localDevice == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under LocalBacnetDevice Export Table");
            return;
        }
        if (localDevice.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("LocalDevice fault: " + localDevice.getFaultCause());
            return;
        }
        BComplex localDeviceParent = localDevice.getParent();
        if (!(localDeviceParent instanceof BBacnetNetwork)) {
            this.fatalFault = true;
            this.setFaultCause("Not under BacnetNetwork");
            return;
        }
        BBacnetNetwork network = (BBacnetNetwork)localDeviceParent;
        if (network.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + network.getFaultCause());
            return;
        }
        if (!network.hasServerLicense()) {
            this.fatalFault = true;
            this.setFaultCause("Server capability not licensed");
            return;
        }
        this.setFaultCause("");
    }

    @Override
    public void checkConfiguration() {
        if (this.fatalFault) {
            this.exportFault = true;
            this.updateReliability();
            logger.warning(this + ": is in fatal fault");
            return;
        }
        if (this.networkPort == null) {
            this.setStatusFaulted("Cannot find exported network port");
            return;
        }
        if (!this.getObjectId().isValid()) {
            this.setStatusFaulted("Invalid Object ID");
            return;
        }
        if (this.getObjectName() == null || this.getObjectName().trim().isEmpty()) {
            this.setStatusFaulted("Invalid Object Name");
            return;
        }
        String exportError = BBacnetNetwork.localDevice().export(this);
        if (exportError != null) {
            this.setStatusFaulted(exportError);
            return;
        }
        this.exportFault = false;
        this.setFaultCause("");
        this.updateReliability();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": configuration is ok");
        }
    }

    private void setStatusFaulted(String faultCause) {
        this.setFaultCause(faultCause);
        this.exportFault = true;
        this.updateReliability();
        logger.warning(this + ": " + faultCause);
    }

    @Override
    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        int propertyId = propertyValue.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (!this.isListProp(propertyId)) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (propertyValue.getPropertyArrayIndex() != -1) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        return this.addListElements(propertyId, propertyValue.getPropertyValue());
    }

    protected ChangeListError addListElements(int propertyId, byte[] value) {
        return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
    }

    @Override
    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        int propertyId = propertyValue.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (!this.isListProp(propertyId)) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (propertyValue.getPropertyArrayIndex() != -1) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        return this.removeListElements(propertyId, propertyValue.getPropertyValue());
    }

    protected ChangeListError removeListElements(int propertyId, byte[] value) {
        return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
    }

    @Override
    public final int[] getPropertyList() {
        return BacnetPropertyList.makePropertyList(REQUIRED_PROPS, this.getOptionalProps());
    }

    protected abstract int[] getOptionalProps();

    protected abstract boolean isArrayProp(int var1);

    protected abstract boolean isListProp(int var1);

    protected boolean hasProperty(int propertyId) {
        for (int id : REQUIRED_PROPS) {
            if (id != propertyId) continue;
            return true;
        }
        for (int id : this.getOptionalProps()) {
            if (id != propertyId) continue;
            return true;
        }
        return propertyId == 371;
    }

    @Override
    public final PropertyValue readProperty(PropertyReference ref) throws RejectException {
        return this.readProperty(ref.getPropertyId(), ref.getPropertyArrayIndex());
    }

    private PropertyValue readProperty(int propertyId, int index) {
        if (index >= 0) {
            if (!this.isArrayProp(propertyId)) {
                return new NReadPropertyResult(propertyId, index, new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray));
            }
        } else if (index < -1) {
            return new NReadPropertyResult(propertyId, index, new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.invalidArrayIndex));
        }
        switch (propertyId) {
            case 75: {
                return new NReadPropertyResult(propertyId, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 77: {
                return new NReadPropertyResult(propertyId, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 79: {
                return new NReadPropertyResult(propertyId, AsnUtil.toAsnEnumerated((BEnum)BBacnetObjectType.networkPort));
            }
            case 28: {
                return new NReadPropertyResult(propertyId, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
            case 111: {
                return new NReadPropertyResult(propertyId, AsnUtil.statusToAsnStatusFlags(this.getStatus()));
            }
            case 103: {
                return new NReadPropertyResult(propertyId, AsnUtil.toAsnEnumerated(this.getReliability()));
            }
            case 81: {
                return new NReadPropertyResult(propertyId, AsnUtil.toAsnBoolean(!this.networkPort.getEnabled()));
            }
            case 427: {
                return new NReadPropertyResult(propertyId, AsnUtil.toAsnEnumerated(this.getNetworkType()));
            }
            case 482: {
                return new NReadPropertyResult(propertyId, AsnUtil.toAsnEnumerated((BEnum)BBacnetProtocolLevel.bacnetApplication));
            }
            case 416: {
                return new NReadPropertyResult(propertyId, AsnUtil.toAsnBoolean(this.hasPendingChanges()));
            }
            case 417: {
                return BacnetDescriptorUtil.makeEnumReadResult(BBacnetPropertyIdentifier.command, this.getCommand());
            }
            case 371: {
                return this.readPropertyList(index);
            }
        }
        return this.readOptionalProperty(propertyId, index);
    }

    protected abstract int getNetworkType();

    protected abstract PropertyValue readOptionalProperty(int var1, int var2);

    @Override
    public final PropertyValue[] readPropertyMultiple(PropertyReference[] propertyReferences) throws RejectException {
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>(propertyReferences.length);
        block5: for (PropertyReference propertyReference : propertyReferences) {
            int propertyId = propertyReference.getPropertyId();
            switch (propertyId) {
                case 8: {
                    for (int prop : REQUIRED_PROPS) {
                        results.add(this.readProperty(prop, -1));
                    }
                    for (int prop : this.getOptionalProps()) {
                        results.add(this.readProperty(prop, -1));
                    }
                    continue block5;
                }
                case 80: {
                    for (int prop : this.getOptionalProps()) {
                        results.add(this.readProperty(prop, -1));
                    }
                    continue block5;
                }
                case 105: {
                    for (int prop : REQUIRED_PROPS) {
                        results.add(this.readProperty(prop, -1));
                    }
                    continue block5;
                }
                default: {
                    results.add(this.readProperty(propertyId, propertyReference.getPropertyArrayIndex()));
                }
            }
        }
        return results.toArray(EMPTY_PROPERTY_VALUE_ARRAY);
    }

    @Override
    public final RangeData readRange(RangeReference rangeReference) throws RejectException {
        int propertyId = rangeReference.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (!this.isListProp(propertyId)) {
            return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (rangeReference.getPropertyArrayIndex() != -1) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        try {
            switch (rangeReference.getRangeType()) {
                case 6: {
                    return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.listItemNotNumbered);
                }
                case 7: {
                    return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.listItemNotTimestamped);
                }
                case 3: {
                    return this.readRangeByPosition(rangeReference, this.getListElements(propertyId));
                }
                case -1: {
                    return this.readRangeAll(rangeReference, this.getListElements(propertyId));
                }
            }
            return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.parameterOutOfRange);
        }
        catch (ErrorException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, this + ": errorException readRange property " + propertyId + ": " + (Object)((Object)e));
            }
            return new ReadRangeAck(e.getErrorType().getErrorClass(), e.getErrorType().getErrorCode());
        }
    }

    protected abstract List<? extends BIBacnetDataType> getListElements(int var1) throws ErrorException;

    private RangeData readRangeByPosition(RangeReference rangeReference, List<? extends BIBacnetDataType> elements) {
        int elementCount = elements.size();
        int refIndex = (int)rangeReference.getReferenceIndex();
        if (refIndex < 1 || refIndex > elementCount) {
            return new ReadRangeAck(this.getObjectId(), rangeReference.getPropertyId(), -1, BBacnetBitString.emptyBitString(3), 0L, EMPTY_BYTE_ARRAY);
        }
        int count = rangeReference.getCount();
        if (count == 0) {
            return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.inconsistentParameters);
        }
        return this.readRange(rangeReference, elements, refIndex, count);
    }

    private RangeData readRangeAll(RangeReference rangeReference, List<? extends BIBacnetDataType> elements) {
        return this.readRange(rangeReference, elements, 1, elements.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadRangeAck readRange(RangeReference rangeReference, List<? extends BIBacnetDataType> elements, int refIndex, int count) {
        int maxDataLength = Integer.MAX_VALUE;
        if (rangeReference instanceof BacnetConfirmedRequest) {
            maxDataLength = ((BacnetConfirmedRequest)((Object)rangeReference)).getMaxDataLength() - 23 + 3 + 5;
        }
        boolean firstItem = false;
        boolean lastItem = false;
        boolean moreItems = false;
        int itemLimit = Math.abs(count);
        int elementCount = elements.size();
        int itemCount = 0;
        ByteArrayOutputStream itemData = new ByteArrayOutputStream();
        AsnOutputStream asnOut = AsnOutputStream.make();
        try {
            if (count > 0) {
                int i;
                for (i = refIndex - 1; i < elementCount && itemCount < itemLimit; ++itemCount, ++i) {
                    asnOut.reset();
                    elements.get(i).writeAsn(asnOut);
                    if (asnOut.size() + itemData.size() > maxDataLength) {
                        moreItems = true;
                        break;
                    }
                    asnOut.writeTo(itemData);
                }
                if (itemData.size() > 0) {
                    firstItem = refIndex == 1;
                    lastItem = i == elementCount;
                }
            } else {
                int i;
                ByteArrayOutputStream temp = new ByteArrayOutputStream();
                for (i = refIndex - 1; i >= 0 && itemCount < itemLimit; ++itemCount, --i) {
                    asnOut.reset();
                    elements.get(i).writeAsn(asnOut);
                    if (asnOut.size() + itemData.size() > maxDataLength) {
                        moreItems = true;
                        break;
                    }
                    temp.reset();
                    itemData.writeTo(temp);
                    itemData.reset();
                    asnOut.writeTo(itemData);
                    temp.writeTo(itemData);
                }
                if (itemData.size() > 0) {
                    firstItem = i + 1 == 0;
                    lastItem = refIndex == elementCount;
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, this + ": error writing encoded read range item to item data", logger.isLoggable(Level.FINE) ? e : null);
            ReadRangeAck readRangeAck = new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.other);
            return readRangeAck;
        }
        finally {
            asnOut.release();
        }
        return new ReadRangeAck(this.getObjectId(), rangeReference.getPropertyId(), -1, BBacnetBitString.make(new boolean[]{firstItem, lastItem, moreItems}), (long)itemCount, itemData.toByteArray());
    }

    @Override
    public final ErrorType writeProperty(PropertyValue val) throws BacnetException {
        return this.writeProperty(val.getPropertyId(), val.getPropertyArrayIndex(), val.getPropertyValue(), val.getPriority());
    }

    private ErrorType writeProperty(int propertyId, int index, byte[] value, int priority) throws BacnetException {
        if (index >= 0) {
            if (!this.isArrayProp(propertyId)) {
                return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
            }
        } else if (index < -1) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.invalidArrayIndex);
        }
        try {
            switch (propertyId) {
                case 75: 
                case 79: 
                case 111: 
                case 371: 
                case 416: 
                case 427: 
                case 482: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine((Object)((Object)this.getObjectId()) + ": attempted to write read-only property " + BBacnetPropertyIdentifier.tag(propertyId));
                    }
                    return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
                }
                case 77: {
                    BacUtil.setObjectName(this, objectName, value);
                    return null;
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(value), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 103: {
                    return this.writeReliability(value);
                }
                case 81: {
                    return this.writeOutOfService(value);
                }
                case 417: {
                    return this.writeCommand(value);
                }
            }
            return this.writeOptionalProperty(propertyId, index, value, priority);
        }
        catch (OutOfRangeException e) {
            logger.log(Level.WARNING, this + ": OutOfRangeException writing property " + BBacnetPropertyIdentifier.tag(propertyId) + "- " + (Object)((Object)e), (Throwable)((Object)(logger.isLoggable(Level.FINE) ? e : null)));
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
        }
        catch (AsnException e) {
            logger.log(Level.WARNING, this + ": AsnException writing property " + BBacnetPropertyIdentifier.tag(propertyId) + "- " + (Object)((Object)e), (Throwable)((Object)(logger.isLoggable(Level.FINE) ? e : null)));
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.invalidDataType);
        }
        catch (PermissionException e) {
            logger.log(Level.WARNING, this + ": PermissionException writing property " + BBacnetPropertyIdentifier.tag(propertyId) + "- " + (Object)((Object)e), logger.isLoggable(Level.FINE) ? e : null);
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
        }
    }

    protected abstract ErrorType writeOptionalProperty(int var1, int var2, byte[] var3, int var4) throws BacnetException;

    protected PropertyValue readNetworkNumber() {
        int value = this.getNetworkNumber();
        if (value < 0 || (long)value >= 65535L) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.networkNumber, BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
        }
        return BacnetDescriptorUtil.makeUnsignedReadResult(BBacnetPropertyIdentifier.networkNumber, value);
    }

    private int getNetworkNumber() {
        BBacnetUnsigned pending = this.getPendingChange(NETWORK_NUMBER, BBacnetUnsigned.class);
        return pending != null ? pending.getInt() : this.networkPort.getNetworkNumber();
    }

    protected ErrorType writeNetworkNumber(byte[] value) throws AsnException {
        BBacnetUnsigned unsigned = AsnUtil.fromAsnUnsigned(value);
        if (!this.getNetworkLayer().isValidNetworkNumber(unsigned.getInt())) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
        }
        this.addPendingChange(NETWORK_NUMBER, (BValue)unsigned, BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    protected void validateSetNetworkNumber(BValue value, Context context) {
        this.checkPendingChangeType(NETWORK_NUMBER, value, BBacnetUnsigned.TYPE);
        this.checkCanWrite(this.networkPort, (Slot)BNetworkPort.networkNumber, context);
    }

    protected void validateNetworkNumber(Context context) throws ValidateChangesException {
        BBacnetUnsigned change = this.getPendingChange(NETWORK_NUMBER, BBacnetUnsigned.class);
        if (change != null) {
            int value = change.getInt();
            if (this.isDuplicateNetworkNumber(value)) {
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.other, BBacnetPropertyIdentifier.networkNumber, "Value " + value + " is already used by another in-service network port");
            }
            if (!this.getNetworkLayer().isValidNetworkNumber(value)) {
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange, BBacnetPropertyIdentifier.networkNumber, "Value " + value + " is not in the range 0..65534 or is zero and device is a router");
            }
            this.validateCanWrite(this.networkPort, (Slot)BNetworkPort.networkNumber, BBacnetPropertyIdentifier.networkNumber, context);
        }
    }

    private boolean isDuplicateNetworkNumber(int pendingValue) {
        BNetworkPort[] ports;
        BBacnetStack comm = (BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm();
        for (BNetworkPort port : ports = (BNetworkPort[])comm.getNetwork().getChildren(BNetworkPort.class)) {
            BBacnetNetworkPortDescriptor descriptor = port.findDescriptor();
            if (descriptor == this || !port.getEnabled() || !(descriptor != null ? pendingValue == descriptor.getNetworkNumber() : pendingValue == port.getNetworkNumber())) continue;
            return true;
        }
        return false;
    }

    protected void activateNetworkNumber(Context context) {
        BBacnetUnsigned change = this.getPendingChange(NETWORK_NUMBER, BBacnetUnsigned.class);
        if (change != null) {
            this.networkPort.setInt(BNetworkPort.networkNumber, change.getInt(), context);
        }
    }

    protected PropertyValue readNetworkNumberQuality() {
        return BacnetDescriptorUtil.makeEnumReadResult(BBacnetPropertyIdentifier.networkNumberQuality, (BEnum)this.networkPort.getNetworkNumberQuality());
    }

    protected PropertyValue readApduLength() {
        int value = this.networkPort.getLink().getMaxAPDULengthAccepted();
        if (value < 0) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.apduLength, BBacnetErrorClass.property, BBacnetErrorCode.notConfigured);
        }
        return BacnetDescriptorUtil.makeUnsignedReadResult(BBacnetPropertyIdentifier.apduLength, value);
    }

    protected PropertyValue readRoutingTable() {
        BBacnetListOf routerEntries = new BBacnetListOf(BBacnetRoutingTableEntry.TYPE);
        for (BBacnetRoutingTableEntry routerEntry : this.getRouterEntries()) {
            routerEntries.addListElement((BValue)routerEntry, null);
        }
        return BacnetDescriptorUtil.makeListOfReadResult(BBacnetPropertyIdentifier.routingTable, routerEntries);
    }

    protected List<BBacnetRoutingTableEntry> getRouterEntries() {
        int portId = this.networkPort.getPortId();
        BBacnetNetworkLayer networkLayer = this.getNetworkLayer();
        BBacnetRouterEntry[] entries = (BBacnetRouterEntry[])networkLayer.getRouterTable().getChildren(BBacnetRouterEntry.class);
        ArrayList<BBacnetRoutingTableEntry> routerEntries = new ArrayList<BBacnetRoutingTableEntry>();
        for (BBacnetRouterEntry entry : entries) {
            if (portId != entry.getPortId()) continue;
            BBacnetRoutingTableEntry routerEntry = new BBacnetRoutingTableEntry();
            routerEntry.setNetworkNumber(BBacnetUnsigned.make(entry.getDnet()));
            routerEntry.setMacAddress(entry.getRouterAddress().getMacAddress());
            switch (entry.getRouterStatus().getOrdinal()) {
                case 0: {
                    routerEntry.setStatus(BBacnetRouterStatus.available);
                    break;
                }
                case 2: {
                    routerEntry.setStatus(BBacnetRouterStatus.busy);
                    break;
                }
                default: {
                    routerEntry.setStatus(BBacnetRouterStatus.disconnected);
                }
            }
            routerEntry.setPerformanceIndex(BBacnetUnsigned.make(entry.getPerformanceIndex()));
            routerEntries.add(routerEntry);
        }
        return routerEntries;
    }

    public boolean hasPendingChanges() {
        return ((BValue[])this.getPendingChanges().getChildren(BValue.class)).length > 0;
    }

    protected void addPendingChange(String propertyName, BValue value, Context context) {
        BBacnetNetworkPortPendingChanges pendingChanges = this.getPendingChanges();
        Property existing = pendingChanges.getProperty(propertyName);
        if (existing != null) {
            if (logger.isLoggable(Level.FINE)) {
                BValue oldValue = pendingChanges.get(existing);
                logger.fine((Object)((Object)this.getObjectId()) + ": replacing pending change value for " + propertyName + "; oldValue: " + oldValue + ", newValue: " + value);
            }
            pendingChanges.set(existing, value, context);
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": adding pending change value for " + propertyName + "; newValue: " + value);
        }
        pendingChanges.add(propertyName, value, context);
    }

    protected final <T extends BValue> T getPendingChange(String name, Class<T> clazz) {
        BBacnetNetworkPortPendingChanges pendingChanges = this.getPendingChanges();
        BValue pendingChange = pendingChanges.get(name);
        if (pendingChange == null) {
            return null;
        }
        if (!pendingChange.getClass().equals(clazz)) {
            logger.warning((Object)((Object)this.getObjectId()) + ": Removing PendingChange with incorrect type; name: " + name + ", expected class: " + clazz + ", actual class: " + pendingChange.getClass());
            pendingChanges.remove(name);
            return null;
        }
        return (T)pendingChange;
    }

    public void discardPendingChanges(Context context) {
        this.getPendingChanges().removeAll(context);
    }

    private ErrorType writeReliability(byte[] value) throws AsnException {
        BBacnetReliability reliabilityValue = BBacnetReliability.make(AsnUtil.fromAsnEnumerated(value));
        if (this.networkPort.getEnabled()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": attempt to write reliability when port is not out-of-service");
            }
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
        }
        this.set(reliability, (BValue)reliabilityValue, BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    public void updateReliability() {
        if (this.networkPort != null && !this.networkPort.getEnabled()) {
            return;
        }
        if (this.networkPort != null && this.networkPort.getStatus().isFault() || this.fatalFault || this.exportFault) {
            this.setReliability((BEnum)BBacnetReliability.configurationError);
            return;
        }
        this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
    }

    private ErrorType writeOutOfService(byte[] value) throws AsnException {
        boolean outOfServiceValue = AsnUtil.fromAsnBoolean(value);
        this.networkPort.setBoolean(BNetworkPort.enabled, !outOfServiceValue, BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    private ErrorType writeCommand(byte[] value) throws AsnException {
        return this.handleCommand(AsnUtil.fromAsnEnumerated(value), BLocalBacnetDevice.getBacnetContext());
    }

    public void doExecuteCommand(BDynamicEnum command, Context context) throws Exception {
        ErrorType error = this.handleCommand(command.getOrdinal(), context);
        if (error != null) {
            throw new BajaException(this + ": could not execute command " + command + "; error: " + error);
        }
    }

    private ErrorType handleCommand(int command, Context context) {
        if (this.getCommand().getOrdinal() != 0) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info(this + ": attempt to write command value " + BBacnetNetworkPortCommand.tag(command) + " when current value is not Idle");
            }
            return new NErrorType(BBacnetErrorClass.object, BBacnetErrorCode.busy);
        }
        if (command == 0) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info(this + ": attempt to write command value Idle");
            }
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
        }
        if (this.hasPendingChanges() && command != 1 && command != 9) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info(this + ": attempt to write command value " + BBacnetNetworkPortCommand.tag(command) + " when there are pending changes; only the Discard Changes or Validate Changes commands are allowed");
            }
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.invalidValueInThisState);
        }
        if (!this.networkPort.getEnabled()) {
            switch (command) {
                case 1: 
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info(this + ": attempt to write command value " + BBacnetNetworkPortCommand.tag(command) + "when port is out of service");
                    }
                    return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
                }
            }
        }
        switch (command) {
            case 1: {
                return this.handleDiscardChangesCommand(context);
            }
            case 2: {
                return this.handleRenewFdRegistrationCommand(context);
            }
            case 3: {
                return this.handleRestartSlaveDiscovery();
            }
            case 4: {
                return this.handleRenewDhcpCommand(context);
            }
            case 5: {
                return this.handleRestartAutoNegotiationCommand();
            }
            case 6: {
                return this.handleDisconnectCommand();
            }
            case 7: {
                return this.handleRestartPortCommand(context);
            }
            case 8: {
                return this.handleGenerateCsrFileCommand(context);
            }
            case 9: {
                return this.handleValidateChangesCommand(context);
            }
        }
        return this.handleProprietaryCommand(command);
    }

    private ErrorType handleDiscardChangesCommand(Context context) {
        this.set(command, (BValue)BBacnetNetworkPortCommand.discardChanges, context);
        try {
            if (this.hasPendingChanges()) {
                this.discardPendingChanges(context);
            }
            if (this.networkPort.getEnabled()) {
                this.updateReliability();
            }
        }
        catch (PermissionException e) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, this + ": attempt to write command value Discard Changes but user does not have permission to remove pending changes.", logger.isLoggable(Level.FINE) ? e : null);
            }
            if (this.networkPort.getEnabled()) {
                this.setReliability((BEnum)BBacnetReliability.processError);
            }
        }
        finally {
            this.set(command, (BValue)BBacnetNetworkPortCommand.idle, context);
        }
        return null;
    }

    protected ErrorType handleRenewFdRegistrationCommand(Context context) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": attempt to write command value Renew FD Registration when network type is not IPv4 or IPv6: " + BBacnetNetworkType.tag(this.getNetworkType()));
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
    }

    protected ErrorType handleRestartSlaveDiscovery() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": attempt to write command value Restart Slave Discovery when network type is not MSTP: " + BBacnetNetworkType.tag(this.getNetworkType()));
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
    }

    protected ErrorType handleRenewDhcpCommand(Context context) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": attempt to write command value Renew DHCP when network type is not IPv4 or IPv6: " + BBacnetNetworkType.tag(this.getNetworkType()));
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
    }

    private ErrorType handleRestartAutoNegotiationCommand() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Restart Auto-Negotiation command is not supported");
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.optionalFunctionalityNotSupported);
    }

    private ErrorType handleDisconnectCommand() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": attempt to write command value Disconnect when network type is not PTP: " + BBacnetNetworkType.tag(this.getNetworkType()));
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
    }

    private ErrorType handleRestartPortCommand(Context context) {
        this.set(command, (BValue)BBacnetNetworkPortCommand.restartPort, context);
        try {
            if (this.networkPort.getEnabled()) {
                this.networkPort.invoke(BNetworkPort.disable, null, context);
            }
            this.networkPort.invoke(BNetworkPort.enable, null, context);
            if (this.networkPort.getEnabled()) {
                this.updateReliability();
            }
        }
        catch (PermissionException e) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, this + ": attempt to write command value Restart Port but user does not have permission on network port.", logger.isLoggable(Level.FINE) ? e : null);
            }
            if (this.networkPort.getEnabled()) {
                this.setReliability((BEnum)BBacnetReliability.processError);
            }
        }
        finally {
            this.set(command, (BValue)BBacnetNetworkPortCommand.idle, context);
        }
        return null;
    }

    protected ErrorType handleGenerateCsrFileCommand(Context context) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Generate CSR File command is not supported");
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.optionalFunctionalityNotSupported);
    }

    private ErrorType handleValidateChangesCommand(Context context) {
        this.set(command, (BValue)BBacnetNetworkPortCommand.validateChanges, context);
        try {
            this.validateChanges(context);
        }
        catch (ValidateChangesException e) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, this + ": Validate Changes failed; exception: " + (Object)((Object)e), (Throwable)((Object)(logger.isLoggable(Level.FINE) ? e : null)));
            }
            return e.getError();
        }
        this.set(command, (BValue)BBacnetNetworkPortCommand.idle, context);
        return null;
    }

    private ErrorType handleProprietaryCommand(int commandValue) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": unknown command value " + commandValue);
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
    }

    public boolean activateChangesRequiresReboot() {
        return false;
    }

    protected abstract void validateSetPendingChange(String var1, BValue var2, Context var3);

    public abstract void validateChanges(Context var1) throws ValidateChangesException;

    public abstract void activateChanges(Context var1) throws Exception;

    public void doActivatePendingChanges(BBoolean activateIfRebootRequired, Context context) {
        BNetworkPort networkPort = this.networkPort;
        if (networkPort == null) {
            throw new LocalizableRuntimeException("bacnet", "networkPortDescriptor.activatePendingChanges.noNetworkPort");
        }
        if (!this.hasPendingChanges()) {
            throw new LocalizableRuntimeException("bacnet", "networkPortDescriptor.activatePendingChanges.noPendingChanges");
        }
        boolean rebootRequired = this.activateChangesRequiresReboot();
        if (rebootRequired && !activateIfRebootRequired.getBoolean()) {
            throw new LocalizableRuntimeException("bacnet", "networkPortDescriptor.activatePendingChanges.requireReboot");
        }
        try {
            this.validateChanges(context);
            boolean wasEnabled = networkPort.getEnabled();
            networkPort.setBoolean(BNetworkPort.enabled, false, context);
            this.activateChanges(context);
            this.discardPendingChanges(context);
            if (wasEnabled) {
                networkPort.setBoolean(BNetworkPort.enabled, true, context);
            }
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("bacnet", "networkPortDescriptor.activatePendingChanges.failed", new Object[]{e}, (Throwable)e);
        }
        if (rebootRequired) {
            throw new LocalizableRuntimeException("bacnet", "networkPortDescriptor.activatePendingChanges.manualReboot");
        }
    }

    private void resolveNetworkPort() {
        BNetworkPort resolved = null;
        BOrd networkPortOrd = this.getNetworkPortOrd();
        try {
            BObject target = networkPortOrd.get((BObject)this);
            if (target instanceof BNetworkPort) {
                resolved = (BNetworkPort)target;
            } else {
                logger.warning((Object)((Object)this.getObjectId()) + ": Network Port Ord does not resolve to a BNetworkPort: " + networkPortOrd);
            }
        }
        catch (BajaRuntimeException e) {
            logger.log(Level.WARNING, (Object)((Object)this.getObjectId()) + ": unable to resolve Network Port Ord: " + networkPortOrd, logger.isLoggable(Level.FINE) ? e : null);
        }
        this.networkPort = resolved;
    }

    private BBacnetNetworkLayer getNetworkLayer() {
        return (BBacnetNetworkLayer)this.networkPort.getParent();
    }

    protected void checkCanWrite(BComponent target, Context context) {
        BUser user;
        BUser bUser = user = context != null ? context.getUser() : null;
        if (user != null) {
            user.check((BIProtected)target, BPermissions.adminWrite);
        }
    }

    protected void checkCanWrite(BComponent target, Slot slot, Context context) {
        BUser user;
        BUser bUser = user = context != null ? context.getUser() : null;
        if (user != null) {
            user.checkWrite(target, slot);
        }
    }

    protected void checkCanReadPendingChanges(Context context) throws ValidateChangesException {
        BUser user = this.getUser(context, BBacnetErrorCode.readAccessDenied);
        if (!user.getPermissionsFor((BIProtected)this.getPendingChanges()).hasAdminRead()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": User missing admin read permissions on pending changes");
            }
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.readAccessDenied, null, "User missing read permissions on pending changes");
        }
    }

    protected void validateCanWrite(BComponent target, BBacnetPropertyIdentifier propertyId, Context context) throws ValidateChangesException {
        BUser user = this.getUser(context, BBacnetErrorCode.writeAccessDenied);
        try {
            user.check((BIProtected)target, BPermissions.adminWrite);
        }
        catch (PermissionException e) {
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied, propertyId, "User missing write permissions");
        }
    }

    protected void validateCanWrite(BComponent target, Slot slot, BBacnetPropertyIdentifier propertyId, Context context) throws ValidateChangesException {
        BUser user = this.getUser(context, BBacnetErrorCode.writeAccessDenied);
        try {
            user.checkWrite(target, slot);
        }
        catch (PermissionException e) {
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied, propertyId, "User missing write permissions");
        }
    }

    protected BUser getUser(Context context, BBacnetErrorCode errorCode) throws ValidateChangesException {
        BUser user;
        BUser bUser = user = context != null ? context.getUser() : null;
        if (user == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": missing context or context user");
            }
            throw new ValidateChangesException(BBacnetErrorClass.property, errorCode, null, "Missing write or read permissions");
        }
        return user;
    }

    protected void checkPendingChangeType(String name, BValue value, Type type) {
        if (!value.getType().is(type)) {
            throw new LocalizableRuntimeException("bacnet", "networkPortDescriptor.pendingChange.wrongType", new Object[]{name, value.getType(), type});
        }
    }
}

