/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.datatypes.BBacnetValueSource;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetMultiStatePointDescriptor;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.BacnetWritableDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="bacnetWritable", type="String", defaultValue="BBacnetPointDescriptor.lexNotWritable", flags=5), @NiagaraProperty(name="valueSourceArray", type="BBacnetArray", defaultValue="new BBacnetArray(BBacnetValueSource.TYPE, 16)", flags=67), @NiagaraProperty(name="lastCommandTime", type="BBacnetTimeStamp", defaultValue="new BBacnetTimeStamp(new BBacnetDateTime())", flags=67), @NiagaraProperty(name="commandTimeArray", type="BBacnetArray", defaultValue="makeEmptyCommandTimeArray()", flags=67)})
public abstract class BBacnetMultiStateWritableDescriptor
extends BBacnetMultiStatePointDescriptor
implements BacnetWritableDescriptor {
    @Generated
    public static final Property bacnetWritable = BBacnetMultiStateWritableDescriptor.newProperty((int)5, (String)BBacnetPointDescriptor.lexNotWritable, null);
    @Generated
    public static final Property valueSourceArray = BBacnetMultiStateWritableDescriptor.newProperty((int)67, (BValue)new BBacnetArray(BBacnetValueSource.TYPE, 16), null);
    @Generated
    public static final Property lastCommandTime = BBacnetMultiStateWritableDescriptor.newProperty((int)67, (BValue)new BBacnetTimeStamp(new BBacnetDateTime()), null);
    @Generated
    public static final Property commandTimeArray = BBacnetMultiStateWritableDescriptor.newProperty((int)67, (BValue)BBacnetMultiStateWritableDescriptor.makeEmptyCommandTimeArray(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetMultiStateWritableDescriptor.class);

    @Override
    @Generated
    public String getBacnetWritable() {
        return this.getString(bacnetWritable);
    }

    @Generated
    public void setBacnetWritable(String v) {
        this.setString(bacnetWritable, v, null);
    }

    @Override
    @Generated
    public BBacnetArray getValueSourceArray() {
        return (BBacnetArray)this.get(valueSourceArray);
    }

    @Generated
    public void setValueSourceArray(BBacnetArray v) {
        this.set(valueSourceArray, (BValue)v, null);
    }

    @Generated
    public BBacnetTimeStamp getLastCommandTime() {
        return (BBacnetTimeStamp)this.get(lastCommandTime);
    }

    @Override
    @Generated
    public void setLastCommandTime(BBacnetTimeStamp v) {
        this.set(lastCommandTime, (BValue)v, null);
    }

    @Override
    @Generated
    public BBacnetArray getCommandTimeArray() {
        return (BBacnetArray)this.get(commandTimeArray);
    }

    @Generated
    public void setCommandTimeArray(BBacnetArray v) {
        this.set(commandTimeArray, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected final boolean isPointTypeLegal(BControlPoint pt) {
        return pt instanceof BEnumWritable;
    }

    @Override
    protected boolean isCommandable() {
        return true;
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BEnumWritable pt = (BEnumWritable)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 87: {
                return this.readPriorityArray(ndx);
            }
            case 104: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(pt.getFallback().getValue().getOrdinal()));
            }
        }
        return super.readProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BEnumWritable pt = (BEnumWritable)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 87: {
                    return new NErrorType(2, 40);
                }
                case 104: {
                    int writeVal = AsnUtil.fromAsnUnsignedInt(val);
                    BDynamicEnum ms = pt.getFallback().getValue();
                    BEnumRange r = (BEnumRange)pt.getFacets().getFacet("range");
                    if (r != null && !r.isOrdinal(writeVal)) {
                        return new NErrorType(2, 37);
                    }
                    BStatusEnum fb = pt.getFallback();
                    fb.set(BStatusEnum.value, (BValue)BDynamicEnum.make((int)writeVal, (BEnumRange)ms.getRange()), BLocalBacnetDevice.getBacnetContext());
                    fb.setStatusNull(false);
                    return null;
                }
            }
            return super.writeProperty(pId, ndx, val, pri);
        }
        catch (IllegalArgumentException | OutOfRangeException e) {
            return new NErrorType(2, 37);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri, BBacnetAddress sourceAddress) throws BacnetException {
        BEnumWritable pt = (BEnumWritable)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 85: {
                    return this.writePriorityArray(pri, val, sourceAddress);
                }
                case 433: {
                    return this.writeValueSource(pri, val, sourceAddress);
                }
                case 430: 
                case 431: 
                case 432: 
                case 434: {
                    return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
                }
            }
            return super.writeProperty(pId, ndx, val, pri, sourceAddress);
        }
        catch (IllegalArgumentException | OutOfRangeException e) {
            return new NErrorType(2, 37);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        switch (pId) {
            case 431: {
                return this.readCurrentCommandPriority();
            }
            case 433: {
                return this.readValueSource(this.getValueSourceArray());
            }
            case 434: {
                return BacnetDescriptorUtil.readArray(pId, ndx, this.getValueSourceArray());
            }
            case 432: {
                return BacnetDescriptorUtil.makeConstructedReadResult(BBacnetPropertyIdentifier.lastCommandTime, (BValue)this.getLastCommandTime());
            }
            case 430: {
                return BacnetDescriptorUtil.readArray(pId, ndx, this.getCommandTimeArray());
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected void writeAsnPriorityValue(AsnOutput out, BValue value) {
        out.writeUnsignedInteger(((BEnum)value).getOrdinal());
    }

    @Override
    protected BValue readAsnPriorityValue(AsnInput in, BControlPoint point) throws AsnException {
        int ordinal = in.readUnsignedInt();
        BEnumRange range = (BEnumRange)point.getFacets().getFacet("range");
        return BDynamicEnum.make((int)ordinal, (BEnumRange)range);
    }

    @Override
    protected boolean isPriorityValueOutOfRange(BValue value, BControlPoint point) {
        int ordinal = ((BEnum)value).getOrdinal();
        if (ordinal <= 0) {
            return true;
        }
        BEnumRange range = (BEnumRange)point.getFacets().getFacet("range");
        return range != null && !range.isOrdinal(ordinal);
    }

    private void resetBacnetWritable() {
        StringBuilder sb = new StringBuilder();
        Knob[] knobs = this.getKnobs();
        for (int i = 0; i < knobs.length; ++i) {
            BObject tgt = knobs[i].getTargetOrd().get((BObject)this);
            BControlPoint pt = this.getPoint();
            if (!knobs[i].getTargetSlotName().startsWith("in") || tgt != pt) continue;
            sb.append(knobs[i].getTargetSlotName()).append(',');
        }
        this.setBacnetWritable(sb.length() > 0 ? sb.substring(0, sb.length() - 1) : lexNotWritable);
    }

    public void knobAdded(Knob knob, Context cx) {
        this.resetBacnetWritable();
    }

    public void knobRemoved(Knob knob, Context cx) {
        this.resetBacnetWritable();
    }
}

