/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.fault.BEnumFaultAlgorithm;
import javax.baja.alarm.ext.offnormal.BEnumChangeOfStateAlgorithm;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetMultiStatePointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BOutOfServiceExt;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.util.EnumRangeWrapper;
import javax.baja.control.BEnumPoint;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"control:EnumPoint"})})
@NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.MULTI_STATE_VALUE)", flags=64, override=true)
public class BBacnetMultiStateValueDescriptor
extends BBacnetMultiStatePointDescriptor {
    @Generated
    public static final Property objectId = BBacnetMultiStateValueDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(19), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetMultiStateValueDescriptor.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Deprecated
    public BStatusEnum getBacnetValue() {
        throw new BajaRuntimeException("Method getBacnetValue() is deprecated!");
    }

    @Deprecated
    public void setBacnetValue(BStatusEnum v) {
        throw new BajaRuntimeException("Method setBacnetValue() is deprecated!");
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(19);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public BEnum getEventType() {
        return BBacnetEventType.changeOfState;
    }

    @Override
    public boolean isValidAlarmExt(BIAlarmSource ext) {
        if (ext instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)ext).getOffnormalAlgorithm() instanceof BEnumChangeOfStateAlgorithm;
        }
        return false;
    }

    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BEnumPoint pt = (BEnumPoint)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 85: {
                    BOutOfServiceExt outOfServiceExt = this.getOosExt();
                    if (outOfServiceExt.getOutOfService()) {
                        BDynamicEnum ms = pt.getOut().getValue();
                        int writeVal = AsnUtil.fromAsnUnsignedInt(val);
                        BEnumRange r = (BEnumRange)pt.getFacets().getFacet("range");
                        if (r != null && !r.isOrdinal(writeVal)) {
                            return new NErrorType(2, 37);
                        }
                        outOfServiceExt.set(BOutOfServiceExt.presentValue, (BValue)BDynamicEnum.make((int)writeVal, (BEnumRange)ms.getRange()), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    return new NErrorType(2, 40);
                }
            }
        }
        catch (IllegalArgumentException | OutOfRangeException e) {
            return new NErrorType(2, 37);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
        return super.writeProperty(pId, ndx, val, pri);
    }

    @Override
    protected void addRequiredProps(Vector v) {
        v.add(BBacnetPropertyIdentifier.presentValue);
        v.add(BBacnetPropertyIdentifier.statusFlags);
        v.add(BBacnetPropertyIdentifier.eventState);
        v.add(BBacnetPropertyIdentifier.outOfService);
        v.add(BBacnetPropertyIdentifier.numberOfStates);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        BAlarmSourceExt alarmExt;
        v.add(BBacnetPropertyIdentifier.description);
        v.add(BBacnetPropertyIdentifier.reliability);
        BEnumRange r = (BEnumRange)this.getPoint().getFacets().getFacet("range");
        if (r != null) {
            v.add(BBacnetPropertyIdentifier.stateText);
        }
        if ((alarmExt = this.getAlarmExt()) != null) {
            v.add(BBacnetPropertyIdentifier.timeDelay);
            v.add(BBacnetPropertyIdentifier.notificationClass);
            v.add(BBacnetPropertyIdentifier.alarmValues);
            if (BBacnetNetwork.bacnet().setAndGetShouldSupportFaults()) {
                v.add(BBacnetPropertyIdentifier.faultValues);
            }
            v.add(BBacnetPropertyIdentifier.eventEnable);
            v.add(BBacnetPropertyIdentifier.ackedTransitions);
            v.add(BBacnetPropertyIdentifier.notifyType);
            v.add(BBacnetPropertyIdentifier.eventTimeStamps);
            v.add(BBacnetPropertyIdentifier.eventMessageTexts);
            v.add(BBacnetPropertyIdentifier.eventMessageTextsConfig);
            v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibitRef);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibit);
            v.add(BBacnetPropertyIdentifier.timeDelayNormal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            try {
                if (pId == 7) {
                    AsnOutputStream asnOut = AsnOutputStream.make();
                    try {
                        BEnumChangeOfStateAlgorithm alg = (BEnumChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
                        int[] vals = alg.getAlarmValues().getOrdinals();
                        for (int i = 0; i < vals.length; ++i) {
                            asnOut.writeUnsignedInteger(vals[i]);
                        }
                        NReadPropertyResult i = new NReadPropertyResult(pId, ndx, asnOut.toByteArray());
                        return i;
                    }
                    finally {
                        asnOut.release();
                    }
                }
                if (pId == 39) {
                    if (!BBacnetNetwork.bacnet().setAndGetShouldSupportFaults()) {
                        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
                    }
                    AsnOutputStream asnOut = AsnOutputStream.make();
                    try {
                        BEnumFaultAlgorithm alg = (BEnumFaultAlgorithm)almExt.getFaultAlgorithm();
                        int[] validVals = alg.getValidValues().getOrdinals();
                        BEnumRange r = (BEnumRange)this.getPoint().getFacets().getFacet("range");
                        int[] rangeVals = r.getOrdinals();
                        for (int i = 0; i < rangeVals.length; ++i) {
                            boolean valid = false;
                            for (int j = 0; j < validVals.length; ++j) {
                                if (rangeVals[i] != validVals[j]) continue;
                                valid = true;
                                break;
                            }
                            if (valid) continue;
                            asnOut.writeUnsignedInteger(rangeVals[i]);
                        }
                        NReadPropertyResult nReadPropertyResult = new NReadPropertyResult(pId, ndx, asnOut.toByteArray());
                        return nReadPropertyResult;
                    }
                    finally {
                        asnOut.release();
                    }
                }
            }
            catch (Exception e) {
                return new NReadPropertyResult(pId, ndx, new NErrorType(0, 25));
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            try {
                if (pId == 7) {
                    BEnumChangeOfStateAlgorithm alg = (BEnumChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
                    BEnumRange alarmValueRange = (BEnumRange)this.getPoint().getFacets().getFacet("range");
                    EnumRangeWrapper enumRangeWrapper = BBacnetMultiStateValueDescriptor.getWritableEnumRange(val, alarmValueRange, false);
                    if (enumRangeWrapper.getErrorType() == null) {
                        alg.set(BEnumChangeOfStateAlgorithm.alarmValues, (BValue)enumRangeWrapper.getEnumRange(), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    return enumRangeWrapper.getErrorType();
                }
                if (pId == 35) {
                    almExt.set(BAlarmSourceExt.alarmEnable, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(AsnUtil.fromAsnBitString(val)), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                if (pId == 39) {
                    if (!BBacnetNetwork.bacnet().setAndGetShouldSupportFaults()) {
                        return new NErrorType(2, 32);
                    }
                    BEnumFaultAlgorithm alg = (BEnumFaultAlgorithm)almExt.getFaultAlgorithm();
                    BEnumRange faultValueRange = (BEnumRange)this.getPoint().getFacets().getFacet("range");
                    EnumRangeWrapper enumRangeWrapper = BBacnetMultiStateValueDescriptor.getWritableEnumRange(val, faultValueRange, true);
                    if (enumRangeWrapper.getErrorType() == null) {
                        alg.set(BEnumFaultAlgorithm.validValues, (BValue)enumRangeWrapper.getEnumRange(), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    return enumRangeWrapper.getErrorType();
                }
            }
            catch (AsnException e) {
                log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
                return new NErrorType(2, 9);
            }
            catch (PermissionException e) {
                log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
                return new NErrorType(2, 40);
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }
}

