/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.fault.BEnumFaultAlgorithm;
import javax.baja.alarm.ext.offnormal.BEnumChangeOfStateAlgorithm;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.EnumRangeWrapper;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BBacnetMultiStatePointDescriptor
extends BBacnetPointDescriptor {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetMultiStatePointDescriptor.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"control/enumPoint.png"), (BIcon)BIcon.std((String)"badges/export.png"));

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected boolean isPointTypeLegal(BControlPoint pt) {
        return pt instanceof BEnumPoint;
    }

    @Override
    protected int getPresentValueAsnType() {
        return 2;
    }

    @Override
    protected byte[] convertToAsn(BValue value) {
        return AsnUtil.toAsnUnsigned(((BEnum)value).getOrdinal());
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BEnumPoint pt = (BEnumPoint)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 85: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(pt.getOut().getValue().getOrdinal()));
            }
            case 74: {
                BEnumRange r = (BEnumRange)pt.getFacets().getFacet("range");
                if (r != null) {
                    return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(r.getOrdinals().length));
                }
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(Integer.MAX_VALUE));
            }
            case 110: {
                return this.readStateText(ndx);
            }
        }
        return super.readProperty(pId, ndx);
    }

    @Override
    protected byte[] makeInterfaceValue(BStatusValue proxyValue) {
        return AsnUtil.toAsnUnsigned((BEnum)((BStatusEnum)proxyValue).getValue());
    }

    @Override
    public RangeData readRange(RangeReference rangeReference) throws RejectException {
        int propertyId = rangeReference.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (propertyId != 7 && propertyId != 39) {
            return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (rangeReference.getPropertyArrayIndex() != -1) {
            return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        int rangeType = rangeReference.getRangeType();
        switch (rangeType) {
            case 6: {
                return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.listItemNotNumbered);
            }
            case 7: {
                return new ReadRangeAck(BBacnetErrorClass.property, BBacnetErrorCode.listItemNotTimestamped);
            }
            case -1: 
            case 3: {
                break;
            }
            default: {
                return new ReadRangeAck(BBacnetErrorClass.services, BBacnetErrorCode.parameterOutOfRange);
            }
        }
        BAlarmSourceExt almExt = this.getAlarmExt();
        switch (propertyId) {
            case 7: {
                if (almExt == null) break;
                BEnumChangeOfStateAlgorithm alg = (BEnumChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
                int[] ordinals = alg.getAlarmValues().getOrdinals();
                Integer[] avals = new Integer[ordinals.length];
                for (int i = 0; i < avals.length; ++i) {
                    avals[i] = ordinals[i];
                }
                return this.readRange(rangeReference, avals, 5);
            }
            case 39: {
                if (!BBacnetNetwork.bacnet().setAndGetShouldSupportFaults()) {
                    return new ReadRangeAck(2, 32);
                }
                if (almExt == null) break;
                BEnumFaultAlgorithm alg = (BEnumFaultAlgorithm)almExt.getFaultAlgorithm();
                int[] validVals = alg.getValidValues().getOrdinals();
                BEnumRange r = (BEnumRange)this.getPoint().getFacets().getFacet("range");
                int[] rangeVals = r.getOrdinals();
                Array a = new Array(Integer.class);
                for (int i = 0; i < rangeVals.length; ++i) {
                    boolean valid = false;
                    for (int j = 0; j < validVals.length; ++j) {
                        if (rangeVals[i] != validVals[j]) continue;
                        valid = true;
                        break;
                    }
                    if (valid) continue;
                    a.add((Object)rangeVals[i]);
                }
                Integer[] fvals = (Integer[])a.trim();
                return this.readRange(rangeReference, fvals, 5);
            }
        }
        return new ReadRangeAck(2, 32);
    }

    @Override
    public ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        int propertyId = propertyValue.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (propertyId != 7 && propertyId != 39) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (propertyValue.getPropertyArrayIndex() != -1) {
            return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return new NChangeListError(8, new NErrorType(1, 1000), 0L);
        }
        BEnumChangeOfStateAlgorithm enumChangeOfStateAlgorithm = (BEnumChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
        switch (propertyId) {
            case 7: {
                return this.addAlarmValues(propertyValue, enumChangeOfStateAlgorithm);
            }
            case 39: {
                return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
            }
        }
        return BacnetDescriptorUtil.makeAddListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
    }

    @Override
    public ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        int propertyId = propertyValue.getPropertyId();
        if (!this.hasProperty(propertyId)) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
        }
        if (propertyId != 7 && propertyId != 39) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.services, BBacnetErrorCode.propertyIsNotA_List);
        }
        if (propertyValue.getPropertyArrayIndex() != -1) {
            return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.propertyIsNotAnArray);
        }
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt == null) {
            return new NChangeListError(9, new NErrorType(1, 1000), 0L);
        }
        BEnumChangeOfStateAlgorithm enumChangeOfStateAlgorithm = (BEnumChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
        switch (propertyId) {
            case 7: {
                return this.removeAlarmValues(propertyValue, enumChangeOfStateAlgorithm);
            }
            case 39: {
                return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
            }
        }
        return BacnetDescriptorUtil.makeRemoveListElementError(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeListError addAlarmValues(PropertyValue propertyValue, BEnumChangeOfStateAlgorithm alg) {
        int i;
        ArrayList<BBacnetUnsigned> v = new ArrayList<BBacnetUnsigned>();
        int ffen = 1;
        AsnInputStream asnIn = AsnInputStream.make(propertyValue.getPropertyValue());
        try {
            int tag = asnIn.peekTag();
            while (tag != -1) {
                v.add(asnIn.readUnsigned());
                ++ffen;
                tag = asnIn.peekTag();
            }
        }
        catch (AsnException e) {
            NChangeListError nChangeListError = new NChangeListError(8, new NErrorType(2, 9), ffen);
            return nChangeListError;
        }
        finally {
            asnIn.release();
        }
        BEnumRange r = (BEnumRange)this.getPoint().getFacets().getFacet("range");
        BEnumRange almVals = alg.getAlarmValues();
        Array a = new Array(BBacnetUnsigned.class);
        int[] ordinals = almVals.getOrdinals();
        for (i = 0; i < ordinals.length; ++i) {
            a.add((Object)BBacnetUnsigned.make(ordinals[i]));
        }
        try {
            for (i = 0; i < v.size(); ++i) {
                BBacnetUnsigned u = (BBacnetUnsigned)((Object)v.get(i));
                int newOrdinal = u.getInt();
                boolean found = false;
                for (int j = 0; j < ordinals.length; ++j) {
                    if (ordinals[j] != newOrdinal) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                a.add((Object)u);
            }
            BBacnetUnsigned[] newUVals = (BBacnetUnsigned[])a.trim();
            int[] newOrdinals = new int[newUVals.length];
            String[] newTags = new String[newUVals.length];
            for (int i2 = 0; i2 < newOrdinals.length; ++i2) {
                newOrdinals[i2] = newUVals[i2].getInt();
                newTags[i2] = r.getTag(newOrdinals[i2]);
            }
            alg.set(BEnumChangeOfStateAlgorithm.alarmValues, (BValue)BEnumRange.make((int[])newOrdinals, (String[])newTags), BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (PermissionException e) {
            log.warning("PermissionException adding elements to alarmValues in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NChangeListError(8, new NErrorType(2, 40), 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeListError removeAlarmValues(PropertyValue propertyValue, BEnumChangeOfStateAlgorithm alg) {
        ArrayList<BBacnetUnsigned> v = new ArrayList<BBacnetUnsigned>();
        int ffen = 1;
        AsnInputStream asnIn = AsnInputStream.make(propertyValue.getPropertyValue());
        try {
            int tag = asnIn.peekTag();
            while (tag != -1) {
                v.add(asnIn.readUnsigned());
                ++ffen;
                tag = asnIn.peekTag();
            }
        }
        catch (AsnException e) {
            NChangeListError nChangeListError = new NChangeListError(9, new NErrorType(2, 9), ffen);
            return nChangeListError;
        }
        finally {
            asnIn.release();
        }
        BEnumRange r = (BEnumRange)this.getPoint().getFacets().getFacet("range");
        BEnumRange almVals = alg.getAlarmValues();
        Array a = new Array(BBacnetUnsigned.class);
        int[] ordinals = almVals.getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            a.add((Object)BBacnetUnsigned.make(ordinals[i]));
        }
        try {
            for (ffen = 1; ffen <= v.size(); ++ffen) {
                BBacnetUnsigned u = (BBacnetUnsigned)((Object)v.get(ffen - 1));
                if (!a.contains((Object)u)) {
                    return new NChangeListError(9, new NErrorType(5, 81), ffen);
                }
                a.remove((Object)u);
            }
            BBacnetUnsigned[] newUVals = (BBacnetUnsigned[])a.trim();
            int[] newOrdinals = new int[newUVals.length];
            String[] newTags = new String[newUVals.length];
            for (int i = 0; i < newOrdinals.length; ++i) {
                newOrdinals[i] = newUVals[i].getInt();
                newTags[i] = r.getTag(newOrdinals[i]);
            }
            alg.set(BEnumChangeOfStateAlgorithm.alarmValues, (BValue)BEnumRange.make((int[])newOrdinals, (String[])newTags), BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (PermissionException e) {
            log.warning("PermissionException removing elements from alarmValues in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NChangeListError(9, new NErrorType(2, 40), 0L);
        }
    }

    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BEnumPoint pt = (BEnumPoint)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 74: {
                    return new NErrorType(2, 40);
                }
                case 110: {
                    return this.writeStateText(ndx, val, pt);
                }
            }
            return super.writeProperty(pId, ndx, val, pri);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RangeData readRange(RangeReference ref, Integer[] list, int maxEncodedSize) {
        int rangeType = ref.getRangeType();
        int len = list.length;
        boolean[] rflags = new boolean[]{false, false, false};
        int maxDataLength = -1;
        if (ref instanceof BacnetConfirmedRequest) {
            maxDataLength = ((BacnetConfirmedRequest)((Object)ref)).getMaxDataLength() - 23 + 3 + 5;
        }
        if (rangeType == 3) {
            int i;
            int refNdx = (int)ref.getReferenceIndex();
            int count = ref.getCount();
            if (refNdx > len || refNdx < 1) {
                return new ReadRangeAck(this.getObjectId(), ref.getPropertyId(), -1, BBacnetBitString.emptyBitString(3), 0L, new byte[0]);
            }
            Array a = new Array(Integer.class);
            int itemsFound = 0;
            if (count > 0) {
                for (i = refNdx - 1; i < len && itemsFound < count; ++itemsFound, ++i) {
                    a.add((Object)list[i]);
                }
                if (refNdx == 1) {
                    rflags[0] = true;
                }
                if (refNdx + count - 1 >= len) {
                    rflags[1] = true;
                }
            } else if (count < 0) {
                count = -count;
                for (i = refNdx - 1; i >= 0 && itemsFound < count; ++itemsFound, --i) {
                    a.add((Object)list[i]);
                }
                a = a.reverse();
                if (refNdx - count <= 0) {
                    rflags[0] = true;
                }
                if (refNdx == len) {
                    rflags[1] = true;
                }
            } else {
                return new ReadRangeAck(5, 7);
            }
            ListIterator it = a.iterator();
            int itemCount = 0;
            AsnOutputStream asnOut = AsnOutputStream.make();
            try {
                if (maxDataLength > 0) {
                    while (it.hasNext()) {
                        if (maxDataLength - asnOut.size() < maxEncodedSize) {
                            rflags[1] = false;
                            break;
                        }
                        asnOut.writeUnsignedInteger(((Integer)it.next()).intValue());
                        ++itemCount;
                    }
                } else {
                    itemCount = itemsFound;
                    while (it.hasNext()) {
                        asnOut.writeUnsignedInteger(((Integer)it.next()).intValue());
                    }
                }
                if (itemCount < itemsFound) {
                    rflags[2] = true;
                }
                ReadRangeAck readRangeAck = new ReadRangeAck(this.getObjectId(), ref.getPropertyId(), -1, BBacnetBitString.make(rflags), (long)itemCount, asnOut.toByteArray());
                return readRangeAck;
            }
            finally {
                asnOut.release();
            }
        }
        if (rangeType == -1) {
            rflags[0] = false;
            int itemCount = 0;
            AsnOutputStream asnOut = AsnOutputStream.make();
            try {
                int i;
                if (maxDataLength > 0) {
                    for (i = 0; i < len; ++i) {
                        asnOut.writeUnsignedInteger(list[i].intValue());
                        ++itemCount;
                        if (maxDataLength - asnOut.size() < maxEncodedSize) break;
                    }
                    if (itemCount > 0) {
                        rflags[0] = true;
                    }
                    if (itemCount > 0 && itemCount == len) {
                        rflags[1] = true;
                    }
                } else {
                    itemCount = len;
                    for (i = 0; i < len; ++i) {
                        asnOut.writeUnsignedInteger(list[i].intValue());
                    }
                    if (itemCount > 0) {
                        rflags[0] = true;
                    }
                    if (itemCount > 0 && itemCount == len) {
                        rflags[1] = true;
                    }
                }
                if (itemCount < len) {
                    rflags[2] = true;
                }
                ReadRangeAck readRangeAck = new ReadRangeAck(this.getObjectId(), ref.getPropertyId(), -1, BBacnetBitString.make(rflags), (long)itemCount, asnOut.toByteArray());
                return readRangeAck;
            }
            finally {
                asnOut.release();
            }
        }
        return new ReadRangeAck(5, 7);
    }

    @Override
    protected final boolean checkPointConfiguration() {
        int[] ords;
        BEnumRange r = (BEnumRange)this.getPoint().getFacets().getFacet("range");
        if (r != null && (ords = r.getOrdinals()).length > 0) {
            if (ords[0] != 1) {
                this.setFaultCause("Range must be 1-N for export to BACnet.");
                return false;
            }
            for (int i = 0; i < ords.length; ++i) {
                if (ords[i] == i + 1) continue;
                this.setFaultCause("State Range supports only contiguous ordinals.");
                return false;
            }
        }
        return true;
    }

    @Override
    protected void validate() {
        BStatus s;
        BStatusEnum pointOut;
        if (!this.configOk.get()) {
            return;
        }
        if (this.getOosExt().getOutOfService()) {
            this.setFaultCause("");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            BBacnetReliability algorithmicReliability = this.getAlgorithmicReliability();
            if (!algorithmicReliability.equals(BBacnetReliability.noFaultDetected)) {
                this.setReliability((BEnum)algorithmicReliability);
            } else {
                this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            }
            return;
        }
        BEnumPoint point = (BEnumPoint)this.getPoint();
        BBacnetReliability pointReliability = this.validatePoint(point, pointOut = point.getOut());
        if (!pointReliability.equals(BBacnetReliability.noFaultDetected)) {
            // empty if block
        }
        if ((s = pointOut.getStatus()).isFault()) {
            BBacnetReliability algorithmicReliability = this.getAlgorithmicReliability();
            if (!algorithmicReliability.equals(BBacnetReliability.noFaultDetected)) {
                this.setReliability((BEnum)algorithmicReliability);
            } else {
                this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            }
            return;
        }
        this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
    }

    protected BBacnetReliability validatePoint(BEnumPoint point, BStatusEnum pointOut) {
        if (pointOut.getStatus().isNull()) {
            this.setFaultCause("Invalid value for BACnet Object: " + pointOut);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return BBacnetReliability.noFaultDetected;
        }
        int ordinal = pointOut.getValue().getOrdinal();
        BEnumRange range = (BEnumRange)point.getFacets().getFacet("range");
        if (range == null) {
            this.setFaultCause(lex.getText("export.configurationFault"));
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return BBacnetReliability.noFaultDetected;
        }
        if (ordinal == 0 || !range.isOrdinal(ordinal)) {
            this.setFaultCause("Value out of range: " + ordinal);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return BBacnetReliability.noFaultDetected;
        }
        this.setFaultCause("");
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        return BBacnetReliability.noFaultDetected;
    }

    private BBacnetReliability getAlgorithmicReliability() {
        BAlarmSourceExt alarmExt = this.getAlarmExt();
        if (alarmExt == null) {
            return BBacnetReliability.noFaultDetected;
        }
        BFaultAlgorithm faultAlgorithm = alarmExt.getFaultAlgorithm();
        if (!(faultAlgorithm instanceof BEnumFaultAlgorithm)) {
            return BBacnetReliability.noFaultDetected;
        }
        if (alarmExt.getAlarmState().equals((Object)BAlarmState.fault)) {
            return BBacnetReliability.multiStateFault;
        }
        return BBacnetReliability.noFaultDetected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static EnumRangeWrapper getWritableEnumRange(byte[] val, BEnumRange tagRange, boolean skipOrdinals) throws AsnException {
        List<BBacnetUnsigned> alarmOrdinalList;
        AsnInputStream asnIn = AsnInputStream.make(val);
        try {
            int tag = asnIn.peekTag();
            if (skipOrdinals) {
                alarmOrdinalList = Collections.synchronizedList(new LinkedList());
                for (int ordinal : tagRange.getOrdinals()) {
                    alarmOrdinalList.add(BBacnetUnsigned.make(ordinal));
                }
                while (tag != -1) {
                    BBacnetUnsigned excludeUnsigned = asnIn.readUnsigned();
                    int excludeOrdinal = excludeUnsigned.getInt();
                    if (!tagRange.isOrdinal(excludeOrdinal)) {
                        log.warning("Invalid ordinal value : " + excludeOrdinal);
                        EnumRangeWrapper enumRangeWrapper = EnumRangeWrapper.make(BEnumRange.DEFAULT, new NErrorType(2, 37));
                        return enumRangeWrapper;
                    }
                    alarmOrdinalList.remove((Object)excludeUnsigned);
                    tag = asnIn.peekTag();
                }
            } else {
                alarmOrdinalList = Collections.synchronizedList(new ArrayList());
                while (tag != -1) {
                    alarmOrdinalList.add(asnIn.readUnsigned());
                    tag = asnIn.peekTag();
                }
            }
        }
        finally {
            asnIn.release();
        }
        return BBacnetMultiStatePointDescriptor.makeEnumRange(tagRange, alarmOrdinalList);
    }

    private static EnumRangeWrapper makeEnumRange(BEnumRange tagRange, List<BBacnetUnsigned> ordinalList) {
        Iterator<BBacnetUnsigned> it = ordinalList.iterator();
        int size = ordinalList.size();
        int[] ordinals = new int[size];
        String[] tags = new String[size];
        int counter = 0;
        while (it.hasNext()) {
            BBacnetUnsigned bacnetUnsigned = it.next();
            int ordinal = bacnetUnsigned.getInt();
            if (tagRange.isOrdinal(ordinal)) {
                ordinals[counter] = ordinal;
                tags[counter++] = tagRange.getTag(ordinal);
                continue;
            }
            log.warning("Invalid ordinal value: " + ordinal);
            return EnumRangeWrapper.make(BEnumRange.DEFAULT, new NErrorType(2, 37));
        }
        BEnumRange enumRange = BEnumRange.make((int[])ordinals, (String[])tags);
        return EnumRangeWrapper.make(enumRange, null);
    }

    @Override
    BStatusValue getCurrentStatusValue() {
        BStatusEnum sv = new BStatusEnum((BEnum)((BEnumPoint)this.getPoint()).getOut().getValue());
        sv.setStatus(this.getStatusFlags());
        return sv;
    }

    @Override
    boolean checkCov(BStatusValue currentValue, BStatusValue covValue) {
        if (currentValue.getStatus().getBits() != covValue.getStatus().getBits()) {
            return true;
        }
        return ((BStatusEnum)currentValue).getEnum().getOrdinal() != ((BStatusEnum)covValue).getEnum().getOrdinal();
    }

    @Deprecated
    boolean checkCov(BControlPoint pt, BBacnetCovSubscription covSub) {
        int covValue;
        if (pt.getStatus().getBits() != covSub.getLastValue().getStatus().getBits()) {
            return true;
        }
        int currentValue = ((BEnumPoint)pt).getEnum().getOrdinal();
        return currentValue != (covValue = ((BIEnum)covSub.getLastValue()).getEnum().getOrdinal());
    }

    @Override
    BStatus getStatusFlags() {
        int status = super.getStatusFlags().getBits();
        BEnumPoint pt = (BEnumPoint)this.getPoint();
        if (pt.getOut().getValue().getOrdinal() <= 0) {
            status |= 2;
        }
        return BStatus.make((int)status);
    }

    private static String[] getTags(BEnumRange r) {
        int[] ordinals = r.getOrdinals();
        String[] tags = new String[ordinals.length];
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = r.getTag(ordinals[i]);
        }
        return tags;
    }

    private static int findIndex(int ndx, int[] ordinals) {
        for (int i = 0; i < ordinals.length; ++i) {
            if (ordinals[i] != ndx) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyValue readStateText(int ndx) {
        BEnumRange range = (BEnumRange)this.getPoint().getFacets().getFacet("range");
        if (range == null) {
            return new NReadPropertyResult(110, ndx, new NErrorType(2, 32));
        }
        int length = range.getOrdinals().length;
        if (ndx == -1) {
            AsnOutputStream asnOut = AsnOutputStream.make();
            try {
                for (int i = 1; i <= length; ++i) {
                    asnOut.writeCharacterString(SlotPath.unescape((String)range.getTag(i)));
                }
                NReadPropertyResult nReadPropertyResult = new NReadPropertyResult(110, -1, asnOut.toByteArray());
                return nReadPropertyResult;
            }
            finally {
                asnOut.release();
            }
        }
        if (ndx == 0) {
            return new NReadPropertyResult(110, 0, AsnUtil.toAsnUnsigned(length));
        }
        if (ndx >= 1 && ndx <= length) {
            try {
                return new NReadPropertyResult(110, ndx, AsnUtil.toAsnCharacterString(SlotPath.unescape((String)range.getTag(ndx))));
            }
            catch (Exception e) {
                return new NReadPropertyResult(110, ndx, new NErrorType(2, 42));
            }
        }
        return new NReadPropertyResult(110, ndx, new NErrorType(2, 42));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NErrorType writeStateText(int ndx, byte[] val, BEnumPoint pt) throws BacnetException {
        block19: {
            BFacets f = pt.getFacets();
            BEnumRange r = (BEnumRange)f.getFacet("range");
            if (r == null) break block19;
            try {
                BEnumRange range;
                switch (ndx) {
                    case 0: {
                        return new NErrorType(2, 42);
                    }
                    case -1: {
                        BEnumRange range2;
                        ArrayList<String> v = new ArrayList<String>();
                        AsnInputStream asnIn = AsnInputStream.make(val);
                        try {
                            int tag = asnIn.peekTag();
                            while (tag != -1) {
                                v.add(asnIn.readCharacterString());
                                tag = asnIn.peekTag();
                            }
                        }
                        finally {
                            asnIn.release();
                        }
                        if (v.size() != r.getOrdinals().length) {
                            return new NErrorType(2, 37);
                        }
                        int[] newOrdinals = new int[v.size()];
                        String[] newTags = new String[v.size()];
                        for (int i = 0; i < newOrdinals.length; ++i) {
                            newOrdinals[i] = i + 1;
                            newTags[i] = SlotPath.escape((String)((String)v.get(i)));
                            if (newTags[i].length() != 0) continue;
                            return new NErrorType(2, 37);
                        }
                        try {
                            range2 = BEnumRange.make((int[])newOrdinals, (String[])newTags);
                        }
                        catch (IllegalArgumentException iae) {
                            return new NErrorType(2, 37);
                        }
                        pt.set(BControlPoint.facets, (BValue)BFacets.make((BFacets)f, (String)"range", (BIDataValue)range2), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
                int[] ordinals = r.getOrdinals();
                String[] tags = BBacnetMultiStatePointDescriptor.getTags(r);
                if (ndx < 1 || ndx > ordinals.length) {
                    return new NErrorType(2, 42);
                }
                int i = BBacnetMultiStatePointDescriptor.findIndex(ndx, ordinals);
                if (i < 0) {
                    log.severe("MultiStatePointDescriptor.writeStateText: Index not found in ordinal list: " + ndx);
                    return new NErrorType(2, 42);
                }
                tags[i] = SlotPath.escape((String)AsnUtil.fromAsnCharacterString(val));
                if (tags[i].length() == 0) {
                    return new NErrorType(2, 37);
                }
                try {
                    range = BEnumRange.make((int[])ordinals, (String[])tags);
                }
                catch (IllegalArgumentException iae) {
                    return new NErrorType(2, 37);
                }
                pt.set(BControlPoint.facets, (BValue)BFacets.make((BFacets)f, (String)"range", (BIDataValue)range), BLocalBacnetDevice.getBacnetContext());
                return null;
            }
            catch (PermissionException e) {
                log.warning("PermissionException writing stateText in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
                return new NErrorType(2, 40);
            }
        }
        return new NErrorType(2, 32);
    }

    public BIcon getIcon() {
        return icon;
    }
}

