/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.enums.BBacnetMstpBaudRate;
import com.tridium.bacnet.stack.link.mstp.BBacnetMstpLinkLayer;
import java.util.List;
import java.util.logging.Level;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetNetworkPortDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.ValidateChangesException;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFloat;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BBacnetMstpPortDescriptor
extends BBacnetNetworkPortDescriptor {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetMstpPortDescriptor.class);
    private static final String MAC_ADDRESS = "MacAddress";
    private static final String MAX_MASTER = "MaxMaster";
    private static final String MAX_INFO_FRAMES = "MaxInfoFrames";
    private static final String LINK_SPEED = "LinkSpeed";
    private static final int[] OPTIONAL_PROPS = new int[]{28, 417, 425, 426, 399, 428, 423, 64, 63, 420, 421, 422, 424};
    private static final int[] VALID_LINK_SPEEDS = BBacnetMstpBaudRate.DEFAULT.getRange().getOrdinals();
    private static final BBacnetArray LINK_SPEEDS_ARRAY = new BBacnetArray(BFloat.TYPE);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected int getNetworkType() {
        return 2;
    }

    @Override
    protected int[] getOptionalProps() {
        return OPTIONAL_PROPS;
    }

    @Override
    protected boolean isArrayProp(int propId) {
        switch (propId) {
            case 371: 
            case 421: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isListProp(int propId) {
        return propId == 428;
    }

    @Override
    protected PropertyValue readOptionalProperty(int propertyId, int index) {
        switch (propertyId) {
            case 425: {
                return this.readNetworkNumber();
            }
            case 426: {
                return this.readNetworkNumberQuality();
            }
            case 399: {
                return this.readApduLength();
            }
            case 428: {
                return this.readRoutingTable();
            }
            case 423: {
                return this.readMacAddress();
            }
            case 64: {
                return this.readMaxMaster();
            }
            case 63: {
                return this.readMaxInfoFrames();
            }
            case 420: {
                return this.readLinkSpeed();
            }
            case 421: {
                return BBacnetMstpPortDescriptor.readLinkSpeeds(index);
            }
            case 422: {
                return BBacnetMstpPortDescriptor.readLinkSpeedAutoNegotiate();
            }
            case 424: {
                return this.readNetworkInterfaceName();
            }
        }
        return new NReadPropertyResult(propertyId, new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty));
    }

    @Override
    protected List<? extends BIBacnetDataType> getListElements(int propertyId) throws ErrorException {
        if (propertyId == 428) {
            return this.getRouterEntries();
        }
        throw new IllegalArgumentException("Invalid propertyId value " + propertyId);
    }

    @Override
    protected ErrorType writeOptionalProperty(int propertyId, int index, byte[] value, int priority) throws BacnetException {
        switch (propertyId) {
            case 399: 
            case 421: 
            case 422: 
            case 424: 
            case 426: 
            case 428: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this + ": attempted to write read-only property " + BBacnetPropertyIdentifier.tag(propertyId));
                }
                return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
            }
            case 425: {
                return this.writeNetworkNumber(value);
            }
            case 423: {
                return this.writeMacAddress(value);
            }
            case 64: {
                return this.writeMaxMaster(value);
            }
            case 63: {
                return this.writeMaxInfoFrames(value);
            }
            case 420: {
                return this.writeLinkSpeed(value);
            }
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
    }

    @Override
    protected void validateSetPendingChange(String name, BValue value, Context context) {
        switch (name) {
            case "NetworkNumber": {
                this.validateSetNetworkNumber(value, context);
                break;
            }
            case "MacAddress": {
                this.validateSetMacAddress(value, context);
                break;
            }
            case "MaxMaster": {
                this.validateSetMaxMaster(value, context);
                break;
            }
            case "MaxInfoFrames": {
                this.validateSetMaxInfoFrames(value, context);
                break;
            }
            case "LinkSpeed": {
                this.validateSetLinkSpeed(value, context);
                break;
            }
            default: {
                throw new LocalizableRuntimeException("bacnet", "networkPortDescriptor.pendingChange.unknown", new Object[]{name});
            }
        }
    }

    @Override
    public void validateChanges(Context context) throws ValidateChangesException {
        if (!this.hasPendingChanges()) {
            return;
        }
        this.checkCanReadPendingChanges(context);
        this.validateNetworkNumber(context);
        this.validateMacAddress(context);
        this.validateMaxMaster(context);
        this.validateMaxInfoFrames(context);
        this.validateLinkSpeed(context);
    }

    @Override
    public void activateChanges(Context context) throws Exception {
        if (!this.hasPendingChanges()) {
            return;
        }
        this.activateNetworkNumber(context);
        this.activateMacAddress(context);
        this.activateMaxMaster(context);
        this.activateMaxInfoFrames(context);
        this.activateLinkSpeed(context);
    }

    @Override
    protected ErrorType handleRestartSlaveDiscovery() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Restart Slave Discovery is not supported");
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.optionalFunctionalityNotSupported);
    }

    private PropertyValue readMacAddress() {
        BBacnetOctetString pendingMacAddress = this.getPendingChange(MAC_ADDRESS, BBacnetOctetString.class);
        if (pendingMacAddress != null) {
            return BacnetDescriptorUtil.makeOctetStringReadResult(BBacnetPropertyIdentifier.macAddress, pendingMacAddress);
        }
        return BacnetDescriptorUtil.makeOctetStringReadResult(BBacnetPropertyIdentifier.macAddress, this.getMstpLink().getMacAddress());
    }

    private ErrorType writeMacAddress(byte[] value) throws AsnException {
        BBacnetOctetString macAddress = AsnUtil.fromAsnOctetString(value);
        try {
            BBacnetMstpPortDescriptor.validateMacAddress(macAddress);
        }
        catch (ValidateChangesException e) {
            return e.getError();
        }
        this.addPendingChange(MAC_ADDRESS, (BValue)macAddress, BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    private void validateSetMacAddress(BValue value, Context context) {
        this.checkPendingChangeType(MAC_ADDRESS, value, BBacnetOctetString.TYPE);
        this.checkCanWrite(this.getMstpLink(), (Slot)BBacnetMstpLinkLayer.mstpAddress, context);
    }

    private void validateMacAddress(Context context) throws ValidateChangesException {
        BBacnetOctetString change = this.getPendingChange(MAC_ADDRESS, BBacnetOctetString.class);
        if (change != null) {
            BBacnetMstpPortDescriptor.validateMacAddress(change);
            this.validateCanWrite(this.getMstpLink(), (Slot)BBacnetMstpLinkLayer.mstpAddress, BBacnetPropertyIdentifier.macAddress, context);
        }
    }

    private static void validateMacAddress(BBacnetOctetString value) throws ValidateChangesException {
        if (value.isNull() || value.length() != 1) {
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange, BBacnetPropertyIdentifier.macAddress, "Value \"[" + (Object)((Object)value) + "]\" does not have a length of one.");
        }
        byte element = value.getAddr()[0];
        if (element < 0 || element > 127) {
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange, BBacnetPropertyIdentifier.macAddress, "Value " + element + " is not in the range of 0-127.");
        }
    }

    private void activateMacAddress(Context context) {
        BBacnetOctetString change = this.getPendingChange(MAC_ADDRESS, BBacnetOctetString.class);
        if (change != null) {
            this.getMstpLink().setInt(BBacnetMstpLinkLayer.mstpAddress, change.getAddr()[0], context);
        }
    }

    public int getMaxMaster() {
        BBacnetUnsigned maxMaster = this.getPendingChange(MAX_MASTER, BBacnetUnsigned.class);
        if (maxMaster != null) {
            return maxMaster.getInt();
        }
        BBacnetMstpLinkLayer mstpLink = this.getMstpLink();
        return mstpLink != null ? mstpLink.getMaxMaster() : 127;
    }

    private PropertyValue readMaxMaster() {
        return BacnetDescriptorUtil.makeUnsignedReadResult(BBacnetPropertyIdentifier.maxMaster, this.getMaxMaster());
    }

    private ErrorType writeMaxMaster(byte[] value) throws AsnException {
        BBacnetUnsigned maxMaster = AsnUtil.fromAsnUnsigned(value);
        try {
            BBacnetMstpPortDescriptor.validateMaxMaster(maxMaster);
        }
        catch (ValidateChangesException e) {
            return e.getError();
        }
        this.addPendingChange(MAX_MASTER, (BValue)maxMaster, BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    private void validateSetMaxMaster(BValue value, Context context) {
        this.checkPendingChangeType(MAX_MASTER, value, BBacnetUnsigned.TYPE);
        this.checkCanWrite(this.getMstpLink(), (Slot)BBacnetMstpLinkLayer.maxMaster, context);
    }

    private void validateMaxMaster(Context context) throws ValidateChangesException {
        BBacnetUnsigned change = this.getPendingChange(MAX_MASTER, BBacnetUnsigned.class);
        if (change != null) {
            BBacnetMstpPortDescriptor.validateMaxMaster(change);
            this.validateCanWrite(this.getMstpLink(), (Slot)BBacnetMstpLinkLayer.maxMaster, BBacnetPropertyIdentifier.maxMaster, context);
        }
    }

    private static void validateMaxMaster(BBacnetUnsigned value) throws ValidateChangesException {
        int intValue = value.getInt();
        if (intValue < 0 || intValue > 127) {
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange, BBacnetPropertyIdentifier.maxMaster, "Value " + (Object)((Object)value) + " is not in the range of 0-127.");
        }
    }

    private void activateMaxMaster(Context context) {
        BBacnetUnsigned change = this.getPendingChange(MAX_MASTER, BBacnetUnsigned.class);
        if (change != null) {
            this.getMstpLink().setInt(BBacnetMstpLinkLayer.maxMaster, change.getInt(), context);
        }
    }

    public int getMaxInfoFrames() {
        BBacnetUnsigned maxInfoFrames = this.getPendingChange(MAX_INFO_FRAMES, BBacnetUnsigned.class);
        if (maxInfoFrames != null) {
            return maxInfoFrames.getInt();
        }
        BBacnetMstpLinkLayer mstpLink = this.getMstpLink();
        return mstpLink != null ? mstpLink.getMaxInfoFrames() : 1;
    }

    private PropertyValue readMaxInfoFrames() {
        return BacnetDescriptorUtil.makeUnsignedReadResult(BBacnetPropertyIdentifier.maxInfoFrames, this.getMaxInfoFrames());
    }

    private ErrorType writeMaxInfoFrames(byte[] value) throws AsnException {
        BBacnetUnsigned maxInfoFrames = AsnUtil.fromAsnUnsigned(value);
        try {
            BBacnetMstpPortDescriptor.validateMaxInfoFrames(maxInfoFrames);
        }
        catch (ValidateChangesException e) {
            return e.getError();
        }
        this.addPendingChange(MAX_INFO_FRAMES, (BValue)maxInfoFrames, BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    private void validateSetMaxInfoFrames(BValue value, Context context) {
        this.checkPendingChangeType(MAX_INFO_FRAMES, value, BBacnetUnsigned.TYPE);
        this.checkCanWrite(this.getMstpLink(), (Slot)BBacnetMstpLinkLayer.maxInfoFrames, context);
    }

    private void validateMaxInfoFrames(Context context) throws ValidateChangesException {
        BBacnetUnsigned change = this.getPendingChange(MAX_INFO_FRAMES, BBacnetUnsigned.class);
        if (change != null) {
            BBacnetMstpPortDescriptor.validateMaxInfoFrames(change);
            this.validateCanWrite(this.getMstpLink(), (Slot)BBacnetMstpLinkLayer.maxInfoFrames, BBacnetPropertyIdentifier.maxInfoFrames, context);
        }
    }

    private static void validateMaxInfoFrames(BBacnetUnsigned value) throws ValidateChangesException {
        int intValue = value.getInt();
        if (intValue < 1 || intValue > 255) {
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange, BBacnetPropertyIdentifier.maxInfoFrames, "Value " + (Object)((Object)value) + " is not in the range of 1-255.");
        }
    }

    private void activateMaxInfoFrames(Context context) {
        BBacnetUnsigned change = this.getPendingChange(MAX_INFO_FRAMES, BBacnetUnsigned.class);
        if (change != null) {
            this.getMstpLink().setInt(BBacnetMstpLinkLayer.maxInfoFrames, change.getInt(), context);
        }
    }

    private PropertyValue readLinkSpeed() {
        BFloat pendingChange = this.getPendingChange(LINK_SPEED, BFloat.class);
        if (pendingChange != null) {
            return BacnetDescriptorUtil.makeRealReadResult(BBacnetPropertyIdentifier.linkSpeed, pendingChange.getFloat());
        }
        BBacnetMstpBaudRate baudRate = this.getMstpLink().getBaudRate();
        return BacnetDescriptorUtil.makeRealReadResult(BBacnetPropertyIdentifier.linkSpeed, baudRate.getOrdinal());
    }

    private ErrorType writeLinkSpeed(byte[] value) throws AsnException {
        float linkSpeed = AsnUtil.fromAsnReal(value);
        try {
            BBacnetMstpPortDescriptor.validateLinkSpeed(linkSpeed);
        }
        catch (ValidateChangesException e) {
            return e.getError();
        }
        this.addPendingChange(LINK_SPEED, (BValue)BFloat.make((float)linkSpeed), BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    private void validateSetLinkSpeed(BValue value, Context context) {
        this.checkPendingChangeType(LINK_SPEED, value, BFloat.TYPE);
        this.checkCanWrite(this.getMstpLink(), (Slot)BBacnetMstpLinkLayer.baudRate, context);
    }

    private void validateLinkSpeed(Context context) throws ValidateChangesException {
        BFloat change = this.getPendingChange(LINK_SPEED, BFloat.class);
        if (change != null) {
            BBacnetMstpPortDescriptor.validateLinkSpeed(change.getFloat());
            this.validateCanWrite(this.getMstpLink(), (Slot)BBacnetMstpLinkLayer.baudRate, BBacnetPropertyIdentifier.linkSpeed, context);
        }
    }

    private static void validateLinkSpeed(float value) throws ValidateChangesException {
        if (!BBacnetMstpPortDescriptor.isLinkSpeedValid(value)) {
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange, BBacnetPropertyIdentifier.linkSpeed, "Value " + (int)value + " is not one of the valid link speeds.");
        }
    }

    private void activateLinkSpeed(Context context) {
        BFloat change = this.getPendingChange(LINK_SPEED, BFloat.class);
        if (change != null) {
            BBacnetMstpBaudRate mstpBaudRate = BBacnetMstpBaudRate.make(change.getInt());
            this.getMstpLink().set(BBacnetMstpLinkLayer.baudRate, (BValue)mstpBaudRate, context);
        }
    }

    private static boolean isLinkSpeedValid(float value) {
        for (int linkSpeed : VALID_LINK_SPEEDS) {
            if (value != (float)linkSpeed) continue;
            return true;
        }
        return false;
    }

    private static PropertyValue readLinkSpeeds(int index) {
        return BacnetDescriptorUtil.readArray(BBacnetPropertyIdentifier.linkSpeeds, index, LINK_SPEEDS_ARRAY);
    }

    private static PropertyValue readLinkSpeedAutoNegotiate() {
        return BacnetDescriptorUtil.makeBooleanReadResult(BBacnetPropertyIdentifier.linkSpeedAutonegotiate, false);
    }

    private PropertyValue readNetworkInterfaceName() {
        return BacnetDescriptorUtil.makeCharStringReadResult(BBacnetPropertyIdentifier.networkInterfaceName, this.getMstpLink().getPortName());
    }

    private BBacnetMstpLinkLayer getMstpLink() {
        return this.networkPort != null ? (BBacnetMstpLinkLayer)this.networkPort.getLink() : null;
    }

    static {
        for (int validLinkSpeed : VALID_LINK_SPEEDS) {
            LINK_SPEEDS_ARRAY.addElement((BValue)BFloat.make((float)validLinkSpeed));
        }
    }
}

