/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.enums.BIpDeviceType;
import com.tridium.bacnet.stack.link.ip.BBacnetIpLinkLayer;
import com.tridium.bacnet.stack.link.ip.BBacnetIpServerPort;
import com.tridium.bacnet.stack.link.ip.BBdtEntry;
import com.tridium.bacnet.stack.link.ip.BBroadcastDistributionTable;
import com.tridium.bacnet.stack.link.ip.BFdtEntry;
import com.tridium.bacnet.stack.link.ip.BForeignDeviceRegistration;
import com.tridium.bacnet.stack.link.ip.util.BacnetIpLinkUtil;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Level;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBdtEntry;
import javax.baja.bacnet.datatypes.BBacnetFdtEntry;
import javax.baja.bacnet.datatypes.BBacnetHostAddress;
import javax.baja.bacnet.datatypes.BBacnetHostAddressChoice;
import javax.baja.bacnet.datatypes.BBacnetHostNPort;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetIpMode;
import javax.baja.bacnet.enums.BBacnetNetworkPortCommand;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetNetworkPortDescriptor;
import javax.baja.bacnet.export.BBacnetNetworkPortPendingChanges;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.ValidateChangesException;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType
public class BBacnetIpPortDescriptor
extends BBacnetNetworkPortDescriptor {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetIpPortDescriptor.class);
    private final boolean IS_TRIDIUM_QNX = PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx);
    private static final String UDP_PORT = "UdpPort";
    private static final String IP_MODE = "IpMode";
    private static final String BBMD_BROADCAST_DISTRIBUTION_TABLE = "BbmdBroadcastDistributionTable";
    private static final String BBMD_ACCEPT_FD_REGISTRATIONS = "BbmdAcceptForeignDeviceRegistrations";
    private static final String FD_BBMD_ADDRESS = "ForeignDeviceBbmdAddress";
    private static final String FD_SUBSCRIPTION_LIFETIME = "ForeignDeviceSubscriptionLifetime";
    private static final String IP_ADDRESS = "IpAddress";
    private static final String SUBNET_MASK = "SubnetMask";
    private static final String DEFAULT_GATEWAY = "DefaultGateway";
    private static final String DNS_SERVER = "DnsServer";
    private static final String DHCP_ENABLE = "DhcpEnable";
    private static final int[] OPTIONAL_PROPS = new int[]{28, 417, 425, 426, 399, 423, 408, 412, 428, 414, 413, 415, 418, 419, 400, 411, 401, 406, 402, 403, 404, 405, 424};

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected int getNetworkType() {
        return 5;
    }

    @Override
    protected int[] getOptionalProps() {
        return OPTIONAL_PROPS;
    }

    @Override
    protected boolean isArrayProp(int propId) {
        switch (propId) {
            case 371: 
            case 406: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isListProp(int propId) {
        switch (propId) {
            case 414: 
            case 415: 
            case 428: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected PropertyValue readOptionalProperty(int propertyId, int index) {
        switch (propertyId) {
            case 425: {
                return this.readNetworkNumber();
            }
            case 426: {
                return this.readNetworkNumberQuality();
            }
            case 399: {
                return this.readApduLength();
            }
            case 423: {
                return this.readMacAddress();
            }
            case 408: {
                return this.readIpMode();
            }
            case 412: {
                return this.readUdpPort();
            }
            case 428: {
                return this.readRoutingTable();
            }
            case 414: {
                return this.readBroadcastDistributionTable();
            }
            case 413: {
                return this.readBbmdAcceptForeignDeviceRegistrations();
            }
            case 415: {
                return this.readForeignDeviceTable();
            }
            case 418: {
                return this.readForeignDeviceBbmdAddress();
            }
            case 419: {
                return this.readForeignDeviceSubscriptionLifetime();
            }
            case 400: {
                return this.readIpAddress();
            }
            case 411: {
                return this.readSubnetMask();
            }
            case 401: {
                return this.readDefaultGateway();
            }
            case 406: {
                return this.readDnsServer(index);
            }
            case 402: {
                return this.readDhcpEnable();
            }
            case 403: {
                return this.readDhcpLeaseTime();
            }
            case 404: {
                return this.readDhcpLeaseTimeRemaining();
            }
            case 405: {
                return this.readDhcpServer();
            }
            case 424: {
                return this.readNetworkInterfaceName();
            }
        }
        return new NReadPropertyResult(propertyId, new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty));
    }

    @Override
    protected List<? extends BIBacnetDataType> getListElements(int propertyId) throws ErrorException {
        switch (propertyId) {
            case 428: {
                return this.getRouterEntries();
            }
            case 414: {
                return this.getBdtEntries();
            }
            case 415: {
                return this.getFdtEntries();
            }
        }
        throw new IllegalArgumentException("Invalid propertyId value " + propertyId);
    }

    @Override
    protected ErrorType writeOptionalProperty(int propertyId, int index, byte[] value, int priority) throws BacnetException {
        switch (propertyId) {
            case 399: 
            case 403: 
            case 404: 
            case 405: 
            case 415: 
            case 423: 
            case 424: 
            case 426: 
            case 428: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this + ": attempted to write read-only property " + BBacnetPropertyIdentifier.tag(propertyId));
                }
                return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
            }
            case 425: {
                return this.writeNetworkNumber(value);
            }
            case 408: {
                return this.writeIpMode(value);
            }
            case 412: {
                return this.writeUdpPort(value);
            }
            case 414: {
                return this.writeBroadcastDistributionTable(value);
            }
            case 418: {
                return this.writeForeignDeviceBbmdAddress(value);
            }
            case 419: {
                return this.writeForeignDeviceSubscriptionLifetime(value);
            }
            case 413: {
                return this.writeBbmdAcceptForeignDeviceRegistrations(value);
            }
            case 400: {
                return this.writeIpAddress(value);
            }
            case 411: {
                return this.writeSubnetMask(value);
            }
            case 401: {
                return this.writeDefaultGateway(value);
            }
            case 406: {
                return this.writeDnsServer(index, value);
            }
            case 402: {
                return this.writeDhcpEnable(value);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": attempted to write unknown property " + BBacnetPropertyIdentifier.tag(propertyId));
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
    }

    @Override
    public boolean activateChangesRequiresReboot() {
        return this.hasAdapterChanges();
    }

    private boolean hasAdapterChanges() {
        BBacnetNetworkPortPendingChanges pendingChanges = this.getPendingChanges();
        return pendingChanges.getProperty(IP_ADDRESS) != null || pendingChanges.getProperty(SUBNET_MASK) != null || pendingChanges.getProperty(DHCP_ENABLE) != null || pendingChanges.getProperty(DEFAULT_GATEWAY) != null || pendingChanges.getProperty(DNS_SERVER) != null;
    }

    @Override
    protected void validateSetPendingChange(String name, BValue value, Context context) {
        switch (name) {
            case "NetworkNumber": {
                this.validateSetNetworkNumber(value, context);
                break;
            }
            case "IpMode": {
                this.validateSetIpMode(value, context);
                break;
            }
            case "UdpPort": {
                this.validateSetUdpPort(value, context);
                break;
            }
            case "BbmdBroadcastDistributionTable": {
                this.validateSetBbmdBroadcastDistributionTable(value, context);
                break;
            }
            case "BbmdAcceptForeignDeviceRegistrations": {
                this.validateSetBbmdAcceptFdRegistrations(value, context);
                break;
            }
            case "ForeignDeviceBbmdAddress": {
                this.validateSetFdBbmdAddress(value, context);
                break;
            }
            case "ForeignDeviceSubscriptionLifetime": {
                this.validateSetFdSubscriptionLifetime(value, context);
                break;
            }
            case "IpAddress": {
                this.validateSetIpAddress(value, context);
                break;
            }
            case "SubnetMask": {
                this.validateSetSubnetMask(value, context);
                break;
            }
            case "DefaultGateway": {
                this.validateSetDefaultGateway(value, context);
                break;
            }
            case "DnsServer": {
                this.validateSetDnsServer(value, context);
                break;
            }
            case "DhcpEnable": {
                this.validateSetDhcpEnable(value, context);
                break;
            }
            default: {
                throw new LocalizableRuntimeException("bacnet", "networkPortDescriptor.pendingChange.unknown", new Object[]{name});
            }
        }
    }

    private static void checkCanSaveAdapterSettings(BTcpIpAdapterSettings adapterSettings, Context context) {
        BUser user;
        if (adapterSettings == null) {
            throw new LocalizableRuntimeException("bacnet", "ipPortDescriptor.pendingChange.missingAdapterSettings");
        }
        BUser bUser = user = context != null ? context.getUser() : null;
        if (user != null) {
            user.checkInvoke((BComponent)BBacnetIpPortDescriptor.getTcpIpService(), (Slot)BTcpIpPlatformService.savePlatformServiceProperties);
        }
    }

    private static void checkCanWriteHostSettings(BTcpIpAdapterSettings adapterSettings) {
        if (adapterSettings.getHostSettings().getIsReadonly()) {
            throw new LocalizableRuntimeException("bacnet", "ipPortDescriptor.pendingChange.readonlyAdapterSettings");
        }
    }

    private static void checkCanWriteAdapterSettings(BTcpIpAdapterSettings adapterSettings) {
        if (adapterSettings.getIsAdapterReadonly()) {
            throw new LocalizableRuntimeException("bacnet", "ipPortDescriptor.pendingChange.readonlyAdapterSettings");
        }
    }

    private void validateCanSaveAdapterSettings(BTcpIpAdapterSettings adapterSettings, Context context) throws ValidateChangesException {
        if (adapterSettings == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": cannot find TCP/IP adapter settings");
            }
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.other, null, "Cannot find IP adapter settings");
        }
        BUser user = this.getUser(context, BBacnetErrorCode.writeAccessDenied);
        try {
            user.checkInvoke((BComponent)BBacnetIpPortDescriptor.getTcpIpService(), (Slot)BTcpIpPlatformService.savePlatformServiceProperties);
        }
        catch (PermissionException e) {
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied, null, "User missing invoke permissions on TCP/IP service");
        }
    }

    private void validateCanWriteHostSettings(BTcpIpAdapterSettings adapterSettings, BBacnetPropertyIdentifier propertyId) throws ValidateChangesException {
        if (adapterSettings.getHostSettings().getIsReadonly()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": TCP/IP host settings are read only");
            }
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied, propertyId, "TCP/IP host settings are read only");
        }
    }

    private void validateCanWriteAdapterSettings(BTcpIpAdapterSettings adapterSettings, BBacnetPropertyIdentifier propertyId) throws ValidateChangesException {
        if (adapterSettings.getIsAdapterReadonly()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": TCP/IP adapter settings are read only");
            }
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied, propertyId, "TCP/IP adapter settings are read only");
        }
    }

    @Override
    public void validateChanges(Context context) throws ValidateChangesException {
        if (!this.hasPendingChanges()) {
            return;
        }
        this.checkCanReadPendingChanges(context);
        this.validateNetworkNumber(context);
        this.validateIpMode(context);
        this.validateUdpPort(context);
        this.validateBroadcastDistributionTable(context);
        this.validateBbmdAcceptFdRegistrations(context);
        this.validateFdBbmdAddress(context);
        this.validateFdSubscriptionLifetime(context);
        if (this.hasAdapterChanges()) {
            BTcpIpAdapterSettings adapterSettings = this.findAdapterSettings();
            this.validateCanSaveAdapterSettings(adapterSettings, context);
            this.validateIpAddress(adapterSettings, context);
            this.validateSubnetMask(adapterSettings, context);
            this.validateDefaultGateway(adapterSettings, context);
            this.validateDnsServer(adapterSettings, context);
            this.validateDhcpEnable(adapterSettings, context);
        }
    }

    @Override
    public void activateChanges(Context context) throws Exception {
        if (!this.hasPendingChanges()) {
            return;
        }
        BTcpIpAdapterSettings adapterSettings = null;
        if (this.hasAdapterChanges() && (adapterSettings = this.findAdapterSettings()) == null) {
            throw new BacnetException(this + ": has pending changes to the TCP/IP adapter but adapter settings could not be found");
        }
        this.activateNetworkNumber(context);
        this.activateIpMode(context);
        this.activateUdpPort(context);
        this.activateBroadcastDistributionTable();
        this.activateBbmdAcceptFdRegistrations(context);
        this.activateFdBbmdAddress(context);
        this.activateFdSubscriptionLifetime(context);
        if (this.hasAdapterChanges()) {
            this.activateIpAddress(adapterSettings, context);
            this.activateSubnetMask(adapterSettings, context);
            this.activateDefaultGateway(adapterSettings, context);
            this.activateDnsServer(adapterSettings, context);
            this.activateDhcpEnable(adapterSettings, context);
            BBacnetIpPortDescriptor.getTcpIpService().invoke(BTcpIpPlatformService.savePlatformServiceProperties, null, context);
        }
    }

    private static String makeAddressStr(byte[] bytes) {
        if (bytes == null || bytes.length != 4) {
            return "null";
        }
        return "" + (bytes[0] & 0xFF) + '.' + (bytes[1] & 0xFF) + '.' + (bytes[2] & 0xFF) + '.' + (bytes[3] & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ErrorType handleRenewFdRegistrationCommand(Context context) {
        BBacnetIpLinkLayer ipLinkLayer = this.getIpLinkLayer();
        BIpDeviceType ipDeviceType = ipLinkLayer.getIpDeviceType();
        if (!ipDeviceType.equals((Object)BIpDeviceType.foreignDevice)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": attempt to write command value Renew FD Registration when IP Device Type is not Foreign Device: " + (Object)((Object)ipDeviceType));
            }
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
        }
        this.set(command, (BValue)BBacnetNetworkPortCommand.renewFdRegistration, context);
        try {
            BForeignDeviceRegistration[] registrations = (BForeignDeviceRegistration[])ipLinkLayer.getChildren(BForeignDeviceRegistration.class);
            if (registrations.length > 0) {
                registrations[0].invoke(BForeignDeviceRegistration.registerWithBBMD, null, context);
                this.updateReliability();
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this + ": attempt to write command value Renew FD Registration but no foreign device registrations found");
                }
                this.setReliability((BEnum)BBacnetReliability.renewFdRegistrationFailure);
            }
        }
        catch (Exception e) {
            this.setReliability((BEnum)BBacnetReliability.renewFdRegistrationFailure);
        }
        finally {
            this.set(command, (BValue)BBacnetNetworkPortCommand.idle, context);
        }
        return null;
    }

    @Override
    protected ErrorType handleRenewDhcpCommand(Context context) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": Renew DHCP command is not supported");
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.optionalFunctionalityNotSupported);
    }

    private PropertyValue readMacAddress() {
        byte[] macBytes = this.getMacAddress();
        if (macBytes == null) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.macAddress, BBacnetErrorClass.property, BBacnetErrorCode.valueNotInitialized);
        }
        return BacnetDescriptorUtil.makeOctetStringReadResult(BBacnetPropertyIdentifier.macAddress, macBytes);
    }

    private byte[] getMacAddress() {
        byte[] macBytes;
        BBacnetOctetString ipAddress = this.getPendingChange(IP_ADDRESS, BBacnetOctetString.class);
        BBacnetUnsigned udpPort = this.getPendingChange(UDP_PORT, BBacnetUnsigned.class);
        if (ipAddress != null && udpPort != null) {
            macBytes = new byte[6];
        } else {
            macBytes = this.getIpLinkLayer().getMacAddress();
            if (macBytes == null || macBytes.length != 6) {
                return null;
            }
            if (ipAddress != null || udpPort != null) {
                macBytes = (byte[])macBytes.clone();
            }
        }
        if (ipAddress != null) {
            System.arraycopy(ipAddress.getAddr(), 0, macBytes, 0, 4);
        }
        if (udpPort != null) {
            int port = udpPort.getInt();
            macBytes[4] = (byte)((port & 0xFF00) >> 8);
            macBytes[5] = (byte)(port & 0xFF);
        }
        return macBytes;
    }

    private PropertyValue readIpMode() {
        return BacnetDescriptorUtil.makeEnumReadResult(BBacnetPropertyIdentifier.bacnetIpMode, (BEnum)this.getIpMode());
    }

    private BBacnetIpMode getIpMode() {
        BBacnetIpMode pending = this.getPendingChange(IP_MODE, BBacnetIpMode.class);
        if (pending != null) {
            return pending;
        }
        switch (this.getIpLinkLayer().getIpDeviceType().getOrdinal()) {
            case 1: {
                return BBacnetIpMode.foreign;
            }
            case 2: {
                return BBacnetIpMode.bbmd;
            }
        }
        return BBacnetIpMode.normal;
    }

    private ErrorType writeIpMode(byte[] value) throws AsnException {
        this.addPendingChange(IP_MODE, (BValue)BBacnetIpMode.make(AsnUtil.fromAsnEnumerated(value)), BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    private void validateSetIpMode(BValue value, Context context) {
        this.checkPendingChangeType(IP_MODE, value, BBacnetIpMode.TYPE);
        this.checkCanWrite(this.getIpLinkLayer(), (Slot)BBacnetIpLinkLayer.ipDeviceType, context);
    }

    private void validateIpMode(Context context) throws ValidateChangesException {
        BBacnetIpMode change = this.getPendingChange(IP_MODE, BBacnetIpMode.class);
        if (change != null) {
            this.validateCanWrite(this.getIpLinkLayer(), (Slot)BBacnetIpLinkLayer.ipDeviceType, BBacnetPropertyIdentifier.bacnetIpMode, context);
        }
    }

    private void activateIpMode(Context context) {
        BBacnetIpMode change = this.getPendingChange(IP_MODE, BBacnetIpMode.class);
        if (change != null) {
            this.getIpLinkLayer().set(BBacnetIpLinkLayer.ipDeviceType, (BValue)BBacnetIpPortDescriptor.makeDeviceType(change), context);
        }
    }

    private PropertyValue readUdpPort() {
        BBacnetUnsigned pending = this.getPendingChange(UDP_PORT, BBacnetUnsigned.class);
        if (pending != null) {
            if (pending.getInt() < 0 || (long)pending.getInt() > 65535L) {
                return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.bacnetIpUdpPort, BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
            }
            return BacnetDescriptorUtil.makeUnsignedReadResult(BBacnetPropertyIdentifier.bacnetIpUdpPort, pending);
        }
        byte[] mac = this.getIpLinkLayer().getMacAddress();
        if (mac == null || mac.length != 6) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.bacnetIpUdpPort, BBacnetErrorClass.property, BBacnetErrorCode.valueNotInitialized);
        }
        return BacnetDescriptorUtil.makeUnsignedReadResult(BBacnetPropertyIdentifier.bacnetIpUdpPort, BacnetIpLinkUtil.getPortFromBacnetIpBytes(mac));
    }

    private ErrorType writeUdpPort(byte[] value) throws AsnException {
        BBacnetUnsigned udpPort = AsnUtil.fromAsnUnsigned(value);
        if (udpPort.getInt() > 65535) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
        }
        this.addPendingChange(UDP_PORT, (BValue)udpPort, BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    private void validateSetUdpPort(BValue value, Context context) {
        this.checkPendingChangeType(UDP_PORT, value, BBacnetUnsigned.TYPE);
        this.checkCanWrite((BComponent)this.getIpLinkLayer().getUdpServerPort(), (Slot)BBacnetIpServerPort.publicServerPort, context);
    }

    private void validateUdpPort(Context context) throws ValidateChangesException {
        BBacnetUnsigned change = this.getPendingChange(UDP_PORT, BBacnetUnsigned.class);
        if (change != null) {
            int value = change.getInt();
            if (value < 0 || value > 65535) {
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange, BBacnetPropertyIdentifier.bacnetIpUdpPort, "Value " + change.getInt() + " is not a valid Unsigned16");
            }
            this.validateCanWrite((BComponent)this.getIpLinkLayer().getUdpServerPort(), (Slot)BBacnetIpServerPort.publicServerPort, BBacnetPropertyIdentifier.bacnetIpUdpPort, context);
        }
    }

    private void activateUdpPort(Context context) {
        BBacnetUnsigned change = this.getPendingChange(UDP_PORT, BBacnetUnsigned.class);
        if (change != null) {
            this.getIpLinkLayer().getUdpServerPort().setInt(BBacnetIpServerPort.publicServerPort, change.getInt(), context);
        }
    }

    private PropertyValue readBroadcastDistributionTable() {
        try {
            BBacnetListOf table = this.getPendingChange(BBMD_BROADCAST_DISTRIBUTION_TABLE, BBacnetListOf.class);
            if (table == null) {
                table = new BBacnetListOf(BBacnetBdtEntry.TYPE);
                for (BBacnetBdtEntry bdtEntry : this.getBdtEntries()) {
                    table.addListElement((BValue)bdtEntry, null);
                }
            }
            return BacnetDescriptorUtil.makeListOfReadResult(BBacnetPropertyIdentifier.bbmdBroadcastDistributionTable, table);
        }
        catch (ErrorException e) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.bbmdBroadcastDistributionTable, e.getErrorType());
        }
    }

    private List<BBacnetBdtEntry> getBdtEntries() throws ErrorException {
        BBdtEntry[] entries;
        ArrayList<BBacnetBdtEntry> bdtEntries = new ArrayList<BBacnetBdtEntry>();
        BBacnetIpLinkLayer linkLayer = this.getIpLinkLayer();
        if (!linkLayer.getIpDeviceType().equals((Object)BIpDeviceType.bbmd)) {
            return bdtEntries;
        }
        BBroadcastDistributionTable table = linkLayer.getBroadcastDistributionTable();
        for (BBdtEntry entry : entries = (BBdtEntry[])table.getChildren(BBdtEntry.class)) {
            try {
                BBacnetHostNPort bbmdAddress = BBacnetHostNPort.parseBacnetIpAddress(entry.getBacnetIPAddress());
                if (bbmdAddress.getHostAddress().getChoice().equals((Object)BBacnetHostAddressChoice.none)) {
                    throw new ErrorException(new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueNotInitialized));
                }
                byte[] mask = entry.getBdMask();
                BacnetIpLinkUtil.validateAddressLength(mask, 4);
                BBacnetBdtEntry bacnetEntry = new BBacnetBdtEntry();
                bacnetEntry.setBbmdAddress(bbmdAddress);
                bacnetEntry.setBroadcastMask(BBacnetOctetString.make(mask));
                bdtEntries.add(bacnetEntry);
            }
            catch (IllegalArgumentException ex) {
                throw new ErrorException(new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueNotInitialized));
            }
        }
        return bdtEntries;
    }

    private ErrorType writeBroadcastDistributionTable(byte[] value) throws AsnException {
        BBacnetListOf bdtEntries = (BBacnetListOf)AsnUtil.fromAsn(-3, value, (BValue)new BBacnetListOf(BBacnetBdtEntry.TYPE));
        try {
            this.validateBacnetBdtEntries((BBacnetBdtEntry[])bdtEntries.getChildren(BBacnetBdtEntry.class));
        }
        catch (ValidateChangesException e) {
            return e.getError();
        }
        this.addPendingChange(BBMD_BROADCAST_DISTRIBUTION_TABLE, (BValue)bdtEntries, BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    public void validateSetBbmdBroadcastDistributionTable(BValue value, Context context) {
        this.checkPendingChangeType(BBMD_BROADCAST_DISTRIBUTION_TABLE, value, BBacnetListOf.TYPE);
        this.checkCanWrite(this.getIpLinkLayer().getBroadcastDistributionTable(), context);
    }

    private void validateBroadcastDistributionTable(Context context) throws ValidateChangesException {
        BBacnetListOf change = this.getPendingChange(BBMD_BROADCAST_DISTRIBUTION_TABLE, BBacnetListOf.class);
        if (change != null) {
            BBacnetBdtEntry[] bacnetBdtEntries = (BBacnetBdtEntry[])change.getChildren(BBacnetBdtEntry.class);
            if (bacnetBdtEntries.length == 0) {
                return;
            }
            this.validateBacnetBdtEntries(bacnetBdtEntries);
            if (!this.getIpMode().equals((Object)BBacnetIpMode.bbmd)) {
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.invalidValueInThisState, BBacnetPropertyIdentifier.bbmdBroadcastDistributionTable, "Cannot activate a non-empty BDT when the IP mode will not be BBMD");
            }
            byte[] localMac = this.getMacAddress();
            if (localMac == null) {
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueNotInitialized, BBacnetPropertyIdentifier.bbmdBroadcastDistributionTable, "Port's MAC address has not been initialized");
            }
            int localMatches = 0;
            for (BBacnetBdtEntry bacnetBdtEntry : bacnetBdtEntries) {
                byte[] bbmdAddress = bacnetBdtEntry.getBbmdAddress().getBacnetIpAddressBytes();
                if (!Arrays.equals(localMac, bbmdAddress)) continue;
                ++localMatches;
            }
            if (localMatches != 1) {
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.invalidValueInThisState, BBacnetPropertyIdentifier.bbmdBroadcastDistributionTable, "One and only one entry must match the port's MAC address");
            }
            this.validateCanWrite(this.getIpLinkLayer().getBroadcastDistributionTable(), BBacnetPropertyIdentifier.bbmdBroadcastDistributionTable, context);
        }
    }

    private void validateBacnetBdtEntries(BBacnetBdtEntry[] bdtEntries) throws ValidateChangesException {
        for (BBacnetBdtEntry bacnetEntry : bdtEntries) {
            BBacnetHostNPort hostAddress = bacnetEntry.getBbmdAddress();
            BBacnetHostAddressChoice addressChoice = hostAddress.getHostAddress().getChoice();
            if (addressChoice.equals((Object)BBacnetHostAddressChoice.none)) {
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange, BBacnetPropertyIdentifier.bbmdBroadcastDistributionTable, "BACnetHostAddress choice none is not valid");
            }
            if (addressChoice.equals((Object)BBacnetHostAddressChoice.name)) {
                return;
            }
            if (!addressChoice.equals((Object)BBacnetHostAddressChoice.ipAddress)) {
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.optionalFunctionalityNotSupported, BBacnetPropertyIdentifier.bbmdBroadcastDistributionTable, "Unsupported BACnetHostAddress choice: " + (Object)((Object)hostAddress.getHostAddress().getChoice()));
            }
            try {
                BacnetIpLinkUtil.validateAddressLength(hostAddress.getBacnetIpAddressBytes(), 6);
                BacnetIpLinkUtil.validateAddressLength(bacnetEntry.getBroadcastMask().getBytes(), 4);
            }
            catch (IllegalArgumentException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, this + ": Failed to validate address/mask bytes of BDT entry", e);
                }
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange, BBacnetPropertyIdentifier.bbmdBroadcastDistributionTable, e.getMessage());
            }
        }
    }

    private void activateBroadcastDistributionTable() {
        BBacnetListOf change = this.getPendingChange(BBMD_BROADCAST_DISTRIBUTION_TABLE, BBacnetListOf.class);
        if (change != null) {
            byte[] localMac = this.getMacAddress();
            BBroadcastDistributionTable table = this.getIpLinkLayer().getBroadcastDistributionTable();
            table.removeAll(BBroadcastDistributionTable.noValidation);
            for (BBacnetBdtEntry bacnetBdtEntry : (BBacnetBdtEntry[])change.getChildren(BBacnetBdtEntry.class)) {
                byte[] macAddress = bacnetBdtEntry.getBbmdAddress().getBacnetIpAddressBytes();
                BBdtEntry bdtEntry = new BBdtEntry(macAddress, bacnetBdtEntry.getBroadcastMask().getBytes());
                if (Arrays.equals(localMac, macAddress)) {
                    table.add("localDevice", (BValue)bdtEntry, BBroadcastDistributionTable.noValidation);
                    continue;
                }
                table.add(null, (BValue)bdtEntry, BBroadcastDistributionTable.noValidation);
            }
        }
    }

    private PropertyValue readBbmdAcceptForeignDeviceRegistrations() {
        BBoolean pending = this.getPendingChange(BBMD_ACCEPT_FD_REGISTRATIONS, BBoolean.class);
        return BacnetDescriptorUtil.makeBooleanReadResult(BBacnetPropertyIdentifier.bbmdAcceptFdRegistrations, pending != null ? pending.getBoolean() : this.getIpLinkLayer().getAcceptsForeignDeviceRegistrations());
    }

    private ErrorType writeBbmdAcceptForeignDeviceRegistrations(byte[] value) throws AsnException {
        this.addPendingChange(BBMD_ACCEPT_FD_REGISTRATIONS, (BValue)BBoolean.make((boolean)AsnUtil.fromAsnBoolean(value)), BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    public void validateSetBbmdAcceptFdRegistrations(BValue value, Context context) {
        this.checkPendingChangeType(BBMD_ACCEPT_FD_REGISTRATIONS, value, BBoolean.TYPE);
        this.checkCanWrite(this.getIpLinkLayer(), (Slot)BBacnetIpLinkLayer.acceptsForeignDeviceRegistrations, context);
    }

    private void validateBbmdAcceptFdRegistrations(Context context) throws ValidateChangesException {
        BBoolean change = this.getPendingChange(BBMD_ACCEPT_FD_REGISTRATIONS, BBoolean.class);
        if (change != null) {
            this.validateCanWrite(this.getIpLinkLayer(), (Slot)BBacnetIpLinkLayer.acceptsForeignDeviceRegistrations, BBacnetPropertyIdentifier.bbmdAcceptFdRegistrations, context);
        }
    }

    private void activateBbmdAcceptFdRegistrations(Context context) {
        BBoolean change = this.getPendingChange(BBMD_ACCEPT_FD_REGISTRATIONS, BBoolean.class);
        if (change != null) {
            this.getIpLinkLayer().set(BBacnetIpLinkLayer.acceptsForeignDeviceRegistrations, (BValue)change, context);
        }
    }

    private PropertyValue readForeignDeviceTable() {
        BBacnetListOf fdtEntries = new BBacnetListOf(BBacnetFdtEntry.TYPE);
        for (BBacnetFdtEntry fdtEntry : this.getFdtEntries()) {
            fdtEntries.addListElement((BValue)fdtEntry, null);
        }
        return BacnetDescriptorUtil.makeListOfReadResult(BBacnetPropertyIdentifier.bbmdForeignDeviceTable, fdtEntries);
    }

    private List<BBacnetFdtEntry> getFdtEntries() {
        BAbsTime now = BAbsTime.now();
        ArrayList<BBacnetFdtEntry> fdtEntries = new ArrayList<BBacnetFdtEntry>();
        for (BFdtEntry entry : (BFdtEntry[])this.getIpLinkLayer().getForeignDeviceTable().getChildren(BFdtEntry.class)) {
            BBacnetFdtEntry fdtEntry = new BBacnetFdtEntry();
            fdtEntry.setBacnetIpAddress(this.getBacnetIpOctetString(entry));
            int timeToLive = BBacnetIpPortDescriptor.coerceToUnsignedShort(entry.getTimeToLive());
            fdtEntry.setTimeToLive(BBacnetUnsigned.make(timeToLive));
            int remaining = now.delta(entry.getPurgeTime()).getSeconds();
            remaining = BBacnetIpPortDescriptor.coerceToUnsignedShort(remaining);
            fdtEntry.setRemainingTimeToLive(BBacnetUnsigned.make(remaining));
            fdtEntries.add(fdtEntry);
        }
        return fdtEntries;
    }

    private BBacnetOctetString getBacnetIpOctetString(BFdtEntry entry) {
        block4: {
            try {
                byte[] addressBytes = entry.getBIpAddr();
                if (addressBytes != null) {
                    return BBacnetOctetString.make(addressBytes);
                }
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(this + ": could not map FdtEntry to BacnetFdtEntry with address " + entry.getBacnetIPAddress());
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.INFO)) break block4;
                logger.log(Level.INFO, this + ": could not map FdtEntry to BacnetFdtEntry with address " + entry.getBacnetIPAddress() + "; error: " + e, logger.isLoggable(Level.FINE) ? e : null);
            }
        }
        return BacnetIpLinkUtil.EMPTY_BACNET_IP_OCTET_STRING;
    }

    private static int coerceToUnsignedShort(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 65535) {
            return 65535;
        }
        return value;
    }

    private PropertyValue readForeignDeviceBbmdAddress() {
        BBacnetHostNPort address = this.getPendingChange(FD_BBMD_ADDRESS, BBacnetHostNPort.class);
        if (address == null) {
            BForeignDeviceRegistration[] registrations = (BForeignDeviceRegistration[])this.getIpLinkLayer().getChildren(BForeignDeviceRegistration.class);
            String addressStr = registrations.length > 0 ? registrations[0].getBbmdAddress() : this.getIpLinkLayer().getBbmdAddress();
            byte[] addressBytes = BacnetIpLinkUtil.getBacnetIpBytes(addressStr);
            if (addressBytes == null || addressBytes.length != 6) {
                return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.fdBbmdAddress, BBacnetErrorClass.property, BBacnetErrorCode.valueNotInitialized);
            }
            address = BBacnetHostNPort.makeWithBacnetIpBytes(addressBytes);
        }
        return BacnetDescriptorUtil.makeConstructedReadResult(BBacnetPropertyIdentifier.fdBbmdAddress, (BValue)address);
    }

    private ErrorType writeForeignDeviceBbmdAddress(byte[] value) throws AsnException {
        BBacnetHostNPort hostNPort = (BBacnetHostNPort)AsnUtil.fromAsn(-1, value, (BValue)new BBacnetHostNPort());
        try {
            this.validateFdBbmdAddress(hostNPort.getHostAddress());
        }
        catch (ValidateChangesException e) {
            return e.getError();
        }
        this.addPendingChange(FD_BBMD_ADDRESS, (BValue)hostNPort, BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    public void validateSetFdBbmdAddress(BValue value, Context context) {
        this.checkPendingChangeType(FD_BBMD_ADDRESS, value, BBacnetHostNPort.TYPE);
        this.checkCanWrite(this.getIpLinkLayer(), (Slot)BBacnetIpLinkLayer.bbmdAddress, context);
    }

    private void validateFdBbmdAddress(Context context) throws ValidateChangesException {
        BBacnetHostNPort change = this.getPendingChange(FD_BBMD_ADDRESS, BBacnetHostNPort.class);
        if (change != null) {
            this.validateFdBbmdAddress(change.getHostAddress());
            if (this.getIpMode().equals((Object)BBacnetIpMode.foreign) && !change.getHostAddress().getChoice().equals((Object)BBacnetHostAddressChoice.ipAddress)) {
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange, BBacnetPropertyIdentifier.fdBbmdAddress, "When IP Mode is Foreign, BACnetHostAddress choice must be IP");
            }
            this.validateCanWrite(this.getIpLinkLayer(), (Slot)BBacnetIpLinkLayer.bbmdAddress, BBacnetPropertyIdentifier.fdBbmdAddress, context);
        }
    }

    private void validateFdBbmdAddress(BBacnetHostAddress hostAddress) throws ValidateChangesException {
        if (hostAddress.getChoice().equals((Object)BBacnetHostAddressChoice.ipAddress)) {
            try {
                BacnetIpLinkUtil.validateAddressLength(hostAddress.getIpAddress().getAddr(), 4);
            }
            catch (IllegalArgumentException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this + ": failed to validate foreign device BBMD address bytes: " + (Object)((Object)hostAddress.getIpAddress()));
                }
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange, BBacnetPropertyIdentifier.fdBbmdAddress, "Invalid BACnetHostAddress IP address");
            }
        } else if (!hostAddress.getChoice().equals((Object)BBacnetHostAddressChoice.none)) {
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.optionalFunctionalityNotSupported, BBacnetPropertyIdentifier.fdBbmdAddress, "Unsupported BACnetHostAddress choice: " + (Object)((Object)hostAddress.getChoice()));
        }
    }

    private void activateFdBbmdAddress(Context context) {
        BBacnetHostNPort change = this.getPendingChange(FD_BBMD_ADDRESS, BBacnetHostNPort.class);
        if (change != null) {
            BBacnetIpLinkLayer ipLinkLayer;
            BForeignDeviceRegistration[] registrations;
            String bbmdAddress = "null";
            BBacnetHostAddress hostAddress = change.getHostAddress();
            if (hostAddress.getChoice().equals((Object)BBacnetHostAddressChoice.ipAddress)) {
                BBacnetOctetString ipAddress = hostAddress.getIpAddress();
                bbmdAddress = BBacnetIpPortDescriptor.makeAddressStr(ipAddress.getBytes()) + ':' + change.getPort();
            }
            if ((registrations = (BForeignDeviceRegistration[])(ipLinkLayer = this.getIpLinkLayer()).getChildren(BForeignDeviceRegistration.class)).length > 0) {
                registrations[0].setString(BForeignDeviceRegistration.bbmdAddress, bbmdAddress, context);
            }
            ipLinkLayer.setString(BBacnetIpLinkLayer.bbmdAddress, bbmdAddress, context);
        }
    }

    private PropertyValue readForeignDeviceSubscriptionLifetime() {
        int lifetime;
        BBacnetUnsigned pending = this.getPendingChange(FD_SUBSCRIPTION_LIFETIME, BBacnetUnsigned.class);
        if (pending != null) {
            lifetime = pending.getInt();
        } else {
            BForeignDeviceRegistration[] registrations = (BForeignDeviceRegistration[])this.getIpLinkLayer().getChildren(BForeignDeviceRegistration.class);
            lifetime = registrations.length > 0 ? registrations[0].getRegistrationLifetime().getSeconds() : this.getIpLinkLayer().getRegistrationLifetime().getSeconds();
            if (lifetime < 0 || lifetime > 65535) {
                return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.fdSubscriptionLifetime, BBacnetErrorClass.property, BBacnetErrorCode.valueNotInitialized);
            }
        }
        return BacnetDescriptorUtil.makeUnsignedReadResult(BBacnetPropertyIdentifier.fdSubscriptionLifetime, lifetime);
    }

    private ErrorType writeForeignDeviceSubscriptionLifetime(byte[] value) throws AsnException {
        BBacnetUnsigned unsigned = AsnUtil.fromAsnUnsigned(value);
        if ((long)unsigned.getInt() > 65535L) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange);
        }
        this.addPendingChange(FD_SUBSCRIPTION_LIFETIME, (BValue)unsigned, BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    public void validateSetFdSubscriptionLifetime(BValue value, Context context) {
        this.checkPendingChangeType(FD_SUBSCRIPTION_LIFETIME, value, BBacnetUnsigned.TYPE);
        this.checkCanWrite(this.getIpLinkLayer(), (Slot)BBacnetIpLinkLayer.registrationLifetime, context);
    }

    private void validateFdSubscriptionLifetime(Context context) throws ValidateChangesException {
        BBacnetUnsigned change = this.getPendingChange(FD_SUBSCRIPTION_LIFETIME, BBacnetUnsigned.class);
        if (change != null) {
            int value = change.getInt();
            if (value < 0 || (long)value > 65535L) {
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange, BBacnetPropertyIdentifier.fdSubscriptionLifetime, "Value " + change.getInt() + " is not a valid Unsigned16");
            }
            this.validateCanWrite(this.getIpLinkLayer(), (Slot)BBacnetIpLinkLayer.registrationLifetime, BBacnetPropertyIdentifier.fdSubscriptionLifetime, context);
        }
    }

    private void activateFdSubscriptionLifetime(Context context) {
        BBacnetUnsigned change = this.getPendingChange(FD_SUBSCRIPTION_LIFETIME, BBacnetUnsigned.class);
        if (change != null) {
            BRelTime lifetime = BRelTime.makeSeconds((int)change.getInt());
            BBacnetIpLinkLayer ipLinkLayer = this.getIpLinkLayer();
            BForeignDeviceRegistration[] registrations = (BForeignDeviceRegistration[])ipLinkLayer.getChildren(BForeignDeviceRegistration.class);
            if (registrations.length > 0) {
                registrations[0].set(BForeignDeviceRegistration.registrationLifetime, (BValue)lifetime, context);
            }
            ipLinkLayer.set(BBacnetIpLinkLayer.registrationLifetime, (BValue)lifetime, context);
        }
    }

    private PropertyValue readIpAddress() {
        BBacnetOctetString pending = this.getPendingChange(IP_ADDRESS, BBacnetOctetString.class);
        if (pending != null) {
            return BacnetDescriptorUtil.makeOctetStringReadResult(BBacnetPropertyIdentifier.ipAddress, pending);
        }
        byte[] mac = this.getIpLinkLayer().getMacAddress();
        if (mac == null || mac.length != 6) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.ipAddress, BBacnetErrorClass.property, BBacnetErrorCode.valueNotInitialized);
        }
        return BacnetDescriptorUtil.makeOctetStringReadResult(BBacnetPropertyIdentifier.ipAddress, Arrays.copyOf(mac, 4));
    }

    private ErrorType writeIpAddress(byte[] value) throws AsnException {
        BBacnetOctetString octetString = AsnUtil.fromAsnOctetString(value);
        try {
            BBacnetIpPortDescriptor.validateAddress(octetString, BBacnetPropertyIdentifier.ipAddress);
        }
        catch (ValidateChangesException e) {
            return e.getError();
        }
        try {
            this.addPendingChange(IP_ADDRESS, (BValue)octetString, BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (Exception e) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
        }
    }

    public void validateSetIpAddress(BValue value, Context context) {
        this.checkPendingChangeType(IP_ADDRESS, value, BBacnetOctetString.TYPE);
        BTcpIpAdapterSettings adapterSettings = this.findAdapterSettings();
        BBacnetIpPortDescriptor.checkCanSaveAdapterSettings(adapterSettings, context);
        this.checkCanWrite((BComponent)adapterSettings, (Slot)BTcpIpAdapterSettings.ipAddress, context);
        BBacnetIpPortDescriptor.checkCanWriteAdapterSettings(adapterSettings);
    }

    private void validateIpAddress(BTcpIpAdapterSettings adapterSettings, Context context) throws ValidateChangesException {
        BBacnetOctetString change = this.getPendingChange(IP_ADDRESS, BBacnetOctetString.class);
        if (change != null) {
            BBacnetIpPortDescriptor.validateAddress(change, BBacnetPropertyIdentifier.ipAddress);
            this.validateCanWrite((BComponent)adapterSettings, (Slot)BTcpIpAdapterSettings.ipAddress, BBacnetPropertyIdentifier.ipAddress, context);
            this.validateCanWriteAdapterSettings(adapterSettings, BBacnetPropertyIdentifier.ipAddress);
            this.checkDhcpDisabled(BBacnetPropertyIdentifier.ipAddress);
        }
    }

    private void activateIpAddress(BTcpIpAdapterSettings adapterSettings, Context context) {
        BBacnetOctetString change = this.getPendingChange(IP_ADDRESS, BBacnetOctetString.class);
        if (change != null) {
            adapterSettings.setString(BTcpIpAdapterSettings.ipAddress, BBacnetIpPortDescriptor.makeAddressStr(change.getBytes()), context);
        }
    }

    private PropertyValue readSubnetMask() {
        BBacnetOctetString pending = this.getPendingChange(SUBNET_MASK, BBacnetOctetString.class);
        if (pending != null) {
            return BacnetDescriptorUtil.makeOctetStringReadResult(BBacnetPropertyIdentifier.ipSubnetMask, pending);
        }
        short networkPrefix = this.getIpLinkLayer().getNetworkPrefixLength();
        if (networkPrefix < 0 || networkPrefix > 32) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.ipSubnetMask, BBacnetErrorClass.property, BBacnetErrorCode.valueNotInitialized);
        }
        int netmask = BacnetIpLinkUtil.convertNetmask(networkPrefix);
        byte[] subnetMask = BacnetIpLinkUtil.convertIntToAddress(netmask);
        return BacnetDescriptorUtil.makeOctetStringReadResult(BBacnetPropertyIdentifier.ipSubnetMask, subnetMask);
    }

    private ErrorType writeSubnetMask(byte[] value) throws AsnException {
        BBacnetOctetString octetString = AsnUtil.fromAsnOctetString(value);
        try {
            BBacnetIpPortDescriptor.validateAddress(octetString, BBacnetPropertyIdentifier.ipSubnetMask);
        }
        catch (ValidateChangesException e) {
            return e.getError();
        }
        try {
            this.addPendingChange(SUBNET_MASK, (BValue)octetString, BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (Exception e) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
        }
    }

    public void validateSetSubnetMask(BValue value, Context context) {
        this.checkPendingChangeType(SUBNET_MASK, value, BBacnetOctetString.TYPE);
        BTcpIpAdapterSettings adapterSettings = this.findAdapterSettings();
        BBacnetIpPortDescriptor.checkCanSaveAdapterSettings(adapterSettings, context);
        this.checkCanWrite((BComponent)adapterSettings, (Slot)BTcpIpAdapterSettings.subnetMask, context);
        BBacnetIpPortDescriptor.checkCanWriteAdapterSettings(adapterSettings);
    }

    private void validateSubnetMask(BTcpIpAdapterSettings adapterSettings, Context context) throws ValidateChangesException {
        BBacnetOctetString change = this.getPendingChange(SUBNET_MASK, BBacnetOctetString.class);
        if (change != null) {
            BBacnetIpPortDescriptor.validateAddress(change, BBacnetPropertyIdentifier.ipSubnetMask);
            this.validateCanWrite((BComponent)adapterSettings, (Slot)BTcpIpAdapterSettings.subnetMask, BBacnetPropertyIdentifier.ipSubnetMask, context);
            this.validateCanWriteAdapterSettings(adapterSettings, BBacnetPropertyIdentifier.ipSubnetMask);
            this.checkDhcpDisabled(BBacnetPropertyIdentifier.ipSubnetMask);
        }
    }

    private void activateSubnetMask(BTcpIpAdapterSettings adapterSettings, Context context) {
        BBacnetOctetString change = this.getPendingChange(SUBNET_MASK, BBacnetOctetString.class);
        if (change != null) {
            adapterSettings.setString(BTcpIpAdapterSettings.subnetMask, BBacnetIpPortDescriptor.makeAddressStr(change.getBytes()), context);
        }
    }

    private PropertyValue readDefaultGateway() {
        BBacnetOctetString defaultGateway = this.getPendingChange(DEFAULT_GATEWAY, BBacnetOctetString.class);
        if (defaultGateway == null && (defaultGateway = this.getAdapterDefaultGateway()) == null) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.ipDefaultGateway, BBacnetErrorClass.property, BBacnetErrorCode.other);
        }
        return BacnetDescriptorUtil.makeOctetStringReadResult(BBacnetPropertyIdentifier.ipDefaultGateway, defaultGateway);
    }

    private BBacnetOctetString getAdapterDefaultGateway() {
        BTcpIpAdapterSettings adapterSettings = this.findAdapterSettings();
        if (adapterSettings == null) {
            return null;
        }
        String defaultGateway = adapterSettings.getUsesAdapterLevelSettings() ? adapterSettings.getDefaultGateway().trim() : adapterSettings.getHostSettings().getDefaultGateway().trim();
        return defaultGateway.isEmpty() ? BBacnetOctetString.make(EMPTY_BYTE_ARRAY) : BBacnetOctetString.make(BacnetIpLinkUtil.parseIpBytes(defaultGateway));
    }

    private ErrorType writeDefaultGateway(byte[] value) throws AsnException {
        BBacnetOctetString octetString = AsnUtil.fromAsnOctetString(value);
        int length = octetString.getBytes().length;
        if (length != 0 && length != 4) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.invalidDataEncoding);
        }
        try {
            this.addPendingChange(DEFAULT_GATEWAY, (BValue)octetString, BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (Exception e) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
        }
    }

    private void validateSetDefaultGateway(BValue value, Context context) {
        this.checkPendingChangeType(DEFAULT_GATEWAY, value, BBacnetOctetString.TYPE);
        BTcpIpAdapterSettings adapterSettings = this.findAdapterSettings();
        BBacnetIpPortDescriptor.checkCanSaveAdapterSettings(adapterSettings, context);
        if (adapterSettings.getUsesAdapterLevelSettings()) {
            this.checkCanWrite((BComponent)adapterSettings, (Slot)BTcpIpAdapterSettings.defaultGateway, context);
            BBacnetIpPortDescriptor.checkCanWriteAdapterSettings(adapterSettings);
        } else {
            this.checkCanWrite((BComponent)adapterSettings.getHostSettings(), (Slot)BTcpIpHostSettings.defaultGateway, context);
            BBacnetIpPortDescriptor.checkCanWriteHostSettings(adapterSettings);
        }
    }

    private void validateDefaultGateway(BTcpIpAdapterSettings adapterSettings, Context context) throws ValidateChangesException {
        BBacnetOctetString change = this.getPendingChange(DEFAULT_GATEWAY, BBacnetOctetString.class);
        if (change != null) {
            int length = change.getBytes().length;
            if (length != 0 && length != 4) {
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.invalidDataEncoding, BBacnetPropertyIdentifier.ipDefaultGateway, "Octet string length is " + length + " instead of 0 or 4");
            }
            if (adapterSettings.getUsesAdapterLevelSettings()) {
                this.validateCanWrite((BComponent)adapterSettings, (Slot)BTcpIpAdapterSettings.defaultGateway, BBacnetPropertyIdentifier.ipDefaultGateway, context);
                this.validateCanWriteAdapterSettings(adapterSettings, BBacnetPropertyIdentifier.ipDefaultGateway);
            } else {
                this.validateCanWrite((BComponent)adapterSettings.getHostSettings(), (Slot)BTcpIpHostSettings.defaultGateway, BBacnetPropertyIdentifier.ipDefaultGateway, context);
                this.validateCanWriteHostSettings(adapterSettings, BBacnetPropertyIdentifier.ipDefaultGateway);
            }
            this.checkDhcpDisabled(BBacnetPropertyIdentifier.ipDefaultGateway);
        }
    }

    private void activateDefaultGateway(BTcpIpAdapterSettings adapterSettings, Context context) {
        BBacnetOctetString change = this.getPendingChange(DEFAULT_GATEWAY, BBacnetOctetString.class);
        if (change != null) {
            String changeStr;
            byte[] bytes = change.getBytes();
            String string = changeStr = bytes.length == 0 ? "" : BBacnetIpPortDescriptor.makeAddressStr(bytes);
            if (adapterSettings.getUsesAdapterLevelSettings()) {
                adapterSettings.setString(BTcpIpAdapterSettings.defaultGateway, changeStr, context);
            } else {
                adapterSettings.getHostSettings().setString(BTcpIpHostSettings.defaultGateway, changeStr, context);
            }
        }
    }

    private PropertyValue readDnsServer(int index) {
        BBacnetArray dnsServer = this.getDnsServer();
        if (dnsServer == null) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.ipDnsServer, index, BBacnetErrorClass.property, BBacnetErrorCode.other);
        }
        return BacnetDescriptorUtil.readArray(406, index, dnsServer);
    }

    private BBacnetArray getDnsServer() {
        BBacnetArray dnsServer = this.getPendingChange(DNS_SERVER, BBacnetArray.class);
        if (dnsServer == null) {
            dnsServer = this.getAdapterDnsServer();
        }
        if (dnsServer != null && dnsServer.getSize() <= 0) {
            dnsServer.addElement((BValue)BBacnetOctetString.make(new byte[4]));
        }
        return dnsServer;
    }

    private BBacnetArray getAdapterDnsServer() {
        BTcpIpAdapterSettings adapterSettings = this.findAdapterSettings();
        if (adapterSettings == null) {
            return null;
        }
        BVector dnsHosts = adapterSettings.getUsesAdapterLevelSettings() ? adapterSettings.getDnsHosts() : adapterSettings.getHostSettings().getDnsHosts();
        BBacnetArray dnsServer = new BBacnetArray(BBacnetOctetString.TYPE);
        for (BString dnsHost : (BString[])dnsHosts.getChildren(BString.class)) {
            byte[] dnsAddress = BacnetIpLinkUtil.parseIpBytes(dnsHost.getString().trim());
            if (dnsAddress == null || dnsAddress.length != 4) {
                dnsAddress = new byte[4];
            }
            dnsServer.addElement((BValue)BBacnetOctetString.make(dnsAddress));
        }
        return dnsServer;
    }

    private ErrorType writeDnsServer(int index, byte[] value) throws AsnException {
        BBacnetArray dnsServer = this.getDnsServer();
        if (dnsServer == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info(this + ": could not find DNS server setting when attempt to write pending change to it");
            }
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
        }
        if (index == 0) {
            int newSize = AsnUtil.fromAsnUnsignedInt(value);
            dnsServer.setSize(newSize);
            for (int i = 1; i <= newSize; ++i) {
                BBacnetOctetString element = (BBacnetOctetString)dnsServer.getElement(i);
                if (element == null) {
                    dnsServer.add("element" + i, (BValue)BBacnetOctetString.make(new byte[4]));
                    continue;
                }
                if (!element.isNull()) continue;
                dnsServer.setElement(i, (BValue)BBacnetOctetString.make(new byte[4]));
            }
        } else if (index == -1) {
            dnsServer = (BBacnetArray)AsnUtil.fromAsn(-2, value, (BValue)new BBacnetArray(BBacnetOctetString.TYPE));
        } else {
            if (index > dnsServer.getSize()) {
                return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.invalidArrayIndex);
            }
            BBacnetOctetString dnsHost = AsnUtil.fromAsnOctetString(value);
            if (dnsHost.length() != 4) {
                return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.invalidDataEncoding);
            }
            dnsServer.setElement(index, (BValue)dnsHost);
        }
        try {
            this.addPendingChange(DNS_SERVER, (BValue)dnsServer, BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (Exception e) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
        }
    }

    private void validateSetDnsServer(BValue value, Context context) {
        this.checkPendingChangeType(DNS_SERVER, value, BBacnetArray.TYPE);
        BTcpIpAdapterSettings adapterSettings = this.findAdapterSettings();
        BBacnetIpPortDescriptor.checkCanSaveAdapterSettings(adapterSettings, context);
        if (adapterSettings.getUsesAdapterLevelSettings()) {
            this.checkCanWrite((BComponent)adapterSettings, (Slot)BTcpIpAdapterSettings.dnsHosts, context);
            BBacnetIpPortDescriptor.checkCanWriteAdapterSettings(adapterSettings);
        } else {
            this.checkCanWrite((BComponent)adapterSettings.getHostSettings(), (Slot)BTcpIpAdapterSettings.dnsHosts, context);
            BBacnetIpPortDescriptor.checkCanWriteHostSettings(adapterSettings);
        }
    }

    private void validateDnsServer(BTcpIpAdapterSettings adapterSettings, Context context) throws ValidateChangesException {
        BBacnetArray change = this.getPendingChange(DNS_SERVER, BBacnetArray.class);
        if (change != null) {
            try {
                for (BBacnetOctetString dnsAddress : (BBacnetOctetString[])change.getChildren(BBacnetOctetString.class)) {
                    BacnetIpLinkUtil.validateAddressLength(dnsAddress.getBytes(), 4);
                }
            }
            catch (IllegalArgumentException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this + ": failed to validate dnsAddress element in DNS server array: " + change);
                }
                throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.invalidDataEncoding, BBacnetPropertyIdentifier.ipDnsServer, e.getMessage());
            }
            if (adapterSettings.getUsesAdapterLevelSettings()) {
                this.validateCanWrite((BComponent)adapterSettings, (Slot)BTcpIpAdapterSettings.dnsHosts, BBacnetPropertyIdentifier.ipDnsServer, context);
                this.validateCanWriteAdapterSettings(adapterSettings, BBacnetPropertyIdentifier.ipDnsServer);
            } else {
                this.validateCanWrite((BComponent)adapterSettings.getHostSettings(), (Slot)BTcpIpHostSettings.dnsHosts, BBacnetPropertyIdentifier.ipDnsServer, context);
                this.validateCanWriteHostSettings(adapterSettings, BBacnetPropertyIdentifier.ipDnsServer);
            }
        }
    }

    private void activateDnsServer(BTcpIpAdapterSettings adapterSettings, Context context) {
        BBacnetArray change = this.getPendingChange(DNS_SERVER, BBacnetArray.class);
        if (change != null) {
            BVector dsnHosts = new BVector();
            for (BBacnetOctetString dnsAddress : (BBacnetOctetString[])change.getChildren(BBacnetOctetString.class)) {
                dsnHosts.add(null, (BValue)BString.make((String)BBacnetIpPortDescriptor.makeAddressStr(dnsAddress.getBytes())));
            }
            if (adapterSettings.getUsesAdapterLevelSettings()) {
                adapterSettings.set(BTcpIpAdapterSettings.dnsHosts, (BValue)dsnHosts, context);
            } else {
                adapterSettings.getHostSettings().set(BTcpIpHostSettings.dnsHosts, (BValue)dsnHosts, context);
            }
        }
    }

    private PropertyValue readDhcpEnable() {
        BBoolean pending = this.getPendingChange(DHCP_ENABLE, BBoolean.class);
        if (pending != null) {
            return BacnetDescriptorUtil.makeBooleanReadResult(BBacnetPropertyIdentifier.ipDhcpEnable, pending.getBoolean());
        }
        BTcpIpAdapterSettings adapterSettings = this.findAdapterSettings();
        if (adapterSettings != null) {
            return BacnetDescriptorUtil.makeBooleanReadResult(BBacnetPropertyIdentifier.ipDhcpEnable, adapterSettings.getIsDhcpEnabled());
        }
        return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.ipDhcpEnable, BBacnetErrorClass.property, BBacnetErrorCode.other);
    }

    private boolean getDhcpEnable() {
        BBoolean pending = this.getPendingChange(DHCP_ENABLE, BBoolean.class);
        if (pending != null) {
            return pending.getBoolean();
        }
        BTcpIpAdapterSettings adapterSettings = this.findAdapterSettings();
        return adapterSettings != null && adapterSettings.getIsDhcpEnabled();
    }

    private ErrorType writeDhcpEnable(byte[] value) throws AsnException {
        boolean dhcpEnable = AsnUtil.fromAsnBoolean(value);
        try {
            this.addPendingChange(DHCP_ENABLE, (BValue)BBoolean.make((boolean)dhcpEnable), BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (Exception e) {
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
        }
    }

    public void validateSetDhcpEnable(BValue value, Context context) {
        this.checkPendingChangeType(DHCP_ENABLE, value, BBoolean.TYPE);
        BTcpIpAdapterSettings adapterSettings = this.findAdapterSettings();
        BBacnetIpPortDescriptor.checkCanSaveAdapterSettings(adapterSettings, context);
        this.checkCanWrite((BComponent)adapterSettings, (Slot)BTcpIpAdapterSettings.isDhcpEnabled, context);
        BBacnetIpPortDescriptor.checkCanWriteAdapterSettings(adapterSettings);
    }

    private void validateDhcpEnable(BTcpIpAdapterSettings adapterSettings, Context context) throws ValidateChangesException {
        BBoolean change = this.getPendingChange(DHCP_ENABLE, BBoolean.class);
        if (change != null) {
            this.validateCanWrite((BComponent)adapterSettings, (Slot)BTcpIpAdapterSettings.isDhcpEnabled, BBacnetPropertyIdentifier.ipDhcpEnable, context);
            this.validateCanWriteAdapterSettings(adapterSettings, BBacnetPropertyIdentifier.ipDhcpEnable);
        }
    }

    private void activateDhcpEnable(BTcpIpAdapterSettings adapterSettings, Context context) {
        BBoolean change = this.getPendingChange(DHCP_ENABLE, BBoolean.class);
        if (change != null) {
            adapterSettings.setBoolean(BTcpIpAdapterSettings.isDhcpEnabled, change.getBoolean(), context);
        }
    }

    private PropertyValue readDhcpLeaseTime() {
        long leaseTime;
        block5: {
            leaseTime = 0L;
            try {
                if (this.getPendingChange(DHCP_ENABLE, BBoolean.class) == null) {
                    String leastGrantedStr;
                    BTcpIpAdapterSettings adapterSettings = this.findAdapterSettings();
                    if (adapterSettings == null) {
                        return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.ipDhcpLeaseTime, BBacnetErrorClass.property, BBacnetErrorCode.other);
                    }
                    if (adapterSettings.getIsDhcpEnabled() && !(leastGrantedStr = adapterSettings.getDhcpLeaseGranted().trim()).isEmpty()) {
                        LocalDateTime leaseGranted = BBacnetIpPortDescriptor.parseDateTime(leastGrantedStr);
                        leaseTime = Math.max(0L, leaseGranted.until(LocalDateTime.now(), ChronoUnit.SECONDS));
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block5;
                logger.log(Level.FINE, this + "Unable to parse the dhcpLeaseGranted", e);
            }
        }
        return BacnetDescriptorUtil.makeUnsignedReadResult(BBacnetPropertyIdentifier.ipDhcpLeaseTime, leaseTime);
    }

    private PropertyValue readDhcpLeaseTimeRemaining() {
        long timeRemaining;
        block5: {
            timeRemaining = 0L;
            try {
                if (this.getPendingChange(DHCP_ENABLE, BBoolean.class) == null) {
                    String leaseExpiresStr;
                    BTcpIpAdapterSettings adapterSettings = this.findAdapterSettings();
                    if (adapterSettings == null) {
                        return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.ipDhcpLeaseTimeRemaining, BBacnetErrorClass.property, BBacnetErrorCode.other);
                    }
                    if (adapterSettings.getIsDhcpEnabled() && !(leaseExpiresStr = adapterSettings.getDhcpLeaseExpires().trim()).isEmpty()) {
                        LocalDateTime leaseExpires = BBacnetIpPortDescriptor.parseDateTime(leaseExpiresStr);
                        timeRemaining = Math.max(0L, LocalDateTime.now().until(leaseExpires, ChronoUnit.SECONDS));
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block5;
                logger.log(Level.FINE, this + "Unable to parse the dhcpLeaseExpires", e);
            }
        }
        return BacnetDescriptorUtil.makeUnsignedReadResult(BBacnetPropertyIdentifier.ipDhcpLeaseTimeRemaining, timeRemaining);
    }

    private static LocalDateTime parseDateTime(String dateTimeStr) {
        return LocalDateTime.parse(dateTimeStr, DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss yyyy"));
    }

    private PropertyValue readDhcpServer() {
        BTcpIpAdapterSettings adapterSettings = this.findAdapterSettings();
        if (adapterSettings == null) {
            return BacnetDescriptorUtil.makeReadError(BBacnetPropertyIdentifier.ipDhcpServer, BBacnetErrorClass.property, BBacnetErrorCode.other);
        }
        byte[] dhcpAddress = BacnetIpLinkUtil.parseIpBytes(adapterSettings.getDhcpHost());
        if (dhcpAddress == null || dhcpAddress.length != 4) {
            return BacnetDescriptorUtil.makeOctetStringReadResult(BBacnetPropertyIdentifier.ipDhcpServer, new byte[4]);
        }
        return BacnetDescriptorUtil.makeOctetStringReadResult(BBacnetPropertyIdentifier.ipDhcpServer, dhcpAddress);
    }

    private PropertyValue readNetworkInterfaceName() {
        return BacnetDescriptorUtil.makeCharStringReadResult(BBacnetPropertyIdentifier.networkInterfaceName, SlotPath.unescape((String)this.getIpLinkLayer().getAdapter().getTag()));
    }

    private BBacnetIpLinkLayer getIpLinkLayer() {
        return (BBacnetIpLinkLayer)this.networkPort.getLink();
    }

    private static BTcpIpPlatformService getTcpIpService() {
        try {
            return (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to resolve BacnetTcpIpPlatformService", logger.isLoggable(Level.FINE) ? e : null);
            return null;
        }
    }

    private BTcpIpAdapterSettings findAdapterSettings() {
        BTcpIpAdapterSettings[] allAdapterSettings;
        BTcpIpPlatformService platformService = BBacnetIpPortDescriptor.getTcpIpService();
        if (platformService == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this + ": could not find TCP/IP platform service");
            }
            return null;
        }
        platformService.checkPropertiesLoaded();
        String adapterOsName = SlotPath.unescape((String)this.getIpLinkLayer().getAdapterId().getTag());
        String adapterId = this.getAdapterIdFromOsName(adapterOsName);
        BTcpIpHostSettings hostSettings = platformService.getSettings();
        for (BTcpIpAdapterSettings adapterSettings : allAdapterSettings = (BTcpIpAdapterSettings[])hostSettings.getAdapters().getChildren(BTcpIpAdapterSettings.class)) {
            if (!adapterSettings.getIsAdapterEnabled() || !adapterSettings.getAdapterId().equals(adapterId)) continue;
            return adapterSettings;
        }
        if (logger.isLoggable(Level.FINE)) {
            StringJoiner adapterInfo = new StringJoiner(",");
            for (BTcpIpAdapterSettings adapterSettings : allAdapterSettings) {
                adapterInfo.add("adapterId: " + adapterSettings.getAdapterId() + ", isEnabled? " + adapterSettings.getIsAdapterEnabled());
            }
            logger.fine(this + ": could not find TCP/IP adapter settings; port adapter OS name: " + adapterOsName + ", port adapter ID: " + adapterId + ", available adapters: {" + adapterInfo + "}");
        }
        return null;
    }

    private String getAdapterIdFromOsName(String adapterOsName) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this + ": converting adapter OS name to platform service ID; OS name: " + adapterOsName + ", isTridiumQnx? " + this.IS_TRIDIUM_QNX + ", isTridiumPlatform? " + PlatformUtil.isTridiumPlatform() + ", isQnx? " + OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx));
        }
        if (this.IS_TRIDIUM_QNX && adapterOsName.startsWith("dm")) {
            return ("en" + adapterOsName.substring(2)).trim();
        }
        return adapterOsName;
    }

    private static void validateAddress(BBacnetOctetString octetString, BBacnetPropertyIdentifier propertyId) throws ValidateChangesException {
        try {
            BacnetIpLinkUtil.validateAddressLength(octetString.getBytes(), 4);
        }
        catch (IllegalArgumentException e) {
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.invalidDataEncoding, propertyId, e.getMessage());
        }
    }

    private void checkDhcpDisabled(BBacnetPropertyIdentifier propertyId) throws ValidateChangesException {
        if (this.getDhcpEnable()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": attempted to write " + propertyId + " when DHCP Enable is true");
            }
            throw new ValidateChangesException(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied, propertyId, "Unable to write " + propertyId + " when DHCP Enable is true");
        }
    }

    private static BIpDeviceType makeDeviceType(BBacnetIpMode ipMode) {
        switch (ipMode.getOrdinal()) {
            case 0: {
                return BIpDeviceType.standard;
            }
            case 1: {
                return BIpDeviceType.foreignDevice;
            }
        }
        return BIpDeviceType.bbmd;
    }
}

