/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetAnalogValueDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"control:NumericPoint"})})
@NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.INTEGER_VALUE)", flags=64, override=true)
public class BBacnetIntegerValueDescriptor
extends BBacnetAnalogValueDescriptor {
    @Generated
    public static final Property objectId = BBacnetIntegerValueDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(45), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetIntegerValueDescriptor.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public byte[] convertToAsn(double value) {
        return AsnUtil.toAsnInteger((int)value);
    }

    @Override
    public byte[] convertToAsn(BValue value) {
        return AsnUtil.toAsnInteger(((BNumber)value).getInt());
    }

    @Override
    public double convertFromAsn(byte[] value) throws AsnException {
        return AsnUtil.fromAsnSignedInteger(value);
    }

    @Override
    protected void addRequiredProps(Vector v) {
        v.add(BBacnetPropertyIdentifier.presentValue);
        v.add(BBacnetPropertyIdentifier.statusFlags);
        v.add(BBacnetPropertyIdentifier.units);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        this.addValueObjectOptionalProps(v);
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        switch (pId) {
            case 22: {
                return new NReadPropertyResult(pId, AsnUtil.toAsnUnsigned((int)this.getCovIncrement()));
            }
        }
        return super.readProperty(pId, ndx);
    }

    @Override
    public double getDeadBandValue(byte[] value) throws AsnException {
        return AsnUtil.fromAsnUnsignedInteger(value);
    }

    @Override
    public byte[] getDeadBandBytes(double value) {
        return AsnUtil.toAsnUnsigned((long)value);
    }

    @Override
    protected double getCovIncrement(byte[] value) throws AsnException {
        return AsnUtil.fromAsnUnsignedInteger(value);
    }
}

