/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.server.BBacnetExportFolder;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.server.BEventHandler;
import com.tridium.bacnet.stack.server.BHashedEventBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.alarm.ext.offnormal.BOutOfRangeAlgorithm;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.alarm.BBacnetStatusAlgorithm;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=67), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="eventDetectionEnable", type="boolean", defaultValue="true", flags=72), @NiagaraProperty(name="dynamicallyCreated", type="boolean", defaultValue="false", flags=77), @NiagaraProperty(name="bacnetStatusFlags", type="BBacnetBitString", defaultValue="BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetStatusFlags\"))", facets={@Facet(value="BacnetBitStringUtil.BACNET_STATUS_FLAGS_FACETS")})})
public abstract class BBacnetEventSource
extends BComponent
implements BIBacnetExportObject {
    @Generated
    public static final Property status = BBacnetEventSource.newProperty((int)67, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BBacnetEventSource.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property eventDetectionEnable = BBacnetEventSource.newProperty((int)72, (boolean)true, null);
    @Generated
    public static final Property dynamicallyCreated = BBacnetEventSource.newProperty((int)77, (boolean)false, null);
    @Generated
    public static final Property bacnetStatusFlags = BBacnetEventSource.newProperty((int)0, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), (BFacets)BacnetBitStringUtil.BACNET_STATUS_FLAGS_FACETS);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetEventSource.class);
    private boolean fatalFault = false;
    protected static final BLink[] EMPTY_LINKS_ARRAY = new BLink[0];
    protected static final BBacnetBitString ACKED_TRANS_DEFAULT = BBacnetBitString.make(new boolean[]{true, true, true});
    protected static final int MESSAGE_TEXTS_COUNT = 3;
    protected static final BBacnetObjectPropertyReference OBJECT_PROP_REF_UNCONFIGURED = new BBacnetObjectPropertyReference(BBacnetObjectIdentifier.make(BBacnetObjectType.analogInput, 0x3FFFFF));
    protected static Logger logger = Logger.getLogger("bacnet.server");

    @Override
    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public boolean getEventDetectionEnable() {
        return this.getBoolean(eventDetectionEnable);
    }

    @Generated
    public void setEventDetectionEnable(boolean v) {
        this.setBoolean(eventDetectionEnable, v, null);
    }

    @Generated
    public boolean getDynamicallyCreated() {
        return this.getBoolean(dynamicallyCreated);
    }

    @Generated
    public void setDynamicallyCreated(boolean v) {
        this.setBoolean(dynamicallyCreated, v, null);
    }

    @Generated
    public BBacnetBitString getBacnetStatusFlags() {
        return (BBacnetBitString)this.get(bacnetStatusFlags);
    }

    @Generated
    public void setBacnetStatusFlags(BBacnetBitString v) {
        this.set(bacnetStatusFlags, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkFatalFault();
        if (!this.getEventDetectionEnable()) {
            this.removeEventFromEventBuffer();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(eventDetectionEnable)) {
            if (!this.getEventDetectionEnable()) {
                this.removeEventFromEventBuffer();
            }
            this.statusChanged();
        }
        if (p.equals(bacnetStatusFlags)) {
            this.bacnetStatusFlagChanged();
        }
    }

    protected void bacnetStatusFlagChanged() {
        BControlPoint point = this.getPoint();
        BAlarmSourceExt alarmExt = this.setStatusFlagsOnBAcnetStatusAlgo(point);
        if (null != alarmExt) {
            // empty if block
        }
    }

    private BAlarmSourceExt setStatusFlagsOnBAcnetStatusAlgo(BControlPoint point) {
        if (null != point) {
            BAlarmSourceExt[] c = (BAlarmSourceExt[])point.getChildren(BAlarmSourceExt.class);
            for (int i = 0; i < c.length; ++i) {
                BAlarmSourceExt alarmSourceExt = c[i];
                if (!alarmSourceExt.getOffnormalAlgorithm().getType().is(BBacnetStatusAlgorithm.TYPE)) continue;
                ((BBacnetStatusAlgorithm)alarmSourceExt.getOffnormalAlgorithm()).setStausFlags(this.getBacnetStatusFlags());
                return alarmSourceExt;
            }
        }
        return null;
    }

    void checkValid() {
    }

    protected BBacnetExportFolder getSvo() {
        for (BBacnetEventSource parent = this; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BBacnetExportFolder)) continue;
            return (BBacnetExportFolder)((Object)parent);
        }
        return null;
    }

    public abstract boolean isValidAlarmExt(BIAlarmSource var1);

    @Deprecated
    protected abstract void updateAlarmInhibit();

    public abstract boolean isEventInitiationEnabled();

    @Override
    public abstract BBacnetObjectIdentifier getObjectId();

    public abstract BEnum getEventState();

    public abstract BControlPoint getPoint();

    public abstract BBacnetBitString getAckedTransitions();

    public abstract BBacnetTimeStamp[] getEventTimeStamps();

    public abstract BBacnetNotifyType getNotifyType();

    public abstract BBacnetBitString getEventEnable();

    public abstract int[] getEventPriorities();

    public abstract BBacnetNotificationClassDescriptor getNotificationClass();

    public abstract BEnum getEventType();

    @Override
    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private void checkFatalFault() {
        BBacnetExportTable exports = null;
        BLocalBacnetDevice local = null;
        BBacnetNetwork network = null;
        if (this.fatalFault) {
            return;
        }
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof BBacnetExportTable) {
                exports = (BBacnetExportTable)parent;
                continue;
            }
            if (!(parent instanceof BLocalBacnetDevice)) continue;
            local = (BLocalBacnetDevice)parent;
            break;
        }
        if (exports == null || local == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under LocalBacnetDevice Export Table");
            return;
        }
        if (local.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("LocalDevice fault: " + local.getFaultCause());
            return;
        }
        network = (BBacnetNetwork)local.getParent();
        if (network == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under BacnetNetwork");
            return;
        }
        if (network.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + network.getFaultCause());
            return;
        }
        if (!network.hasServerLicense()) {
            this.fatalFault = true;
            this.setFaultCause("Server capability not licensed");
            return;
        }
        this.setFaultCause("");
    }

    protected PropertyValue readEventMessageTexts(int ndx) {
        if (ndx < -1 || ndx > 3) {
            return new NReadPropertyResult(351, ndx, new NErrorType(2, 42));
        }
        BBacnetObjectIdentifier deviceId = BBacnetNetwork.localDevice().getObjectId();
        BEventHandler eventHandler = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().getEventHandler();
        AsnOutputStream out = new AsnOutputStream();
        boolean used = true;
        switch (ndx) {
            case 0: {
                out.writeUnsignedInteger(3L);
                break;
            }
            case -1: {
                used = false;
            }
            case 1: {
                out.writeCharacterString(this.readEventMessageTextFromEventBuffer(eventHandler, 2, deviceId, "toOffNormalMsgText"));
                if (used) break;
            }
            case 2: {
                out.writeCharacterString(this.readEventMessageTextFromEventBuffer(eventHandler, 1, deviceId, "toFaultMsgText"));
                if (used) break;
            }
            case 3: {
                out.writeCharacterString(this.readEventMessageTextFromEventBuffer(eventHandler, 0, deviceId, "toNormalMsgText"));
                if (!used) break;
            }
        }
        return new NReadPropertyResult(351, ndx, out.toByteArray());
    }

    protected PropertyValue readEventMessageTextsConfig(String toOffnormalText, String toFaultText, String toNormalText, int ndx) {
        if (ndx < -1 || ndx > 3) {
            return new NReadPropertyResult(352, ndx, new NErrorType(2, 42));
        }
        AsnOutputStream out = new AsnOutputStream();
        boolean used = true;
        switch (ndx) {
            case 0: {
                out.writeUnsignedInteger(3L);
                break;
            }
            case -1: {
                used = false;
            }
            case 1: {
                out.writeCharacterString(toOffnormalText);
                if (used) break;
            }
            case 2: {
                out.writeCharacterString(toFaultText);
                if (used) break;
            }
            case 3: {
                out.writeCharacterString(toNormalText);
            }
        }
        return new NReadPropertyResult(352, ndx, out.toByteArray());
    }

    protected static ErrorType writeEventMessageTextsConfig(int ndx, byte[] val, BAlarmSourceExt almExt) throws AsnException {
        if (ndx < -1 || ndx > 3) {
            return new NErrorType(2, 42);
        }
        switch (ndx) {
            case 0: {
                return new NErrorType(2, 40);
            }
            case -1: {
                BBacnetArray textsConfig = new BBacnetArray(BString.TYPE, 3);
                AsnUtil.fromAsn(-4, val, (BValue)textsConfig);
                Context context = BLocalBacnetDevice.getBacnetContext();
                almExt.set(BAlarmSourceExt.toOffnormalText, (BValue)BFormat.make((String)textsConfig.getElement(1).toString(null)), context);
                almExt.set(BAlarmSourceExt.toFaultText, (BValue)BFormat.make((String)textsConfig.getElement(2).toString(null)), context);
                almExt.set(BAlarmSourceExt.toNormalText, (BValue)BFormat.make((String)textsConfig.getElement(3).toString(null)), context);
                BBacnetEventSource.resetOutOfRangeTexts(almExt);
                break;
            }
            case 1: {
                almExt.set(BAlarmSourceExt.toOffnormalText, (BValue)BFormat.make((String)AsnUtil.fromAsnCharacterString(val)), BLocalBacnetDevice.getBacnetContext());
                BBacnetEventSource.resetOutOfRangeTexts(almExt);
                break;
            }
            case 2: {
                almExt.set(BAlarmSourceExt.toFaultText, (BValue)BFormat.make((String)AsnUtil.fromAsnCharacterString(val)), BLocalBacnetDevice.getBacnetContext());
                break;
            }
            case 3: {
                almExt.set(BAlarmSourceExt.toNormalText, (BValue)BFormat.make((String)AsnUtil.fromAsnCharacterString(val)), BLocalBacnetDevice.getBacnetContext());
            }
        }
        return null;
    }

    protected static void resetOutOfRangeTexts(BAlarmSourceExt almExt) {
        BOffnormalAlgorithm offnormal = almExt.getOffnormalAlgorithm();
        if (offnormal instanceof BOutOfRangeAlgorithm) {
            BOutOfRangeAlgorithm outOfRange = (BOutOfRangeAlgorithm)offnormal;
            outOfRange.setHighLimitText(BFormat.DEFAULT);
            outOfRange.setLowLimitText(BFormat.DEFAULT);
        }
    }

    protected PropertyValue readEventTimeStamps(BAbsTime lastOffnormalTime, BAbsTime lastFaultTime, BAbsTime lastToNormalTime, int ndx) {
        if (ndx < -1 || ndx > 3) {
            return new NReadPropertyResult(130, ndx, new NErrorType(2, 42));
        }
        BBacnetObjectIdentifier deviceId = BBacnetNetwork.localDevice().getObjectId();
        BEventHandler eh = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().getEventHandler();
        AsnOutputStream asnOut = new AsnOutputStream();
        boolean used = true;
        switch (ndx) {
            case 0: {
                asnOut.writeUnsignedInteger(3L);
                break;
            }
            case -1: {
                used = false;
            }
            case 1: {
                if (this.getAlarmRecordFromEventBuffer(eh, 2, deviceId) != null) {
                    BBacnetTimeStamp.encodeTimeStamp(lastOffnormalTime, asnOut);
                } else {
                    BBacnetTimeStamp.encodeTimeStamp(BAbsTime.NULL, asnOut);
                }
                if (used) break;
            }
            case 2: {
                if (this.getAlarmRecordFromEventBuffer(eh, 1, deviceId) != null) {
                    BBacnetTimeStamp.encodeTimeStamp(lastFaultTime, asnOut);
                } else {
                    BBacnetTimeStamp.encodeTimeStamp(BAbsTime.NULL, asnOut);
                }
                if (used) break;
            }
            case 3: {
                if (this.getAlarmRecordFromEventBuffer(eh, 0, deviceId) != null) {
                    BBacnetTimeStamp.encodeTimeStamp(lastToNormalTime, asnOut);
                } else {
                    BBacnetTimeStamp.encodeTimeStamp(BAbsTime.NULL, asnOut);
                }
                if (!used) break;
            }
        }
        return new NReadPropertyResult(130, ndx, asnOut.toByteArray());
    }

    protected BAlarmTransitionBits readEventTransition(BAlarmTransitionBits alarmTransitionBits) {
        int bits = 0;
        BBacnetObjectIdentifier deviceId = BBacnetNetwork.localDevice().getObjectId();
        BEventHandler eh = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().getEventHandler();
        if (this.getAlarmRecordFromEventBuffer(eh, 2, deviceId) != null) {
            if (alarmTransitionBits.isToOffnormal()) {
                bits |= 1;
            }
        } else {
            bits |= 1;
        }
        if (this.getAlarmRecordFromEventBuffer(eh, 1, deviceId) != null) {
            if (alarmTransitionBits.isToFault()) {
                bits |= 2;
            }
        } else {
            bits |= 2;
        }
        if (this.getAlarmRecordFromEventBuffer(eh, 0, deviceId) != null) {
            if (alarmTransitionBits.isToNormal()) {
                bits |= 4;
            }
        } else {
            bits |= 4;
        }
        return BAlarmTransitionBits.make((int)bits);
    }

    public void statusChanged() {
    }

    protected void removeEventFromEventBuffer() {
        BEventHandler eventHandler = BBacnetServerLayer.getServerLayer().getEventHandler();
        eventHandler.removeAllRecordFromEventBuffer(BBacnetNetwork.localDevice().getObjectId(), this.getObjectId(), 0L);
        eventHandler.removeEventSummary(this.getObjectId());
    }

    private String readEventMessageTextFromEventBuffer(BEventHandler eventHandler, int eventStateOrdinal, BBacnetObjectIdentifier deviceId, String msgTextKey) {
        BAlarmRecord rec = this.getAlarmRecordFromEventBuffer(eventHandler, eventStateOrdinal, deviceId);
        if (rec != null) {
            return rec.getAlarmData().gets(msgTextKey, "");
        }
        return "";
    }

    private BAlarmRecord getAlarmRecordFromEventBuffer(BEventHandler eventHandler, int eventStateOrdinal, BBacnetObjectIdentifier deviceId) {
        BHashedEventBuffer eventBuffer = null;
        switch (eventStateOrdinal) {
            case 2: {
                eventBuffer = eventHandler.getToOffnormalBuffer();
                break;
            }
            case 1: {
                eventBuffer = eventHandler.getToFaultBuffer();
                break;
            }
            case 0: {
                eventBuffer = eventHandler.getToNormalBuffer();
            }
        }
        if (eventBuffer == null) {
            return null;
        }
        return eventBuffer.getRecord(deviceId, this.getObjectId(), 0L, false);
    }

    protected BBacnetObjectPropertyReference getEventAlgorithmInhibitRef(BAlarmSourceExt alarmExt) {
        for (BLink link : alarmExt.getLinks((Slot)BAlarmSourceExt.alarmInhibit)) {
            BBacnetObjectIdentifier objectId;
            BIBacnetExportObject descriptor;
            BComponent source;
            if (!link.isActive() || !link.isEnabled() || !((source = link.getSourceComponent()) instanceof BBooleanPoint) || (descriptor = this.findDescriptor(source.getHandleOrd())) == null || !(objectId = descriptor.getObjectId()).isConfigured()) continue;
            return new BBacnetObjectPropertyReference(objectId);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((Object)((Object)this.getObjectId()) + ": returning unconfigured eventAlgorithmInhibitRef because there is a no valid link to alarmInhibitRef.");
        }
        return OBJECT_PROP_REF_UNCONFIGURED;
    }

    protected BIBacnetExportObject findDescriptor(BOrd ord) {
        BBacnetObjectIdentifier objectId = BBacnetNetwork.localDevice().lookupBacnetObjectId(ord);
        if (objectId == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": could not find object ID for ord \"" + ord + '\"');
            }
            return null;
        }
        BIBacnetExportObject descriptor = BBacnetNetwork.localDevice().lookupBacnetObject(objectId);
        if (descriptor == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": found object ID \"" + (Object)((Object)objectId) + "\" for ord \"" + ord + "\" but could not find descriptor");
            }
            return null;
        }
        return descriptor;
    }

    protected ErrorType writeEventAlgorithmInhibitRef(byte[] val, BAlarmSourceExt alarmExt) throws AsnException {
        BBooleanPoint sourcePoint;
        BBacnetObjectPropertyReference newObjPropRef = new BBacnetObjectPropertyReference();
        AsnUtil.fromAsn(val, (BValue)newObjPropRef);
        Context context = BLocalBacnetDevice.getBacnetContext();
        if (!newObjPropRef.getObjectId().isConfigured()) {
            this.removeAlarmInhibitLinks(alarmExt, context);
            return null;
        }
        try {
            sourcePoint = this.findEventAlgorithmInhibitSourcePoint(newObjPropRef);
        }
        catch (ErrorException e) {
            return e.getErrorType();
        }
        BBacnetEventSource.checkLinkPermissions((BComponent)sourcePoint, "out", context);
        alarmExt.add(null, (BValue)new BLink(sourcePoint.getHandleOrd(), "out", alarmExt.getAlarmInhibit().getName(), true), context);
        return null;
    }

    private void removeAlarmInhibitLinks(BAlarmSourceExt alarmExt, Context context) {
        if (alarmExt != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": removing links to alarmInhibit because eventAlgorithmInhibitRef is set to the unconfigured instance number 4194303");
            }
            for (BLink link : alarmExt.getLinks((Slot)BAlarmSourceExt.alarmInhibit)) {
                alarmExt.remove(link.getPropertyInParent(), context);
            }
        }
    }

    protected BBooleanPoint findEventAlgorithmInhibitSourcePoint(BBacnetObjectPropertyReference objPropRef) throws ErrorException {
        BControlPoint sourcePoint;
        try {
            sourcePoint = BacnetDescriptorUtil.findOrAddLocalPoint(objPropRef.getObjectId(), objPropRef.getPropertyId(), objPropRef.getPropertyArrayIndex());
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, (Object)((Object)this.getObjectId()) + ": could not resolve point for eventAlgorithmInhibitRef " + objPropRef, logger.isLoggable(Level.FINE) ? e : null);
            }
            throw new ErrorException(new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange));
        }
        if (sourcePoint == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning((Object)((Object)this.getObjectId()) + ": could not resolve the point for eventAlgorithmInhibitRef " + objPropRef);
            }
            throw new ErrorException(new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange));
        }
        if (!(sourcePoint instanceof BBooleanPoint)) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning((Object)((Object)this.getObjectId()) + ": eventAlgorithmInhibitRef (" + objPropRef + ") point is type " + sourcePoint.getType() + " but should be instanceof BooleanPoint");
            }
            throw new ErrorException(new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.valueOutOfRange));
        }
        return (BBooleanPoint)sourcePoint;
    }

    protected static void checkLinkPermissions(BComponent source, String sourceSlotName, Context context) {
        BUser user;
        BUser bUser = user = context != null ? context.getUser() : null;
        if (user == null) {
            return;
        }
        user.checkWrite(source, source.getSlot(sourceSlotName));
    }

    protected ErrorType writeEventAlgorithmInhibit(byte[] val, BAlarmSourceExt alarmExt) throws AsnException {
        boolean newValue = AsnUtil.fromAsnBoolean(val);
        if (!this.getEventDetectionEnable()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": could not write the alarmInhibit property because event detection is disabled");
            }
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
        }
        if (alarmExt.getLinks((Slot)BAlarmSourceExt.alarmInhibit).length > 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((Object)((Object)this.getObjectId()) + ": could not write the eventAlgorithmInhibit property because alarmInhibit is linked");
            }
            return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
        }
        alarmExt.set(BAlarmSourceExt.alarmInhibit, (BValue)new BStatusBoolean(newValue), BLocalBacnetDevice.getBacnetContext());
        return null;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetEventSource", 2);
        out.prop((Object)"fatalFault", this.fatalFault);
        out.endProps();
    }
}

