/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.stack.link.ethernet.BBacnetEthernetLinkLayer;
import java.util.List;
import java.util.logging.Level;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetNetworkPortDescriptor;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.ValidateChangesException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BBacnetEthernetPortDescriptor
extends BBacnetNetworkPortDescriptor {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetEthernetPortDescriptor.class);
    private static final int[] OPTIONAL_PROPS = new int[]{28, 417, 425, 426, 399, 428, 423, 424};

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected int getNetworkType() {
        return 0;
    }

    @Override
    protected int[] getOptionalProps() {
        return OPTIONAL_PROPS;
    }

    @Override
    protected boolean isArrayProp(int propId) {
        return propId == 371;
    }

    @Override
    protected boolean isListProp(int propId) {
        return propId == 428;
    }

    @Override
    protected List<? extends BIBacnetDataType> getListElements(int propertyId) throws ErrorException {
        if (propertyId == 428) {
            return this.getRouterEntries();
        }
        throw new IllegalArgumentException("Invalid propertyId value " + propertyId);
    }

    @Override
    protected PropertyValue readOptionalProperty(int propertyId, int index) {
        switch (propertyId) {
            case 425: {
                return this.readNetworkNumber();
            }
            case 426: {
                return this.readNetworkNumberQuality();
            }
            case 399: {
                return this.readApduLength();
            }
            case 428: {
                return this.readRoutingTable();
            }
            case 423: {
                return this.readMacAddress();
            }
            case 424: {
                return this.readNetworkInterfaceName();
            }
        }
        return new NReadPropertyResult(propertyId, new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty));
    }

    @Override
    protected ErrorType writeOptionalProperty(int propertyId, int index, byte[] value, int priority) throws BacnetException {
        switch (propertyId) {
            case 399: 
            case 423: 
            case 424: 
            case 426: 
            case 428: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(this + ": attempted to write read-only property " + BBacnetPropertyIdentifier.tag(propertyId));
                }
                return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
            }
            case 425: {
                return this.writeNetworkNumber(value);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this + ": attempted to write unknown property " + BBacnetPropertyIdentifier.tag(propertyId));
        }
        return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.unknownProperty);
    }

    @Override
    protected void validateSetPendingChange(String name, BValue value, Context context) {
        if ("NetworkNumber".equals(name)) {
            this.validateSetNetworkNumber(value, context);
            return;
        }
        throw new LocalizableRuntimeException("bacnet", "networkPortDescriptor.pendingChange.unknown", new Object[]{name});
    }

    @Override
    public void validateChanges(Context context) throws ValidateChangesException {
        if (!this.hasPendingChanges()) {
            return;
        }
        this.checkCanReadPendingChanges(context);
        this.validateNetworkNumber(context);
    }

    @Override
    public void activateChanges(Context context) throws Exception {
        if (!this.hasPendingChanges()) {
            return;
        }
        this.activateNetworkNumber(context);
    }

    private PropertyValue readMacAddress() {
        byte[] macBytes = this.getLinkLayer().getMacAddress();
        return BacnetDescriptorUtil.makeOctetStringReadResult(BBacnetPropertyIdentifier.macAddress, macBytes != null ? macBytes : new byte[]{});
    }

    private PropertyValue readNetworkInterfaceName() {
        return BacnetDescriptorUtil.makeCharStringReadResult(BBacnetPropertyIdentifier.networkInterfaceName, SlotPath.unescape((String)this.getLinkLayer().getAdapterName().getTag()));
    }

    private BBacnetEthernetLinkLayer getLinkLayer() {
        return (BBacnetEthernetLinkLayer)this.networkPort.getLink();
    }
}

