/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.offnormal.BStringChangeOfStateAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOptionalCharacterString;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.datatypes.BBacnetValueSource;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.BacnetWritableDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BControlPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"control:StringWritable"})})
@NiagaraProperties(value={@NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.CHARACTER_STRING_VALUE)", flags=64, override=true), @NiagaraProperty(name="bacnetWritable", type="String", defaultValue="BBacnetPointDescriptor.lexNotWritable", flags=5), @NiagaraProperty(name="valueSourceArray", type="BBacnetArray", defaultValue="new BBacnetArray(BBacnetValueSource.TYPE, 16)", flags=67), @NiagaraProperty(name="lastCommandTime", type="BBacnetTimeStamp", defaultValue="new BBacnetTimeStamp(new BBacnetDateTime())", flags=67), @NiagaraProperty(name="commandTimeArray", type="BBacnetArray", defaultValue="makeEmptyCommandTimeArray()", flags=67)})
public class BBacnetCharacterStringDescriptor
extends BBacnetPointDescriptor
implements BacnetWritableDescriptor {
    @Generated
    public static final Property objectId = BBacnetCharacterStringDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(40), null);
    @Generated
    public static final Property bacnetWritable = BBacnetCharacterStringDescriptor.newProperty((int)5, (String)BBacnetPointDescriptor.lexNotWritable, null);
    @Generated
    public static final Property valueSourceArray = BBacnetCharacterStringDescriptor.newProperty((int)67, (BValue)new BBacnetArray(BBacnetValueSource.TYPE, 16), null);
    @Generated
    public static final Property lastCommandTime = BBacnetCharacterStringDescriptor.newProperty((int)67, (BValue)new BBacnetTimeStamp(new BBacnetDateTime()), null);
    @Generated
    public static final Property commandTimeArray = BBacnetCharacterStringDescriptor.newProperty((int)67, (BValue)BBacnetCharacterStringDescriptor.makeEmptyCommandTimeArray(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetCharacterStringDescriptor.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"control/stringPoint.png"), (BIcon)BIcon.std((String)"badges/export.png"));

    @Override
    @Generated
    public String getBacnetWritable() {
        return this.getString(bacnetWritable);
    }

    @Generated
    public void setBacnetWritable(String v) {
        this.setString(bacnetWritable, v, null);
    }

    @Override
    @Generated
    public BBacnetArray getValueSourceArray() {
        return (BBacnetArray)this.get(valueSourceArray);
    }

    @Generated
    public void setValueSourceArray(BBacnetArray v) {
        this.set(valueSourceArray, (BValue)v, null);
    }

    @Generated
    public BBacnetTimeStamp getLastCommandTime() {
        return (BBacnetTimeStamp)this.get(lastCommandTime);
    }

    @Override
    @Generated
    public void setLastCommandTime(BBacnetTimeStamp v) {
        this.set(lastCommandTime, (BValue)v, null);
    }

    @Override
    @Generated
    public BBacnetArray getCommandTimeArray() {
        return (BBacnetArray)this.get(commandTimeArray);
    }

    @Generated
    public void setCommandTimeArray(BBacnetArray v) {
        this.set(commandTimeArray, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected boolean isPointTypeLegal(BControlPoint pt) {
        return pt instanceof BStringPoint;
    }

    @Override
    public BEnum getEventType() {
        return BBacnetEventType.changeOfCharacterstring;
    }

    @Override
    public boolean isValidAlarmExt(BIAlarmSource ext) {
        if (ext instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)ext).getOffnormalAlgorithm() instanceof BStringChangeOfStateAlgorithm;
        }
        return false;
    }

    @Override
    protected boolean isCommandable() {
        return true;
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BStringWritable pt = (BStringWritable)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 87: {
                return this.readPriorityArray(ndx);
            }
            case 104: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(pt.getFallback().getValue()));
            }
            case 85: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(pt.getOut().getValue()));
            }
        }
        return super.readProperty(pId, ndx);
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        switch (pId) {
            case 7: {
                BAlarmSourceExt alarmExt = this.getAlarmExt();
                if (alarmExt == null || !(alarmExt.getOffnormalAlgorithm() instanceof BStringChangeOfStateAlgorithm)) {
                    return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
                }
                String alarmExpression = ((BStringChangeOfStateAlgorithm)alarmExt.getOffnormalAlgorithm()).getExpression();
                AsnOutputStream asnOut = new AsnOutputStream();
                new BBacnetOptionalCharacterString(alarmExpression).writeAsn(asnOut);
                byte[] val = asnOut.toByteArray();
                return new NReadPropertyResult(pId, ndx, val);
            }
            case 431: {
                return this.readCurrentCommandPriority();
            }
            case 433: {
                return this.readValueSource(this.getValueSourceArray());
            }
            case 434: {
                return BacnetDescriptorUtil.readArray(pId, ndx, this.getValueSourceArray());
            }
            case 432: {
                return BacnetDescriptorUtil.makeConstructedReadResult(BBacnetPropertyIdentifier.lastCommandTime, (BValue)this.getLastCommandTime());
            }
            case 430: {
                return BacnetDescriptorUtil.readArray(pId, ndx, this.getCommandTimeArray());
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected byte[] makeInterfaceValue(BStatusValue proxyValue) {
        throw new UnsupportedOperationException("BACnet Characterstring object does not have an interface value property");
    }

    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BStringWritable pt = (BStringWritable)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 87: {
                    return new NErrorType(2, 40);
                }
                case 104: {
                    BStatusString fb = pt.getFallback();
                    fb.setString(BStatusString.value, AsnUtil.fromAsnCharacterString(val), BLocalBacnetDevice.getBacnetContext());
                    fb.setStatusNull(false);
                    return null;
                }
            }
            return super.writeProperty(pId, ndx, val, pri);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri, BBacnetAddress sourceAddress) throws BacnetException {
        BStringWritable pt = (BStringWritable)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 85: {
                    return this.writePriorityArray(pri, val, sourceAddress);
                }
                case 433: {
                    return this.writeValueSource(pri, val, sourceAddress);
                }
                case 430: 
                case 431: 
                case 432: 
                case 434: {
                    return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
                }
            }
            return super.writeProperty(pId, ndx, val, pri, sourceAddress);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        switch (pId) {
            case 7: {
                if (this.getAlarmExt() != null) {
                    return new NErrorType(2, 40);
                }
                return new NErrorType(2, 32);
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }

    @Override
    protected void addRequiredProps(Vector v) {
        v.add(BBacnetPropertyIdentifier.presentValue);
        v.add(BBacnetPropertyIdentifier.statusFlags);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        v.add(BBacnetPropertyIdentifier.description);
        v.add(BBacnetPropertyIdentifier.eventState);
        v.add(BBacnetPropertyIdentifier.reliability);
        v.add(BBacnetPropertyIdentifier.outOfService);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
        v.add(BBacnetPropertyIdentifier.currentCommandPriority);
        v.add(BBacnetPropertyIdentifier.valueSource);
        v.add(BBacnetPropertyIdentifier.valueSourceArray);
        v.add(BBacnetPropertyIdentifier.lastCommandTime);
        v.add(BBacnetPropertyIdentifier.commandTimeArray);
        BAlarmSourceExt alarmExt = this.getAlarmExt();
        if (alarmExt != null) {
            v.add(BBacnetPropertyIdentifier.timeDelay);
            v.add(BBacnetPropertyIdentifier.notificationClass);
            v.add(BBacnetPropertyIdentifier.alarmValues);
            v.add(BBacnetPropertyIdentifier.eventEnable);
            v.add(BBacnetPropertyIdentifier.ackedTransitions);
            v.add(BBacnetPropertyIdentifier.notifyType);
            v.add(BBacnetPropertyIdentifier.eventTimeStamps);
            v.add(BBacnetPropertyIdentifier.eventMessageTexts);
            v.add(BBacnetPropertyIdentifier.eventMessageTextsConfig);
            v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibitRef);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibit);
            v.add(BBacnetPropertyIdentifier.timeDelayNormal);
        }
    }

    @Override
    protected void validate() {
        if (!this.configOk.get()) {
            return;
        }
        if (this.getOosExt().getOutOfService()) {
            this.setFaultCause("");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            return;
        }
        BStatusString sn = ((BStringPoint)this.getPoint()).getOut();
        BStatus s = sn.getStatus();
        if (s.isNull()) {
            this.setFaultCause("Invalid value for BACnet Object: " + sn);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            return;
        }
        this.setFaultCause("");
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
    }

    @Override
    protected int getPresentValueAsnType() {
        return 7;
    }

    @Override
    protected BValue readAsnPriorityValue(AsnInput in, BControlPoint point) throws AsnException {
        return BString.make((String)in.readCharacterString());
    }

    @Override
    protected boolean isPriorityValueOutOfRange(BValue value, BControlPoint point) {
        return false;
    }

    @Override
    BStatusValue getCurrentStatusValue() {
        BStatusString sv = new BStatusString(((BStringPoint)this.getPoint()).getOut().getValue());
        sv.setStatus(this.getStatusFlags());
        return sv;
    }

    @Override
    public boolean checkCov(BStatusValue currentValue, BStatusValue covValue) {
        return !currentValue.toString().equals(covValue.toString());
    }

    @Override
    protected void writeAsnPriorityValue(AsnOutput out, BValue value) {
        out.writeCharacterString(((BString)value).getString());
    }

    @Override
    protected byte[] convertToAsn(BValue value) {
        return AsnUtil.toAsnCharacterString(((BString)value).getString());
    }

    private void resetBacnetWritable() {
        StringBuilder sb = new StringBuilder();
        Knob[] knobs = this.getKnobs();
        for (int i = 0; i < knobs.length; ++i) {
            BObject tgt = knobs[i].getTargetOrd().get((BObject)this);
            BControlPoint pt = this.getPoint();
            if (!knobs[i].getTargetSlotName().startsWith("in") || tgt != pt) continue;
            sb.append(knobs[i].getTargetSlotName()).append(',');
        }
        this.setBacnetWritable(sb.length() > 0 ? sb.substring(0, sb.length() - 1) : lexNotWritable);
    }

    public void knobAdded(Knob knob, Context cx) {
        this.resetBacnetWritable();
    }

    public void knobRemoved(Knob knob, Context cx) {
        this.resetBacnetWritable();
    }

    public BIcon getIcon() {
        return icon;
    }
}

