/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.offnormal.BBooleanChangeOfStateAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetBinaryWritableDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BDiscreteTotalizerExt;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"control:BooleanWritable"})})
@NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.BINARY_VALUE)", flags=64, override=true)
public class BBacnetBinaryValuePrioritizedDescriptor
extends BBacnetBinaryWritableDescriptor {
    @Generated
    public static final Property objectId = BBacnetBinaryValuePrioritizedDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(5), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetBinaryValuePrioritizedDescriptor.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(5);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public BEnum getEventType() {
        return BBacnetEventType.changeOfState;
    }

    @Override
    public boolean isValidAlarmExt(BIAlarmSource ext) {
        if (ext instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)ext).getOffnormalAlgorithm() instanceof BBooleanChangeOfStateAlgorithm;
        }
        return false;
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BBooleanPoint pt = (BBooleanPoint)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 85: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(pt.getOut().getValue()));
            }
        }
        return super.readProperty(pId, ndx);
    }

    @Override
    protected void addRequiredProps(Vector v) {
        v.add(BBacnetPropertyIdentifier.presentValue);
        v.add(BBacnetPropertyIdentifier.statusFlags);
        v.add(BBacnetPropertyIdentifier.eventState);
        v.add(BBacnetPropertyIdentifier.outOfService);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        BDiscreteTotalizerExt tot;
        BString ft;
        v.add(BBacnetPropertyIdentifier.description);
        v.add(BBacnetPropertyIdentifier.reliability);
        BControlPoint pt = this.getPoint();
        BString tt = (BString)pt.getFacets().getFacet("trueText");
        if (tt != null) {
            v.add(BBacnetPropertyIdentifier.activeText);
        }
        if ((ft = (BString)pt.getFacets().getFacet("falseText")) != null) {
            v.add(BBacnetPropertyIdentifier.inactiveText);
        }
        if ((tot = this.getTotalizerExt()) != null) {
            v.add(BBacnetPropertyIdentifier.changeOfStateTime);
            v.add(BBacnetPropertyIdentifier.changeOfStateCount);
            v.add(BBacnetPropertyIdentifier.timeOfStateCountReset);
            v.add(BBacnetPropertyIdentifier.elapsedActiveTime);
            v.add(BBacnetPropertyIdentifier.timeOfActiveTimeReset);
        }
        v.add(BBacnetPropertyIdentifier.minimumOffTime);
        v.add(BBacnetPropertyIdentifier.minimumOnTime);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
        v.add(BBacnetPropertyIdentifier.currentCommandPriority);
        v.add(BBacnetPropertyIdentifier.valueSource);
        v.add(BBacnetPropertyIdentifier.valueSourceArray);
        v.add(BBacnetPropertyIdentifier.lastCommandTime);
        v.add(BBacnetPropertyIdentifier.commandTimeArray);
        BAlarmSourceExt alarmExt = this.getAlarmExt();
        if (alarmExt != null) {
            v.add(BBacnetPropertyIdentifier.timeDelay);
            v.add(BBacnetPropertyIdentifier.notificationClass);
            v.add(BBacnetPropertyIdentifier.alarmValue);
            v.add(BBacnetPropertyIdentifier.eventEnable);
            v.add(BBacnetPropertyIdentifier.ackedTransitions);
            v.add(BBacnetPropertyIdentifier.notifyType);
            v.add(BBacnetPropertyIdentifier.eventTimeStamps);
            v.add(BBacnetPropertyIdentifier.eventMessageTexts);
            v.add(BBacnetPropertyIdentifier.eventMessageTextsConfig);
            v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibitRef);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibit);
            v.add(BBacnetPropertyIdentifier.timeDelayNormal);
        }
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            BBooleanChangeOfStateAlgorithm alg = (BBooleanChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
            if (pId == 6) {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(alg.getAlarmValue()));
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            try {
                BBooleanChangeOfStateAlgorithm alg = (BBooleanChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
                switch (pId) {
                    case 6: {
                        alg.setBoolean(BBooleanChangeOfStateAlgorithm.alarmValue, AsnUtil.fromOnlyBinaryPv(val), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 35: {
                        almExt.set(BAlarmSourceExt.alarmEnable, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(AsnUtil.fromAsnBitString(val)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
            }
            catch (OutOfRangeException e) {
                log.warning("OutOfRangeException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
                return new NErrorType(2, 37);
            }
            catch (AsnException e) {
                log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
                return new NErrorType(2, 9);
            }
            catch (PermissionException e) {
                log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
                return new NErrorType(2, 40);
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }
}

