/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.offnormal.BBooleanChangeOfStateAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetBinaryPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BOutOfServiceExt;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BDiscreteTotalizerExt;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"control:BooleanPoint"})})
@NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.BINARY_VALUE)", flags=64, override=true)
public class BBacnetBinaryValueDescriptor
extends BBacnetBinaryPointDescriptor {
    @Generated
    public static final Property objectId = BBacnetBinaryValueDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(5), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetBinaryValueDescriptor.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Deprecated
    public BStatusBoolean getBacnetValue() {
        throw new BajaRuntimeException("Method getBacnetValue() is deprecated!");
    }

    @Deprecated
    public void setBacnetValue(BStatusBoolean v) {
        throw new BajaRuntimeException("Method setBacnetValue() is deprecated!");
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(5);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public BEnum getEventType() {
        return BBacnetEventType.changeOfState;
    }

    @Override
    public boolean isValidAlarmExt(BIAlarmSource ext) {
        if (ext instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)ext).getOffnormalAlgorithm() instanceof BBooleanChangeOfStateAlgorithm;
        }
        return false;
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BBooleanPoint pt = (BBooleanPoint)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 85: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(pt.getOut().getValue()));
            }
        }
        return super.readProperty(pId, ndx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BBooleanPoint pt = (BBooleanPoint)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 85: {
                    BOutOfServiceExt outOfServiceExt = this.getOosExt();
                    if (!outOfServiceExt.getOutOfService()) return new NErrorType(2, 40);
                    AsnInputStream asnIn = AsnInputStream.make(val);
                    try {
                        int tag = asnIn.peekTag();
                        if (tag != 9) throw new AsnException("Invalid tag: " + tag);
                        int pv = asnIn.readEnumerated();
                        if (pv == 0) {
                            outOfServiceExt.set(BOutOfServiceExt.presentValue, (BValue)BBoolean.FALSE, BLocalBacnetDevice.getBacnetContext());
                            return null;
                        }
                        if (pv == 1) {
                            outOfServiceExt.set(BOutOfServiceExt.presentValue, (BValue)BBoolean.TRUE, BLocalBacnetDevice.getBacnetContext());
                            return null;
                        }
                        NErrorType nErrorType = new NErrorType(2, 37);
                        return nErrorType;
                    }
                    finally {
                        asnIn.release();
                    }
                }
            }
            return super.writeProperty(pId, ndx, val, pri);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    @Override
    protected void addRequiredProps(Vector v) {
        v.add(BBacnetPropertyIdentifier.presentValue);
        v.add(BBacnetPropertyIdentifier.statusFlags);
        v.add(BBacnetPropertyIdentifier.eventState);
        v.add(BBacnetPropertyIdentifier.outOfService);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        BAlarmSourceExt alarmExt;
        BDiscreteTotalizerExt tot;
        BString ft;
        v.add(BBacnetPropertyIdentifier.description);
        v.add(BBacnetPropertyIdentifier.reliability);
        BControlPoint pt = this.getPoint();
        BString tt = (BString)pt.getFacets().getFacet("trueText");
        if (tt != null) {
            v.add(BBacnetPropertyIdentifier.activeText);
        }
        if ((ft = (BString)pt.getFacets().getFacet("falseText")) != null) {
            v.add(BBacnetPropertyIdentifier.inactiveText);
        }
        if ((tot = this.getTotalizerExt()) != null) {
            v.add(BBacnetPropertyIdentifier.changeOfStateTime);
            v.add(BBacnetPropertyIdentifier.changeOfStateCount);
            v.add(BBacnetPropertyIdentifier.timeOfStateCountReset);
            v.add(BBacnetPropertyIdentifier.elapsedActiveTime);
            v.add(BBacnetPropertyIdentifier.timeOfActiveTimeReset);
        }
        if ((alarmExt = this.getAlarmExt()) != null) {
            v.add(BBacnetPropertyIdentifier.timeDelay);
            v.add(BBacnetPropertyIdentifier.notificationClass);
            v.add(BBacnetPropertyIdentifier.alarmValue);
            v.add(BBacnetPropertyIdentifier.eventEnable);
            v.add(BBacnetPropertyIdentifier.ackedTransitions);
            v.add(BBacnetPropertyIdentifier.notifyType);
            v.add(BBacnetPropertyIdentifier.eventTimeStamps);
            v.add(BBacnetPropertyIdentifier.eventMessageTexts);
            v.add(BBacnetPropertyIdentifier.eventMessageTextsConfig);
            v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibitRef);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibit);
            v.add(BBacnetPropertyIdentifier.timeDelayNormal);
        }
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            BBooleanChangeOfStateAlgorithm alg = (BBooleanChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
            if (pId == 6) {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(alg.getAlarmValue()));
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            try {
                BBooleanChangeOfStateAlgorithm alg = (BBooleanChangeOfStateAlgorithm)almExt.getOffnormalAlgorithm();
                switch (pId) {
                    case 6: {
                        alg.setBoolean(BBooleanChangeOfStateAlgorithm.alarmValue, AsnUtil.fromOnlyBinaryPv(val), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 35: {
                        almExt.set(BAlarmSourceExt.alarmEnable, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(AsnUtil.fromAsnBitString(val)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
            }
            catch (OutOfRangeException e) {
                log.warning("OutOfRangeException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
                return new NErrorType(2, 37);
            }
            catch (AsnException e) {
                log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
                return new NErrorType(2, 9);
            }
            catch (PermissionException e) {
                log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
                return new NErrorType(2, 40);
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }
}

