/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.offnormal.BBooleanCommandFailureAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetBinaryWritableDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BDiscreteTotalizerExt;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"control:BooleanWritable"})})
@NiagaraProperties(value={@NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.BINARY_OUTPUT)", flags=64, override=true), @NiagaraProperty(name="deviceType", type="String", defaultValue="")})
public class BBacnetBinaryOutputDescriptor
extends BBacnetBinaryWritableDescriptor {
    @Generated
    public static final Property objectId = BBacnetBinaryOutputDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(4), null);
    @Generated
    public static final Property deviceType = BBacnetBinaryOutputDescriptor.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetBinaryOutputDescriptor.class);

    @Generated
    public String getDeviceType() {
        return this.getString(deviceType);
    }

    @Generated
    public void setDeviceType(String v) {
        this.setString(deviceType, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(4);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public BEnum getEventType() {
        return BBacnetEventType.commandFailure;
    }

    @Override
    public boolean isValidAlarmExt(BIAlarmSource ext) {
        if (ext instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)ext).getOffnormalAlgorithm() instanceof BBooleanCommandFailureAlgorithm;
        }
        return false;
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BBooleanWritable pt = (BBooleanWritable)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 85: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(pt.getOut().getValue()));
            }
            case 84: {
                return this.readPolarityProperty((BBooleanPoint)pt);
            }
        }
        return super.readProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BBooleanWritable pt = (BBooleanWritable)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            if (pId == 84) {
                return this.writePolarityProperty((BBooleanPoint)pt, val);
            }
            return super.writeProperty(pId, ndx, val, pri);
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    @Override
    protected void addRequiredProps(Vector v) {
        v.add(BBacnetPropertyIdentifier.presentValue);
        v.add(BBacnetPropertyIdentifier.statusFlags);
        v.add(BBacnetPropertyIdentifier.eventState);
        v.add(BBacnetPropertyIdentifier.outOfService);
        v.add(BBacnetPropertyIdentifier.polarity);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
        v.add(BBacnetPropertyIdentifier.currentCommandPriority);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        BDiscreteTotalizerExt tot;
        BString ft;
        v.add(BBacnetPropertyIdentifier.description);
        v.add(BBacnetPropertyIdentifier.deviceType);
        v.add(BBacnetPropertyIdentifier.reliability);
        BControlPoint pt = this.getPoint();
        BString tt = (BString)pt.getFacets().getFacet("trueText");
        if (tt != null) {
            v.add(BBacnetPropertyIdentifier.activeText);
        }
        if ((ft = (BString)pt.getFacets().getFacet("falseText")) != null) {
            v.add(BBacnetPropertyIdentifier.inactiveText);
        }
        if ((tot = this.getTotalizerExt()) != null) {
            v.add(BBacnetPropertyIdentifier.changeOfStateTime);
            v.add(BBacnetPropertyIdentifier.changeOfStateCount);
            v.add(BBacnetPropertyIdentifier.timeOfStateCountReset);
            v.add(BBacnetPropertyIdentifier.elapsedActiveTime);
            v.add(BBacnetPropertyIdentifier.timeOfActiveTimeReset);
        }
        v.add(BBacnetPropertyIdentifier.minimumOffTime);
        v.add(BBacnetPropertyIdentifier.minimumOnTime);
        v.add(BBacnetPropertyIdentifier.interfaceValue);
        v.add(BBacnetPropertyIdentifier.valueSource);
        v.add(BBacnetPropertyIdentifier.valueSourceArray);
        v.add(BBacnetPropertyIdentifier.lastCommandTime);
        v.add(BBacnetPropertyIdentifier.commandTimeArray);
        BAlarmSourceExt alarmExt = this.getAlarmExt();
        if (alarmExt != null) {
            v.add(BBacnetPropertyIdentifier.timeDelay);
            v.add(BBacnetPropertyIdentifier.notificationClass);
            v.add(BBacnetPropertyIdentifier.feedbackValue);
            v.add(BBacnetPropertyIdentifier.eventEnable);
            v.add(BBacnetPropertyIdentifier.ackedTransitions);
            v.add(BBacnetPropertyIdentifier.notifyType);
            v.add(BBacnetPropertyIdentifier.eventTimeStamps);
            v.add(BBacnetPropertyIdentifier.eventMessageTexts);
            v.add(BBacnetPropertyIdentifier.eventMessageTextsConfig);
            v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibitRef);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibit);
            v.add(BBacnetPropertyIdentifier.timeDelayNormal);
        }
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            BBooleanCommandFailureAlgorithm alg = (BBooleanCommandFailureAlgorithm)almExt.getOffnormalAlgorithm();
            if (pId == 40) {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(alg.getFeedbackValue().getValue()));
            }
        }
        switch (pId) {
            case 31: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getDeviceType()));
            }
            case 387: {
                return this.readInterfaceValue();
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        switch (pId) {
            case 31: 
            case 387: {
                return new NErrorType(2, 40);
            }
        }
        BAlarmSourceExt almExt = this.getAlarmExt();
        if (almExt != null) {
            switch (pId) {
                case 40: {
                    return new NErrorType(2, 40);
                }
                case 35: {
                    almExt.set(BAlarmSourceExt.alarmEnable, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(AsnUtil.fromAsnBitString(val)), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }
}

