/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.datatypes.BBacnetValueSource;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetAnalogPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetDescriptorUtil;
import javax.baja.bacnet.export.BacnetWritableDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BDouble;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="bacnetWritable", type="String", defaultValue="BBacnetAnalogPointDescriptor.lexNotWritable", flags=5), @NiagaraProperty(name="valueSourceArray", type="BBacnetArray", defaultValue="new BBacnetArray(BBacnetValueSource.TYPE, 16)", flags=67), @NiagaraProperty(name="lastCommandTime", type="BBacnetTimeStamp", defaultValue="new BBacnetTimeStamp(new BBacnetDateTime())", flags=67), @NiagaraProperty(name="commandTimeArray", type="BBacnetArray", defaultValue="makeEmptyCommandTimeArray()", flags=67)})
public abstract class BBacnetAnalogWritableDescriptor
extends BBacnetAnalogPointDescriptor
implements BacnetWritableDescriptor {
    @Generated
    public static final Property bacnetWritable = BBacnetAnalogWritableDescriptor.newProperty((int)5, (String)BBacnetAnalogPointDescriptor.lexNotWritable, null);
    @Generated
    public static final Property valueSourceArray = BBacnetAnalogWritableDescriptor.newProperty((int)67, (BValue)new BBacnetArray(BBacnetValueSource.TYPE, 16), null);
    @Generated
    public static final Property lastCommandTime = BBacnetAnalogWritableDescriptor.newProperty((int)67, (BValue)new BBacnetTimeStamp(new BBacnetDateTime()), null);
    @Generated
    public static final Property commandTimeArray = BBacnetAnalogWritableDescriptor.newProperty((int)67, (BValue)BBacnetAnalogWritableDescriptor.makeEmptyCommandTimeArray(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetAnalogWritableDescriptor.class);

    @Override
    @Generated
    public String getBacnetWritable() {
        return this.getString(bacnetWritable);
    }

    @Generated
    public void setBacnetWritable(String v) {
        this.setString(bacnetWritable, v, null);
    }

    @Override
    @Generated
    public BBacnetArray getValueSourceArray() {
        return (BBacnetArray)this.get(valueSourceArray);
    }

    @Generated
    public void setValueSourceArray(BBacnetArray v) {
        this.set(valueSourceArray, (BValue)v, null);
    }

    @Generated
    public BBacnetTimeStamp getLastCommandTime() {
        return (BBacnetTimeStamp)this.get(lastCommandTime);
    }

    @Override
    @Generated
    public void setLastCommandTime(BBacnetTimeStamp v) {
        this.set(lastCommandTime, (BValue)v, null);
    }

    @Override
    @Generated
    public BBacnetArray getCommandTimeArray() {
        return (BBacnetArray)this.get(commandTimeArray);
    }

    @Generated
    public void setCommandTimeArray(BBacnetArray v) {
        this.set(commandTimeArray, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected final boolean isPointTypeLegal(BControlPoint pt) {
        return pt instanceof BNumericWritable;
    }

    @Override
    protected boolean isCommandable() {
        return true;
    }

    @Override
    protected PropertyValue readProperty(int pId, int ndx) {
        BNumericWritable pt = (BNumericWritable)this.getPoint();
        if (pt == null) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(1, 1000));
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 87: {
                return this.readPriorityArray(ndx);
            }
            case 104: {
                byte[] asn = this.convertToAsn(pt.getFallback().getValue());
                return new NReadPropertyResult(pId, ndx, asn);
            }
        }
        return super.readProperty(pId, ndx);
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        switch (pId) {
            case 431: {
                return this.readCurrentCommandPriority();
            }
            case 433: {
                return this.readValueSource(this.getValueSourceArray());
            }
            case 434: {
                return BacnetDescriptorUtil.readArray(pId, ndx, this.getValueSourceArray());
            }
            case 432: {
                return BacnetDescriptorUtil.makeConstructedReadResult(BBacnetPropertyIdentifier.lastCommandTime, (BValue)this.getLastCommandTime());
            }
            case 430: {
                return BacnetDescriptorUtil.readArray(pId, ndx, this.getCommandTimeArray());
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        BNumericWritable pt = (BNumericWritable)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 87: {
                    return new NErrorType(2, 40);
                }
                case 104: {
                    BNumber nmin = (BNumber)this.getPoint().getFacets().getFacet("min");
                    BNumber nmax = (BNumber)this.getPoint().getFacets().getFacet("max");
                    double min = nmin != null ? nmin.getDouble() : Double.NEGATIVE_INFINITY;
                    double max = nmax != null ? nmax.getDouble() : Double.POSITIVE_INFINITY;
                    double real = Double.NaN;
                    real = this.convertFromAsn(val);
                    if (real < min || real > max) {
                        return new NErrorType(2, 37);
                    }
                    BStatusNumeric fb = pt.getFallback();
                    fb.setDouble(BStatusNumeric.value, real, BLocalBacnetDevice.getBacnetContext());
                    fb.setStatusNull(false);
                    return null;
                }
            }
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
        return super.writeProperty(pId, ndx, val, pri);
    }

    @Override
    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri, BBacnetAddress sourceAddress) throws BacnetException {
        BNumericWritable pt = (BNumericWritable)this.getPoint();
        if (pt == null) {
            return new NErrorType(1, 1000);
        }
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 85: {
                    return this.writePriorityArray(pri, val, sourceAddress);
                }
                case 433: {
                    return this.writeValueSource(pri, val, sourceAddress);
                }
                case 430: 
                case 431: 
                case 432: 
                case 434: {
                    return new NErrorType(BBacnetErrorClass.property, BBacnetErrorCode.writeAccessDenied);
                }
            }
        }
        catch (AsnException e) {
            log.warning("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            log.warning("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
        return super.writeProperty(pId, ndx, val, pri, sourceAddress);
    }

    @Override
    protected void writeAsnPriorityValue(AsnOutput out, BValue value) {
        out.writeReal(((BNumber)value).getDouble());
    }

    @Override
    protected BValue readAsnPriorityValue(AsnInput in, BControlPoint point) throws AsnException {
        return BDouble.make((double)in.readReal());
    }

    @Override
    protected boolean isPriorityValueOutOfRange(BValue value, BControlPoint point) {
        BNumber nmin = (BNumber)point.getFacets().getFacet("min");
        BNumber nmax = (BNumber)point.getFacets().getFacet("max");
        double min = nmin != null ? nmin.getDouble() : Double.NEGATIVE_INFINITY;
        double max = nmax != null ? nmax.getDouble() : Double.POSITIVE_INFINITY;
        double real = ((BNumber)value).getDouble();
        return real < min || real > max;
    }

    private void resetBacnetWritable() {
        StringBuilder sb = new StringBuilder();
        Knob[] knobs = this.getKnobs();
        for (int i = 0; i < knobs.length; ++i) {
            BObject tgt = knobs[i].getTargetOrd().get((BObject)this);
            BControlPoint pt = this.getPoint();
            if (!knobs[i].getTargetSlotName().startsWith("in") || tgt != pt) continue;
            sb.append(knobs[i].getTargetSlotName()).append(',');
        }
        this.setBacnetWritable(sb.length() > 0 ? sb.substring(0, sb.length() - 1) : lexNotWritable);
    }

    public void knobAdded(Knob knob, Context cx) {
        this.resetBacnetWritable();
    }

    public void knobRemoved(Knob knob, Context cx) {
        this.resetBacnetWritable();
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        switch (pId) {
            case 35: {
                BAlarmSourceExt almExt = this.getAlarmExt();
                if (almExt == null) break;
                almExt.set(BAlarmSourceExt.alarmEnable, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(AsnUtil.fromAsnBitString(val)), BLocalBacnetDevice.getBacnetContext());
                return null;
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }
}

