/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.fault.BOutOfRangeFaultAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetAnalogWritableDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"control:NumericWritable"})})
@NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.make(BBacnetObjectType.ANALOG_VALUE)", flags=64, override=true)
public class BBacnetAnalogValuePrioritizedDescriptor
extends BBacnetAnalogWritableDescriptor {
    @Generated
    public static final Property objectId = BBacnetAnalogValuePrioritizedDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(2), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetAnalogValuePrioritizedDescriptor.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(2);
        }
        return super.getSlotFacets(s);
    }

    @Override
    protected void addRequiredProps(Vector v) {
        v.add(BBacnetPropertyIdentifier.presentValue);
        v.add(BBacnetPropertyIdentifier.statusFlags);
        v.add(BBacnetPropertyIdentifier.eventState);
        v.add(BBacnetPropertyIdentifier.outOfService);
        v.add(BBacnetPropertyIdentifier.units);
    }

    @Override
    protected void addOptionalProps(Vector v) {
        BNumber prec;
        BNumber max;
        v.add(BBacnetPropertyIdentifier.description);
        v.add(BBacnetPropertyIdentifier.reliability);
        v.add(BBacnetPropertyIdentifier.priorityArray);
        v.add(BBacnetPropertyIdentifier.relinquishDefault);
        BControlPoint pt = this.getPoint();
        BNumber min = (BNumber)pt.getFacets().getFacet("min");
        if (min != null) {
            v.add(BBacnetPropertyIdentifier.minPresValue);
        }
        if ((max = (BNumber)pt.getFacets().getFacet("max")) != null) {
            v.add(BBacnetPropertyIdentifier.maxPresValue);
        }
        if ((prec = (BNumber)pt.getFacets().getFacet("precision")) != null) {
            v.add(BBacnetPropertyIdentifier.resolution);
        }
        v.add(BBacnetPropertyIdentifier.covIncrement);
        v.add(BBacnetPropertyIdentifier.currentCommandPriority);
        v.add(BBacnetPropertyIdentifier.valueSource);
        v.add(BBacnetPropertyIdentifier.valueSourceArray);
        v.add(BBacnetPropertyIdentifier.lastCommandTime);
        v.add(BBacnetPropertyIdentifier.commandTimeArray);
        BAlarmSourceExt alarmExt = this.getAlarmExt();
        if (alarmExt != null) {
            v.add(BBacnetPropertyIdentifier.timeDelay);
            v.add(BBacnetPropertyIdentifier.notificationClass);
            v.add(BBacnetPropertyIdentifier.highLimit);
            v.add(BBacnetPropertyIdentifier.lowLimit);
            v.add(BBacnetPropertyIdentifier.deadband);
            v.add(BBacnetPropertyIdentifier.limitEnable);
            v.add(BBacnetPropertyIdentifier.eventEnable);
            v.add(BBacnetPropertyIdentifier.ackedTransitions);
            v.add(BBacnetPropertyIdentifier.notifyType);
            v.add(BBacnetPropertyIdentifier.eventTimeStamps);
            v.add(BBacnetPropertyIdentifier.eventMessageTexts);
            v.add(BBacnetPropertyIdentifier.eventMessageTextsConfig);
            v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibitRef);
            v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibit);
            v.add(BBacnetPropertyIdentifier.timeDelayNormal);
            if (alarmExt.getFaultAlgorithm() instanceof BOutOfRangeFaultAlgorithm) {
                v.add(BBacnetPropertyIdentifier.faultHighLimit);
                v.add(BBacnetPropertyIdentifier.faultLowLimit);
            }
        }
    }

    @Override
    protected PropertyValue readOptionalProperty(int pId, int ndx) {
        switch (pId) {
            case 388: {
                BFaultAlgorithm faultAlgorithm = this.getFaultAlgorithm();
                if (!(faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)) break;
                return new NReadPropertyResult(pId, ndx, this.convertToAsn(((BOutOfRangeFaultAlgorithm)faultAlgorithm).getHighLimit()));
            }
            case 389: {
                BFaultAlgorithm faultAlgorithm = this.getFaultAlgorithm();
                if (!(faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)) break;
                return new NReadPropertyResult(pId, ndx, this.convertToAsn(((BOutOfRangeFaultAlgorithm)faultAlgorithm).getLowLimit()));
            }
        }
        return super.readOptionalProperty(pId, ndx);
    }

    @Override
    protected ErrorType writeOptionalProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        switch (pId) {
            case 388: {
                BFaultAlgorithm faultAlgorithm = this.getFaultAlgorithm();
                if (!(faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)) break;
                faultAlgorithm.setDouble(BOutOfRangeFaultAlgorithm.highLimit, this.convertFromAsn(val), BLocalBacnetDevice.getBacnetContext());
                return null;
            }
            case 389: {
                BFaultAlgorithm faultAlgorithm = this.getFaultAlgorithm();
                if (!(faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)) break;
                faultAlgorithm.setDouble(BOutOfRangeFaultAlgorithm.lowLimit, this.convertFromAsn(val), BLocalBacnetDevice.getBacnetContext());
                return null;
            }
        }
        return super.writeOptionalProperty(pId, ndx, val, pri);
    }
}

