/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.enums;

import java.util.Arrays;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="analogInput"), @Range(value="analogOutput"), @Range(value="analogValue"), @Range(value="binaryInput"), @Range(value="binaryOutput"), @Range(value="binaryValue"), @Range(value="calendar"), @Range(value="command"), @Range(value="device"), @Range(value="eventEnrollment"), @Range(value="file"), @Range(value="group"), @Range(value="loop"), @Range(value="multiStateInput"), @Range(value="multiStateOutput"), @Range(value="notificationClass"), @Range(value="program"), @Range(value="schedule"), @Range(value="averaging"), @Range(value="multiStateValue"), @Range(value="trendLog"), @Range(value="lifeSafetyPoint"), @Range(value="lifeSafetyZone"), @Range(value="accumulator"), @Range(value="pulseConverter"), @Range(value="eventLog"), @Range(value="globalGroup"), @Range(value="trendLogMultiple"), @Range(value="loadControl"), @Range(value="structuredView"), @Range(value="accessDoor"), @Range(value="unassigned31"), @Range(value="accessCredential"), @Range(value="accessPoint"), @Range(value="accessRights"), @Range(value="accessUser"), @Range(value="accessZone"), @Range(value="credentialDataInput"), @Range(value="networkSecurity"), @Range(value="bitstringValue"), @Range(value="characterStringValue"), @Range(value="datePatternValue"), @Range(value="dateValue"), @Range(value="dateTimePatternValue"), @Range(value="dateTimeValue"), @Range(value="integerValue"), @Range(value="largeAnalogValue"), @Range(value="octetStringValue"), @Range(value="positiveIntegerValue"), @Range(value="timePatternValue"), @Range(value="timeValue"), @Range(value="notificationForwarder"), @Range(value="alertEnrollment"), @Range(value="channel"), @Range(value="lightingOutput"), @Range(value="binaryLightingOutput"), @Range(value="networkPort"), @Range(value="elevatorGroup"), @Range(value="escalator"), @Range(value="lift")})
public final class BBacnetObjectType
extends BFrozenEnum
implements BacnetConst {
    @Generated
    public static final int ANALOG_INPUT = 0;
    @Generated
    public static final int ANALOG_OUTPUT = 1;
    @Generated
    public static final int ANALOG_VALUE = 2;
    @Generated
    public static final int BINARY_INPUT = 3;
    @Generated
    public static final int BINARY_OUTPUT = 4;
    @Generated
    public static final int BINARY_VALUE = 5;
    @Generated
    public static final int CALENDAR = 6;
    @Generated
    public static final int COMMAND = 7;
    @Generated
    public static final int DEVICE = 8;
    @Generated
    public static final int EVENT_ENROLLMENT = 9;
    @Generated
    public static final int FILE = 10;
    @Generated
    public static final int GROUP = 11;
    @Generated
    public static final int LOOP = 12;
    @Generated
    public static final int MULTI_STATE_INPUT = 13;
    @Generated
    public static final int MULTI_STATE_OUTPUT = 14;
    @Generated
    public static final int NOTIFICATION_CLASS = 15;
    @Generated
    public static final int PROGRAM = 16;
    @Generated
    public static final int SCHEDULE = 17;
    @Generated
    public static final int AVERAGING = 18;
    @Generated
    public static final int MULTI_STATE_VALUE = 19;
    @Generated
    public static final int TREND_LOG = 20;
    @Generated
    public static final int LIFE_SAFETY_POINT = 21;
    @Generated
    public static final int LIFE_SAFETY_ZONE = 22;
    @Generated
    public static final int ACCUMULATOR = 23;
    @Generated
    public static final int PULSE_CONVERTER = 24;
    @Generated
    public static final int EVENT_LOG = 25;
    @Generated
    public static final int GLOBAL_GROUP = 26;
    @Generated
    public static final int TREND_LOG_MULTIPLE = 27;
    @Generated
    public static final int LOAD_CONTROL = 28;
    @Generated
    public static final int STRUCTURED_VIEW = 29;
    @Generated
    public static final int ACCESS_DOOR = 30;
    @Generated
    public static final int UNASSIGNED_31 = 31;
    @Generated
    public static final int ACCESS_CREDENTIAL = 32;
    @Generated
    public static final int ACCESS_POINT = 33;
    @Generated
    public static final int ACCESS_RIGHTS = 34;
    @Generated
    public static final int ACCESS_USER = 35;
    @Generated
    public static final int ACCESS_ZONE = 36;
    @Generated
    public static final int CREDENTIAL_DATA_INPUT = 37;
    @Generated
    public static final int NETWORK_SECURITY = 38;
    @Generated
    public static final int BITSTRING_VALUE = 39;
    @Generated
    public static final int CHARACTER_STRING_VALUE = 40;
    @Generated
    public static final int DATE_PATTERN_VALUE = 41;
    @Generated
    public static final int DATE_VALUE = 42;
    @Generated
    public static final int DATE_TIME_PATTERN_VALUE = 43;
    @Generated
    public static final int DATE_TIME_VALUE = 44;
    @Generated
    public static final int INTEGER_VALUE = 45;
    @Generated
    public static final int LARGE_ANALOG_VALUE = 46;
    @Generated
    public static final int OCTET_STRING_VALUE = 47;
    @Generated
    public static final int POSITIVE_INTEGER_VALUE = 48;
    @Generated
    public static final int TIME_PATTERN_VALUE = 49;
    @Generated
    public static final int TIME_VALUE = 50;
    @Generated
    public static final int NOTIFICATION_FORWARDER = 51;
    @Generated
    public static final int ALERT_ENROLLMENT = 52;
    @Generated
    public static final int CHANNEL = 53;
    @Generated
    public static final int LIGHTING_OUTPUT = 54;
    @Generated
    public static final int BINARY_LIGHTING_OUTPUT = 55;
    @Generated
    public static final int NETWORK_PORT = 56;
    @Generated
    public static final int ELEVATOR_GROUP = 57;
    @Generated
    public static final int ESCALATOR = 58;
    @Generated
    public static final int LIFT = 59;
    @Generated
    public static final BBacnetObjectType analogInput = new BBacnetObjectType(0);
    @Generated
    public static final BBacnetObjectType analogOutput = new BBacnetObjectType(1);
    @Generated
    public static final BBacnetObjectType analogValue = new BBacnetObjectType(2);
    @Generated
    public static final BBacnetObjectType binaryInput = new BBacnetObjectType(3);
    @Generated
    public static final BBacnetObjectType binaryOutput = new BBacnetObjectType(4);
    @Generated
    public static final BBacnetObjectType binaryValue = new BBacnetObjectType(5);
    @Generated
    public static final BBacnetObjectType calendar = new BBacnetObjectType(6);
    @Generated
    public static final BBacnetObjectType command = new BBacnetObjectType(7);
    @Generated
    public static final BBacnetObjectType device = new BBacnetObjectType(8);
    @Generated
    public static final BBacnetObjectType eventEnrollment = new BBacnetObjectType(9);
    @Generated
    public static final BBacnetObjectType file = new BBacnetObjectType(10);
    @Generated
    public static final BBacnetObjectType group = new BBacnetObjectType(11);
    @Generated
    public static final BBacnetObjectType loop = new BBacnetObjectType(12);
    @Generated
    public static final BBacnetObjectType multiStateInput = new BBacnetObjectType(13);
    @Generated
    public static final BBacnetObjectType multiStateOutput = new BBacnetObjectType(14);
    @Generated
    public static final BBacnetObjectType notificationClass = new BBacnetObjectType(15);
    @Generated
    public static final BBacnetObjectType program = new BBacnetObjectType(16);
    @Generated
    public static final BBacnetObjectType schedule = new BBacnetObjectType(17);
    @Generated
    public static final BBacnetObjectType averaging = new BBacnetObjectType(18);
    @Generated
    public static final BBacnetObjectType multiStateValue = new BBacnetObjectType(19);
    @Generated
    public static final BBacnetObjectType trendLog = new BBacnetObjectType(20);
    @Generated
    public static final BBacnetObjectType lifeSafetyPoint = new BBacnetObjectType(21);
    @Generated
    public static final BBacnetObjectType lifeSafetyZone = new BBacnetObjectType(22);
    @Generated
    public static final BBacnetObjectType accumulator = new BBacnetObjectType(23);
    @Generated
    public static final BBacnetObjectType pulseConverter = new BBacnetObjectType(24);
    @Generated
    public static final BBacnetObjectType eventLog = new BBacnetObjectType(25);
    @Generated
    public static final BBacnetObjectType globalGroup = new BBacnetObjectType(26);
    @Generated
    public static final BBacnetObjectType trendLogMultiple = new BBacnetObjectType(27);
    @Generated
    public static final BBacnetObjectType loadControl = new BBacnetObjectType(28);
    @Generated
    public static final BBacnetObjectType structuredView = new BBacnetObjectType(29);
    @Generated
    public static final BBacnetObjectType accessDoor = new BBacnetObjectType(30);
    @Generated
    public static final BBacnetObjectType unassigned31 = new BBacnetObjectType(31);
    @Generated
    public static final BBacnetObjectType accessCredential = new BBacnetObjectType(32);
    @Generated
    public static final BBacnetObjectType accessPoint = new BBacnetObjectType(33);
    @Generated
    public static final BBacnetObjectType accessRights = new BBacnetObjectType(34);
    @Generated
    public static final BBacnetObjectType accessUser = new BBacnetObjectType(35);
    @Generated
    public static final BBacnetObjectType accessZone = new BBacnetObjectType(36);
    @Generated
    public static final BBacnetObjectType credentialDataInput = new BBacnetObjectType(37);
    @Generated
    public static final BBacnetObjectType networkSecurity = new BBacnetObjectType(38);
    @Generated
    public static final BBacnetObjectType bitstringValue = new BBacnetObjectType(39);
    @Generated
    public static final BBacnetObjectType characterStringValue = new BBacnetObjectType(40);
    @Generated
    public static final BBacnetObjectType datePatternValue = new BBacnetObjectType(41);
    @Generated
    public static final BBacnetObjectType dateValue = new BBacnetObjectType(42);
    @Generated
    public static final BBacnetObjectType dateTimePatternValue = new BBacnetObjectType(43);
    @Generated
    public static final BBacnetObjectType dateTimeValue = new BBacnetObjectType(44);
    @Generated
    public static final BBacnetObjectType integerValue = new BBacnetObjectType(45);
    @Generated
    public static final BBacnetObjectType largeAnalogValue = new BBacnetObjectType(46);
    @Generated
    public static final BBacnetObjectType octetStringValue = new BBacnetObjectType(47);
    @Generated
    public static final BBacnetObjectType positiveIntegerValue = new BBacnetObjectType(48);
    @Generated
    public static final BBacnetObjectType timePatternValue = new BBacnetObjectType(49);
    @Generated
    public static final BBacnetObjectType timeValue = new BBacnetObjectType(50);
    @Generated
    public static final BBacnetObjectType notificationForwarder = new BBacnetObjectType(51);
    @Generated
    public static final BBacnetObjectType alertEnrollment = new BBacnetObjectType(52);
    @Generated
    public static final BBacnetObjectType channel = new BBacnetObjectType(53);
    @Generated
    public static final BBacnetObjectType lightingOutput = new BBacnetObjectType(54);
    @Generated
    public static final BBacnetObjectType binaryLightingOutput = new BBacnetObjectType(55);
    @Generated
    public static final BBacnetObjectType networkPort = new BBacnetObjectType(56);
    @Generated
    public static final BBacnetObjectType elevatorGroup = new BBacnetObjectType(57);
    @Generated
    public static final BBacnetObjectType escalator = new BBacnetObjectType(58);
    @Generated
    public static final BBacnetObjectType lift = new BBacnetObjectType(59);
    @Generated
    public static final BBacnetObjectType DEFAULT = analogInput;
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetObjectType.class);
    public static final int MAX_ASHRAE_ID = 59;
    public static final int MAX_RESERVED_ID = 127;
    public static final int MAX_ID = 1023;
    private static final String INVALID_OBJECT_TYPE = "INVALID";
    private static final String[] shortTags = BBacnetObjectType.makeShortTags();
    private static final BFacets[] objectIdFacets = new BFacets[60];

    @Generated
    public static BBacnetObjectType make(int ordinal) {
        return (BBacnetObjectType)analogInput.getRange().get(ordinal, false);
    }

    @Generated
    public static BBacnetObjectType make(String tag) {
        return (BBacnetObjectType)analogInput.getRange().get(tag);
    }

    @Generated
    private BBacnetObjectType(int ordinal) {
        super(ordinal);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static String tag(int id) {
        if (DEFAULT.getRange().isOrdinal(id)) {
            return DEFAULT.getRange().getTag(id);
        }
        if (BBacnetObjectType.isAshrae(id)) {
            return ASHRAE_PREFIX + id;
        }
        if (BBacnetObjectType.isProprietary(id)) {
            return PROPRIETARY_PREFIX + id;
        }
        return "INVALID:" + id;
    }

    public static int ordinal(String tag) {
        try {
            return DEFAULT.getRange().tagToOrdinal(tag);
        }
        catch (InvalidEnumException e) {
            if (tag.startsWith(ASHRAE_PREFIX)) {
                return Integer.parseInt(tag.substring(ASHRAE_PREFIX_LENGTH));
            }
            if (tag.startsWith(PROPRIETARY_PREFIX)) {
                return Integer.parseInt(tag.substring(PROPRIETARY_PREFIX_LENGTH));
            }
            if (tag.startsWith(INVALID_OBJECT_TYPE)) {
                return -1;
            }
            throw e;
        }
    }

    public static boolean isProprietary(int id) {
        return id > 127 && id <= 1023;
    }

    public static boolean isAshrae(int id) {
        return id > 59 && id <= 127;
    }

    public static boolean isValid(int id) {
        return id <= 1023;
    }

    public static boolean isFixed(int id) {
        return id <= 59;
    }

    @Deprecated
    public static boolean hasStatusFlags(int ordinal) {
        return BBacnetObjectType.hasStatusFlags(ordinal, null);
    }

    public static boolean hasStatusFlags(int ordinal, BBacnetDevice device) {
        int pr = 0;
        if (device != null) {
            pr = device.getProtocolRevision();
        }
        return BBacnetObjectType.hasStatusFlags(ordinal, pr);
    }

    public static boolean hasStatusFlags(int ordinal, int pr) {
        if (ordinal > 59) {
            return false;
        }
        switch (ordinal) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                return pr >= 0;
            }
            case 19: {
                return pr >= 1;
            }
            case 21: 
            case 22: {
                return pr >= 2;
            }
            case 17: 
            case 23: 
            case 24: {
                return pr >= 4;
            }
            case 28: 
            case 30: {
                return pr >= 6;
            }
            case 20: 
            case 25: 
            case 27: {
                return pr >= 7;
            }
            case 32: {
                return pr >= 9;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return pr >= 10;
            }
            case 26: {
                return pr >= 11;
            }
            case 9: 
            case 51: {
                return pr >= 13;
            }
            case 53: 
            case 54: {
                return pr >= 14;
            }
            case 7: 
            case 8: 
            case 15: 
            case 55: {
                return pr >= 16;
            }
            case 31: 
            case 56: {
                return pr >= 17;
            }
            case 58: 
            case 59: {
                return pr >= 18;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean canSupportCov(int ordinal) {
        return BBacnetObjectType.canSupportCov(ordinal, null);
    }

    public static boolean canSupportCov(int ordinal, BBacnetDevice device) {
        int pr = 0;
        if (device != null) {
            pr = device.getProtocolRevision();
        }
        return BBacnetObjectType.canSupportCov(ordinal, pr);
    }

    public static boolean canSupportCov(int ordinal, int pr) {
        if (ordinal > 59) {
            return false;
        }
        switch (ordinal) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: {
                return pr >= 0;
            }
            case 19: {
                return pr >= 1;
            }
            case 21: 
            case 22: {
                return pr >= 2;
            }
            case 24: {
                return pr >= 4;
            }
            case 28: 
            case 30: {
                return pr >= 6;
            }
            case 33: 
            case 37: {
                return pr >= 9;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return pr >= 10;
            }
            case 54: {
                return pr >= 14;
            }
            case 55: {
                return pr >= 16;
            }
        }
        return false;
    }

    public static long bitmask(int ... bits) {
        long mask = 0L;
        for (int i = 0; i < bits.length; ++i) {
            mask |= 1L << bits[i];
        }
        return mask;
    }

    public static String getShortTag(int objectType) {
        if (objectType < 0 || objectType >= shortTags.length) {
            return objectType + ":";
        }
        return shortTags[objectType];
    }

    private static String[] makeShortTags() {
        Object[] shortTags = new String[60];
        Arrays.fill(shortTags, "");
        shortTags[0] = "AI";
        shortTags[1] = "AO";
        shortTags[2] = "AV";
        shortTags[3] = "BI";
        shortTags[4] = "BO";
        shortTags[5] = "BV";
        shortTags[6] = "CAL";
        shortTags[7] = "CMD";
        shortTags[8] = "DEV";
        shortTags[9] = "EE";
        shortTags[10] = "FILE";
        shortTags[11] = "GRP";
        shortTags[12] = "LP";
        shortTags[13] = "MSI";
        shortTags[14] = "MSO";
        shortTags[15] = "NC";
        shortTags[16] = "PGM";
        shortTags[17] = "SCH";
        shortTags[18] = "AVG";
        shortTags[19] = "MSV";
        shortTags[20] = "LOG";
        shortTags[21] = "LSP";
        shortTags[22] = "LSZ";
        shortTags[23] = "ACC";
        shortTags[24] = "PC";
        shortTags[25] = "ELOG";
        shortTags[26] = "GGRP";
        shortTags[27] = "TLM";
        shortTags[28] = "LCO";
        shortTags[29] = "SVO";
        shortTags[30] = "DOOR";
        shortTags[31] = "TMR";
        shortTags[32] = "ACRD";
        shortTags[33] = "APNT";
        shortTags[34] = "ARGT";
        shortTags[35] = "AUSR";
        shortTags[36] = "AZNE";
        shortTags[37] = "CRDI";
        shortTags[38] = "SEC";
        shortTags[39] = "BSV";
        shortTags[40] = "CSV";
        shortTags[41] = "DTP";
        shortTags[42] = "DTV";
        shortTags[43] = "DTMP";
        shortTags[44] = "DTMV";
        shortTags[45] = "INT";
        shortTags[46] = "LAV";
        shortTags[47] = "OSV";
        shortTags[48] = "PINT";
        shortTags[49] = "TMP";
        shortTags[50] = "TMV";
        shortTags[51] = "NF";
        shortTags[52] = "AE";
        shortTags[53] = "CHA";
        shortTags[54] = "LO";
        shortTags[55] = "BLO";
        shortTags[56] = "NP";
        shortTags[57] = "EG";
        shortTags[58] = "ESC";
        shortTags[59] = "LIFT";
        return shortTags;
    }

    public static BFacets getObjectIdFacets(int objectType) {
        if (objectType < 0 || objectType >= objectIdFacets.length) {
            return null;
        }
        BFacets facets = objectIdFacets[objectType];
        if (facets == null) {
            BBacnetObjectType.objectIdFacets[objectType] = facets = BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{objectType}, (String[])new String[]{BBacnetObjectType.tag(objectType)}));
        }
        return facets;
    }
}

