/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BacnetConst;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="idle"), @Range(value="discardChanges"), @Range(value="renewFdRegistration"), @Range(value="restartSlaveDiscovery"), @Range(value="renewDhcp"), @Range(value="restartAutonegotiation"), @Range(value="disconnect"), @Range(value="restartPort"), @Range(value="generateCsrFile"), @Range(value="validateChanges")})
public final class BBacnetNetworkPortCommand
extends BFrozenEnum {
    @Generated
    public static final int IDLE = 0;
    @Generated
    public static final int DISCARD_CHANGES = 1;
    @Generated
    public static final int RENEW_FD_REGISTRATION = 2;
    @Generated
    public static final int RESTART_SLAVE_DISCOVERY = 3;
    @Generated
    public static final int RENEW_DHCP = 4;
    @Generated
    public static final int RESTART_AUTONEGOTIATION = 5;
    @Generated
    public static final int DISCONNECT = 6;
    @Generated
    public static final int RESTART_PORT = 7;
    @Generated
    public static final int GENERATE_CSR_FILE = 8;
    @Generated
    public static final int VALIDATE_CHANGES = 9;
    @Generated
    public static final BBacnetNetworkPortCommand idle = new BBacnetNetworkPortCommand(0);
    @Generated
    public static final BBacnetNetworkPortCommand discardChanges = new BBacnetNetworkPortCommand(1);
    @Generated
    public static final BBacnetNetworkPortCommand renewFdRegistration = new BBacnetNetworkPortCommand(2);
    @Generated
    public static final BBacnetNetworkPortCommand restartSlaveDiscovery = new BBacnetNetworkPortCommand(3);
    @Generated
    public static final BBacnetNetworkPortCommand renewDhcp = new BBacnetNetworkPortCommand(4);
    @Generated
    public static final BBacnetNetworkPortCommand restartAutonegotiation = new BBacnetNetworkPortCommand(5);
    @Generated
    public static final BBacnetNetworkPortCommand disconnect = new BBacnetNetworkPortCommand(6);
    @Generated
    public static final BBacnetNetworkPortCommand restartPort = new BBacnetNetworkPortCommand(7);
    @Generated
    public static final BBacnetNetworkPortCommand generateCsrFile = new BBacnetNetworkPortCommand(8);
    @Generated
    public static final BBacnetNetworkPortCommand validateChanges = new BBacnetNetworkPortCommand(9);
    @Generated
    public static final BBacnetNetworkPortCommand DEFAULT = idle;
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetNetworkPortCommand.class);
    private static final int MAX_FIXED_ID = 9;
    private static final int MAX_RESERVED_ID = 127;
    private static final int MAX_ID = 255;

    @Generated
    public static BBacnetNetworkPortCommand make(int ordinal) {
        return (BBacnetNetworkPortCommand)idle.getRange().get(ordinal, false);
    }

    @Generated
    public static BBacnetNetworkPortCommand make(String tag) {
        return (BBacnetNetworkPortCommand)idle.getRange().get(tag);
    }

    @Generated
    private BBacnetNetworkPortCommand(int ordinal) {
        super(ordinal);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static String tag(int id) {
        if (DEFAULT.getRange().isOrdinal(id)) {
            return DEFAULT.getRange().getTag(id);
        }
        if (BBacnetNetworkPortCommand.isAshrae(id)) {
            return BacnetConst.ASHRAE_PREFIX + id;
        }
        if (BBacnetNetworkPortCommand.isProprietary(id)) {
            return BacnetConst.PROPRIETARY_PREFIX + id;
        }
        throw new InvalidEnumException(id);
    }

    public static int ordinal(String tag) {
        try {
            return DEFAULT.getRange().tagToOrdinal(tag);
        }
        catch (InvalidEnumException e) {
            if (tag.startsWith(BacnetConst.ASHRAE_PREFIX)) {
                return Integer.parseInt(tag.substring(BacnetConst.ASHRAE_PREFIX_LENGTH));
            }
            if (tag.startsWith(BacnetConst.PROPRIETARY_PREFIX)) {
                return Integer.parseInt(tag.substring(BacnetConst.PROPRIETARY_PREFIX_LENGTH));
            }
            throw e;
        }
    }

    public static boolean isProprietary(int id) {
        return id > 127 && id <= 255;
    }

    public static boolean isAshrae(int id) {
        return id > 9 && id <= 127;
    }

    public static boolean isValid(int id) {
        return id <= 255;
    }

    public static boolean isFixed(int id) {
        return id <= 9;
    }

    public String toString(Context context) {
        if (BacnetConst.facetsContext.equals(context)) {
            return this.getTag();
        }
        return this.getDisplayTag(context);
    }
}

