/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BacnetConst;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="operational"), @Range(value="operationalReadOnly"), @Range(value="downloadRequired"), @Range(value="downloadInProgress"), @Range(value="nonOperational"), @Range(value="backupInProgress")})
public final class BBacnetDeviceStatus
extends BFrozenEnum
implements BacnetConst {
    @Generated
    public static final int OPERATIONAL = 0;
    @Generated
    public static final int OPERATIONAL_READ_ONLY = 1;
    @Generated
    public static final int DOWNLOAD_REQUIRED = 2;
    @Generated
    public static final int DOWNLOAD_IN_PROGRESS = 3;
    @Generated
    public static final int NON_OPERATIONAL = 4;
    @Generated
    public static final int BACKUP_IN_PROGRESS = 5;
    @Generated
    public static final BBacnetDeviceStatus operational = new BBacnetDeviceStatus(0);
    @Generated
    public static final BBacnetDeviceStatus operationalReadOnly = new BBacnetDeviceStatus(1);
    @Generated
    public static final BBacnetDeviceStatus downloadRequired = new BBacnetDeviceStatus(2);
    @Generated
    public static final BBacnetDeviceStatus downloadInProgress = new BBacnetDeviceStatus(3);
    @Generated
    public static final BBacnetDeviceStatus nonOperational = new BBacnetDeviceStatus(4);
    @Generated
    public static final BBacnetDeviceStatus backupInProgress = new BBacnetDeviceStatus(5);
    @Generated
    public static final BBacnetDeviceStatus DEFAULT = operational;
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetDeviceStatus.class);
    public static final int MAX_ASHRAE_ID = 5;
    public static final int MAX_RESERVED_ID = 63;
    public static final int MAX_ID = 65535;

    @Generated
    public static BBacnetDeviceStatus make(int ordinal) {
        return (BBacnetDeviceStatus)operational.getRange().get(ordinal, false);
    }

    @Generated
    public static BBacnetDeviceStatus make(String tag) {
        return (BBacnetDeviceStatus)operational.getRange().get(tag);
    }

    @Generated
    private BBacnetDeviceStatus(int ordinal) {
        super(ordinal);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static String tag(int id) {
        if (DEFAULT.getRange().isOrdinal(id)) {
            return DEFAULT.getRange().getTag(id);
        }
        if (BBacnetDeviceStatus.isAshrae(id)) {
            return ASHRAE_PREFIX + id;
        }
        if (BBacnetDeviceStatus.isProprietary(id)) {
            return PROPRIETARY_PREFIX + id;
        }
        throw new InvalidEnumException(id);
    }

    public static int ordinal(String tag) {
        try {
            return DEFAULT.getRange().tagToOrdinal(tag);
        }
        catch (InvalidEnumException e) {
            if (tag.startsWith(ASHRAE_PREFIX)) {
                return Integer.parseInt(tag.substring(ASHRAE_PREFIX_LENGTH));
            }
            if (tag.startsWith(PROPRIETARY_PREFIX)) {
                return Integer.parseInt(tag.substring(PROPRIETARY_PREFIX_LENGTH));
            }
            throw e;
        }
    }

    public static boolean isProprietary(int id) {
        return id > 63 && id <= 65535;
    }

    public static boolean isAshrae(int id) {
        return id > 5 && id <= 63;
    }

    public static boolean isValid(int id) {
        return id <= 65535;
    }

    public static boolean isFixed(int id) {
        return id <= 5;
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.getTag();
        }
        return this.getDisplayTag(context);
    }
}

