/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes.elevator;

import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="floorNumber", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.DEFAULT", facets={@Facet(value="BFacets.makeInt(null, (int)BBacnetUnsigned.MIN_UNSIGNED_VALUE, (int)BBacnetUnsigned.MAX_UNSIGNED8_VALUE)")})
public class BBacnetLiftCarCallListEntry
extends BComponent
implements BIBacnetDataType {
    @Generated
    public static final Property floorNumber = BBacnetLiftCarCallListEntry.newProperty((int)0, (BValue)BBacnetUnsigned.DEFAULT, (BFacets)BFacets.makeInt(null, (int)0, (int)255));
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetLiftCarCallListEntry.class);

    @Generated
    public BBacnetUnsigned getFloorNumber() {
        return (BBacnetUnsigned)this.get(floorNumber);
    }

    @Generated
    public void setFloorNumber(BBacnetUnsigned v) {
        this.set(floorNumber, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void writeAsn(AsnOutput out) {
        int floorNumber = this.getFloorNumber().getInt();
        if (floorNumber < 0 || (long)floorNumber > 255L) {
            throw new IllegalArgumentException("BACnetLiftCarCallList entry floor number must be Unsigned8; actual: " + floorNumber);
        }
        out.writeUnsignedInteger(floorNumber);
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int floorNumber = in.readUnsignedInt();
        if ((long)floorNumber > 255L) {
            throw new OutOfRangeException("BACnetLiftCarCallList entry floor number must be Unsigned8; actual: " + floorNumber);
        }
        this.setFloorNumber(BBacnetUnsigned.make(floorNumber));
    }

    public String toString(Context context) {
        return String.valueOf(this.getFloorNumber().getInt());
    }
}

