/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes.elevator;

import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.datatypes.elevator.BBacnetLandingCallStatusCommandChoice;
import javax.baja.bacnet.enums.elevator.BBacnetLiftCarDirection;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="floorNumber", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.DEFAULT", facets={@Facet(value="BFacets.makeInt(null, (int)BBacnetUnsigned.MIN_UNSIGNED_VALUE, (int)BBacnetUnsigned.MAX_UNSIGNED8_VALUE)")}), @NiagaraProperty(name="commandChoice", type="BBacnetLandingCallStatusCommandChoice", defaultValue="BBacnetLandingCallStatusCommandChoice.DEFAULT"), @NiagaraProperty(name="direction", type="BBacnetLiftCarDirection", defaultValue="BBacnetLiftCarDirection.DEFAULT"), @NiagaraProperty(name="destination", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.DEFAULT", facets={@Facet(value="BFacets.makeInt(null, (int)BBacnetUnsigned.MIN_UNSIGNED_VALUE, (int)BBacnetUnsigned.MAX_UNSIGNED8_VALUE)")}), @NiagaraProperty(name="floorText", type="String", defaultValue="")})
public class BBacnetLandingCallStatus
extends BStruct
implements BIBacnetDataType {
    @Generated
    public static final Property floorNumber = BBacnetLandingCallStatus.newProperty((int)0, (BValue)BBacnetUnsigned.DEFAULT, (BFacets)BFacets.makeInt(null, (int)0, (int)255));
    @Generated
    public static final Property commandChoice = BBacnetLandingCallStatus.newProperty((int)0, (BValue)BBacnetLandingCallStatusCommandChoice.DEFAULT, null);
    @Generated
    public static final Property direction = BBacnetLandingCallStatus.newProperty((int)0, (BValue)BBacnetLiftCarDirection.DEFAULT, null);
    @Generated
    public static final Property destination = BBacnetLandingCallStatus.newProperty((int)0, (BValue)BBacnetUnsigned.DEFAULT, (BFacets)BFacets.makeInt(null, (int)0, (int)255));
    @Generated
    public static final Property floorText = BBacnetLandingCallStatus.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetLandingCallStatus.class);

    @Generated
    public BBacnetUnsigned getFloorNumber() {
        return (BBacnetUnsigned)this.get(floorNumber);
    }

    @Generated
    public void setFloorNumber(BBacnetUnsigned v) {
        this.set(floorNumber, (BValue)v, null);
    }

    @Generated
    public BBacnetLandingCallStatusCommandChoice getCommandChoice() {
        return (BBacnetLandingCallStatusCommandChoice)this.get(commandChoice);
    }

    @Generated
    public void setCommandChoice(BBacnetLandingCallStatusCommandChoice v) {
        this.set(commandChoice, (BValue)v, null);
    }

    @Generated
    public BBacnetLiftCarDirection getDirection() {
        return (BBacnetLiftCarDirection)this.get(direction);
    }

    @Generated
    public void setDirection(BBacnetLiftCarDirection v) {
        this.set(direction, (BValue)v, null);
    }

    @Generated
    public BBacnetUnsigned getDestination() {
        return (BBacnetUnsigned)this.get(destination);
    }

    @Generated
    public void setDestination(BBacnetUnsigned v) {
        this.set(destination, (BValue)v, null);
    }

    @Generated
    public String getFloorText() {
        return this.getString(floorText);
    }

    @Generated
    public void setFloorText(String v) {
        this.setString(floorText, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void writeAsn(AsnOutput out) {
        int floorNumber = this.getFloorNumber().getInt();
        if (floorNumber < 0 || (long)floorNumber > 255L) {
            throw new IllegalArgumentException("BACnetLandingCallStatus floor number must be Unsigned8; actual: " + floorNumber);
        }
        out.writeUnsignedInteger(0, floorNumber);
        BBacnetLandingCallStatusCommandChoice commandChoice = this.getCommandChoice();
        switch (commandChoice.getOrdinal()) {
            case 0: {
                out.writeEnumerated(1, (BEnum)this.getDirection());
                break;
            }
            case 1: {
                int destination = this.getDestination().getInt();
                if (destination < 0 || (long)destination > 255L) {
                    throw new IllegalArgumentException("BACnetLandingCallStatus destination must be Unsigned8; actual: " + destination);
                }
                out.writeUnsignedInteger(2, destination);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid command choice: " + (Object)((Object)commandChoice));
            }
        }
        String floorText = this.getFloorText();
        if (!floorText.isEmpty()) {
            out.writeCharacterString(3, floorText);
        }
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        BBacnetLandingCallStatusCommandChoice commandChoice;
        int floorNumber = in.readUnsignedInt(0);
        if ((long)floorNumber > 255L) {
            throw new OutOfRangeException("BACnetLandingCallStatus floor number must be Unsigned8; actual: " + floorNumber);
        }
        BBacnetLiftCarDirection direction = BBacnetLiftCarDirection.DEFAULT;
        int destination = 0;
        int tag = in.peekTag();
        if (in.isContextTag(1)) {
            commandChoice = BBacnetLandingCallStatusCommandChoice.direction;
            direction = BBacnetLiftCarDirection.make(in.readEnumerated(1));
        } else if (in.isContextTag(2)) {
            commandChoice = BBacnetLandingCallStatusCommandChoice.destination;
            destination = in.readUnsignedInt(2);
            if ((long)destination > 255L) {
                throw new OutOfRangeException("BACnetLandingCallStatus destination must be Unsigned8; actual: " + destination);
            }
        } else {
            throw new AsnException("Invalid tag: " + tag);
        }
        String floorText = "";
        in.peekTag();
        if (in.isValueTag(3)) {
            floorText = in.readCharacterString(3);
        }
        this.setFloorNumber(BBacnetUnsigned.make(floorNumber));
        this.setCommandChoice(commandChoice);
        this.setDirection(direction);
        this.setDestination(BBacnetUnsigned.make(destination));
        this.setFloorText(floorText);
    }

    public String toString(Context context) {
        StringBuilder builder = new StringBuilder().append(this.getFloorNumber().getInt());
        switch (this.getCommandChoice().getOrdinal()) {
            case 0: {
                builder.append(" ").append(this.getDirection().toString(context));
                break;
            }
            case 1: {
                builder.append(" \u2192 ").append(this.getDestination().getInt());
                break;
            }
            default: {
                builder.append(" ?");
            }
        }
        return builder.toString();
    }
}

