/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes.elevator;

import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.elevator.BBacnetLiftCarDirection;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="floorNumber", type="BBacnetUnsigned", defaultValue="BBacnetUnsigned.DEFAULT", facets={@Facet(value="BFacets.makeInt(null, (int)BBacnetUnsigned.MIN_UNSIGNED_VALUE, (int)BBacnetUnsigned.MAX_UNSIGNED8_VALUE)")}), @NiagaraProperty(name="direction", type="BBacnetLiftCarDirection", defaultValue="BBacnetLiftCarDirection.DEFAULT")})
public class BBacnetAssignedLandingCallEntry
extends BComponent
implements BIBacnetDataType {
    @Generated
    public static final Property floorNumber = BBacnetAssignedLandingCallEntry.newProperty((int)0, (BValue)BBacnetUnsigned.DEFAULT, (BFacets)BFacets.makeInt(null, (int)0, (int)255));
    @Generated
    public static final Property direction = BBacnetAssignedLandingCallEntry.newProperty((int)0, (BValue)BBacnetLiftCarDirection.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetAssignedLandingCallEntry.class);

    @Generated
    public BBacnetUnsigned getFloorNumber() {
        return (BBacnetUnsigned)this.get(floorNumber);
    }

    @Generated
    public void setFloorNumber(BBacnetUnsigned v) {
        this.set(floorNumber, (BValue)v, null);
    }

    @Generated
    public BBacnetLiftCarDirection getDirection() {
        return (BBacnetLiftCarDirection)this.get(direction);
    }

    @Generated
    public void setDirection(BBacnetLiftCarDirection v) {
        this.set(direction, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void writeAsn(AsnOutput out) {
        int floorNumber = this.getFloorNumber().getInt();
        if (floorNumber < 0 || (long)floorNumber > 255L) {
            throw new IllegalArgumentException("BACnetAssignedLandingCalls entry floor number must be Unsigned8; actual: " + floorNumber);
        }
        out.writeUnsigned(0, this.getFloorNumber());
        out.writeEnumerated(1, (BEnum)this.getDirection());
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        int floorNumber = in.readUnsignedInt(0);
        if ((long)floorNumber > 255L) {
            throw new OutOfRangeException("BACnetAssignedLandingCalls entry floor number must be Unsigned8; actual: " + floorNumber);
        }
        BBacnetLiftCarDirection direction = BBacnetLiftCarDirection.make(in.readEnumerated(1));
        this.setFloorNumber(BBacnetUnsigned.make(floorNumber));
        this.setDirection(direction);
    }

    public String toString(Context context) {
        return this.getFloorNumber().getInt() + ", " + this.getDirection().toString(context);
    }
}

